/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazionePrimaNotaPP;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.primanota.InsiemePNIva;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.PNIva;
import gestionale.primanota.PNRiga;
import gestionale.primanota.Partita;
import gestionale.primanota.Registrazione;
import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaPrimaNota
implements Runnable {
    public GestoreStampe stampa_prima_nota;
    FunzioniDate fda;
    Funzioni f;
    String dataDA;
    String dataA;
    String siono;
    boolean esito = false;
    Thread thread;
    Color colore = new Color(220, 220, 220);

    public StampaPrimaNota(String dataDA, String dataA, String siono) {
        MyTrace.log.info("RICHIESTA ISTANZA CLASSE StampaPrimaNota()");
        this.dataA = dataA;
        this.dataDA = dataDA;
        this.siono = siono;
        MyTrace.log.info("CLASSE StampaPrimaNota() ISTANZIATA");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    public boolean Elabora() {
        Configurazioni.getIstanza();
        int y_inizio = Configurazioni.inizio_stampe;
        try {
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA PRIMA NOTA INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            long tempo_di_visualizzazione = System.currentTimeMillis();
            this.fda = new FunzioniDate();
            this.f = new Funzioni();
            this.stampa_prima_nota = new GestoreStampe();
            this.stampa_prima_nota.aggiungi_pj();
            this.stampa_prima_nota.setIntPP((OggettoToPrint)new IntestazionePrimaNotaPP());
            this.stampa_prima_nota.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Prima Nota"));
            this.stampa_intestazione_prima_nota(this.stampa_prima_nota, y_inizio);
            int y_corrente = y_inizio + 55;
            Registrazione temp = new Registrazione();
            String query_registro = "SELECT * FROM v_reg WHERE data_doc between '" + this.dataDA + "' and '" + this.dataA + "'";
            if (this.siono.equals("si")) {
                query_registro = query_registro + " and v_reg.contabile=1 ";
            }
            query_registro = query_registro + " order by data_doc";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_registro);
            int segno = 0;
            int numero = 0;
            int idprecedente = 0;
            while (res.next()) {
                double totale = 0.0;
                ++numero;
                temp.setIdregistro(res.getInt("idregistro"));
                temp.setData_doc(res.getString("data_doc"));
                temp.setData_reg(res.getString("data_reg"));
                String codice_causale = res.getString("codice_cc");
                String descrizione_causale = res.getString("descrizione_cc");
                temp.setNote(res.getString("note"));
                temp.setNum_doc(res.getString("num_doc"));
                temp.setNum_reg(res.getInt("num_reg"));
                temp.setAnno_prot(res.getInt("anno_prot"));
                if (y_corrente > 740) {
                    this.stampa_prima_nota.appendLine(18, 750, 18, 820, this.stampa_prima_nota.colore_bianco);
                    this.stampa_prima_nota.appendLine(55, 750, 55, 820, this.stampa_prima_nota.colore_bianco);
                    this.stampa_prima_nota.appendLine(573, 750, 573, 820, this.stampa_prima_nota.colore_bianco);
                    this.stampa_prima_nota.appendLine(18, 750, 573, 750, this.colore);
                    this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_10);
                    this.stampa_prima_nota.paginanuova();
                    y_corrente = y_inizio;
                    this.stampa_intestazione_prima_nota(this.stampa_prima_nota, y_corrente - 50);
                }
                this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_7_B);
                this.stampa_prima_nota.appendTextOvunque("" + numero, 20, y_corrente - 5);
                this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_7);
                this.stampa_prima_nota.appendTextOvunque("Reg. n." + temp.getNum_reg(), 20, y_corrente + 3);
                this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_7_B);
                this.stampa_prima_nota.appendTextOvunque(temp.getData_regIt(), 65, y_corrente - 5);
                this.stampa_prima_nota.appendTextOvunque(temp.getData_docIt() + "            " + temp.getNum_doc().replaceAll("null", "") + "/" + temp.getAnno_doc(), 140, y_corrente - 5);
                this.stampa_prima_nota.appendTextOvunque(descrizione_causale + " (" + codice_causale + ") - " + temp.getNote(), 270, y_corrente - 5);
                this.stampa_prima_nota.appendLine(55, y_corrente - 3, 573, y_corrente - 3, this.colore);
                this.stampa_prima_nota.appendLine(18, y_corrente - 12, 573, y_corrente - 12, this.colore);
                int y_temp = y_corrente - 3;
                y_corrente += 9;
                int contatore = 0;
                temp.seleziona_righe();
                for (PNRiga pnr : temp.getInsieme_righe().vettoreRPN) {
                    this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_7);
                    if (pnr.getSegno() == 1) {
                        this.stampa_prima_nota.appendTextOvunque("" + this.f.formattaNumero("" + pnr.getImporto()), 465, y_corrente - 5);
                        totale += Double.valueOf(this.f.formattaNumero("" + pnr.getImporto())).doubleValue();
                    }
                    if (pnr.getSegno() == 2) {
                        this.stampa_prima_nota.appendTextOvunque("" + this.f.formattaNumero("" + pnr.getImporto()), 530, y_corrente - 5);
                        totale -= Double.valueOf(this.f.formattaNumero("" + pnr.getImporto())).doubleValue();
                    }
                    this.stampa_prima_nota.appendTextOvunque("" + pnr.getCd_conto(), 65, y_corrente - 5);
                    this.stampa_prima_nota.appendTextOvunque("" + pnr.getDescrizione_conto(), 140, y_corrente - 5);
                    ++contatore;
                    if ((y_corrente += 7) <= 750) continue;
                    this.stampa_prima_nota.appendLine(18, 750, 18, 820, this.stampa_prima_nota.colore_bianco);
                    this.stampa_prima_nota.appendLine(55, 750, 55, 820, this.stampa_prima_nota.colore_bianco);
                    this.stampa_prima_nota.appendLine(573, 750, 573, 820, this.stampa_prima_nota.colore_bianco);
                    this.stampa_prima_nota.appendLine(18, 750, 573, 750);
                    this.stampa_prima_nota.paginanuova();
                    y_corrente = y_inizio;
                    this.stampa_intestazione_prima_nota(this.stampa_prima_nota, y_corrente - 50);
                    this.stampa_prima_nota.appendLine(55, y_corrente - 10, 55, y_corrente + 100, this.colore);
                    this.stampa_prima_nota.appendLine(573, y_corrente - 10, 573, y_corrente + 100, this.colore);
                    this.stampa_prima_nota.appendLine(18, y_corrente - 10, 18, y_corrente + 100, this.colore);
                }
                this.stampa_prima_nota.appendLine(18, y_temp - 8, 18, y_corrente + 100 + contatore * 5, this.colore);
                this.stampa_prima_nota.appendLine(55, y_temp - 8, 55, y_corrente + 100 + contatore * 5, this.colore);
                this.stampa_prima_nota.appendLine(573, y_temp - 8, 573, y_corrente + 100 + contatore * 5, this.colore);
                String w_partite = " WHERE id_registro='" + temp.getIdregistro() + "'";
                InsiemePartite insieme_p = new InsiemePartite();
                insieme_p.caricamento(w_partite, "");
                for (Partita p : insieme_p.vettoreP) {
                    String codice_cf = "";
                    String ragione_sociale = "";
                    if (p.getTipo_cf().equals("C") || p.getTipo_cf().equals("F")) {
                        codice_cf = p.getTipo_cf() + p.getCodice_cf();
                        ragione_sociale = p.getRagione_sociale_cf();
                    }
                    if (y_corrente > 750) {
                        this.stampa_prima_nota.appendLine(18, 750, 18, 820, this.stampa_prima_nota.colore_bianco);
                        this.stampa_prima_nota.appendLine(55, 750, 55, 820, this.stampa_prima_nota.colore_bianco);
                        this.stampa_prima_nota.appendLine(573, 750, 573, 820, this.stampa_prima_nota.colore_bianco);
                        this.stampa_prima_nota.appendLine(18, 573, 573, 750);
                        this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_10);
                        this.stampa_prima_nota.paginanuova();
                        y_corrente = y_inizio;
                        this.stampa_intestazione_prima_nota(this.stampa_prima_nota, y_corrente - 50);
                        this.stampa_prima_nota.appendLine(55, y_corrente - 10, 55, y_corrente + 100, this.colore);
                        this.stampa_prima_nota.appendLine(573, y_corrente - 10, 573, y_corrente + 100, this.colore);
                        this.stampa_prima_nota.appendLine(18, y_corrente - 10, 18, y_corrente + 100, this.colore);
                    }
                    this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_7);
                    if (p.getSegno() == 1) {
                        this.stampa_prima_nota.appendTextOvunque("" + this.f.formattaNumero("" + p.getImporto()), 465, y_corrente - 5);
                        totale += Double.valueOf(this.f.formattaNumero("" + p.getImporto())).doubleValue();
                    }
                    if (p.getSegno() == 2) {
                        this.stampa_prima_nota.appendTextOvunque("" + this.f.formattaNumero("" + p.getImporto()), 530, y_corrente - 5);
                        totale -= Double.valueOf(this.f.formattaNumero("" + p.getImporto())).doubleValue();
                    }
                    this.stampa_prima_nota.appendTextOvunque("" + codice_cf, 65, y_corrente - 5);
                    this.stampa_prima_nota.appendTextOvunque("" + ragione_sociale, 140, y_corrente - 5);
                    y_corrente += 7;
                }
                String w_iva = " WHERE id_registro='" + temp.getIdregistro() + "'";
                InsiemePNIva insieme_pni = new InsiemePNIva();
                insieme_pni.caricamento(w_iva, " ");
                for (PNIva pni : insieme_pni.vettoreIVAPN) {
                    segno = pni.getSegno();
                    String importo = "" + pni.getImposta();
                    String codice_conto = pni.getC().getConto();
                    String descrizione_conto = pni.getC().getDescrizione();
                    if (y_corrente > 750) {
                        this.stampa_prima_nota.appendLine(18, 750, 18, 820, this.stampa_prima_nota.colore_bianco);
                        this.stampa_prima_nota.appendLine(55, 750, 55, 820, this.stampa_prima_nota.colore_bianco);
                        this.stampa_prima_nota.appendLine(573, 750, 573, 820, this.stampa_prima_nota.colore_bianco);
                        this.stampa_prima_nota.appendLine(18, 750, 573, 750);
                        this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_10);
                        this.stampa_prima_nota.paginanuova();
                        y_corrente = y_inizio;
                        this.stampa_intestazione_prima_nota(this.stampa_prima_nota, y_corrente - 50);
                        this.stampa_prima_nota.appendLine(55, y_corrente - 10, 55, y_corrente + 100, this.colore);
                        this.stampa_prima_nota.appendLine(573, y_corrente - 10, 573, y_corrente + 100, this.colore);
                        this.stampa_prima_nota.appendLine(18, y_corrente - 10, 18, y_corrente + 100, this.colore);
                    }
                    this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_7);
                    if (segno == 1) {
                        this.stampa_prima_nota.appendTextOvunque("" + this.f.formattaNumero("" + importo), 465, y_corrente - 5);
                        totale += Double.valueOf(this.f.formattaNumero("" + importo)).doubleValue();
                    }
                    if (segno == 2) {
                        this.stampa_prima_nota.appendTextOvunque("" + this.f.formattaNumero("" + importo), 530, y_corrente - 5);
                        totale -= Double.valueOf(this.f.formattaNumero("" + importo)).doubleValue();
                    }
                    this.stampa_prima_nota.appendTextOvunque("" + codice_conto, 65, y_corrente - 5);
                    this.stampa_prima_nota.appendTextOvunque("" + descrizione_conto, 140, y_corrente - 5);
                    y_corrente += 7;
                }
                if (totale == 0.0 || this.f.formattaNumero("" + totale).equals("-0.00") || this.f.formattaNumero("" + totale).equals("0.00")) {
                    this.stampa_prima_nota.appendTextOvunque("OK", 300, y_corrente - 12);
                } else {
                    this.stampa_prima_nota.appendTextOvunque(this.f.formattaNumero("" + totale), 300, y_corrente - 12, this.stampa_prima_nota.colore_rosso);
                }
                idprecedente = temp.getIdregistro();
                y_corrente += 2;
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            this.stampa_prima_nota.setFont(this.stampa_prima_nota.Font_Calibri_10);
            this.stampa_prima_nota.appendLine(18, y_corrente, 573, y_corrente, this.colore);
            this.stampa_prima_nota.appendLine(18, y_corrente + 1, 18, y_corrente + 250, this.stampa_prima_nota.colore_bianco);
            this.stampa_prima_nota.appendLine(55, y_corrente + 1, 55, y_corrente + 250, this.stampa_prima_nota.colore_bianco);
            this.stampa_prima_nota.appendLine(573, y_corrente + 1, 573, y_corrente + 250, this.stampa_prima_nota.colore_bianco);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            this.stampa_prima_nota.getSeg().getMy_pj_corrente().getPj().setJobName(date_now + ora_now + "_Registro_fino_dal_" + this.dataDA + "_al_" + this.dataA + "_aggiornato_al_" + this.fda.dataCorrenteIt());
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.stampa_prima_nota.print();
            System.out.println("Fine Stampa");
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA PRIMA NOTA FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.esito = true;
        }
        catch (SQLException ex) {
            MyTrace.log.severe("ECCEZIONE in Stampaprimanota()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.esito = false;
        }
        return this.esito;
    }

    public void stampa_intestazione_prima_nota(GestoreStampe stampa_prima_nota, int altezza) {
        stampa_prima_nota.setFont(stampa_prima_nota.Font_Calibri_10_B);
        stampa_prima_nota.appendRoundRect(18, (altezza += 10) - 10, 555, 35, 10, 10);
        if (this.siono.equals("no")) {
            stampa_prima_nota.appendTextOvunque("Prima Nota  dal " + this.dataDA + " al " + this.dataA, 20, altezza + 3);
        } else {
            stampa_prima_nota.appendTextOvunque("Prima Nota  dal " + this.dataDA + " al " + this.dataA + "  CONTABILE", 20, altezza + 3);
        }
        stampa_prima_nota.appendTextOvunque("Nr.", 30, altezza + 17);
        stampa_prima_nota.appendTextOvunque("Data Reg..", 65, altezza + 17);
        stampa_prima_nota.appendTextOvunque("Data Doc.", 140, altezza + 17);
        stampa_prima_nota.appendTextOvunque("Num. Doc.", 200, altezza + 17);
        stampa_prima_nota.appendTextOvunque("Descrizione (codice)", 270, altezza + 17);
        stampa_prima_nota.appendTextOvunque("Importo", 485, altezza + 3);
        stampa_prima_nota.setFont(stampa_prima_nota.Font_Calibri_9_B);
        stampa_prima_nota.appendTextOvunque("Dare", 460, altezza + 17);
        stampa_prima_nota.appendTextOvunque("Avere", 530, altezza + 17);
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA PRIMANOTA");
        attesa.start();
        this.Elabora();
        attesa.stop();
    }
}

