/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneInterrogazionePartite;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.Partita;
import java.awt.Color;
import java.math.BigDecimal;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaInterrogazionePartite
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    GestoreStampe stampa;
    String tipo_ricerca;
    String codice_cf;
    String data_reg_from;
    String data_reg_to;
    String data_doc_from;
    String data_doc_to;
    String causale_contabile;
    String avere;
    String dare;
    String avere_dare;
    Thread thread;
    Color colore = new Color(220, 220, 220);
    InsiemePartite insieme_p;

    public StampaInterrogazionePartite(InsiemePartite insieme_p, String tipo_ricerca, String codice_cf, String data_reg_from, String data_reg_to, String data_doc_from, String data_doc_to, String causale_contabile, String avere, String dare, String avere_dare) {
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.stampa = new GestoreStampe();
        this.stampa.aggiungi_pj();
        this.tipo_ricerca = tipo_ricerca;
        this.codice_cf = codice_cf;
        this.data_reg_from = data_reg_from;
        this.data_reg_to = data_reg_to;
        this.data_doc_from = data_doc_from;
        this.data_doc_to = data_doc_to;
        this.causale_contabile = causale_contabile;
        this.avere = avere;
        this.dare = dare;
        this.avere_dare = avere_dare;
        this.insieme_p = insieme_p;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    public boolean elabora() {
        Configurazioni.getIstanza();
        int y_inizio = Configurazioni.inizio_stampe;
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA INTERROGAZINE PARTITE C/F INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        long tempo_di_visualizzazione = System.currentTimeMillis();
        int id_cf = 0;
        Money importo = new Money(BigDecimal.ZERO);
        int segno = 0;
        String num_doc = "";
        int num_reg = 0;
        String causale_contable = "";
        String data = "";
        String note = "";
        String ragione = "";
        String codice = "";
        String stringa_intestazione = "";
        String anno = "";
        String anno_doc = "";
        String data_now = this.fda.dataCorrente();
        String ora_now = this.fda.OraCorrente();
        this.stampa.setIntPP((OggettoToPrint)new IntestazioneInterrogazionePartite());
        this.stampa.setInt((OggettoToPrint)new IntestazioneInterrogazionePartite());
        this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Partite"));
        if (!this.codice_cf.equals("")) {
            Anagrafica c = new Anagrafica();
            c.seleziona_da_codice(this.codice_cf.substring(1), this.tipo_ricerca);
            ragione = c.getRagione_sociale();
            codice = c.getCodice();
            id_cf = c.getIdanag();
            stringa_intestazione = "Interrogazione Partite del " + this.f.cli_for(this.tipo_ricerca) + ": " + this.tipo_ricerca + "" + codice + " - " + ragione + "  dal " + this.data_doc_from + "  al " + this.data_doc_to;
            this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(data_now.replaceAll("-", "") + ora_now.replaceAll(":", "") + "_Interrogazione_Partite_del_" + this.f.cli_for(this.tipo_ricerca) + ":_" + this.tipo_ricerca + codice + "-" + ragione + "_dal_" + this.data_doc_from + "_al_" + this.data_doc_to);
        }
        if (this.codice_cf.equals("")) {
            stringa_intestazione = "Interrogazione Partite di tutti i " + this.f.cli_for(this.tipo_ricerca) + " dal " + this.data_doc_from + "  al " + this.data_doc_to;
            this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(data_now.replaceAll("-", "") + ora_now.replaceAll(":", "") + "_Interrogazione_Partite_di_tutti_i_" + this.f.cli_for(this.tipo_ricerca) + "_dal_" + this.data_doc_from + "_al_" + this.data_doc_to);
        }
        int y = y_inizio;
        this.intestazione_tabella_conti(this.stampa, 18, y, stringa_intestazione);
        y = y_inizio + 60;
        for (Partita p : this.insieme_p.vettoreP) {
            data = "" + p.getData_doc();
            anno_doc = this.fda.anno(data);
            try {
                segno = p.getSegno();
            }
            catch (Exception e_segno) {
                // empty catch block
            }
            importo = p.getImporto();
            String descrizione_cc = "" + p.getDescrizione_cc();
            try {
                num_doc = p.getDocumento();
            }
            catch (Exception e_segno) {
                // empty catch block
            }
            try {
                num_reg = p.getNum_reg();
            }
            catch (Exception e_segno) {
                // empty catch block
            }
            note = p.getDescrizione();
            anno = p.getAnno_prot();
            if (y > 750) {
                this.stampa.paginanuova();
                y = y_inizio;
                this.intestazione_tabella_conti(this.stampa, 18, y, stringa_intestazione);
                y = y_inizio + 60;
            }
            this.stampa.appendRect(18, y, 555, 20, this.colore);
            this.stampa.setFont(this.stampa.Font_Calibri_7);
            this.stampa.appendTextOvunque(this.fda.gira_data(data), 20, y + 8);
            if (segno == 1) {
                this.stampa.appendTextOvunque("" + importo, 100, y + 8);
            }
            if (segno == 2) {
                this.stampa.appendTextOvunque("" + importo, 150, y + 8);
            }
            this.stampa.appendTextOvunque(descrizione_cc, 240, y + 8);
            this.stampa.appendTextOvunque("" + num_reg + "/" + anno, 470, y + 8);
            if (!num_doc.equals("")) {
                this.stampa.appendTextOvunque("" + num_doc + "/" + anno_doc, 530, y + 8);
            }
            this.stampa.appendTextOvunque(note, 20, y + 16);
            y += 20;
        }
        this.stampa.setFont(this.stampa.Font_Calibri_12_B);
        this.stampa.appendLine(18, y += 15, 573, y);
        this.stampa.appendLine(18, y + 5, 573, y + 5);
        if (y > 750) {
            this.stampa.paginanuova();
            y = y_inizio;
            this.intestazione_tabella_conti(this.stampa, 18, y, stringa_intestazione);
            y = y_inizio + 60;
        }
        this.stampa.appendRoundRect(170, y += 20, 250, 50, 10, 10);
        String S_tot_dare = "Totale Dare";
        String S_avere = "Totale Avere";
        String S_avere_dare = "Totale Saldo";
        this.stampa.appendTextOvunque(S_tot_dare, 190, (y += 3) + 10);
        this.stampa.appendStringaOvunqueFormattazioneDestra(this.dare, 350, y + 10, 45);
        this.stampa.appendTextOvunque(S_avere, 190, y + 25);
        this.stampa.appendStringaOvunqueFormattazioneDestra(this.avere, 350, y + 25, 45);
        this.stampa.appendTextOvunque(S_avere_dare, 190, y + 40);
        this.stampa.appendStringaOvunqueFormattazioneDestra(this.avere_dare, 350, y + 40, 45);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
        this.stampa.print();
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA INTERROGAZIONE PARTITE C/F FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
        return true;
    }

    public void intestazione_tabella_conti(GestoreStampe stampa, int x, int y, String ragione_sociale) {
        stampa.setFont(stampa.Font_Calibri_9_B);
        stampa.appendRoundRect(x, y, 555, 50, 10, 10);
        stampa.appendTextOvunque(ragione_sociale.toUpperCase(), 22, y + 20);
        stampa.appendTextOvunque("DATA", 22, y + 35);
        stampa.appendTextOvunque("DARE", 100, y + 35);
        stampa.appendTextOvunque("AVERE", 150, y + 35);
        stampa.appendTextOvunque("DESCRIZIONE CAUSALE", 240, y + 35);
        stampa.appendTextOvunque("Nr. REG.", 470, y + 35);
        stampa.appendTextOvunque("Nr. DOC.", 530, y + 35);
        y += 50;
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD INTERROGAZIONE PARTITE");
        attesa.start();
        this.elabora();
        attesa.stop();
    }
}

