/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import anagrafiche.clienti_fornitori.Anagrafica;
import com.mysql.jdbc.ResultSetMetaData;
import gestionale.MyDesktopWindow;
import gestionale.causali_contabili.CausaleContabile;
import gestionale.configurazioni.Configurazioni;
import gestionale.iva.RegistriIVA;
import gestionale.primanota.InsiemePNIva;
import gestionale.primanota.InsiemePNRiga;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.PNIva;
import gestionale.primanota.PNRiga;
import gestionale.primanota.Partita;
import gestionale.scadenziario.InsiemeScadenze;
import gestionale.scadenziario.Scadenza;
import gestionale.trattamento_economico.ConfRata;
import gestionale.trattamento_economico.TrattamentoEconomico;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Iterator;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Performance;

public class Registrazione {
    private int idregistro;
    private int num_reg;
    private int anno_prot;
    private int id_causale_contabile;
    private int id_anagrafica;
    private int id_registro_iva;
    private int id_tipo_modello;
    private int id_trattamento_economico;
    private int id_conto_banca_appoggio;
    private int anno_reg;
    private int protocollo_iva;
    private int iva_proporzionale;
    private String num_doc;
    private String data_reg;
    private String data_doc;
    private String tipo_cf;
    private String note;
    private String iban_cf;
    private String codice_causale_contabile;
    private String message;
    private String codice_ri;
    private String ragione_sociale_cf;
    private String codice_cf;
    private String desc_banca;
    private String iban_banca;
    private CausaleContabile cc;
    private Anagrafica anagrafica = new Anagrafica();
    private TrattamentoEconomico te;
    private RegistriIVA ri;
    private Money importo_doc = new Money(BigDecimal.ZERO);
    private InsiemePNIva insieme_iva;
    private InsiemePNIva insieme_iva_da_eliminare;
    private InsiemePNRiga insieme_righe;
    private InsiemePartite insieme_p;
    private InsiemePartite insieme_p_da_eliminare;
    private InsiemeScadenze insieme_s;
    private InsiemeScadenze insieme_s_da_eliminare;
    private FunzioniDate fda = new FunzioniDate();
    private Funzioni f = new Funzioni();
    private long tempo_di_visualizzazione;

    public int getAnno_doc() {
        if (this.data_doc != null) {
            return Integer.valueOf(this.fda.anno(this.data_doc));
        }
        return this.fda.annoCorrente();
    }

    public int getAnno_prot() {
        return this.anno_prot;
    }

    public void setAnno_prot(int anno_prot) {
        this.anno_prot = anno_prot;
    }

    public int getAnno_reg() {
        return this.anno_reg;
    }

    public void setAnno_reg(int anno_reg) {
        this.anno_reg = anno_reg;
    }

    public String getData_doc() {
        if (this.data_doc != null) {
            return this.data_doc;
        }
        return this.fda.dataCorrente();
    }

    public String getData_docIt() {
        if (this.data_doc != null) {
            return this.fda.gira_data(this.data_doc);
        }
        return this.fda.dataCorrenteIt();
    }

    public void setData_doc(String data_doc) {
        this.data_doc = data_doc;
    }

    public String getData_reg() {
        return this.data_reg;
    }

    public String getData_regIt() {
        return this.fda.gira_data(this.data_reg);
    }

    public void setData_reg(String data_reg) {
        this.data_reg = data_reg;
    }

    public int getId_causale_contabile() {
        return this.id_causale_contabile;
    }

    public void setId_causale_contabile(int id_causale_contabile) {
        this.id_causale_contabile = id_causale_contabile;
        CausaleContabile cc_temp = new CausaleContabile();
        cc_temp.seleziona(id_causale_contabile);
        this.setCc(cc_temp);
    }

    public void setId_causale_contabile_e_basta(int id_causale_contabile) {
        this.id_causale_contabile = id_causale_contabile;
    }

    public Anagrafica getAnagrafica() {
        return this.anagrafica;
    }

    public void setAnagrafica(Anagrafica anagrafica) {
        this.anagrafica = anagrafica;
    }

    public int getId_anagrafica() {
        return this.id_anagrafica;
    }

    public void setId_anagrafica(int id_anagrafica) {
        this.id_anagrafica = id_anagrafica;
        Anagrafica c = new Anagrafica();
        c.seleziona_da_id(id_anagrafica);
        this.setAnagrafica(c);
    }

    public void setId_anag_e_basta(int id_anag) {
        this.id_anagrafica = id_anag;
    }

    public String getCodice_causale_contabile() {
        return this.codice_causale_contabile;
    }

    public void setCodice_causale_contabile(String codice_causale_contabile) {
        this.codice_causale_contabile = codice_causale_contabile;
    }

    public int getId_trattamento_economico() {
        return this.id_trattamento_economico;
    }

    public void setId_trattamento_economico(int id_trattamento_economico) {
        this.id_trattamento_economico = id_trattamento_economico;
    }

    public int getId_registro_iva() {
        return this.id_registro_iva;
    }

    public void setId_registro_iva(int id_registro_iva) {
        this.id_registro_iva = id_registro_iva;
    }

    public int getIdregistro() {
        return this.idregistro;
    }

    public String getCodice_ri() {
        return this.codice_ri;
    }

    public void setCodice_ri(String codice_ri) {
        this.codice_ri = codice_ri;
    }

    public void setIdregistro(int idregistro) {
        this.idregistro = idregistro;
    }

    public Money getImporto_doc() {
        return this.importo_doc;
    }

    public void setImporto_doc(Money importo_doc) {
        this.importo_doc = importo_doc;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getNum_doc() {
        return this.num_doc;
    }

    public void setNum_doc(String num_doc) {
        this.num_doc = num_doc;
    }

    public int getNum_reg() {
        return this.num_reg;
    }

    public void setNum_reg(int num_reg) {
        this.num_reg = num_reg;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public CausaleContabile getCc() {
        return this.cc;
    }

    public void setCc(CausaleContabile cc) {
        this.cc = cc;
    }

    public String getIban_cf() {
        return this.iban_cf;
    }

    public void setIban_cf(String iban_cf) {
        this.iban_cf = iban_cf;
    }

    public int getId_banca_appoggio() {
        return this.id_conto_banca_appoggio;
    }

    public void setId_banca_appoggio(int conto_banca_appoggio) {
        this.id_conto_banca_appoggio = conto_banca_appoggio;
    }

    public InsiemePNIva getInsieme_iva() {
        return this.insieme_iva;
    }

    public void setInsieme_iva(InsiemePNIva insieme_iva) {
        this.insieme_iva = insieme_iva;
    }

    public InsiemePNRiga getInsieme_righe() {
        return this.insieme_righe;
    }

    public void setInsieme_righe(InsiemePNRiga insieme_righe) {
        this.insieme_righe = insieme_righe;
    }

    public InsiemePartite getInsieme_p() {
        return this.insieme_p;
    }

    public void setInsieme_p(InsiemePartite insieme_p) {
        this.insieme_p = insieme_p;
    }

    public int getProtocollo_iva() {
        return this.protocollo_iva;
    }

    public void setProtocollo_iva(int protocollo_iva) {
        this.protocollo_iva = protocollo_iva;
    }

    public InsiemePartite getInsieme_p_da_eliminare() {
        return this.insieme_p_da_eliminare;
    }

    public void setInsieme_p_da_eliminare(InsiemePartite insieme_p_da_eliminare) {
        this.insieme_p_da_eliminare = insieme_p_da_eliminare;
    }

    public int getIva_proporzionale() {
        return this.iva_proporzionale;
    }

    public void setIva_proporzionale(int iva_proporzionale) {
        this.iva_proporzionale = iva_proporzionale;
    }

    public TrattamentoEconomico getTe() {
        return this.te;
    }

    public void setTe(TrattamentoEconomico te) {
        this.te = te;
    }

    public InsiemeScadenze getInsieme_s() {
        return this.insieme_s;
    }

    public void setInsieme_s(InsiemeScadenze insieme_s) {
        this.insieme_s = insieme_s;
    }

    public String getCodice_cf() {
        return this.codice_cf;
    }

    public void setCodice_cf(String codice_cf) {
        this.codice_cf = codice_cf;
    }

    public String getRagione_sociale_cf() {
        return this.ragione_sociale_cf;
    }

    public void setRagione_sociale_cf(String ragione_sociale_cf) {
        this.ragione_sociale_cf = ragione_sociale_cf;
    }

    public RegistriIVA getRi() {
        return this.ri;
    }

    public void setRi(RegistriIVA ri) {
        this.ri = ri;
    }

    public int getId_tipo_modello() {
        return this.id_tipo_modello;
    }

    public void setId_tipo_modello(int id_tipo_modello) {
        this.id_tipo_modello = id_tipo_modello;
    }

    public InsiemeScadenze getInsieme_s_da_eliminare() {
        return this.insieme_s_da_eliminare;
    }

    public void setInsieme_s_da_eliminare(InsiemeScadenze insieme_s_da_eliminare) {
        this.insieme_s_da_eliminare = insieme_s_da_eliminare;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDesc_banca() {
        return this.desc_banca;
    }

    public void setDesc_banca(String desc_banca) {
        this.desc_banca = desc_banca;
    }

    public String getIban_banca() {
        return this.iban_banca;
    }

    public void setIban_banca(String iban_banca) {
        this.iban_banca = iban_banca;
    }

    public InsiemePNIva getInsieme_iva_da_eliminare() {
        return this.insieme_iva_da_eliminare;
    }

    public void setInsieme_iva_da_eliminare(InsiemePNIva insieme_iva_da_eliminare) {
        this.insieme_iva_da_eliminare = insieme_iva_da_eliminare;
    }

    public boolean inserisciRegistrazione(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        Performance perf = new Performance("INSERISCI REGISTRAZIONE");
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO registro(num_reg,data_reg,num_doc,data_doc,anno_prot,id_causale_contabile,tipo_cf,importo_doc,id_conf_registri_iva,id_conf_trattamento_economico,note,iban_cf, id_banca_appoggio,anno_reg,protocollo_iva,iva_proporzionale,id_anagrafica) VALUES ( (SELECT (COALESCE(MAX(num_reg),0))+1 FROM (SELECT * FROM registro WHERE anno_reg=" + this.fda.anno(this.getData_reg()) + ")as tab_temporanea)," + "'" + this.getData_reg() + "'," + "'" + this.getNum_doc() + "'," + "'" + this.getData_doc() + "'," + "'" + this.getAnno_prot() + "'," + "'" + this.getId_causale_contabile() + "'," + "'" + this.getTipo_cf() + "'," + "'" + this.getImporto_doc() + "'," + "" + this.f.zero_to_null(this.getId_registro_iva()) + "," + "" + this.f.zero_to_null(this.getId_trattamento_economico()) + "," + "'" + this.getNote().replaceAll("'", "''") + " '," + "'" + this.getIban_cf() + "'," + "" + this.f.zero_to_null(this.getId_banca_appoggio()) + "," + "'" + this.fda.anno(this.getData_reg()) + "'," + " (SELECT (IFNULL(MAX(protocollo_iva),0))+1 as nuovo_protocollo FROM (SELECT * FROM registro WHERE anno_prot=" + this.getAnno_prot() + " AND id_conf_registri_iva=" + this.getId_registro_iva() + ")as temp2)," + "'" + this.getIva_proporzionale() + "'," + "" + this.f.zero_to_null(this.getId_anagrafica()) + ")"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento Registrazione non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        this.setIdregistro(Configurazioni.getIstanza().connessione.id_inserito("registro"));
        String q_prot = "SELECT num_reg from registro where idRegistro=" + this.getIdregistro();
        ResultSet res_num = Configurazioni.getIstanza().connessione.eseguiQuery(q_prot);
        int numero = 0;
        try {
            while (res_num.next()) {
                numero = res_num.getInt("num_reg");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res_num);
        if (numero != this.getNum_reg()) {
            this.setNum_reg(numero);
        }
        String q_prot2 = "SELECT protocollo_iva from registro where idregistro=" + this.getIdregistro();
        ResultSet res_num2 = Configurazioni.getIstanza().connessione.eseguiQuery(q_prot2);
        int numero2 = 0;
        try {
            while (res_num2.next()) {
                numero2 = res_num2.getInt("protocollo_iva");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res_num2);
        if (numero2 != this.getProtocollo_iva()) {
            this.setProtocollo_iva(numero2);
        }
        int id_p = 0;
        boolean ris_partita = true;
        if (this.getInsieme_p() != null && !this.getInsieme_p().vettoreP.isEmpty()) {
            for (Partita p : this.getInsieme_p().vettoreP) {
                p.setId_registro(this.getIdregistro());
                ris_partita = p.inserisciPartita(false);
                id_p = p.getId();
            }
        }
        if (!ris_partita) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento registrazione  non riuscito per partite");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        boolean ris_iva = true;
        if (this.getInsieme_iva() != null && !this.getInsieme_iva().vettoreIVAPN.isEmpty()) {
            for (PNIva pni : this.getInsieme_iva().vettoreIVAPN) {
                pni.setId_registro(this.getIdregistro());
                pni.setProtocollo_iva(this.getProtocollo_iva());
                pni.setR(this);
                ris_iva = pni.inserisciPNIva(false);
            }
        }
        if (!ris_iva) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento registrazione  non riuscito per righe iva");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        boolean ris_riga = true;
        if (this.getInsieme_righe() != null && !this.getInsieme_righe().vettoreRPN.isEmpty()) {
            for (PNRiga pnr : this.getInsieme_righe().vettoreRPN) {
                pnr.setId_registro(this.getIdregistro());
                pnr.setR(this);
                ris_riga = pnr.inserisciPNRiga(false);
            }
        }
        if (!ris_riga) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento registrazione  non riuscito per righe gestione");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        boolean ris_s = true;
        if (this.getInsieme_s() != null && !this.getInsieme_s().vettoreS.isEmpty()) {
            for (Scadenza s : this.getInsieme_s().vettoreS) {
                s.setId_registro(this.getIdregistro());
                s.setId_partita_c(id_p);
                ris_s = s.inserisciScadenza(false);
            }
        }
        if (!ris_s) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento registrazione  non riuscito per scadenze");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','registro','" + this.getIdregistro() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento Registrazione non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        MyTrace.log.info("END INSERISCI TUTTO OK");
        perf.fine();
        return true;
    }

    public void seleziona(int id) {
        String query_seleziona = "SELECT registro.*, anag_anagrafica.idanagrafica,anag_anagrafica.codice,anag_anagrafica.ragione_sociale,  anag_banche.descrizione as desc_banca, anag_banche.IBAN as iban_banca,conf_causale_contabile.*  from registro  left join anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idanagrafica  left join conf_causale_contabile on registro.id_causale_contabile=conf_causale_contabile.idcausale_contabile LEFT JOIN anag_banche ON registro.id_banca_appoggio=anag_banche.idAnag_banche  WHERE registro.idregistro='" + id + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = (ResultSetMetaData)res.getMetaData();
            while (res.next()) {
                this.setIdregistro(id);
                this.setNum_reg(res.getInt("num_reg"));
                this.setAnno_prot(res.getInt("anno_prot"));
                this.setAnno_reg(res.getInt("anno_reg"));
                this.setData_doc(res.getString("data_doc"));
                this.setData_reg(res.getString("data_reg"));
                this.setIban_cf(res.getString("iban_cf"));
                this.setId_banca_appoggio(res.getInt("id_banca_appoggio"));
                this.setDesc_banca(res.getString("desc_banca"));
                this.setIban_banca(res.getString("iban_banca"));
                this.setId_causale_contabile(res.getInt("id_causale_contabile"));
                this.setId_anag_e_basta(res.getInt("id_anagrafica"));
                this.setId_registro_iva(res.getInt("id_conf_registri_iva"));
                this.setImporto_doc(new Money(res.getDouble("importo_doc")));
                this.setIva_proporzionale(res.getInt("iva_proporzionale"));
                this.setNote(res.getString("note"));
                this.setNum_doc(res.getString("num_doc"));
                this.setProtocollo_iva(res.getInt("protocollo_iva"));
                this.setTipo_cf(res.getString("tipo_cf"));
                this.setCodice_cf(res.getString("codice"));
                this.setRagione_sociale_cf(res.getString("ragione_sociale"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Registrazione non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public boolean modificaRegistrazione(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "Update registro SET num_reg='" + this.getNum_reg() + "'," + "data_reg='" + this.getData_reg() + "'," + "num_doc='" + this.getNum_doc() + "'," + "id_causale_contabile=" + this.getId_causale_contabile() + "," + "id_conf_registri_iva=" + this.f.zero_to_null(this.getId_registro_iva()) + "," + "data_doc='" + this.getData_doc() + "'," + "id_anagrafica=" + this.f.zero_to_null(this.getId_anagrafica()) + "," + "importo_doc='" + this.getImporto_doc() + "'," + "id_conf_trattamento_economico=" + this.f.zero_to_null(this.getId_trattamento_economico()) + "," + "note='" + this.getNote().replaceAll("'", "''") + "'," + "iban_cf='" + this.getIban_cf() + "'," + "id_banca_appoggio=" + this.f.zero_to_null(this.getId_banca_appoggio()) + "," + "anno_reg='" + this.fda.anno(this.getData_reg()) + "'," + "protocollo_iva='" + this.getProtocollo_iva() + "'," + "anno_prot='" + this.getAnno_prot() + "'," + "iva_proporzionale='" + this.getIva_proporzionale() + "' " + "WHERE idregistro='" + this.getIdregistro() + "'"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Registro non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        boolean ris_partita2 = true;
        if (this.getInsieme_p_da_eliminare() != null && !this.getInsieme_p_da_eliminare().vettoreP.isEmpty()) {
            for (Partita p : this.getInsieme_p_da_eliminare().vettoreP) {
                ris_partita2 = p.eliminaPartita(false);
            }
        }
        if (!ris_partita2) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica registro  non riuscito per eliminazione partite");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        boolean ris_partita = true;
        int id_p = 0;
        if (this.getInsieme_p() != null && !this.getInsieme_p().vettoreP.isEmpty()) {
            for (Partita p : this.getInsieme_p().vettoreP) {
                if (p.getId() == 0 || p.getTipo_partita().equals("S")) {
                    p.setId_registro(this.getIdregistro());
                    ris_partita = p.inserisciPartita(false);
                } else {
                    ris_partita = p.modificaPartita(false);
                }
                id_p = p.getId();
            }
        }
        if (!ris_partita) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica registro  non riuscito per inserimento/modifica partite");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        boolean ris_om = true;
        if (this.getInsieme_iva_da_eliminare() != null && !this.getInsieme_iva_da_eliminare().vettoreIVAPN.isEmpty()) {
            try {
                for (PNIva s : this.getInsieme_iva_da_eliminare().vettoreIVAPN) {
                    ris_om = s.eliminaPNIva(false);
                }
            }
            catch (Exception e) {
                MyTrace.log.severe("ECCEZIONE su Registrazione.svuota PNIVA() ECCEZIONE:[" + e + "]");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                return false;
            }
        }
        if (!ris_om) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Registrou non riuscita per eliminazione iva");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        boolean ris_iva = true;
        for (PNIva pni : this.getInsieme_iva().vettoreIVAPN) {
            if (pni.getId() == 0) {
                pni.setId_registro(this.getIdregistro());
                pni.setProtocollo_iva(this.getProtocollo_iva());
                ris_iva = pni.inserisciPNIva(false);
                continue;
            }
            pni.setProtocollo_iva(this.getProtocollo_iva());
            ris_iva = pni.modificaPNIva(false);
        }
        if (!ris_iva) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Registrou non riuscita per inserimenti/modifica iva");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        boolean ris_riga = true;
        for (PNRiga pnr : this.getInsieme_righe().vettoreRPN) {
            if (pnr.getId() == 0) {
                pnr.setId_registro(this.getIdregistro());
                ris_riga = pnr.inserisciPNRiga(false);
                continue;
            }
            if (pnr.getId_conto() == 0 && pnr.getImporto().isZero()) {
                ris_riga = pnr.eliminaPNRiga(false);
                continue;
            }
            ris_riga = pnr.modificaPNRiga(false);
        }
        if (!ris_riga) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Registrou non riuscita per righe gestione");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        boolean ris_s_el = true;
        if (this.getInsieme_s_da_eliminare() != null && !this.getInsieme_s_da_eliminare().vettoreS.isEmpty()) {
            try {
                for (Scadenza s : this.getInsieme_s_da_eliminare().vettoreS) {
                    ris_s_el = s.eliminaScadenza(false);
                }
            }
            catch (Exception e) {
                MyTrace.log.severe("ECCEZIONE su Registrazione.svuotaScadenze() ECCEZIONE:[" + e + "]");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                return false;
            }
        }
        if (!ris_s_el) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica registro non riuscita per eliminazione scadenze");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        boolean ris_s = true;
        if (this.getInsieme_s() != null && !this.getInsieme_s().vettoreS.isEmpty()) {
            for (Scadenza s : this.getInsieme_s().vettoreS) {
                if (s.getId() == 0) {
                    s.setId_registro(this.getIdregistro());
                    s.setId_partita_c(id_p);
                    ris_s = s.inserisciScadenza(false);
                    continue;
                }
                ris_s = s.modificaScadenza(false);
            }
        }
        if (!ris_s) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica registro non riuscita per inserimento scadenze");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','registro','" + this.getIdregistro() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Registro non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void selezionaDati() {
        MyTrace.log.info("SELEZIONA  DATI:>");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        this.setCc(new CausaleContabile());
        this.getCc().seleziona(this.getId_causale_contabile());
        this.getCc().seleziona_dettagli();
        this.getAnagrafica().setIdanag(this.getId_anagrafica());
        this.getAnagrafica().seleziona_da_id(this.getId_anagrafica());
        this.getAnagrafica().seleziona_dettagli();
        MyTrace.log.info("PERFORMANCE: Causale Contabile e C/F in =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        if (this.getId_trattamento_economico() != 0) {
            this.setTe(new TrattamentoEconomico());
            this.getTe().setId(this.getId_trattamento_economico());
            String w = " where idtrattamento_economico=" + this.getId_trattamento_economico() + " ";
            this.getTe().seleziona(w);
            this.getTe().seleziona_dettagli();
        }
        MyTrace.log.info("PERFORMANCE: TRATTAMENTO ECONOMICO in =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        this.setRi(new RegistriIVA());
        this.getRi().seleziona(this.getId_registro_iva());
        MyTrace.log.info("PERFORMANCE: REGISTRO IVA in =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        this.setInsieme_p(new InsiemePartite());
        String where = " WHERE id_registro='" + this.getIdregistro() + "'";
        int quanti = this.getInsieme_p().caricamento(where, "");
        for (Partita p : this.getInsieme_p().vettoreP) {
            if (!p.getTipo_partita().equals("S")) continue;
            p.seleziona_scadenza_saldata();
        }
        MyTrace.log.info("PERFORMANCE: SELEZIONO LA PARTITA in =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        if (this.getCc().getTm().getTipo_partita().equals("S")) {
            this.setInsieme_p_da_eliminare(new InsiemePartite());
            for (Partita p : this.getInsieme_p().vettoreP) {
                this.getInsieme_p_da_eliminare().vettoreP.add(p);
            }
        }
        String w_iva = " WHERE registro_iva.id_registro='" + this.getIdregistro() + "'";
        this.setInsieme_iva(new InsiemePNIva());
        this.getInsieme_iva().caricamento(w_iva, "");
        Iterator i = this.getInsieme_iva().vettoreIVAPN.iterator();
        while (i.hasNext()) {
            ((PNIva)i.next()).setR(this);
        }
        MyTrace.log.info("PERFORMANCE: SELEZIONO LE RIGHE IVA in =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        this.seleziona_righe();
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        String w = " WHERE id_registro='" + this.getIdregistro() + "'";
        this.setInsieme_s(new InsiemeScadenze());
        this.getInsieme_s().caricamento(w, "");
        this.setInsieme_s_da_eliminare(new InsiemeScadenze());
        MyTrace.log.info("PERFORMANCE: SELEZIONO LE SCADENZE in =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
    }

    public void seleziona_righe() {
        String where2 = " WHERE gestione.id_registro='" + this.getIdregistro() + "'";
        this.setInsieme_righe(new InsiemePNRiga());
        this.getInsieme_righe().ccaricamento(where2, " group by gestione.idgestione ");
        Iterator i2 = this.getInsieme_righe().vettoreRPN.iterator();
        while (i2.hasNext()) {
            ((PNRiga)i2.next()).setR(this);
        }
        MyTrace.log.info("PERFORMANCE: SELEZIONO LE RIGHE in =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
    }

    public boolean costruisci_scadenze(boolean in_new, String partenza, boolean iva_p, String note) {
        if (this.getTe() == null) {
            this.setMessage("Inserire il trattamento Economico");
            return false;
        }
        boolean posso = true;
        if (this.getInsieme_s_da_eliminare() == null) {
            this.setInsieme_s_da_eliminare(new InsiemeScadenze());
        }
        if (this.getInsieme_s() == null || in_new) {
            this.setInsieme_s(new InsiemeScadenze());
            posso = true;
        } else {
            for (Scadenza s : this.getInsieme_s().vettoreS) {
                if (s.getPagato() != 1 && s.getImporto_saldato().isZero()) continue;
                posso = false;
            }
        }
        if (posso) {
            for (Scadenza s : this.getInsieme_s().vettoreS) {
                if (s.getId() == 0) continue;
                this.getInsieme_s_da_eliminare().vettoreS.add(s);
            }
            Money tot_iva = new Money(BigDecimal.ZERO);
            Money tot_imponibile = new Money(BigDecimal.ZERO);
            this.setInsieme_s(new InsiemeScadenze());
            if (this.getInsieme_iva() != null) {
                Iterator i = this.getInsieme_iva().vettoreIVAPN.iterator();
                int segno = 0;
                int count = 0;
                while (i.hasNext()) {
                    PNIva pni = (PNIva)i.next();
                    if (count == 0) {
                        segno = pni.getSegno();
                    }
                    tot_iva = pni.getSegno() == segno ? tot_iva.plus(pni.getImposta()) : tot_iva.minus(pni.getImposta());
                    ++count;
                }
            }
            if (this.getInsieme_righe() != null) {
                for (PNRiga pnr : this.getInsieme_righe().vettoreRPN) {
                    Money valore = new Money(BigDecimal.ZERO);
                    valore = pnr.getSegno() == 1 ? pnr.getImporto() : pnr.getImporto().negate();
                    tot_imponibile = tot_imponibile.plus(valore);
                }
            }
            if (tot_imponibile.isMinus()) {
                tot_imponibile = tot_imponibile.negate();
            }
            Iterator ii = this.getTe().getI_rate().vettoreTE.iterator();
            int count = 0;
            while (ii.hasNext()) {
                ConfRata cf = (ConfRata)ii.next();
                Scadenza s = new Scadenza();
                boolean fm = this.getTe().getPartenza().equals("Fine Mese");
                s.setData_scadenza(this.fda.calcola_scadenza(partenza, cf.getGiorni(), fm));
                s.setPercentuale_imponibile(tot_imponibile.times(cf.getPercentuale() / 100.0));
                if (iva_p) {
                    s.setPercentuale_imposta(tot_iva.times(cf.getPercentuale() / 100.0));
                } else if (count == 0) {
                    s.setPercentuale_imposta(tot_iva);
                } else {
                    s.setPercentuale_imposta(new Money(BigDecimal.ZERO));
                }
                s.setImporto(s.getPercentuale_imponibile().plus(s.getPercentuale_imposta()));
                s.setNote(note);
                s.setPagato(0);
                s.setImporto_saldato(new Money(BigDecimal.ZERO));
                this.getInsieme_s().vettoreS.add(s);
                ++count;
            }
        } else {
            this.setMessage("non posso modificare le scadenze di questa registrazione perch\u00e8 sono state pagate.Salvando le scadenze non verranno modificate.");
            return false;
        }
        return true;
    }

    public boolean elimina(int id) {
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getData_docIt();
                break;
            }
            case 1: {
                retVal = "" + this.getNum_doc() + "/" + this.getAnno_doc();
                break;
            }
            case 2: {
                retVal = "" + this.getCodice_causale_contabile();
                break;
            }
            case 3: {
                retVal = "" + this.getNum_reg() + "/" + this.getAnno_reg();
                break;
            }
            case 4: {
                retVal = "" + this.getData_regIt();
                break;
            }
            case 5: {
                if (this.getCodice_ri() != null) {
                    retVal = "" + this.getProtocollo_iva() + "/" + this.getCodice_ri();
                    break;
                }
                retVal = "";
                break;
            }
            case 6: {
                retVal = "" + this.getImporto_doc();
                break;
            }
            case 7: {
                if (this.getTipo_cf().equals("F") || this.getTipo_cf().equals("C")) {
                    retVal = "" + this.getTipo_cf() + this.getCodice_cf();
                    break;
                }
                retVal = "";
                break;
            }
            case 8: {
                if (this.getTipo_cf().equals("F") || this.getTipo_cf().equals("C")) {
                    retVal = "" + this.getRagione_sociale_cf();
                    break;
                }
                retVal = "";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueCorrispettivi(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getData_docIt();
                break;
            }
            case 1: {
                retVal = "" + this.getCodice_causale_contabile();
                break;
            }
            case 2: {
                retVal = "" + this.getNum_reg() + "/" + this.getAnno_reg();
                break;
            }
            case 3: {
                retVal = "" + this.getData_regIt();
                break;
            }
            case 4: {
                retVal = "" + this.getImporto_doc();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

