/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.primanota.Partita;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class PartiteTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    String tipo_cf;
    boolean modificabile;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public PartiteTableModel(String tipo_cf) {
        this.cache = new Vector();
        this.tipo_cf = tipo_cf;
        this.modificabile = true;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public boolean isModificabile() {
        return this.modificabile;
    }

    public void setModificabile(boolean modificabile) {
        this.modificabile = modificabile;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "C/F";
                break;
            }
            case 1: {
                retVal = "Conto";
                break;
            }
            case 2: {
                retVal = "Descrizione Conto";
                break;
            }
            case 3: {
                retVal = "Codice";
                break;
            }
            case 4: {
                retVal = "Ragione Sociale";
                break;
            }
            case 5: {
                retVal = "Importo";
                break;
            }
            case 6: {
                retVal = "Segno";
                break;
            }
            case 7: {
                retVal = "Tipo Partita";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Partita p = new Partita();
        if (!this.cache.isEmpty()) {
            p = (Partita)this.cache.elementAt(row);
            return p.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        try {
            if (c == 6) {
                return JCheckBox.class;
            }
            return this.getValueAt(0, c).getClass();
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getColumnClass con c=" + c);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return JLabel.class;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setDataPartitaRiga(Vector vettoreP) {
        this.cache = new Vector();
        Iterator i = vettoreP.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

