/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.primanota.Registrazione;
import gestionale.scadenziario.Scadenza;
import java.math.BigDecimal;
import java.sql.ResultSet;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class Partita {
    private int id;
    private int id_registro;
    private int segno;
    private int id_p_rif;
    private int id_anagrafica;
    private int num_reg;
    private int protocollo_iva;
    private int id_conto_cf;
    private Money importo = new Money(BigDecimal.ZERO);
    private Money tot_che_saldo = new Money(BigDecimal.ZERO);
    private String tipo_cf;
    private String tipo_partita;
    private String note;
    private String anno_prot;
    private String codice_cf;
    private String ragione_sociale_cf;
    private String descrizione_cc;
    private String data_doc;
    private String protocollo;
    private String documento;
    private String descrizione;
    private String cd_conto_cf;
    private Anagrafica anagrafica;
    private boolean da_eliminare = false;
    private Scadenza s_che_saldo;
    private Funzioni ff = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();
    boolean fittizia = false;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public Anagrafica getAnagrafica() {
        return this.anagrafica;
    }

    public void setAnagrafica(Anagrafica anagrafica) {
        this.anagrafica = anagrafica;
    }

    public int getNum_reg() {
        return this.num_reg;
    }

    public void setNum_reg(int num_reg) {
        this.num_reg = num_reg;
    }

    public int getProtocollo_iva() {
        return this.protocollo_iva;
    }

    public void setProtocollo_iva(int protocollo_iva) {
        this.protocollo_iva = protocollo_iva;
    }

    public int getId_anagrafica() {
        return this.id_anagrafica;
    }

    public void setId_anagrafica(int id_anagrafica) {
        this.id_anagrafica = id_anagrafica;
        Anagrafica c = new Anagrafica();
        c.seleziona_da_id(id_anagrafica);
        this.setAnagrafica(c);
    }

    public int getId_registro() {
        return this.id_registro;
    }

    public void setId_registro(int id_registro) {
        this.id_registro = id_registro;
    }

    public Money getImporto() {
        return this.importo;
    }

    public void setImporto(Money importo) {
        this.importo = importo;
    }

    public int getSegno() {
        return this.segno;
    }

    public void setSegno(int segno) {
        this.segno = segno;
    }

    public String getTipo_partita() {
        return this.tipo_partita;
    }

    public void setTipo_partita(String tipo_partita) {
        this.tipo_partita = tipo_partita;
    }

    public String getCodice_cf() {
        return this.codice_cf;
    }

    public void setCodice_cf(String codice_cf) {
        this.codice_cf = codice_cf;
    }

    public String getRagione_sociale_cf() {
        return this.ragione_sociale_cf;
    }

    public void setRagione_sociale_cf(String ragione_sociale_cf) {
        this.ragione_sociale_cf = ragione_sociale_cf;
    }

    public Money getTot_che_saldo() {
        return this.tot_che_saldo;
    }

    public void setTot_che_saldo(Money tot_che_saldo) {
        this.tot_che_saldo = tot_che_saldo;
    }

    public int getId_p_rif() {
        return this.id_p_rif;
    }

    public void setId_p_rif(int id_p_rif) {
        this.id_p_rif = id_p_rif;
    }

    public boolean isDa_eliminare() {
        return this.da_eliminare;
    }

    public void setDa_eliminare(boolean da_eliminare) {
        this.da_eliminare = da_eliminare;
    }

    public String getDescrizione_cc() {
        return this.descrizione_cc;
    }

    public void setDescrizione_cc(String descrizione_cc) {
        this.descrizione_cc = descrizione_cc;
    }

    public String getData_docIT() {
        return this.fda.gira_data(this.data_doc);
    }

    public String getData_doc() {
        return this.data_doc;
    }

    public void setData_doc(String data_doc) {
        this.data_doc = data_doc;
    }

    public String getDocumento() {
        return this.documento;
    }

    public void setDocumento(String documento) {
        this.documento = documento;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public Scadenza getS_che_saldo() {
        return this.s_che_saldo;
    }

    public void setS_che_saldo(Scadenza s_che_saldo) {
        this.s_che_saldo = s_che_saldo;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getAnno_prot() {
        return this.anno_prot;
    }

    public void setAnno_prot(String anno_prot) {
        this.anno_prot = anno_prot;
    }

    public String getCd_conto_cf() {
        return this.cd_conto_cf;
    }

    public void setCd_conto_cf(String cd_conto_cf) {
        this.cd_conto_cf = cd_conto_cf;
    }

    public int getId_conto_cf() {
        return this.id_conto_cf;
    }

    public void setId_conto_cf(int id_conto_cf) {
        this.id_conto_cf = id_conto_cf;
    }

    public boolean isFittizia() {
        return this.fittizia;
    }

    public void setFittizia(boolean fittizia) {
        this.fittizia = fittizia;
    }

    public void seleziona_scadenza_saldata() {
        String query = "Select * from partite_rif where id_ps=" + this.getId() + " ";
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                this.setId_p_rif(res.getInt("id_pc"));
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Partita rif non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        String where = " WHERE scadenze_partite_rif.id_partita_saldo=" + this.getId();
        this.setS_che_saldo(new Scadenza());
        this.getS_che_saldo().seleziona_scadenza_saldata(where);
    }

    public void seleziona() {
        String query = "";
        query = "SELECT partite.*,anag_anagrafica.codice as codice,anag_anagrafica.ragione_sociale as ragione_sociale  fROM partite  LEFT JOIN anag_anagrafica ON partite.id_anagrafica=anag_anagrafica.idanagrafica  WHERE idpartite=" + this.getId() + " ";
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                this.setId(res.getInt("idpartite"));
                this.setId_registro(res.getInt("id_registro"));
                this.setTipo_cf(res.getString("tipo_cf"));
                this.setSegno(res.getInt("segno"));
                this.setId_anagrafica(res.getInt("id_anagrafica"));
                this.setImporto(new Money(res.getDouble("importo")));
                this.setTipo_partita(res.getString("tipo_partita"));
                this.setRagione_sociale_cf(res.getString("ragione_sociale"));
                this.setCodice_cf(res.getString("codice"));
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Partita non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
    }

    public boolean inserisciPartita(boolean da_solo) {
        if (!this.getImporto().isZero()) {
            String q_trace;
            boolean r_trace;
            String query_ins;
            boolean r_ins;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO partite(id_registro,tipo_cf,id_anagrafica,segno,importo,tipo_partita) VALUES ('" + this.getId_registro() + "', " + "'" + this.getTipo_cf() + "', " + "" + this.ff.zero_to_null(this.getId_anagrafica()) + ", " + "'" + this.getSegno() + "', " + "'" + this.getImporto() + "', " + "'" + this.getTipo_partita() + "')"))) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento partita non riuscito");
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            this.setId(Configurazioni.getIstanza().connessione.id_inserito("partite"));
            if (this.getTipo_partita().equals("S") && this.getId_p_rif() != 0) {
                String q_rif = "INSERT into partite_rif(id_pc,id_ps) VALUES (" + this.getId_p_rif() + "," + this.getId() + ") ";
                boolean r_rif = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_rif);
                if (!r_rif) {
                    Configurazioni.getIstanza().connessione.rollback();
                    MyTrace.log.severe("Inserimento partita non riuscito per partite rif");
                    Configurazioni.eccezione.gestisci("2.2", null);
                    return false;
                }
                boolean res_saldo = true;
                if (this.getS_che_saldo() != null) {
                    this.getS_che_saldo().setId_partita_s(this.getId());
                    res_saldo = this.getS_che_saldo().saldaScadenza(false);
                }
                if (!res_saldo) {
                    Configurazioni.getIstanza().connessione.rollback();
                    MyTrace.log.severe("Inserimento partite non riuscito per aldo scadenza");
                    Configurazioni.eccezione.gestisci("2.2", null);
                    return false;
                }
            }
            if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','partite','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')"))) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento  partita non riuscito per trace");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        return true;
    }

    public boolean modificaPartita(boolean da_solo) {
        if (!this.getImporto().isZero()) {
            String query_mod;
            boolean r_mod;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE  partite  SET  segno='" + this.getSegno() + "'," + " importo='" + this.getImporto() + "'," + " id_anagrafica=" + this.ff.zero_to_null(this.getId_anagrafica()) + " " + " WHERE idpartite='" + this.getId() + "'"))) {
                MyTrace.log.severe("Modifica  partita  non riuscita");
                Configurazioni.eccezione.gestisci("3.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            boolean res_saldo = true;
            if (this.getTipo_partita().equals("S") && this.getId_p_rif() != 0 && this.getS_che_saldo() != null) {
                this.getS_che_saldo().setId_partita_s(this.getId());
                res_saldo = this.getS_che_saldo().saldaScadenza(false);
            }
            if (!res_saldo) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Modifica  partita  non riuscita per saldo scadenza");
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','partite','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Modifica  partita non riuscita per trace");
                Configurazioni.eccezione.gestisci("3.3", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        return this.eliminaPartita(da_solo);
    }

    private boolean elimina_riferimento() {
        String sql = "DELETE FROM partite_rif where id_ps=" + this.getId();
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(sql);
        if (!r_del) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina riferimento  non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        return true;
    }

    public boolean eliminaPartita(boolean da_solo) {
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        boolean res1 = true;
        boolean res2 = true;
        if (this.getTipo_partita().equals("S")) {
            if (this.getS_che_saldo() == null) {
                this.seleziona_scadenza_saldata();
            }
            res1 = this.getS_che_saldo().dissaldaScadenza(false);
        }
        if (!res1) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento scadenza_partite_rif  non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        res2 = this.elimina_riferimento();
        if (!res2) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina partita  non riuscito per partite_rif");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String query_del = "DELETE FROM partite WHERE idpartite='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_del) {
            MyTrace.log.severe("Elimina partita non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','partite','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina Partita non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        try {
            switch (col) {
                case 0: {
                    retVal = this.getTipo_cf();
                    break;
                }
                case 1: {
                    retVal = this.getAnagrafica() != null ? this.getAnagrafica().getConto_appartenenza_codice() : "";
                    System.out.println("RETVAL" + retVal);
                    break;
                }
                case 2: {
                    if (this.getAnagrafica() != null) {
                        retVal = this.getAnagrafica().getConto_appartenenza_descrizione();
                        break;
                    }
                    retVal = "";
                    break;
                }
                case 3: {
                    if (this.getAnagrafica() != null) {
                        retVal = "C" + this.getAnagrafica().getCodice();
                        break;
                    }
                    retVal = "";
                    break;
                }
                case 4: {
                    if (this.getAnagrafica() != null) {
                        retVal = this.getAnagrafica().getRagione_sociale();
                        break;
                    }
                    retVal = "";
                    break;
                }
                case 5: {
                    retVal = this.ff.formattaNumero("" + this.getImporto());
                    break;
                }
                case 6: {
                    retVal = this.ff.string_segno(this.getSegno(), 0);
                    break;
                }
                case 7: {
                    retVal = this.getTipo_partita();
                    break;
                }
                default: {
                    retVal = "";
                    break;
                }
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("getColValue() ECCEZIONE");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        return retVal;
    }

    Object getColValueConti(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getData_docIT();
                break;
            }
            case 1: {
                retVal = this.getDescrizione();
                break;
            }
            case 2: {
                if (this.getSegno() == 1) {
                    retVal = this.ff.formattaNumero("" + this.getImporto());
                    break;
                }
                retVal = "";
                break;
            }
            case 3: {
                if (this.getSegno() == 2) {
                    retVal = this.ff.formattaNumero("" + this.getImporto());
                    break;
                }
                retVal = "";
                break;
            }
            case 4: {
                retVal = this.getDescrizione_cc();
                break;
            }
            case 5: {
                Registrazione r = new Registrazione();
                r.seleziona(this.getId_registro());
                retVal = r.getProtocollo_iva() + "/" + r.getAnno_prot();
                break;
            }
            case 6: {
                if (!this.getDocumento().equals("null") && !this.getDocumento().equals("")) {
                    retVal = this.getDocumento() + "/" + this.fda.anno(this.getData_doc());
                    break;
                }
                retVal = "";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

