/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import controlling.regole.Regola;
import controlling.voci_di_analisi.VoceDiAnalisi;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.piano_dei_conti.Conto5;
import gestionale.primanota.Registrazione;
import java.math.BigDecimal;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class PNRiga {
    private int id;
    private int id_registro;
    private int segno;
    private int id_conto;
    private int id_vda;
    private int id_regola;
    private int bloccato = 0;
    private int id_anagrafica;
    private int num_reg;
    private int id_vda_conto;
    private int id_cc;
    private int cc_editabile;
    private int inserimento_analitica;
    private Money importo = new Money(BigDecimal.ZERO);
    private String note = "";
    private String inizio_competenza;
    private String fine_competenza;
    private String note_registrazione;
    private String num_doc;
    private String cd_conto = "";
    private String descrizione_conto = "";
    private Registrazione r;
    private Conto5 c;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();
    private String data_doc;
    private String data_reg;
    private String descrizione;
    private String descrizione_cc;
    private String protocollo;
    private String documento;
    private String tipo_cf;
    private String ragione_sociale_cf;
    private String tipo_partita;
    private VoceDiAnalisi vda;
    private Regola regola;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSegno() {
        return this.segno;
    }

    public void setSegno(int segno) {
        this.segno = segno;
    }

    public int getId_conto() {
        return this.id_conto;
    }

    public void setId_conto(int id_conto) {
        this.id_conto = id_conto;
        this.c = new Conto5();
        if (id_conto != 0) {
            this.c.seleziona(id_conto);
        } else {
            this.c.setDescrizione("");
            this.c.setConto("");
        }
        this.setC(this.c);
    }

    public Conto5 getC() {
        return this.c;
    }

    public void setC(Conto5 c) {
        this.c = c;
        this.setCd_conto(c.getConto());
        this.setDescrizione_conto(c.getDescrizione());
    }

    public String getCd_conto() {
        return this.cd_conto;
    }

    public void setCd_conto(String cd_conto) {
        this.cd_conto = cd_conto;
    }

    public String getDescrizione_conto() {
        return this.descrizione_conto;
    }

    public void setDescrizione_conto(String descrizione_conto) {
        this.descrizione_conto = descrizione_conto;
    }

    public int getId_vda_conto() {
        return this.id_vda_conto;
    }

    public void setId_vda_conto(int id_vda_conto) {
        this.id_vda_conto = id_vda_conto;
    }

    public int getCc_editabile() {
        return this.cc_editabile;
    }

    public void setCc_editabile(int cc_editabile) {
        this.cc_editabile = cc_editabile;
    }

    public VoceDiAnalisi getVda() {
        return this.vda;
    }

    public void setVda(VoceDiAnalisi vda) {
        this.vda = vda;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public int getId_registro() {
        return this.id_registro;
    }

    public void setId_registro(int id_registro) {
        this.id_registro = id_registro;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getNote_registrazione() {
        return this.note_registrazione;
    }

    public void setNote_registrazione(String note_registrazione) {
        this.note_registrazione = note_registrazione;
    }

    public Registrazione getR() {
        return this.r;
    }

    public void setR(Registrazione r) {
        this.r = r;
    }

    public Money getImporto() {
        return this.importo;
    }

    public void setImporto(Money importo) {
        this.importo = importo;
    }

    public String getData_reg() {
        return this.data_reg;
    }

    public void setData_reg(String data_reg) {
        this.data_reg = data_reg;
    }

    public int getId_vda() {
        return this.id_vda;
    }

    public void setId_vda(int id_vda) {
        this.id_vda = id_vda;
    }

    public String getFine_competenza() {
        return this.fine_competenza;
    }

    public String getFine_competenzaIt() {
        return this.fda.gira_data(this.fine_competenza);
    }

    public void setFine_competenza(String fine_competenza) {
        this.fine_competenza = fine_competenza;
    }

    public String getInizio_competenza() {
        return this.inizio_competenza;
    }

    public String getInizio_competenzaIt() {
        return this.fda.gira_data(this.inizio_competenza);
    }

    public void setInizio_competenza(String inizio_competenza) {
        this.inizio_competenza = inizio_competenza;
    }

    public String getData_doc_it() {
        return this.fda.gira_data(this.data_doc);
    }

    public String getData_doc() {
        return this.data_doc;
    }

    public void setData_doc(String data_doc) {
        this.data_doc = data_doc;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public String getDescrizione_cc() {
        return this.descrizione_cc;
    }

    public void setDescrizione_cc(String descrizione_cc) {
        this.descrizione_cc = descrizione_cc;
    }

    public String getDocumento() {
        return this.documento;
    }

    public void setDocumento(String documento) {
        this.documento = documento;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public int getBloccato() {
        return this.bloccato;
    }

    public void setBloccato(int bloccato) {
        this.bloccato = bloccato;
    }

    public int getId_regola() {
        return this.id_regola;
    }

    public void setId_regola(int id_regola) {
        this.id_regola = id_regola;
    }

    public int getId_anagrafica() {
        return this.id_anagrafica;
    }

    public void setId_anagrafica(int id_anagrafica) {
        this.id_anagrafica = id_anagrafica;
    }

    public String getRagione_sociale_cf() {
        return this.ragione_sociale_cf;
    }

    public void setRagione_sociale_cf(String ragione_sociale_cf) {
        this.ragione_sociale_cf = ragione_sociale_cf;
    }

    public String getNum_doc() {
        return this.num_doc;
    }

    public void setNum_doc(String num_doc) {
        this.num_doc = num_doc;
    }

    public int getNum_reg() {
        return this.num_reg;
    }

    public void setNum_reg(int num_reg) {
        this.num_reg = num_reg;
    }

    public String getTipo_partita() {
        return this.tipo_partita;
    }

    public void setTipo_partita(String tipo_partita) {
        this.tipo_partita = tipo_partita;
    }

    public int getId_cc() {
        return this.id_cc;
    }

    public void setId_cc(int id_cc) {
        this.id_cc = id_cc;
    }

    public int getInserimento_analitica() {
        return this.inserimento_analitica;
    }

    public void setInserimento_analitica(int inserimento_analitica) {
        this.inserimento_analitica = inserimento_analitica;
    }

    public Regola getRegola() {
        return this.regola;
    }

    public void setRegola(Regola regola) {
        this.regola = regola;
    }

    public boolean inserisciPNRiga(boolean da_solo) {
        if (!this.getImporto().isZero()) {
            String query_ins;
            boolean r_ins;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO gestione(id_registro,idConto,segno,importo,note,id_vda,id_regola,inizio_competenza,fine_competenza,bloccato) VALUES (" + this.getId_registro() + ", " + "'" + this.getId_conto() + "', " + "'" + this.getSegno() + "', " + "'" + this.getImporto() + "', " + "'" + this.getNote().replaceAll("'", "''") + "', " + "'" + this.getId_vda() + "', " + "" + this.f.zero_to_null(this.getId_regola()) + ", " + "'" + this.getInizio_competenza() + "', " + "'" + this.getFine_competenza() + "'," + "'" + this.getBloccato() + "')"))) {
                MyTrace.log.severe("Inserimento riga prima nota non riuscito");
                Configurazioni.eccezione.gestisci("2.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.setId(Configurazioni.getIstanza().connessione.id_inserito("gestione"));
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','gestione','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Inserimento  riga pn non riuscito per trace");
                Configurazioni.eccezione.gestisci("2.3", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            boolean res_tot = true;
            if (this.getR() == null || this.getR().getCc() == null || this.getR().getCc().getEditabile() != 1 || this.getR().getCc().getTm() == null || this.getR().getCc().getTm().getInserimento_analitica() == 1) {
                // empty if block
            }
            if (!res_tot) {
                MyTrace.log.severe("Inserimento  riga pn non riuscito per Analitica");
                Configurazioni.eccezione.gestisci("2.3", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        return true;
    }

    public boolean modificaPNRiga(boolean da_solo) {
        if (this.getId_regola() == 0) {
            this.setId_regola(1);
        }
        if (this.getId_vda() == 0) {
            this.setId_vda(1);
        }
        if (!this.getImporto().isZero()) {
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            String query_mod = "UPDATE  gestione  SET  idConto='" + this.getId_conto() + "'," + " segno='" + this.getSegno() + "'," + " importo='" + this.getImporto() + "'," + " note='" + this.getNote().replaceAll("'", "''") + "'," + " id_vda=" + this.f.zero_to_null(this.getId_vda()) + "," + " id_regola=" + this.f.zero_to_null(this.getId_regola()) + "," + " inizio_competenza='" + this.getInizio_competenza() + "'," + " fine_competenza='" + this.getFine_competenza() + "' " + " WHERE idGestione='" + this.getId() + "'";
            boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
            Conto5 conto = new Conto5();
            conto.seleziona(this.getId_conto());
            conto.aggiorna_id_vda_su_conto(this.getId_conto(), this.getId_vda());
            if (!r_mod) {
                MyTrace.log.severe("Modifica  riga pn  non riuscita");
                Configurazioni.eccezione.gestisci("3.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','gestione','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Modifica  riga pn non riuscita per trace");
                Configurazioni.eccezione.gestisci("3.3", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        return this.eliminaPNRiga(da_solo);
    }

    public boolean eliminaPNRiga(boolean da_solo) {
        String query_del;
        boolean r_del;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE from gestione WHERE idgestione='" + this.getId() + "'"))) {
            MyTrace.log.severe("Elimina  Riga gestionee non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','gestione','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina  iva Causale Contabile non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getCd_conto();
                break;
            }
            case 1: {
                retVal = this.getDescrizione_conto();
                break;
            }
            case 2: {
                retVal = this.f.string_segno(this.getSegno(), 0);
                break;
            }
            case 3: {
                retVal = "" + this.getImporto();
                break;
            }
            case 4: {
                retVal = this.getNote();
                break;
            }
            case 5: {
                String vda_da_id = this.f.descrizione_vda_da_id(this.getId_vda());
                if (vda_da_id.equals("")) {
                    VoceDiAnalisi voce = new VoceDiAnalisi();
                    String where = " WHERE idvoci_di_analisi=" + this.getId_vda_conto() + " ";
                    voce.seleziona(where);
                    retVal = "" + voce.getDescrizione_voce();
                    break;
                }
                retVal = (" " + vda_da_id + " ").replaceAll(" null ", "");
                break;
            }
            case 6: {
                String nome_regola_da_id = this.f.nome_regola_da_id(this.getId_regola());
                if (nome_regola_da_id.equals("")) {
                    VoceDiAnalisi voce = new VoceDiAnalisi();
                    String where = " WHERE idvoci_di_analisi=" + this.getId_vda_conto() + " ";
                    voce.seleziona(where);
                    Regola regola = new Regola();
                    String w = " WHERE ctrl_regole.idregole=" + voce.getId_regola_predefinita() + " ";
                    regola.seleziona(w);
                    retVal = "" + (" " + regola.getNome() + " ").replaceAll(" null ", "");
                    break;
                }
                retVal = nome_regola_da_id;
                break;
            }
            case 7: {
                retVal = "" + this.getInizio_competenzaIt();
                break;
            }
            case 8: {
                retVal = "" + this.getFine_competenzaIt();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueConti(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getData_doc_it();
                break;
            }
            case 1: {
                retVal = this.getDescrizione();
                break;
            }
            case 2: {
                if (this.getSegno() == 1) {
                    retVal = this.f.formattaNumero("" + this.getImporto());
                    break;
                }
                retVal = "";
                break;
            }
            case 3: {
                if (this.getSegno() == 2) {
                    retVal = this.f.formattaNumero("" + this.getImporto());
                    break;
                }
                retVal = "";
                break;
            }
            case 4: {
                retVal = this.getDescrizione_cc();
                break;
            }
            case 5: {
                Registrazione r = new Registrazione();
                r.seleziona(this.getId_registro());
                retVal = r.getNum_reg() + "/" + r.getAnno_reg();
                break;
            }
            case 6: {
                if (!this.getDocumento().equals("") && this.getDocumento() != null && !this.getDocumento().equals("null")) {
                    retVal = this.getDocumento() + "/" + this.fda.anno(this.getData_doc());
                    break;
                }
                retVal = "";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

