/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.primanota.PNIva;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.Money;

public class PNIvaTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();

    public PNIvaTableModel() {
        this.cache = new Vector();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Codice";
                break;
            }
            case 1: {
                retVal = "Descrizione";
                break;
            }
            case 2: {
                retVal = "Imponibile";
                break;
            }
            case 3: {
                retVal = "%IVA";
                break;
            }
            case 4: {
                retVal = "Imposta";
                break;
            }
            case 5: {
                retVal = "%IND";
                break;
            }
            case 6: {
                retVal = "Imposta IND";
                break;
            }
            case 7: {
                retVal = "Mese";
                break;
            }
            case 8: {
                retVal = "Anno";
                break;
            }
            case 9: {
                retVal = "Conto IVA";
                break;
            }
            case 10: {
                retVal = "Segno";
                break;
            }
            case 11: {
                retVal = "Note";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public Object getValueAt(int row, int col) {
        PNIva pn_iva = new PNIva();
        if (!this.cache.isEmpty()) {
            pn_iva = (PNIva)this.cache.elementAt(row);
            return pn_iva.getColValue(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PNIva pn_iva = new PNIva();
        pn_iva = (PNIva)this.cache.elementAt(row);
        if (col == 0) {
            pn_iva.setId_aliquota(this.f.id_aliquota_iva(value.toString()));
        }
        if (col == 2) {
            if (pn_iva.getA() != null && !value.toString().equals("")) {
                Money valore = new Money(value.toString());
                pn_iva.setImporto_riga(valore.plus(valore.times(pn_iva.getA().getAliquota() / 100.0)));
            } else {
                JOptionPane.showMessageDialog(null, "Scegli prima  l'aliquota");
            }
        }
        if (col == 10) {
            pn_iva.setSegno(this.f.int_segno(value.toString()));
        }
        if (col == 11) {
            pn_iva.setNote(value.toString());
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c == 10) {
            return JCheckBox.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 2 || col == 10 || col == 11;
    }

    public void setDataPNIva(Vector vettorePNI) {
        this.cache = new Vector();
        Iterator i = vettorePNI.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

