/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.primanota.Partita;
import gestionale.primanota.Registrazione;
import gestionale.scadenziario.InsiemeScadenze;
import gestionale.scadenziario.Scadenza;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import utils.Funzioni;

public class MyStoricoFattura
extends JInternalFrame {
    private Registrazione reg;
    MyTree jTree1;
    private Funzioni f = new Funzioni();

    public MyStoricoFattura(Registrazione r) {
        this.reg = r;
        this.setOpaque(false);
        this.jTree1 = new MyTree();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.initComponents();
        jScrollPane1.setViewportView(this.jTree1);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        this.jTree1.getSelectionModel().setSelectionMode(1);
        this.jTree1.setOpaque(false);
        jScrollPane1.setOpaque(false);
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(700, 350)));
    }

    private void initComponents() {
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Storico Fattura");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyStoricoFattura.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyStoricoFattura.this.finestra_ridimensionata(evt);
            }
        });
        this.pack();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyStoricoFattura(null).setVisible(true);
            }
        });
    }

    class MyTree
    extends JTree
    implements TreeExpansionListener {
        DefaultMutableTreeNode root;

        public MyTree() {
            this.root = new DefaultMutableTreeNode(MyStoricoFattura.this.reg.getCc().getTm().getTipo_causale() + " N\u00b0" + MyStoricoFattura.this.reg.getNum_doc() + " del " + MyStoricoFattura.this.reg.getData_docIt() + "\r\r Registrazione N\u00b0 " + MyStoricoFattura.this.reg.getNum_reg() + " del " + MyStoricoFattura.this.reg.getData_regIt());
            this.setTree();
            this.setModel(new DefaultTreeModel(this.root));
            this.addTreeExpansionListener(this);
        }

        public void setTree() {
            DefaultMutableTreeNode nscadenza = null;
            DefaultMutableTreeNode npagamento = null;
            String w = " where id_registro=" + MyStoricoFattura.this.reg.getIdregistro();
            InsiemeScadenze insieme_s = new InsiemeScadenze();
            insieme_s.caricamento(w, "");
            for (Scadenza s : insieme_s.vettoreS) {
                s.seleziona_partite_di_saldo();
                String pagato = MyStoricoFattura.this.f.si_no(s.getPagato());
                nscadenza = new DefaultMutableTreeNode("Scadenza del " + s.getData_scadenza() + "\n\r Pagata= " + pagato);
                for (Partita p : s.getI_partite_saldo().vettoreP) {
                    Registrazione temp = new Registrazione();
                    temp.seleziona(p.getId_registro());
                    Partita p2 = new Partita();
                    p2.setId(p.getId_p_rif());
                    p2.seleziona();
                    npagamento = new DefaultMutableTreeNode(" Pagamento del " + temp.getData_docIt() + "di \u20ac " + p.getImporto());
                    nscadenza.add(npagamento);
                }
                this.root.add(nscadenza);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            String str = (String)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (str.equals("Parent 3")) {
                this.setExpandedState(path, false);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
        }
    }
}

