/*
 * Decompiled with CFR 0.152.
 */
package gestionale.mastrino;

import gestionale.configurazioni.Configurazioni;
import gestionale.mastrino.Mastrino;
import gestionale.personalizzazione.stampe.IntestazioneMastrino;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Vector;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaMastrino {
    FunzioniDate fda = new FunzioniDate();
    GestoreStampe stampa_mastrino = new GestoreStampe();
    Funzioni f;
    double totale_parziale;
    double totale_dare;
    double totale_avere;

    public StampaMastrino() {
        this.stampa_mastrino.aggiungi_pj();
        this.f = new Funzioni();
        this.totale_parziale = 0.0;
        this.totale_dare = 0.0;
        this.totale_avere = 0.0;
    }

    public boolean elabora(String data_da, String data_a, String codice_conto, String intestazione) {
        int y_inizio;
        Configurazioni.getIstanza();
        int y = y_inizio = Configurazioni.inizio_stampe;
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA MASTRINO INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        long tempo_di_visualizzazione = System.currentTimeMillis();
        boolean id_cf = false;
        String date_now = this.fda.dataCorrente().replaceAll("-", "");
        String ora_now = this.fda.OraCorrente().replaceAll(":", "");
        this.stampa_mastrino.setIntPP((OggettoToPrint)new IntestazioneMastrino());
        this.stampa_mastrino.setInt((OggettoToPrint)new IntestazioneMastrino());
        this.stampa_mastrino.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Mastrino"));
        String query = " select gestione.*, pc_conti_5.*,registro.* FROM gestione  LEFT JOIN pc_conti_5 on gestione.idConto=pc_conti_5.idconto5  LEFT JOIN registro on gestione.id_registro=registro.idregistro  WHERE cdconto LIKE '" + codice_conto + "%'" + " AND  data_doc '" + data_da + "' and '" + data_a + "' " + " order by data_reg";
        this.intestazione_tabella_mastrini(this.stampa_mastrino, 20, y - 50, intestazione);
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            while (res.next()) {
                Mastrino m = new Mastrino();
                m.setCodice_mastro(res.getString("cdconto"));
                m.setDescrizione(res.getString("descrizione"));
                m.setData_reg(res.getString("data_reg"));
                m.setData_doc(res.getString("data_doc"));
                m.setNum_reg(res.getInt("num_reg"));
                m.setNum_doc(res.getString("num_doc"));
                m.setSegno(res.getInt("segno"));
                m.setAnno(Integer.valueOf(this.fda.anno(res.getString("data_doc"))));
                double importo = 0.0;
                importo = res.getDouble("importo");
                m.setImporto(importo);
                if (y > 760) {
                    this.stampa_mastrino.paginanuova();
                    y = 100;
                    this.intestazione_tabella_mastrini(this.stampa_mastrino, 20, y - 50, intestazione);
                }
                this.stampa_mastrino.setFont(this.stampa_mastrino.Font_Calibri_8);
                this.stampa_mastrino.appendRect(20, y, 555, 15);
                this.stampa_mastrino.appendTextOvunque(m.getCodice_mastro(), 22, y + 12);
                this.stampa_mastrino.appendTextOvunque(m.getDescrizione(), 80, y + 12);
                this.stampa_mastrino.appendTextOvunque(m.getData_reg(), 320, y + 12);
                if (!m.getNum_doc().equals("") && m.getNum_doc() != null && !m.getNum_doc().equals("null")) {
                    this.stampa_mastrino.appendTextOvunque(m.getNum_doc() + "/" + m.getAnno(), 390, y + 12);
                }
                if (m.getSegno() == 1) {
                    this.totale_dare += importo;
                    this.totale_parziale += importo;
                    this.stampa_mastrino.appendTextOvunque(this.f.formattaNumero("" + m.getImporto()), 430, y + 12);
                }
                if (m.getSegno() == 2) {
                    importo = -importo;
                    this.stampa_mastrino.appendTextOvunque(this.f.formattaNumero("" + m.getImporto()), 480, y + 12);
                    this.totale_avere += importo;
                    this.totale_parziale += importo;
                }
                this.stampa_mastrino.appendTextOvunque(this.f.formattaNumero("" + this.totale_parziale), 520, y + 12);
                y += 15;
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            this.stampa_mastrino.setFont(this.stampa_mastrino.Font_Calibri_8_B);
            this.stampa_mastrino.appendRect(20, y, 555, 25);
            this.stampa_mastrino.appendTextOvunque("Totali Finali ", 380, y + 18);
            this.stampa_mastrino.appendTextOvunque("" + this.f.formattaNumero("" + this.totale_dare), 430, y + 18);
            if (this.totale_avere < 0.0) {
                this.totale_avere = -this.totale_avere;
            }
            this.stampa_mastrino.appendTextOvunque("" + this.f.formattaNumero("" + this.totale_avere), 480, y + 18);
            this.stampa_mastrino.appendTextOvunque("" + this.f.formattaNumero("" + this.totale_parziale), 520, y + 18);
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Mastrino_" + intestazione + "_dal_" + this.fda.gira_data("" + data_da) + "_al_" + this.fda.gira_data("" + data_a));
            this.stampa_mastrino.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            this.stampa_mastrino.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA MASTRINO FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            return true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: Stampa Mastrino non riuscito");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
    }

    public boolean elabora2(Vector vettoreMastrino, String data_da, String data_a, String intestazione) {
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA MASTRINO INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        long tempo_di_visualizzazione = System.currentTimeMillis();
        boolean id_cf = false;
        String date_now = this.fda.dataCorrente().replaceAll("-", "");
        String ora_now = this.fda.OraCorrente().replaceAll(":", "");
        this.stampa_mastrino.setIntPP((OggettoToPrint)new IntestazioneMastrino());
        this.stampa_mastrino.setInt((OggettoToPrint)new IntestazioneMastrino());
        this.stampa_mastrino.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Mastrino"));
        int y = 50;
        this.intestazione_tabella_mastrini(this.stampa_mastrino, 20, y, intestazione);
        y = 100;
        Iterator i_mastrino = vettoreMastrino.iterator();
        try {
            while (i_mastrino.hasNext()) {
                Mastrino m = (Mastrino)i_mastrino.next();
                if (y > 780) {
                    this.stampa_mastrino.paginanuova();
                    y = 50;
                    this.intestazione_tabella_mastrini(this.stampa_mastrino, 20, y, intestazione);
                    y = 100;
                }
                this.stampa_mastrino.setFont(this.stampa_mastrino.Font_Calibri_8);
                this.stampa_mastrino.appendRect(20, y, 555, 15);
                this.stampa_mastrino.appendTextOvunque(m.getCodice_mastro(), 22, y + 12);
                this.stampa_mastrino.appendTextOvunque(m.getDescrizione(), 80, y + 12);
                this.stampa_mastrino.appendTextOvunque(m.getData_reg(), 320, y + 12);
                if (!m.getNum_doc().equals("") && m.getNum_doc() != null && !m.getNum_doc().equals("null")) {
                    this.stampa_mastrino.appendTextOvunque(m.getNum_doc() + "/" + m.getAnno(), 390, y + 12);
                }
                if (m.getSegno() == 1) {
                    this.totale_dare += m.getImporto();
                    this.totale_parziale += m.getImporto();
                    this.stampa_mastrino.appendTextOvunque(this.f.formattaNumero("" + m.getImporto()), 430, y + 12);
                }
                if (m.getSegno() == 2) {
                    this.stampa_mastrino.appendTextOvunque(this.f.formattaNumero("" + m.getImporto()), 480, y + 12);
                    this.totale_avere -= m.getImporto();
                    this.totale_parziale -= m.getImporto();
                }
                this.stampa_mastrino.appendTextOvunque(this.f.formattaNumero("" + this.totale_parziale), 520, y + 12);
                y += 15;
            }
            this.stampa_mastrino.setFont(this.stampa_mastrino.Font_Calibri_8_B);
            this.stampa_mastrino.appendRect(20, y, 555, 25);
            this.stampa_mastrino.appendTextOvunque("Totali Finali ", 380, y + 18);
            this.stampa_mastrino.appendTextOvunque("" + this.f.formattaNumero("" + this.totale_dare), 430, y + 18);
            if (this.totale_avere < 0.0) {
                this.totale_avere = -this.totale_avere;
            }
            this.stampa_mastrino.appendTextOvunque("" + this.f.formattaNumero("" + this.totale_avere), 480, y + 18);
            this.stampa_mastrino.appendTextOvunque("" + this.f.formattaNumero("" + this.totale_parziale), 520, y + 18);
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Mastrino_" + intestazione + "_dal_" + this.fda.gira_data("" + data_da) + "_al_" + this.fda.gira_data("" + data_a));
            this.stampa_mastrino.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            this.stampa_mastrino.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA MASTRINO FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            return true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: Stampa Mastrino non riuscito");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
    }

    public void intestazione_tabella_mastrini(GestoreStampe stampa, int x, int y, String titolo) {
        stampa.setFont(stampa.Font_Calibri_9_B);
        stampa.appendRoundRect(x, y + 10, 555, 40, 10, 10);
        stampa.appendTextOvunque("CODICE", 20, y + 30);
        stampa.appendTextOvunque("CONTO", 20, y + 40);
        stampa.appendTextOvunque("DESCRIZIONE ", 80, y + 40);
        stampa.appendTextOvunque("DATA ", 320, y + 30);
        stampa.appendTextOvunque("REGISTRAZIONE", 320, y + 40);
        stampa.appendTextOvunque("NUM. DOC./", 390, y + 30);
        stampa.appendTextOvunque("ANNO", 390, y + 40);
        stampa.appendTextOvunque("DARE", 430, y + 40);
        stampa.appendTextOvunque("AVERE", 480, y + 30);
        stampa.appendTextOvunque("SALDO", 520, y + 40);
        stampa.appendTextOvunque(titolo, 25, y + 20);
        stampa.setFont(stampa.Font_Calibri_9_B);
        y += 50;
    }
}

