/*
 * Decompiled with CFR 0.152.
 */
package gestionale.liquidazione_iva;

import gestionale.configurazioni.Configurazioni;
import gestionale.liquidazione_iva.Iva;
import gestionale.personalizzazione.stampe.IntestazioneLiquidazioneIva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaVisualizzaRegistriIva {
    Funzioni f;
    FunzioniDate fda;
    GestoreStampe stampa;
    Vector v_registri;
    Color colore = new Color(220, 220, 220);

    public StampaVisualizzaRegistriIva() {
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.stampa = new GestoreStampe();
        this.stampa.aggiungi_pj();
    }

    public boolean elabora(String query, Vector vettore, String anno) {
        int y_inizio;
        Configurazioni.getIstanza();
        int y = y_inizio = Configurazioni.inizio_stampe;
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA VISUALIZZA REGISTRI IVA INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        long tempo_di_visualizzazione = System.currentTimeMillis();
        boolean id_cf = false;
        String date_now = this.fda.dataCorrente().replaceAll("-", "");
        String ora_now = this.fda.OraCorrente().replaceAll(":", "");
        String pj_name = date_now + ora_now + "_Registri_Iva_anno_" + anno + "_";
        this.v_registri = vettore;
        for (JCheckBox check : this.v_registri) {
            if (!check.isSelected()) continue;
            pj_name = pj_name + "_" + check.getText().replaceAll(" ", "_");
        }
        this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(pj_name);
        this.intestazione_tabella_visualizza_registri_iva(this.stampa, 20, y - 10, vettore);
        y += 40;
        this.stampa.setIntPP((OggettoToPrint)new IntestazioneLiquidazioneIva());
        this.stampa.setInt((OggettoToPrint)new IntestazioneLiquidazioneIva());
        this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Liquidazione Iva"));
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            while (res.next()) {
                Iva i = new Iva();
                i.setAnno(res.getInt("anno"));
                i.setData_doc(res.getString("data_doc"));
                i.setIdregistro_iva(res.getInt("idregistro_iva"));
                i.setImponibile(res.getDouble("imponibile"));
                i.setImposta(res.getDouble("imposta"));
                i.setImposta_ind(res.getDouble("imposta_ind"));
                i.setNum_doc(res.getString("num_doc"));
                i.setSegno(res.getInt("segno"));
                i.setDescrizione_registro(res.getString("descrizione"));
                i.setNum_protocollo(res.getInt("protocollo_iva2"));
                if (y > 720) {
                    this.stampa.paginanuova();
                    y = 90;
                    this.intestazione_tabella_visualizza_registri_iva(this.stampa, 20, y, vettore);
                    y = 140;
                }
                this.stampa.setFont(this.stampa.Font_Calibri_7);
                this.stampa.appendRect(20, y, 555, 15, this.colore);
                this.stampa.appendTextOvunque(i.getNum_doc() + "/" + i.getAnno(), 22, y + 12);
                this.stampa.appendTextOvunque("" + i.getNum_protocollo(), 140, y + 12);
                this.stampa.appendTextOvunque(i.getDescrizione_registro(), 220, y + 12);
                this.stampa.appendTextOvunque(this.f.formattaNumero("" + i.getImponibile()), 300, y + 12);
                this.stampa.appendTextOvunque(this.f.formattaNumero("" + i.getImposta()), 410, y + 12);
                this.stampa.appendTextOvunque(this.f.formattaNumero("" + i.getImposta_ind()), 500, y + 12);
                y += 15;
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA INTERROGAZIONE PARTITE C/F FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            return true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: Stampa Partite Clienti/Fornitori non riuscito");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
    }

    public void intestazione_tabella_visualizza_registri_iva(GestoreStampe stampa, int x, int y, Vector vettore) {
        stampa.setFont(stampa.Font_Calibri_9_B);
        stampa.appendRoundRect(x, y, 555, 50, 10, 10);
        stampa.appendTextOvunque("NUM. DOC.", 22, y + 30);
        stampa.appendTextOvunque("NUM. PROTOCOLLO IVA", 110, y + 30);
        stampa.appendTextOvunque("REGISTRO IVA", 220, y + 30);
        stampa.appendTextOvunque("IMPONIBILE", 300, y + 30);
        stampa.appendTextOvunque("IMPOSTA", 410, y + 30);
        stampa.appendTextOvunque("IMPOSTA INDETRAIBILE", 470, y + 30);
        String titolo_intestazione = "Registri Iva selezionati: ";
        this.v_registri = vettore;
        for (JCheckBox check : this.v_registri) {
            if (!check.isSelected()) continue;
            titolo_intestazione = titolo_intestazione + " " + check.getText();
        }
        stampa.appendTextOvunque(titolo_intestazione, 25, y + 10);
        y += 50;
    }
}

