/*
 * Decompiled with CFR 0.152.
 */
package gestionale.iva;

import cisterna.das.MyDAS;
import gestionale.MyDesktopWindow;
import gestionale.causali_contabili.MyCausaliContabili;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.corrispettivi.MyConfigurazioneCorrispettivi;
import gestionale.documenti.MyDocumentiAttivi;
import gestionale.iva.Aliquota;
import gestionale.iva.AliquotaFixedModel;
import gestionale.iva.AliquotaTableModel;
import gestionale.iva.InsiemeAliquota;
import gestionale.primanota.MyRegistrazioni;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import magazzino.articoli.MyArticoli;
import magazzino.ddtOUT.MyDDTOut;
import magazzino.fOUT.MyFOut;
import magazzino.fpIN.MyfpIN;
import magazzino.listini.MyImportaListini;
import magazzino.ncIN.MyncIN;
import magazzino.ncOUT.MyNcOut;
import trasporti.fatturazione.MyTraFatturazione;
import trasporti.fatture_passive_autostrade.MyTraFattureAutostrade;
import trasporti.fatture_vettori.MyTraFattureVettori;
import trasporti.manutenzione_articoli.MyArticoliManutenzione;
import trasporti.manutenzione_ddi.MyDDIManutenzione;
import utils.Funzioni;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.ToolTipHeader;

public class MyConfiguraAliquotaIVA
extends JInternalFrame
implements ListSelectionListener,
MouseListener {
    JToolBar jToolBarMod;
    AliquotaTableModel atm;
    InsiemeAliquota insieme_a;
    JScrollPane scroll;
    JTable jTableAliquota;
    AliquotaFixedModel afm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<AliquotaTableModel> sorter;
    RowFilter<AliquotaTableModel, Object> rf = null;
    ArrayList<RowFilter<AliquotaTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    Aliquota a_selezione;
    Funzioni f = new Funzioni();
    public JInternalFrame chiamante;
    public int row_chiamante;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JLabel jLabelCF;
    private JLabel jLabelCodice;
    private JLabel jLabelNote;
    private JLabel jLabelPiva;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextAliquota;
    private JTextField jTextCodice;
    private JTextArea jTextDescrizione;
    private JTextField jTextIndetraibilita;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyConfiguraAliquotaIVA() {
        this.atm = new AliquotaTableModel();
        this.insieme_a = new InsiemeAliquota();
        this.jTableAliquota = new JTable(this.atm);
        this.jTableAliquota.setSelectionMode(0);
        this.sorter = new TableRowSorter<AliquotaTableModel>(this.atm);
        for (int i = 0; i < this.atm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.afm = new AliquotaFixedModel();
        this.afm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.afm);
        this.fixedTable.setAutoResizeMode(4);
        this.initComponents();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableAliquota.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(600, 800)));
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("CONFIGURAZIONE_TABELLE_MODIFICA")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableAliquota){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableAliquota.setModel(this.atm);
        this.jTableAliquota.setAutoCreateRowSorter(true);
        this.jTableAliquota.setRowSorter(this.sorter);
        this.jTableAliquota.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        this.jTextAliquota.setEnabled(this.in_modifica);
        this.jTextCodice.setEnabled(this.in_modifica);
        this.jTextIndetraibilita.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableAliquota.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableAliquota.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumn = this.fixedTable.getColumnModel().getColumn(2);
        this.jTableAliquota.addMouseListener(this);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Codice Aliquota", "Valore Aliquota", "Indetraibilit\u00e0", "Descrizione"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableAliquota.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableAliquota.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query = "SELECT * FROM conf_aliquote_iva WHERE abilita='1' ORDER BY codice ASC ";
        if (Configurazioni.righe_ricerca != 0) {
            query = query + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_a.caricamento(query);
        this.atm.setDataAliquota(this.insieme_a.vettoreAliquota);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_a.vettoreAliquota.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.a_selezione = new Aliquota();
        this.a_selezione = (Aliquota)this.insieme_a.vettoreAliquota.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextAliquota.setText("" + this.a_selezione.getAliquota());
        this.jTextCodice.setText(this.a_selezione.getCodice());
        this.jTextDescrizione.setText(this.a_selezione.getDescrizione());
        this.jTextIndetraibilita.setText("" + this.a_selezione.getIndetraibilita());
    }

    private void costruisci() {
        this.a_selezione.setAliquota(Double.valueOf(this.jTextAliquota.getText()));
        this.a_selezione.setCodice(this.jTextCodice.getText());
        this.a_selezione.setDescrizione(this.jTextDescrizione.getText());
        this.a_selezione.setIndetraibilita(Double.valueOf(this.jTextIndetraibilita.getText()));
    }

    private boolean check() {
        String codice = this.jTextCodice.getText();
        if (this.jTextCodice.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un codice Aliquota valido");
            return false;
        }
        if (this.jTextAliquota.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un'Aliquota");
            return false;
        }
        if (this.jTextIndetraibilita.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un'Indetraibilit\u00e0");
            return false;
        }
        if (this.in_new && this.f.check_id_codice_aliquota(codice) != 0) {
            JOptionPane.showMessageDialog(this, "Esiste gi\u00e0 un'Aliquota con questo Codice");
            return false;
        }
        return true;
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.a_selezione.inserisci(false);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.a_selezione.modifica(false);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabelCodice = new JLabel();
        this.jTextCodice = new JTextField();
        this.jLabelCF = new JLabel();
        this.jTextIndetraibilita = new JTextField();
        this.jLabelPiva = new JLabel();
        this.jTextAliquota = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabelNote = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextDescrizione = new JTextArea();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Configurazioni \\ Aliquote I.V.A.");
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                MyConfiguraAliquotaIVA.this.chiusura_frame(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyConfiguraAliquotaIVA.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyConfiguraAliquotaIVA.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraAliquotaIVA.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelCodice.setText("Codice Aliquota");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodice, gridBagConstraints);
        this.jTextCodice.setMinimumSize(new Dimension(200, 30));
        this.jTextCodice.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodice, gridBagConstraints);
        this.jLabelCF.setText("Aliquota");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF, gridBagConstraints);
        this.jTextIndetraibilita.setMinimumSize(new Dimension(200, 30));
        this.jTextIndetraibilita.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextIndetraibilita, gridBagConstraints);
        this.jLabelPiva.setText("Indetraibilita");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelPiva, gridBagConstraints);
        this.jTextAliquota.setMinimumSize(new Dimension(200, 30));
        this.jTextAliquota.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextAliquota, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel3, new GridBagConstraints());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabelNote.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel4.add((Component)this.jLabelNote, gridBagConstraints);
        this.jTextDescrizione.setColumns(60);
        this.jTextDescrizione.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextDescrizione);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel2, "West");
        this.jTabbedPane1.addTab("Dettagli", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableAliquota.getSelectionModel().clearSelection();
        this.a_selezione = new Aliquota();
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questa Aliquota?");
        if (res == 0) {
            this.a_selezione.elimina(res);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.atm.getRowCount() != 0) {
            this.jTableAliquota.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableAliquota.getSelectedRow() > 0 && this.atm.getRowCount() != 0) {
                this.jTableAliquota.getSelectionModel().setSelectionInterval(this.jTableAliquota.getSelectedRow() - 1, this.jTableAliquota.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.atm.getRowCount() != 0) {
                this.jTableAliquota.getSelectionModel().setSelectionInterval(this.jTableAliquota.getSelectedRow() + 1, this.jTableAliquota.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.atm.getRowCount() != 0) {
            this.jTableAliquota.getSelectionModel().setSelectionInterval(this.atm.getRowCount() - 1, this.atm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", "", ""};
            this.afm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.afm.deleteRow();
            this.afm = new AliquotaFixedModel();
            this.fixedTable.setModel(this.afm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", ""};
            this.afm = new AliquotaFixedModel();
            this.fixedTable.setModel(this.afm);
            this.afm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.atm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void chiusura_frame(InternalFrameEvent evt) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyCausaliContabili.class && ((MyCausaliContabili)this.chiamante).aiuto_iva_a) {
                ((MyCausaliContabili)this.chiamante).aiuto_iva_c = false;
            }
            if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).aiuto_iva_a) {
                ((MyRegistrazioni)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyfpIN.class && ((MyfpIN)this.chiamante).aiuto_iva_a) {
                ((MyfpIN)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyncIN.class && ((MyncIN)this.chiamante).aiuto_iva_a) {
                ((MyncIN)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyDAS.class && ((MyDAS)this.chiamante).aiuto_iva_a) {
                ((MyDAS)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyDDIManutenzione.class && ((MyDDIManutenzione)this.chiamante).aiuto_iva_a) {
                ((MyDDIManutenzione)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyFOut.class && ((MyFOut)this.chiamante).aiuto_iva_a) {
                ((MyFOut)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyNcOut.class && ((MyNcOut)this.chiamante).aiuto_iva_art) {
                ((MyNcOut)this.chiamante).aiuto_iva_art = false;
            }
            if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).aiuto_iva_a) {
                ((MyDocumentiAttivi)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).aiuto_iva_rf) {
                ((MyDocumentiAttivi)this.chiamante).aiuto_iva_rf = false;
            }
            if (this.chiamante.getClass() == MyArticoli.class && ((MyArticoli)this.chiamante).f_al_open) {
                ((MyArticoli)this.chiamante).f_al_open = false;
            }
            if (this.chiamante.getClass() == MyArticoli.class && ((MyArticoli)this.chiamante).f_al_ven_open) {
                ((MyArticoli)this.chiamante).f_al_ven_open = false;
            }
            if (this.chiamante.getClass() == MyArticoliManutenzione.class && ((MyArticoliManutenzione)this.chiamante).f_al_open) {
                ((MyArticoliManutenzione)this.chiamante).f_al_open = false;
            }
            if (this.chiamante.getClass() == MyTraFattureVettori.class && ((MyTraFattureVettori)this.chiamante).aiuto_iva_a) {
                ((MyArticoli)this.chiamante).f_al_open = false;
            }
            if (this.chiamante.getClass() == MyTraFattureVettori.class && ((MyTraFattureVettori)this.chiamante).aiuto_iva_a) {
                ((MyTraFattureVettori)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyConfigurazioneCorrispettivi.class && ((MyConfigurazioneCorrispettivi)this.chiamante).aiuto_riga_c) {
                ((MyConfigurazioneCorrispettivi)this.chiamante).aiuto_riga_c = false;
            }
            if (this.chiamante.getClass() == MyImportaListini.class && ((MyImportaListini)this.chiamante).f_al_open) {
                ((MyImportaListini)this.chiamante).f_al_open = false;
            }
            if (this.chiamante.getClass() == MyImportaListini.class && ((MyImportaListini)this.chiamante).f_al_ven_open) {
                ((MyImportaListini)this.chiamante).f_al_ven_open = false;
            }
            if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).aiuto_iva_open) {
                ((MyTraFatturazione)this.chiamante).aiuto_iva_open = false;
            }
            if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).aiuto_iva_a) {
                ((MyTraFatturazione)this.chiamante).aiuto_iva_a = false;
            }
            if (this.chiamante.getClass() == MyTraFattureAutostrade.class && ((MyTraFattureAutostrade)this.chiamante).aiuto_iva_a) {
                ((MyTraFattureAutostrade)this.chiamante).aiuto_iva_a = false;
            }
            this.dispose();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyConfiguraAliquotaIVA().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableAliquota.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableAliquota.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.atm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableAliquota.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.atm.getRowCount() - 1 && modelRow >= 0) {
                Aliquota a = new Aliquota();
                a = (Aliquota)this.insieme_a.vettoreAliquota.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyCausaliContabili.class && ((MyCausaliContabili)this.chiamante).aiuto_iva_a) {
                        ((MyCausaliContabili)this.chiamante).jTableCCIva.getCellEditor().getTableCellEditorComponent(((MyCausaliContabili)this.chiamante).jTableCCIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyCausaliContabili)this.chiamante).jTableCCIva.getCellEditor().stopCellEditing();
                        ((MyCausaliContabili)this.chiamante).aiuto_iva_c = false;
                    }
                    if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).aiuto_iva_a) {
                        ((MyRegistrazioni)this.chiamante).jTablePNIva.setValueAt(a.getCodice(), this.row_chiamante, 0);
                        ((MyRegistrazioni)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyfpIN.class && ((MyfpIN)this.chiamante).aiuto_iva_a) {
                        ((MyfpIN)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyfpIN)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyfpIN)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyfpIN)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyncIN.class && ((MyncIN)this.chiamante).aiuto_iva_a) {
                        ((MyncIN)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyncIN)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyncIN)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyncIN)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyDAS.class && ((MyDAS)this.chiamante).aiuto_iva_a) {
                        ((MyDAS)this.chiamante).jTablePNIva.setValueAt(a.getCodice(), this.row_chiamante, 0);
                        ((MyDAS)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyDDIManutenzione.class && ((MyDDIManutenzione)this.chiamante).aiuto_iva_a) {
                        ((MyDDIManutenzione)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyDDIManutenzione)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyDDIManutenzione)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyDDIManutenzione)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyNcOut.class && ((MyNcOut)this.chiamante).aiuto_iva_art) {
                        ((MyNcOut)this.chiamante).jTableRigheFattura.getCellEditor().getTableCellEditorComponent(((MyNcOut)this.chiamante).jTableRigheFattura, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyNcOut)this.chiamante).jTableRigheFattura.getCellEditor().stopCellEditing();
                        ((MyNcOut)this.chiamante).aiuto_iva_art = false;
                    }
                    if (this.chiamante.getClass() == MyNcOut.class && ((MyNcOut)this.chiamante).aiuto_iva_a) {
                        ((MyNcOut)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyNcOut)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyNcOut)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyNcOut)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyFOut.class && ((MyFOut)this.chiamante).aiuto_iva_art) {
                        ((MyFOut)this.chiamante).jTableRigheFattura.getCellEditor().getTableCellEditorComponent(((MyFOut)this.chiamante).jTableRigheFattura, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyFOut)this.chiamante).jTableRigheFattura.getCellEditor().stopCellEditing();
                        ((MyFOut)this.chiamante).aiuto_iva_art = false;
                    }
                    if (this.chiamante.getClass() == MyFOut.class && ((MyFOut)this.chiamante).aiuto_iva_a) {
                        ((MyFOut)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyFOut)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyFOut)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyFOut)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyDDTOut.class && ((MyDDTOut)this.chiamante).aiuto_iva_art) {
                        ((MyDDTOut)this.chiamante).jTableRigheFattura.getCellEditor().getTableCellEditorComponent(((MyDDTOut)this.chiamante).jTableRigheFattura, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyDDTOut)this.chiamante).jTableRigheFattura.getCellEditor().stopCellEditing();
                        ((MyDDTOut)this.chiamante).aiuto_iva_art = false;
                    }
                    if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).aiuto_iva_a) {
                        ((MyDocumentiAttivi)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyDocumentiAttivi)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyDocumentiAttivi)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyDocumentiAttivi)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).f_aliquota_open) {
                        ((MyDocumentiAttivi)this.chiamante).jTablePNRighe.getCellEditor().getTableCellEditorComponent(((MyDocumentiAttivi)this.chiamante).jTablePNRighe, a.getCodice(), false, this.row_chiamante, 2);
                        ((MyDocumentiAttivi)this.chiamante).jTablePNRighe.getCellEditor().stopCellEditing();
                        ((MyDocumentiAttivi)this.chiamante).f_aliquota_open = false;
                    }
                    if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).aiuto_iva_rf) {
                        ((MyDocumentiAttivi)this.chiamante).jTableRighe.getCellEditor().getTableCellEditorComponent(((MyDocumentiAttivi)this.chiamante).jTableRighe, a.getCodice(), false, this.row_chiamante, 2);
                        ((MyDocumentiAttivi)this.chiamante).jTableRighe.getCellEditor().stopCellEditing();
                        ((MyDocumentiAttivi)this.chiamante).aiuto_iva_rf = false;
                    }
                    if (this.chiamante.getClass() == MyArticoli.class && ((MyArticoli)this.chiamante).f_al_open) {
                        ((MyArticoli)this.chiamante).jTextCodAliquotaAcquisti.setText(a.getCodice());
                        ((MyArticoli)this.chiamante).f_al_open = false;
                    }
                    if (this.chiamante.getClass() == MyArticoliManutenzione.class && ((MyArticoliManutenzione)this.chiamante).f_al_open) {
                        ((MyArticoliManutenzione)this.chiamante).jTextCodAliquota.setText(a.getCodice());
                        ((MyArticoliManutenzione)this.chiamante).f_al_open = false;
                    }
                    if (this.chiamante.getClass() == MyArticoli.class && ((MyArticoli)this.chiamante).f_al_ven_open) {
                        ((MyArticoli)this.chiamante).jTextCodAliquotaVendite.setText(a.getCodice());
                        ((MyArticoli)this.chiamante).f_al_ven_open = false;
                    }
                    if (this.chiamante.getClass() == MyTraFattureVettori.class && ((MyTraFattureVettori)this.chiamante).aiuto_iva_a) {
                        ((MyTraFattureVettori)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyTraFattureVettori)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyTraFattureVettori)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyTraFattureVettori)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyTraFattureVettori.class && ((MyTraFattureVettori)this.chiamante).aiuto_iva_b) {
                        ((MyTraFattureVettori)this.chiamante).jTableRighe.getCellEditor().getTableCellEditorComponent(((MyTraFattureVettori)this.chiamante).jTableRighe, a.getCodice(), false, this.row_chiamante, 7);
                        ((MyTraFattureVettori)this.chiamante).jTableRighe.getCellEditor().stopCellEditing();
                        ((MyTraFattureVettori)this.chiamante).aiuto_iva_b = false;
                    }
                    if (this.chiamante.getClass() == MyTraFattureAutostrade.class && ((MyTraFattureAutostrade)this.chiamante).aiuto_iva_a) {
                        ((MyTraFattureAutostrade)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyTraFattureAutostrade)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyTraFattureAutostrade)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyTraFattureAutostrade)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).aiuto_iva_a) {
                        ((MyTraFatturazione)this.chiamante).jTablePNIva.getCellEditor().getTableCellEditorComponent(((MyTraFatturazione)this.chiamante).jTablePNIva, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyTraFatturazione)this.chiamante).jTablePNIva.getCellEditor().stopCellEditing();
                        ((MyTraFatturazione)this.chiamante).aiuto_iva_a = false;
                    }
                    if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).aiuto_iva_open) {
                        ((MyTraFatturazione)this.chiamante).jTableArticoliFattura.getCellEditor().getTableCellEditorComponent(((MyTraFatturazione)this.chiamante).jTableArticoliFattura, a.getCodice(), false, this.row_chiamante, 7);
                        ((MyTraFatturazione)this.chiamante).jTableArticoliFattura.getCellEditor().stopCellEditing();
                        ((MyTraFatturazione)this.chiamante).aiuto_iva_open = false;
                    }
                    if (this.chiamante.getClass() == MyConfigurazioneCorrispettivi.class && ((MyConfigurazioneCorrispettivi)this.chiamante).aiuto_riga_c) {
                        ((MyConfigurazioneCorrispettivi)this.chiamante).jTableReparti.getCellEditor().getTableCellEditorComponent(((MyConfigurazioneCorrispettivi)this.chiamante).jTableReparti, a.getCodice(), false, this.row_chiamante, 0);
                        ((MyConfigurazioneCorrispettivi)this.chiamante).jTableReparti.getCellEditor().stopCellEditing();
                        ((MyConfigurazioneCorrispettivi)this.chiamante).aiuto_riga_c = false;
                    }
                    if (this.chiamante.getClass() == MyImportaListini.class && ((MyImportaListini)this.chiamante).f_al_open) {
                        ((MyImportaListini)this.chiamante).jTextCodAliquota.setText(a.getCodice());
                        ((MyImportaListini)this.chiamante).f_al_open = false;
                    }
                    if (this.chiamante.getClass() == MyImportaListini.class && ((MyImportaListini)this.chiamante).f_al_ven_open) {
                        ((MyImportaListini)this.chiamante).jTextCodAliquotaVendite.setText(a.getCodice());
                        ((MyImportaListini)this.chiamante).f_al_ven_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<AliquotaTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyConfiguraAliquotaIVA.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyConfiguraAliquotaIVA.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyConfiguraAliquotaIVA.this.rf = RowFilter.andFilter(MyConfiguraAliquotaIVA.this.andFilters);
                MyConfiguraAliquotaIVA.this.sorter.setRowFilter(MyConfiguraAliquotaIVA.this.rf);
                MyConfiguraAliquotaIVA.this.formatta();
            } else {
                String query = "SELECT * FROM conf_aliquote_iva WHERE abilita='1'";
                if (col == 0) {
                    query = query + " AND codice LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    query = query + " AND aliquota LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND indetraibilita LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    query = query + " AND descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                query = query + " ORDER BY codice_fornitore ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyConfiguraAliquotaIVA.this.insieme_a.caricamento(query);
                MyConfiguraAliquotaIVA.this.atm.setDataAliquota(MyConfiguraAliquotaIVA.this.insieme_a.vettoreAliquota);
                MyConfiguraAliquotaIVA.this.formatta();
            }
        }
    }
}

