/*
 * Decompiled with CFR 0.152.
 */
package gestionale.iva;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import utils.Funzioni;
import utils.MyTrace;

public class Aliquota {
    private String codice = "";
    private String descrizione = "";
    private double aliquota = 0.0;
    private double indetraibilita = 0.0;
    private int id;
    private Funzioni f = new Funzioni();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getAliquota() {
        return this.aliquota;
    }

    public void setAliquota(double aliquota) {
        this.aliquota = aliquota;
    }

    public String getCodice() {
        return this.codice;
    }

    public void setCodice(String codice) {
        this.codice = codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public double getIndetraibilita() {
        return this.indetraibilita;
    }

    public void setIndetraibilita(double indetraibilita) {
        this.indetraibilita = indetraibilita;
    }

    public boolean inserisci(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_ins = "INSERT INTO conf_aliquote_iva(codice, descrizione,aliquota, indetraibilita,abilita) VALUES ('" + this.getCodice() + "','" + this.getDescrizione().replaceAll("'", "''") + "'," + "'" + this.getAliquota() + "','" + this.getIndetraibilita() + "','1')";
        boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
        if (!r_start || !r_ins) {
            MyTrace.log.severe("Inserimento Aliquota iva non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM conf_aliquote_iva";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_aliquote_iva','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento  Aliquota Iva non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento  Aliquota IVA non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_mod = "UPDATE  conf_aliquote_iva  SET codice='" + this.getCodice() + "'," + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "',  " + " aliquota='" + this.getAliquota() + "', " + " indetraibilita='" + this.getIndetraibilita() + "'" + " WHERE idAliquota='" + this.getId() + "'";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_start || !r_mod) {
            MyTrace.log.severe("Modifica Aliquota IVA non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_aliquote_iva','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Aliquote iva non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica  aliquote iva non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public void seleziona(String where) {
        String query_seleziona = " select * from conf_aliquote_iva ";
        query_seleziona = query_seleziona + " " + where;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setCodice(res.getString("codice"));
                this.setId(res.getInt("idAliquota"));
                this.setAliquota(res.getDouble("aliquota"));
                this.setIndetraibilita(res.getDouble("indetraibilita"));
                this.setDescrizione(res.getString("descrizione"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Aliquota iva non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public boolean elimina(int id) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "UPDATE conf_aliquote_iva SET abilita='0' WHERE idAliquota='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina Aliquota iva non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_aliquote_iva','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina aliquote iva non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        String q_commit = "COMMIT";
        boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
        if (r_commit) {
            return true;
        }
        MyTrace.log.severe("Elimina aliquote iva non riuscito per commit");
        Configurazioni.eccezione.gestisci("3.4", null);
        return false;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getCodice();
                break;
            }
            case 1: {
                retVal = "" + this.getAliquota();
                break;
            }
            case 2: {
                retVal = "" + this.getIndetraibilita();
                break;
            }
            case 3: {
                retVal = this.getDescrizione();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

