/*
 * Decompiled with CFR 0.152.
 */
package gestionale.documenti;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.documenti.TipoDocumentoAttivo;
import gestionale.iva.Aliquota;
import java.math.BigDecimal;
import magazzino.articoli.Articolo;
import magazzino.movimenti.InsiemeMovimentiMagazzino;
import magazzino.movimenti.MovimentoMagazzino;
import trasporti.ordini.RigaOrdineViaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class RigaDocumento {
    private int id_riga;
    private int id_doc;
    private int id_aliquota;
    private int id_listino_appoggio;
    private int id_tipo_doc;
    private int id_fa_righe_old;
    private int id_fa_old;
    private RigaOrdineViaggio riga_ov;
    private String data_movimento_appoggio;
    private double sconto = 0.0;
    private Money importo = new Money(BigDecimal.ZERO);
    private Quantita quantita = new Quantita(BigDecimal.ZERO);
    private Money prezzo_unitario = new Money(BigDecimal.ZERO);
    private String codice_articolo = "";
    private String descrizione = "";
    private String col_gen_1 = "";
    private String col_gen_2 = "";
    private String unita_misura = "";
    private InsiemeMovimentiMagazzino insieme_om = new InsiemeMovimentiMagazzino();
    private InsiemeMovimentiMagazzino insieme_om_da_eliminare = new InsiemeMovimentiMagazzino();
    private Articolo articolo;
    private Aliquota aliquota = new Aliquota();
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public RigaOrdineViaggio getRiga_ov() {
        return this.riga_ov;
    }

    public void setRiga_ov(RigaOrdineViaggio riga_ov) {
        this.riga_ov = riga_ov;
    }

    public String getCodice_articolo() {
        return this.codice_articolo;
    }

    public void setCodice_articolo(String codice_articolo) {
        this.codice_articolo = codice_articolo;
    }

    public String getCol_gen_1() {
        return this.col_gen_1;
    }

    public void setCol_gen_1(String col_gen_1) {
        this.col_gen_1 = col_gen_1;
    }

    public String getCol_gen_2() {
        return this.col_gen_2;
    }

    public void setCol_gen_2(String col_gen_2) {
        this.col_gen_2 = col_gen_2;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public int getId_riga() {
        return this.id_riga;
    }

    public void setId_riga(int id_riga) {
        this.id_riga = id_riga;
    }

    public Money getImporto() {
        return this.importo;
    }

    public void setImporto(Money importo) {
        this.importo = importo;
    }

    public Money getPrezzo_unitario() {
        return this.prezzo_unitario;
    }

    public void setPrezzo_unitario(Money prezzo_unitario) {
        this.prezzo_unitario = prezzo_unitario;
    }

    public Quantita getQuantita() {
        return this.quantita;
    }

    public void setQuantita(Quantita quantita) {
        this.quantita = quantita;
    }

    public double getSconto() {
        return this.sconto;
    }

    public void setSconto(double sconto) {
        this.sconto = sconto;
    }

    public String getUnita_misura() {
        return this.unita_misura;
    }

    public void setUnita_misura(String unita_misura) {
        this.unita_misura = unita_misura;
    }

    public int getId_aliquota() {
        return this.id_aliquota;
    }

    public void setId_aliquota(int id_aliquota) {
        this.id_aliquota = id_aliquota;
    }

    public Aliquota getAliquota() {
        return this.aliquota;
    }

    public void setAliquota(Aliquota aliquota) {
        this.aliquota = aliquota;
    }

    public int getId_doc() {
        return this.id_doc;
    }

    public void setId_doc(int id_doc) {
        this.id_doc = id_doc;
    }

    public InsiemeMovimentiMagazzino getInsieme_om() {
        return this.insieme_om;
    }

    public void setInsieme_om(InsiemeMovimentiMagazzino insieme_om) {
        this.insieme_om = insieme_om;
    }

    public InsiemeMovimentiMagazzino getInsieme_om_da_eliminare() {
        return this.insieme_om_da_eliminare;
    }

    public void setInsieme_om_da_eliminare(InsiemeMovimentiMagazzino insieme_om_da_eliminare) {
        this.insieme_om_da_eliminare = insieme_om_da_eliminare;
    }

    public Articolo getArticolo() {
        return this.articolo;
    }

    public void setArticolo(Articolo articolo) {
        this.articolo = articolo;
    }

    public int getId_listino_appoggio() {
        return this.id_listino_appoggio;
    }

    public void setId_listino_appoggio(int id_listino_appoggio) {
        this.id_listino_appoggio = id_listino_appoggio;
    }

    public String getData_movimento_appoggio() {
        return this.data_movimento_appoggio;
    }

    public void setData_movimento_appoggio(String data_movimento_appoggio) {
        this.data_movimento_appoggio = data_movimento_appoggio;
    }

    public int getId_fa_righe_old() {
        return this.id_fa_righe_old;
    }

    public void setId_fa_righe_old(int id_fa_righe_old) {
        this.id_fa_righe_old = id_fa_righe_old;
    }

    public int getId_fa_old() {
        return this.id_fa_old;
    }

    public void setId_fa_old(int id_fa_old) {
        this.id_fa_old = id_fa_old;
    }

    public int getId_tipo_doc() {
        return this.id_tipo_doc;
    }

    public void setId_tipo_doc(int id_tipo_doc) {
        this.id_tipo_doc = id_tipo_doc;
    }

    public boolean inserisci(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO documenti_attivi_righe(id_documenti_attivi,codice_articolo,descrizione,colonna_generica_1,colonna_generica_2,unita_misura,quantita,prezzo_unitario,sconto,importo,id_aliquota_iva,id_fa_righe_old,id_fa_old) VALUES ('" + this.getId_doc() + "', " + "'" + this.getCodice_articolo() + "', " + "'" + this.getDescrizione().replaceAll("'", "''") + "', " + "'" + this.getCol_gen_1() + "', " + "'" + this.getCol_gen_2() + "', " + "'" + this.getUnita_misura() + "', " + "'" + this.getQuantita() + "', " + "'" + this.getPrezzo_unitario() + "', " + "'" + this.getSconto() + "', " + "'" + this.getImporto() + "', " + "" + this.getId_aliquota() + "," + "" + this.getId_fa_righe_old() + "," + "" + this.getId_fa_old() + ")"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento riga fattura non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        this.setId_riga(Configurazioni.getIstanza().connessione.id_inserito("documenti_attivi_righe"));
        boolean res_rif = true;
        if (this.getInsieme_om() != null && !this.getInsieme_om().vettoreOM.isEmpty()) {
            for (MovimentoMagazzino om : this.getInsieme_om().vettoreOM) {
                MyTrace.log.severe(" PRIMA FIFIO OM " + om.getA().getCodice_articolo() + " QUANTITA MAG=" + om.getQ_magazzino() + " Q DA FASTTURARE= " + om.getQ_da_fatturare_out());
            }
            this.setInsieme_om(this.getInsieme_om().fifo());
            for (MovimentoMagazzino om : this.getInsieme_om().vettoreOM) {
                MyTrace.log.severe("DOPO FIFO OM " + om.getA().getCodice_articolo() + " QUANTITA MAG=" + om.getQ_magazzino() + " Q DA FASTTURARE= " + om.getQ_da_fatturare_out());
            }
            for (MovimentoMagazzino om : this.getInsieme_om().vettoreOM) {
                if (this.getId_tipo_doc() == 5) {
                    om.setId_riga_doc_out(this.getId_riga());
                } else {
                    om.setId_riga_f_out(this.getId_riga());
                }
                om.setData_movimento(this.getData_movimento_appoggio());
                boolean ris_om = om.inserisci(false);
                if (ris_om) continue;
                MyTrace.log.severe("Inserimento DDI non riuscito per oggetto magazzino");
                Configurazioni.eccezione.gestisci("2.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
        }
        boolean ris_om = true;
        if (this.getRiga_ov() != null) {
            this.getRiga_ov().setId_riga_documento(this.getId_riga());
            this.setQuantita(this.getQuantita());
            if (this.getRiga_ov().getT_o().equals("O")) {
                this.getRiga_ov().setP_um(this.getPrezzo_unitario());
            } else if (this.getUnita_misura().equals("") || this.getUnita_misura().equals("Nr")) {
                this.getRiga_ov().setP_for(this.getPrezzo_unitario());
            } else {
                this.getRiga_ov().setP_um(this.getPrezzo_unitario());
            }
            this.getRiga_ov().fattura();
        }
        if (!ris_om) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento riga non riuscito per fatturazione riga_ov");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','documenti_attivi_righe','" + this.getId_riga() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento  riga doc non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modifica(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE  documenti_attivi_righe  SET  codice_articolo='" + this.getCodice_articolo() + "'," + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "'," + " colonna_generica_1='" + this.getCol_gen_1().replaceAll("'", "''") + "'," + " colonna_generica_2='" + this.getCol_gen_2().replaceAll("'", "''") + "'," + " unita_misura='" + this.getUnita_misura().replaceAll("'", "''") + "'," + " quantita='" + this.getQuantita() + "'," + " prezzo_unitario='" + this.getPrezzo_unitario() + "', " + " sconto='" + this.getSconto() + "'," + " importo='" + this.getImporto() + "'," + " id_aliquota_iva= " + this.getId_aliquota() + ", " + " id_fa_righe_old= " + this.getId_fa_righe_old() + ", " + " id_fa_old = " + this.getId_fa_old() + " " + " WHERE iddocumenti_attivi_righe=" + this.getId_riga() + ""))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica  riga doc non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        boolean res_om = true;
        boolean res_a = true;
        if (this.getInsieme_om() != null && !this.getInsieme_om().vettoreOM.isEmpty()) {
            this.setInsieme_om(this.getInsieme_om().fifo());
            for (MovimentoMagazzino om : this.getInsieme_om().vettoreOM) {
                om.setId_riga_doc_out(this.getId_riga());
                om.setData_movimento(this.getData_movimento_appoggio());
                if (om.getId() == 0) {
                    res_om = om.inserisci(false);
                    if (res_om) continue;
                    MyTrace.log.severe("Modifica DDI non riuscita per om");
                    Configurazioni.eccezione.gestisci("3.2", null);
                    Configurazioni.getIstanza().connessione.rollback();
                    return false;
                }
                res_om = om.modifica(false);
                if (res_om) continue;
                MyTrace.log.severe("Modifica DDI non riuscita per om");
                Configurazioni.eccezione.gestisci("3.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
        }
        if (this.getInsieme_om_da_eliminare() != null && !this.getInsieme_om_da_eliminare().vettoreOM.isEmpty()) {
            for (MovimentoMagazzino om : this.getInsieme_om_da_eliminare().vettoreOM) {
                res_om = om.elimina(false);
                if (res_om) continue;
                MyTrace.log.severe("Modifica DDI non riuscita per eliminazione om");
                Configurazioni.eccezione.gestisci("3.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
        }
        boolean ris_om = true;
        if (this.getRiga_ov() != null) {
            this.getRiga_ov().setId_riga_documento(this.getId_riga());
            this.setQuantita(this.getQuantita());
            if (this.getRiga_ov().getT_o().equals("O")) {
                this.getRiga_ov().setP_um(this.getPrezzo_unitario());
            } else if (this.getUnita_misura().equals("") || this.getUnita_misura().equals("Nr")) {
                this.getRiga_ov().setP_for(this.getPrezzo_unitario());
            } else {
                this.getRiga_ov().setP_um(this.getPrezzo_unitario());
            }
            this.getRiga_ov().fattura();
        }
        if (!ris_om) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento riga non riuscito per fatturazione riga_ov");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','documenti_attivi_righe','" + this.getId_riga() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica  riga fa non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean eliminaRF(boolean da_solo) {
        String query_del;
        boolean r_del;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "delete from documenti_attivi_righe WHERE iddocumenti_attivi_righe=" + this.getId_riga() + ""))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina  Riga doc non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        if (this.getInsieme_om() != null && !this.getInsieme_om().vettoreOM.isEmpty()) {
            for (MovimentoMagazzino om_da_el : this.getInsieme_om().vettoreOM) {
                boolean res_el = om_da_el.elimina(false);
                if (res_el) continue;
                MyTrace.log.severe("Modifica DDT non riuscita per eliminazione om");
                Configurazioni.eccezione.gestisci("3.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
        }
        boolean ris_om = true;
        if (this.getRiga_ov() != null) {
            this.getRiga_ov().setId_riga_documento(0);
            this.getRiga_ov().fattura();
        }
        if (!ris_om) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento riga non riuscito per fatturazione riga_ov");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','fatture_attive_righe','" + this.getId_riga() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina  riga doc non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public Object getColValue(TipoDocumentoAttivo.Colonna c) {
        String retVal = "";
        switch (c.getId_di_riferimento()) {
            case 1: {
                retVal = this.getCodice_articolo();
                break;
            }
            case 2: {
                retVal = this.getDescrizione();
                break;
            }
            case 3: {
                retVal = "" + this.getCol_gen_1();
                break;
            }
            case 4: {
                retVal = this.getCol_gen_2();
                break;
            }
            case 5: {
                retVal = "" + this.getUnita_misura();
                break;
            }
            case 6: {
                retVal = this.f.formattaNumero("" + this.getQuantita(), "#0.000");
                break;
            }
            case 7: {
                retVal = this.f.formattaNumero("" + this.getPrezzo_unitario());
                break;
            }
            case 8: {
                retVal = "" + this.getSconto();
                break;
            }
            case 9: {
                retVal = this.f.formattaNumero("" + this.getImporto());
                break;
            }
            case 10: {
                if (this.getAliquota() != null) {
                    retVal = this.getAliquota().getCodice();
                    break;
                }
                retVal = "";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

