/*
 * Decompiled with CFR 0.152.
 */
package gestionale.documenti;

import gestionale.configurazioni.Configurazioni;
import gestionale.documenti.Documento;
import gestionale.primanota.Registrazione;
import java.sql.ResultSet;
import java.util.ArrayList;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;

public class InsiemeDocumenti {
    public ArrayList<Documento> vettoreDOC = new ArrayList();
    int colCount;
    public String[] headers;
    private String qq = "SELECT documenti_attivi.*, registro.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice, anag_banche.descrizione as desc_banca, anag_banche.IBAN as iban_banca, fatture_attive_tipi.tipo as tipo_fa, vcausali.id_modelli_cc, vcausali.codice as codice_causale, vcausali.tipo_causale,  vcausali.codice_ri  FROM documenti_attivi  LEFT JOIN registro ON documenti_attivi.id_registro=registro.idregistro  LEFT JOIN anag_anagrafica ON registro.id_anagrafica=anag_anagrafica.idanagrafica  LEFT JOIN vcausali ON registro.id_causale_contabile=vcausali.idcausale_contabile  LEFT JOIN anag_banche ON registro.id_banca_appoggio=anag_banche.idAnag_banche  LEFT JOIN fatture_attive_tipi ON documenti_attivi.id_tipo=fatture_attive_tipi.idfatture_attive_tipi  ";

    public int caricamento(String where, String order_by) {
        this.vettoreDOC = new ArrayList();
        String query = this.qq;
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Documento f = new Documento();
                f.setIdDocumento(res.getInt("iddocumenti_attivi"));
                f.setId_causale_contabile(res.getInt("id_causale_contabile"));
                f.setId_tipo(res.getInt("id_tipo"));
                f.setString_tipo(res.getString("tipo_fa"));
                f.setDestinazione(res.getString("destinazione"));
                f.setNumero(res.getInt("numero"));
                f.setCodifica(res.getString("codifica"));
                f.setAnno(res.getInt("anno"));
                f.setDescrizione(res.getString("descrizione"));
                f.setId_fa_old(res.getInt("id_fa_old"));
                f.setId_contatore(res.getInt("id_contatore"));
                f.setId_registro(res.getInt("idregistro"));
                Registrazione r = new Registrazione();
                r.setIdregistro(res.getInt("idregistro"));
                r.setNum_reg(res.getInt("num_reg"));
                r.setData_reg(res.getString("data_reg"));
                r.setNum_doc(res.getString("num_doc"));
                r.setData_doc(res.getString("data_doc"));
                r.setAnno_prot(res.getInt("anno_prot"));
                r.setId_causale_contabile_e_basta(res.getInt("id_causale_contabile"));
                r.setCodice_causale_contabile(res.getString("codice_causale"));
                r.setTipo_cf(res.getString("tipo_cf"));
                r.setId_anag_e_basta(res.getInt("id_anagrafica"));
                r.setRagione_sociale_cf(res.getString("ragione_sociale"));
                r.setCodice_cf(res.getString("codice"));
                r.setImporto_doc(new Money(res.getDouble("importo_doc")));
                r.setId_registro_iva(res.getInt("id_conf_registri_iva"));
                r.setId_trattamento_economico(res.getInt("id_conf_trattamento_economico"));
                r.setNote(res.getString("note"));
                r.setIban_cf(res.getString("iban_cf"));
                r.setId_banca_appoggio(res.getInt("id_banca_appoggio"));
                r.setDesc_banca(res.getString("desc_banca"));
                r.setIban_banca(res.getString("iban_banca"));
                r.setAnno_reg(res.getInt("anno_reg"));
                r.setProtocollo_iva(res.getInt("protocollo_iva"));
                r.setIva_proporzionale(res.getInt("iva_proporzionale"));
                r.setId_tipo_modello(res.getInt("id_modelli_cc"));
                r.setCodice_ri(res.getString("codice_ri"));
                f.setR(r);
                this.vettoreDOC.add(f);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreDOC = new ArrayList();
            MyTrace.log.severe("Seleziona Fatture Attive non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreDOC.size();
    }

    public String getQq() {
        return this.qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public boolean inserisci(boolean da_solo) {
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        for (Documento doc : this.vettoreDOC) {
            boolean res = doc.inserisciConversione(false);
            if (res) continue;
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento doc non riuscito");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }
}

