/*
 * Decompiled with CFR 0.152.
 */
package gestionale.documenti;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.documenti.InsiemeRigheDoc;
import gestionale.documenti.RigaDocumento;
import gestionale.documenti.TotaliDocumento;
import gestionale.iva.Aliquota;
import gestionale.primanota.InsiemePNIva;
import gestionale.primanota.InsiemePNRiga;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.PNIva;
import gestionale.primanota.PNRiga;
import gestionale.primanota.Partita;
import gestionale.primanota.Registrazione;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class Documento {
    private Registrazione r = new Registrazione();
    private String destinazione;
    private String descrizione;
    private String codifica = "";
    private String string_tipo;
    private int idDocumento;
    private int id_registro;
    private int id_causale_contabile;
    private int id_tipo;
    private int numero;
    private int anno;
    private int id_contatore;
    private int id_fa_old;
    private Money tot_imposta = new Money(BigDecimal.ZERO);
    private Money tot_imponibile = new Money(BigDecimal.ZERO);
    private Money tot_doc = new Money(BigDecimal.ZERO);
    private InsiemeRigheDoc insieme_r;
    private ArrayList<TotaliDocumento> v_riepilogo;
    private Vector v_el;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public String getDestinazione() {
        return this.destinazione;
    }

    public void setDestinazione(String destinazione) {
        this.destinazione = destinazione;
    }

    public int getId_causale_contabile() {
        return this.id_causale_contabile;
    }

    public void setId_causale_contabile(int id_causale_contabile) {
        this.id_causale_contabile = id_causale_contabile;
    }

    public ArrayList<TotaliDocumento> getV_riepilogo() {
        return this.v_riepilogo;
    }

    public void setV_riepilogo(ArrayList<TotaliDocumento> v_riepilogo) {
        this.v_riepilogo = v_riepilogo;
    }

    public Vector getV_el() {
        return this.v_el;
    }

    public void setV_el(Vector v_el) {
        this.v_el = v_el;
    }

    public Registrazione getR() {
        return this.r;
    }

    public void setR(Registrazione r) {
        this.r = r;
    }

    public int getIdDocumento() {
        return this.idDocumento;
    }

    public void setIdDocumento(int idDocumento) {
        this.idDocumento = idDocumento;
    }

    public int getId_registro() {
        return this.id_registro;
    }

    public void setId_registro(int id_registro) {
        this.id_registro = id_registro;
    }

    public int getId_tipo() {
        return this.id_tipo;
    }

    public void setId_tipo(int id_tipo) {
        this.id_tipo = id_tipo;
    }

    public String getCodifica() {
        return this.codifica;
    }

    public void setCodifica(String codifica) {
        this.codifica = codifica;
    }

    public int getNumero() {
        return this.numero;
    }

    public void setNumero(int numero) {
        this.numero = numero;
    }

    public int getAnno() {
        return this.anno;
    }

    public void setAnno(int anno) {
        this.anno = anno;
    }

    public Money getTot_imposta() {
        return this.tot_imposta;
    }

    public void setTot_imposta(Money tot_imposta) {
        this.tot_imposta = tot_imposta;
    }

    public Money getTot_imponibile() {
        return this.tot_imponibile;
    }

    public void setTot_imponibile(Money tot_imponibile) {
        this.tot_imponibile = tot_imponibile;
    }

    public Money getTot_doc() {
        return this.tot_doc;
    }

    public void setTot_doc(Money tot_doc) {
        this.tot_doc = tot_doc;
    }

    public InsiemeRigheDoc getInsieme_r() {
        return this.insieme_r;
    }

    public void setInsieme_r(InsiemeRigheDoc insieme_r) {
        this.insieme_r = insieme_r;
    }

    public int getId_fa_old() {
        return this.id_fa_old;
    }

    public void setId_fa_old(int id_fa_old) {
        this.id_fa_old = id_fa_old;
    }

    public String getString_tipo() {
        return this.string_tipo;
    }

    public void setString_tipo(String string_tipo) {
        this.string_tipo = string_tipo;
    }

    public int getId_contatore() {
        return this.id_contatore;
    }

    public void setId_contatore(int id_contatore) {
        this.id_contatore = id_contatore;
    }

    public boolean inserisci(boolean da_solo) {
        try {
            boolean res_reg;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            String query_ins = "";
            query_ins = "INSERT INTO documenti_attivi(id_causale_contabile,id_tipo,descrizione,destinazione,numero,codifica,anno,id_contatore) VALUES (" + this.getId_causale_contabile() + "," + "" + this.getId_tipo() + "," + "'" + this.getDescrizione().replaceAll("'", "''") + "', " + "'" + this.getDestinazione().replaceAll("'", "''") + "'," + "(SELECT (COALESCE(MAX(numero),0))+1 FROM (SELECT * FROM documenti_attivi " + "                 WHERE anno=" + this.getAnno() + " AND id_contatore=" + this.getId_contatore() + ")as temp2)," + "'" + this.getCodifica() + "'," + "" + this.getAnno() + "," + "" + this.f.zero_to_null(this.getId_contatore()) + ")";
            boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
            if (!r_ins) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento doc non riuscito ");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            this.setIdDocumento(Configurazioni.getIstanza().connessione.id_inserito("documenti_attivi"));
            String q = "SELECT numero from documenti_attivi where iddocumenti_attivi=" + this.getIdDocumento();
            ResultSet res_num = Configurazioni.getIstanza().connessione.eseguiQuery(q);
            int numero = 0;
            try {
                while (res_num.next()) {
                    numero = res_num.getInt("numero");
                }
            }
            catch (Exception e) {
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                e.printStackTrace();
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res_num);
            if (numero != this.getNumero()) {
                this.setNumero(numero);
                this.getR().setNum_doc("" + this.getNumero());
            }
            if (!(res_reg = this.getR().inserisciRegistrazione(false))) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento FA non riuscito per registrazione");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            this.setId_registro(this.getR().getIdregistro());
            boolean res = this.modifica_dati();
            boolean res_riga = true;
            for (RigaDocumento rf : this.getInsieme_r().vettoreR) {
                rf.setId_doc(this.getIdDocumento());
                rf.setData_movimento_appoggio(this.getR().getData_doc());
                rf.setId_tipo_doc(this.getId_tipo());
                res_riga = rf.inserisci(false);
            }
            if (!res_riga) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento FA non riuscito  per righe");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','documenti_attivi','" + this.getIdDocumento() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Inserimento FA non riuscito per trace");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su FatturaAttiva.iinserisci() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean inserisciConversione(boolean da_solo) {
        try {
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            String query_ins = "";
            query_ins = "INSERT INTO documenti_attivi(id_registro,id_causale_contabile,id_tipo,descrizione,destinazione,numero,codifica,anno,id_contatore,id_fa_old) VALUES (" + this.getId_registro() + "," + " " + this.getId_causale_contabile() + "," + "" + this.getId_tipo() + "," + "'" + this.getDescrizione().replaceAll("'", "''") + "', " + "'" + this.getDestinazione().replaceAll("'", "''") + "'," + " " + this.getNumero() + "," + "'" + this.getCodifica() + "'," + "" + this.getAnno() + "," + "" + this.f.zero_to_null(this.getId_contatore()) + "," + "" + this.getId_fa_old() + ")";
            boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
            if (!r_ins) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento doc non riuscito ");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            this.setIdDocumento(Configurazioni.getIstanza().connessione.id_inserito("documenti_attivi"));
            boolean res_riga = true;
            for (RigaDocumento rf : this.getInsieme_r().vettoreR) {
                rf.setId_doc(this.getIdDocumento());
                rf.setData_movimento_appoggio(this.getR().getData_doc());
                res_riga = rf.inserisci(false);
            }
            if (!res_riga) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento FA non riuscito  per righe");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','documenti_attivi','" + this.getIdDocumento() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Inserimento FA non riuscito per trace");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su FatturaAttiva.iinserisci() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean modificaFA(boolean da_solo) {
        try {
            boolean res_r;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(res_r = this.getR().modificaRegistrazione(false))) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Modifica FA non riuscito per registrazione");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            boolean res_1 = this.modifica_dati();
            if (!res_1) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Modifica FA non riuscito per dati");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            boolean res_el = true;
            for (RigaDocumento pnr : this.getInsieme_r().vettoreR) {
                pnr.setId_doc(this.getIdDocumento());
                pnr.setData_movimento_appoggio(this.getR().getData_doc());
                pnr.setId_tipo_doc(this.getId_tipo());
                if (pnr.getId_riga() == 0) {
                    res_el = pnr.inserisci(false);
                    continue;
                }
                res_el = pnr.modifica(false);
            }
            if (!res_el) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Modifica FA non riuscito per riga FA");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            boolean res_s = true;
            if (this.getV_el() != null && !this.getV_el().isEmpty()) {
                res_s = this.svuotaRighe(false);
            }
            if (!res_s) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Modifica FA non riuscito per svuota righe");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su FatturaAttiva.mmodifica() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean modifica_dati() {
        String query_mod = "Update documenti_attivi SET numero=" + this.getNumero() + "," + "id_registro=" + this.getId_registro() + "," + "codifica='" + this.getCodifica() + "'," + "anno=" + this.getAnno() + "," + "id_causale_contabile=" + this.getId_causale_contabile() + "," + "id_fa_old=" + this.getId_fa_old() + "," + "id_contatore=" + this.getId_contatore() + "," + "destinazione='" + this.getDestinazione().replaceAll("'", "''") + "'," + "descrizione='" + this.getDescrizione().replaceAll("'", "''") + "' " + " WHERE iddocumenti_attivi=" + this.getIdDocumento() + "";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            MyTrace.log.severe("Modifica FatturaAttiva non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','documenti_attivi','" + this.getIdDocumento() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Fattura Attiva non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        return true;
    }

    public void seleziona_dettagli() {
        try {
            this.getR().selezionaDati();
            InsiemeRigheDoc i_r = new InsiemeRigheDoc();
            String w = " WHERE id_documenti_attivi= " + this.getIdDocumento() + "";
            i_r.caricamento(w, "");
            for (RigaDocumento r : i_r.vettoreR) {
                r.setId_listino_appoggio(this.getR().getAnagrafica().getIdanag());
            }
            this.setInsieme_r(i_r);
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE: in  FatturaAttiva.seleziona_dettagli()");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
    }

    public boolean svuotaRighe(boolean da_solo) {
        try {
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            boolean ris_om = true;
            for (RigaDocumento rf : this.getV_el()) {
                ris_om = rf.eliminaRF(false);
            }
            if (!ris_om) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Svuota righe fa  non riuscita per elimina righe");
                Configurazioni.eccezione.gestisci("3.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su FatturaAttiva.svuotaRighe() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public void calcola_totali() {
        this.setV_riepilogo(new ArrayList<TotaliDocumento>());
        if (this.getInsieme_r() != null && !this.getInsieme_r().vettoreR.isEmpty()) {
            TotaliDocumento tf3;
            Vector<Aliquota> v_aliquote = new Vector<Aliquota>();
            Vector<Integer> v_id_aliquote = new Vector<Integer>();
            for (RigaDocumento r : this.getInsieme_r().vettoreR) {
                int id_a = 0;
                try {
                    id_a = r.getId_aliquota();
                }
                catch (Exception e) {
                    MyTrace.log.severe("RIGA FATTURA CON ALIQUOTA NULLA");
                }
                if (v_id_aliquote.contains(id_a)) continue;
                v_id_aliquote.add(id_a);
                v_aliquote.add(r.getAliquota());
            }
            Iterator ip = v_aliquote.iterator();
            while (ip.hasNext()) {
                TotaliDocumento tf2 = new TotaliDocumento();
                Aliquota val = (Aliquota)ip.next();
                tf2.setAliquota(val);
                for (RigaDocumento r : this.getInsieme_r().vettoreR) {
                    Aliquota a_corrente = new Aliquota();
                    try {
                        a_corrente = r.getAliquota();
                        if (a_corrente.getId() != val.getId()) continue;
                        tf2.setImponibile(tf2.getImponibile().plus(r.getImporto()));
                    }
                    catch (Exception e) {
                        MyTrace.log.severe("RIGA FATTURA CON ALIQUOTA NULLA");
                    }
                }
                this.getV_riepilogo().add(tf2);
            }
            Money somma_imponibile = new Money(BigDecimal.ZERO);
            Money totale_a_pagare = new Money(BigDecimal.ZERO);
            Money somma_imposta = new Money(BigDecimal.ZERO);
            for (TotaliDocumento tf3 : this.getV_riepilogo()) {
                tf3.setImpsta(tf3.getImponibile().times(tf3.getAliquota().getAliquota() / 100.0));
                totale_a_pagare = totale_a_pagare.plus(tf3.getImponibile().plus(tf3.getImpsta()));
                somma_imponibile = somma_imponibile.plus(tf3.getImponibile());
                somma_imposta = somma_imposta.plus(tf3.getImpsta());
            }
            tf3 = new TotaliDocumento();
            tf3.setImponibile(somma_imponibile);
            tf3.setImpsta(somma_imposta);
            tf3.setTotale_a_pagare(totale_a_pagare);
            this.getV_riepilogo().add(tf3);
            this.setTot_imponibile(somma_imponibile);
            this.setTot_imposta(somma_imposta);
            this.setTot_doc(totale_a_pagare);
            this.getR().setImporto_doc(totale_a_pagare);
        }
    }

    public void costruisci_righe_iva(int da_bloccare) {
        if (this.getR().getInsieme_iva_da_eliminare() == null) {
            this.getR().setInsieme_iva_da_eliminare(new InsiemePNIva());
        }
        if (this.getR().getInsieme_iva() == null) {
            this.getR().setInsieme_iva(new InsiemePNIva());
        }
        Vector<PNIva> v_da_tenere = new Vector<PNIva>();
        if (!this.getR().getInsieme_iva().vettoreIVAPN.isEmpty()) {
            for (PNIva pni : this.getR().getInsieme_iva().vettoreIVAPN) {
                if (pni.getId() == 0) continue;
                if (pni.getBloccato() != 1 && da_bloccare == 1) {
                    v_da_tenere.add(pni);
                }
                this.getR().getInsieme_iva_da_eliminare().vettoreIVAPN.add(pni);
            }
        }
        this.getR().setInsieme_iva(new InsiemePNIva());
        for (TotaliDocumento tf : this.getV_riepilogo()) {
            if (tf.getAliquota() == null || tf.getAliquota().getId() == 0) continue;
            PNIva pni = new PNIva();
            pni.setBloccato(da_bloccare);
            pni.setAnno(this.getAnno());
            pni.setId_aliquota(tf.getAliquota().getId());
            pni.setMese(Integer.parseInt(this.fda.mese(this.getR().getData_doc())));
            pni.setId_conto(this.getR().getCc().getId_conto_iva());
            if (this.getR().getCc().getTm().getNotaCredito() != 1) {
                pni.setSegno(2);
            } else {
                pni.setSegno(1);
            }
            pni.setId_registro_iva(this.getR().getCc().getReg_iva().getIdRegistro());
            pni.setProtocollo_iva(this.getR().getProtocollo_iva());
            pni.setR(this.getR());
            pni.setImponibile(tf.getImponibile());
            pni.setImposta(tf.getImpsta());
            this.getR().getInsieme_iva().vettoreIVAPN.add(pni);
        }
        if (!v_da_tenere.isEmpty()) {
            for (PNIva pni : v_da_tenere) {
                this.getR().getInsieme_iva().vettoreIVAPN.add(pni);
            }
        }
    }

    public void costruisci_righe_gestione() {
        if (this.getR().getInsieme_righe() == null) {
            this.getR().setInsieme_righe(new InsiemePNRiga());
        }
        if (this.getR().getInsieme_righe().vettoreRPN.isEmpty()) {
            PNRiga pnr = new PNRiga();
            pnr.setBloccato(0);
            pnr.setInizio_competenza(this.getR().getData_doc());
            pnr.setFine_competenza(this.getR().getData_doc());
            if (this.getR().getCc().getTm().getNotaCredito() != 1) {
                pnr.setSegno(2);
            } else {
                pnr.setSegno(1);
            }
            pnr.setId_conto(this.getR().getAnagrafica().getId_contropartita_abituale());
            pnr.setImporto(this.getTot_imponibile());
            this.getR().getInsieme_righe().vettoreRPN.add(pnr);
        } else {
            for (PNRiga pnr_temp : this.getR().getInsieme_righe().vettoreRPN) {
                pnr_temp.setImporto(this.getTot_imponibile());
            }
        }
    }

    public Money costruisci_da_fatturare() {
        int id_ri_corrente = this.getR().getAnagrafica().getId_conto_f_da_emettere();
        Money imponibile_materiali_conto = new Money(BigDecimal.ZERO);
        for (RigaDocumento rdoc : this.getInsieme_r().vettoreR) {
            imponibile_materiali_conto = imponibile_materiali_conto.plus(rdoc.getPrezzo_unitario().multiply(rdoc.getQuantita()));
        }
        boolean trovato = false;
        if (this.getR().getInsieme_righe() != null) {
            for (PNRiga pnr_temp : this.getR().getInsieme_righe().vettoreRPN) {
                if (pnr_temp.getBloccato() != 1 || pnr_temp.getId_conto() != id_ri_corrente) continue;
                trovato = true;
                MyTrace.log.info("MyDDI: Ho trovato la riga  BLOCCATA con questa conto => Aggiorno i valori");
                pnr_temp.setImporto(imponibile_materiali_conto);
            }
        }
        if (!trovato) {
            MyTrace.log.info("MyDDI: Non ho trovato la riga  BLOCCATA con questa conto => Costruisco una nuopva riga ");
            PNRiga pnr = new PNRiga();
            this.getR().getInsieme_righe().vettoreRPN.add(pnr);
            pnr.setBloccato(1);
            pnr.setId_conto(id_ri_corrente);
            pnr.setInizio_competenza(this.getR().getData_doc());
            pnr.setFine_competenza(this.getR().getData_doc());
            pnr.setSegno(1);
            pnr.setId_registro(this.getR().getIdregistro());
            pnr.setR(this.getR());
            pnr.setImporto(imponibile_materiali_conto);
        }
        return imponibile_materiali_conto;
    }

    public void costruisci_partite() {
        if (this.getR().getInsieme_p() == null) {
            this.getR().setInsieme_p(new InsiemePartite());
        }
        if (this.getR().getInsieme_p().vettoreP.isEmpty()) {
            Partita p = new Partita();
            p.setTipo_cf("C");
            if (this.getR().getCc().getTm().getNotaCredito() != 1) {
                p.setSegno(1);
            } else {
                p.setSegno(2);
            }
            p.setImporto(this.getTot_doc());
            p.setId_anagrafica(this.getR().getId_anagrafica());
            p.setTipo_partita("C");
            this.getR().getInsieme_p().vettoreP.add(p);
        } else {
            Partita p = (Partita)this.getR().getInsieme_p().vettoreP.elementAt(0);
            p.setTipo_cf("C");
            if (this.getR().getCc().getTm().getNotaCredito() != 1) {
                p.setSegno(1);
            } else {
                p.setSegno(2);
            }
            p.setImporto(this.getTot_doc());
            p.setId_anagrafica(this.getR().getId_anagrafica());
            p.setTipo_partita("C");
        }
    }

    Object getColValue(int col) {
        try {
            String retVal = "";
            switch (col) {
                case 0: {
                    try {
                        retVal = this.getR().getCodice_causale_contabile();
                    }
                    catch (Exception x) {
                        retVal = this.f.codice_CC(this.getId_causale_contabile());
                    }
                    break;
                }
                case 1: {
                    if (this.getNumero() != 0) {
                        retVal = "" + this.getNumero();
                    }
                    if (this.getCodifica().equals("")) break;
                    retVal = retVal + " " + this.getCodifica();
                    break;
                }
                case 2: {
                    retVal = "" + this.getAnno();
                    break;
                }
                case 3: {
                    retVal = "" + this.getR().getData_docIt();
                    break;
                }
                case 4: {
                    retVal = "" + this.getR().getRagione_sociale_cf();
                    break;
                }
                case 5: {
                    retVal = "" + this.getDescrizione();
                    break;
                }
                case 6: {
                    retVal = this.f.formattaNumero("" + this.getR().getImporto_doc());
                    break;
                }
                default: {
                    retVal = "";
                }
            }
            return retVal;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su FatturaAttiva.getColValue() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
    }
}

