/*
 * Decompiled with CFR 0.152.
 */
package gestionale.documenti;

import gestionale.documenti.Documento;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.MyTrace;

public class DocumentiTableModel
extends AbstractTableModel {
    ArrayList<Documento> cache = new ArrayList();
    int colCount;
    String[] headers;
    boolean modo_ric = false;

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "CC";
                break;
            }
            case 1: {
                retVal = "Numero";
                break;
            }
            case 2: {
                retVal = "Anno";
                break;
            }
            case 3: {
                retVal = "Data";
                break;
            }
            case 4: {
                retVal = "Cliente";
                break;
            }
            case 5: {
                retVal = "Descrizione";
                break;
            }
            case 6: {
                retVal = "Totale a pagare";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            Documento f = this.cache.get(row);
            return f.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        try {
            Class<?> classe = this.getValueAt(0, c).getClass();
            return classe;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE: non sono riuscito a estrarre la classe della colonna numero=" + c + " ovvero=" + this.getColumnName(c));
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setDataFA(ArrayList<Documento> vettoreFA) {
        this.cache = new ArrayList();
        Iterator<Documento> i = vettoreFA.iterator();
        while (i.hasNext()) {
            this.cache.add(i.next());
        }
        try {
            this.fireTableChanged(null);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE: nella comunicazione che \u00e8 stata creata la nuova tabella (probabile colonna con classe errata o non definita!)");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }
}

