/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.azienda.Azienda;
import gestionale.personalizzazione.stampe.IntestazioneCorrispettivi;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.primanota.PNIva;
import gestionale.primanota.Registrazione;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaFattureAcquisto
implements Runnable {
    public Vector vettore_fatture_acquisto;
    Azienda azienda;
    String mese;
    int anno;
    Thread thread;

    public StampaFattureAcquisto(Vector vettore_fatture_acquisto, String mese, int anno, Azienda azienda) {
        this.vettore_fatture_acquisto = vettore_fatture_acquisto;
        this.mese = mese;
        this.anno = anno;
        this.azienda = azienda;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA FATTURE ACQUISTO");
        attesa.start();
        this.elabora();
        attesa.stop();
    }

    public void elabora() {
        try {
            int y_inizio;
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            stampa.setFont(stampa.Font_Calibri_7);
            int y = y_inizio = 100;
            stampa.setInt((OggettoToPrint)new IntestazioneCorrispettivi());
            stampa.setIntPP((OggettoToPrint)new IntestazioneCorrispettivi());
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Corrispettivi"));
            Money tot_imponibile = new Money(BigDecimal.ZERO);
            Money tot_imposta = new Money(BigDecimal.ZERO);
            Money tot_tot = new Money(BigDecimal.ZERO);
            this.appendi_intestazione(y, stampa);
            stampa.appendLine(20, y, 20, 780);
            stampa.appendLine(580, y, 580, 780);
            stampa.appendLine(20, 780, 580, 780);
            y += 75;
            Iterator i = this.vettore_fatture_acquisto.iterator();
            int contatore = 0;
            while (i.hasNext()) {
                if (y > 750) {
                    stampa.paginanuova();
                    y = y_inizio;
                    this.appendi_intestazione(y, stampa);
                    stampa.appendLine(20, y += 75, 20, 780);
                    stampa.appendLine(580, y, 580, 780);
                    stampa.appendLine(20, 780, 580, 780);
                }
                Registrazione r = new Registrazione();
                r = (Registrazione)i.next();
                r.seleziona_righe();
                r.selezionaDati();
                stampa.appendTextOvunque(r.getData_regIt(), 25, y + 8);
                stampa.appendTextOvunque(r.getData_docIt(), 100, y + 8);
                stampa.appendTextOvunque(r.getRagione_sociale_cf(), 150, y + 8);
                stampa.appendTextOvunque(r.getCc().getCodice() + "-" + r.getCc().getDescrizione() + "  Doc:" + r.getNum_doc() + "/" + r.getAnno_doc(), 350, y + 8);
                if (++contatore % 2 == 1) {
                    // empty if block
                }
                Iterator iiva = r.getInsieme_iva().vettoreIVAPN.iterator();
                int yrighe = y + 8;
                while (iiva.hasNext()) {
                    if (y > 750) {
                        stampa.paginanuova();
                        y = y_inizio;
                        this.appendi_intestazione(y, stampa);
                        y += 75;
                    }
                    PNIva riga = (PNIva)iiva.next();
                    stampa.appendTextOvunque("" + riga.getC().getConto() + " - " + riga.getC().getDescrizione(), 100, yrighe += 8);
                    stampa.appendTextOvunque("" + riga.getImponibile(), 350, yrighe);
                    stampa.appendTextOvunque("" + riga.getA().getAliquota(), 420, yrighe);
                    stampa.appendTextOvunque("" + riga.getImposta(), 490, yrighe);
                    stampa.appendTextOvunque("" + riga.getImponibile().plus(riga.getImposta()), 540, yrighe);
                    tot_imponibile = tot_imponibile.plus(riga.getImponibile());
                    tot_imposta = tot_imposta.plus(riga.getImposta());
                    tot_tot = tot_tot.plus(riga.getImposta().plus(riga.getImponibile()));
                    if (++contatore % 2 != 1) continue;
                }
                y = yrighe;
            }
            if (y > 750) {
                stampa.paginanuova();
                y = y_inizio;
                this.appendi_intestazione(y, stampa);
                y += 75;
            }
            this.appendi_riga_totali(y, stampa, tot_imponibile, tot_imposta, tot_tot);
            FunzioniDate fda = new FunzioniDate();
            String date_now = fda.dataCorrente().replaceAll("-", "");
            String ora_now = fda.OraCorrente().replaceAll(":", "");
            Funzioni f = new Funzioni();
            String nome_file = f.pulisci_nome_file(date_now + ora_now + "_Fatture_acquisto_di_" + this.mese + "_" + this.anno);
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.print();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su StampaFattureAcquisto.elabora() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void appendi_intestazione(int y, GestoreStampe stampa) {
        try {
            stampa.appendRect(20, y, 40, 25);
            stampa.setFont(stampa.Font_Calibri_7);
            stampa.appendTextOvunque("Ditta n. " + this.azienda.getNumero(), 22, y + 15);
            stampa.appendRect(60, y, 300, 25);
            stampa.appendTextOvunque("" + this.azienda.getRagione_sociale(), 70, y + 8);
            stampa.appendTextOvunque("" + this.azienda.getVia() + " " + this.azienda.getNumero(), 70, y + 16);
            stampa.appendTextOvunque("" + this.azienda.getCap() + " " + this.azienda.getComune() + " " + this.azienda.getProvincia(), 70, y + 24);
            stampa.appendRect(360, y, 220, 25);
            stampa.appendTextOvunque("", 370, y + 8);
            stampa.appendTextOvunque("Codice Fiscale: " + this.azienda.getCf(), 370, y + 16);
            stampa.appendTextOvunque("Partita IVA: " + this.azienda.getP_iva(), 370, y + 24);
            stampa.appendRect(20, y + 25, 560, 25);
            stampa.appendTextOvunque("Mese: " + this.mese + "  Anno:" + this.anno, 35, y + 40);
            stampa.appendTextOvunque("***  REGISTRO DELLE FATTURE DI ACQUISTO  ***", 250, y + 35);
            stampa.appendRect(20, y + 50, 560, 25);
            stampa.appendTextOvunque("Data", 25, y + 60);
            stampa.appendTextOvunque("Data Doc.", 100, y + 60);
            stampa.appendTextOvunque("Ragione Sociale Fornitore", 150, y + 60);
            stampa.appendTextOvunque("Conto - Denominazione del conto", 100, y + 72);
            stampa.appendTextOvunque("Imponibile", 350, y + 72);
            stampa.appendTextOvunque("%IVA", 420, y + 72);
            stampa.appendTextOvunque("Imposta", 490, y + 72);
            stampa.appendTextOvunque("Causale operazione - numero documento", 350, y + 60);
            stampa.appendTextOvunque("Totale", 540, y + 72);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su StampaFattureAcquisto.appendi_intestazione() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void appendi_riga_totali(int y, GestoreStampe stampa, Money imponibile, Money imposta, Money totale) {
        try {
            stampa.appendRect(20, y + 5, 560, 25);
            stampa.appendTextOvunque("TOTALI:", 250, y + 15);
            stampa.appendTextOvunque("" + imponibile, 350, y + 15);
            stampa.appendTextOvunque("" + imposta, 420, y + 15);
            stampa.appendTextOvunque("" + totale, 540, y + 15);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su StampaFattureAcquisto.appendi_intestazione() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }
}

