/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.causali_contabili.CCRigaTableModel2;
import gestionale.causali_contabili.CausaleContabile;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.corrispettivi.ConfigurazioneCorrispettivo;
import gestionale.corrispettivi.InsiemeReparti;
import gestionale.corrispettivi.Reparto;
import gestionale.corrispettivi.RigheRepartiTableModel;
import gestionale.iva.MyConfiguraAliquotaIVA;
import gestionale.piano_dei_conti.MyConto5;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import utils.ButtonRigaElimina;
import utils.ComboInsertEditor;
import utils.Funzioni;
import utils.MyTrace;
import utils.RicercaCellComboRenderer;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;

public class MyConfigurazioneCorrispettivi
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    RigheRepartiTableModel rrtm;
    InsiemeReparti insieme_r;
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    public boolean f_causali_open = false;
    Funzioni f;
    ConfigurazioneCorrispettivo c_selezione;
    CausaleContabile causale_contabile;
    Vector v_da_eliminare;
    public boolean aiuto_riga_c;
    public boolean aiuto_riga_2;
    CCRigaTableModel2 ccr_tm;
    Reparto reparto1;
    private JButton jButtonAddReparto;
    private JButton jButtonModifica;
    private JLabel jLabel1;
    private JLabel jLabelCausale;
    private JLabel jLabelContiIncasso;
    private JLabel jLabelDescrizioneCausale;
    private JLabel jLabelReparti;
    private JPanel jPanel1;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JTable jTableContiIncasso;
    public JTable jTableReparti;
    public JTextField jTextCausale;
    private JToolBar jToolBar1;

    public MyConfigurazioneCorrispettivi() {
        this.initComponents();
        this.crea_toolbar();
        this.rrtm = new RigheRepartiTableModel();
        this.ccr_tm = new CCRigaTableModel2();
        this.causale_contabile = new CausaleContabile();
        Configurazioni.getIstanza();
        String codice_causale = Configurazioni.hm.get("cc_corrispettivi");
        this.causale_contabile.seleziona(codice_causale);
        this.causale_contabile.seleziona_dettagli();
        this.jTextCausale.setText(this.causale_contabile.getCodice());
        this.v_da_eliminare = new Vector();
        this.filtra();
        this.formatta();
        this.visualizzazione();
        this.f = new Funzioni();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(750, 600)));
    }

    public void verifica_CC() {
        try {
            CausaleContabile causale_contabile = new CausaleContabile();
            Configurazioni.getIstanza();
            String codice_causale = Configurazioni.hm.get("cc_corrispettivi");
            causale_contabile.seleziona(codice_causale);
            if (causale_contabile.getCodice().equals("")) {
                JOptionPane.showMessageDialog(this, "Creare una causale contabile per i Corrispettivi chiamata 'CORR'. \nCreare nel file di configurazioni la seguente riga:'cc_corrispettivi = CORR'");
                this.dispose();
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.verifica_CC() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void crea_toolbar() {
        try {
            this.jToolBarMod = new JToolBar();
            JButton jButtonSalva = new JButton();
            JButton jButtonAnnulla = new JButton();
            jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
            jButtonSalva.setText("Salva");
            jButtonSalva.setFocusable(true);
            jButtonSalva.setVerticalTextPosition(3);
            jButtonSalva.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MyConfigurazioneCorrispettivi.this.jButtonSalvaActionPerformed(evt);
                }
            });
            this.jToolBarMod.add(jButtonSalva);
            jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
            jButtonAnnulla.setText("Annulla");
            jButtonAnnulla.setFocusable(true);
            jButtonAnnulla.setVerticalTextPosition(3);
            jButtonAnnulla.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MyConfigurazioneCorrispettivi.this.jButtonAnnullaActionPerformed(evt);
                }
            });
            this.jToolBarMod.add(jButtonAnnulla);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.crea_toolbar() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void visualizzazione() {
        try {
            this.jTableReparti.setEnabled(this.in_modifica);
            this.jTextCausale.setEditable(false);
            this.jButtonAddReparto.setEnabled(this.in_modifica);
            this.jTableContiIncasso.setEnabled(false);
            if (this.in_modifica) {
                this.getContentPane().remove(this.jToolBar1);
                this.getContentPane().add((Component)this.jToolBarMod, "North");
            } else {
                this.getContentPane().remove(this.jToolBarMod);
                this.getContentPane().add((Component)this.jToolBar1, "North");
            }
            this.getContentPane().validate();
            this.getContentPane().repaint();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.visualizzazione() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void formatta() {
        try {
            this.jTableReparti.setRowHeight(27);
            this.jTableReparti.setDefaultEditor(Object.class, new TextEditor());
            this.jTableReparti.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            this.jTableReparti.setDefaultEditor(Button.class, new ButtonEditorEliminaCC(new JCheckBox()));
            this.jTableReparti.setDefaultRenderer(Button.class, new ButtonRigaElimina());
            this.jTableContiIncasso.setRowHeight(27);
            this.jTableContiIncasso.setDefaultEditor(Object.class, new TextRigaEditor());
            this.jTableContiIncasso.setDefaultEditor(JCheckBox.class, new ComboInsertEditor(new String[]{"Dare", "Avere"}));
            this.jTableContiIncasso.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            this.jTableContiIncasso.setDefaultRenderer(JCheckBox.class, new RicercaCellComboRenderer(new String[]{"Dare", "Avere"}));
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.formatta() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void filtra() {
        this.c_selezione = new ConfigurazioneCorrispettivo();
        try {
            String query = "SELECT * FROM conf_reparti WHERE abilita='1'  ";
            this.insieme_r = new InsiemeReparti();
            this.insieme_r.caricamento(query);
            this.rrtm.setDataReparto(this.insieme_r.vettoreReparti);
            this.jTableReparti.setModel(this.rrtm);
            this.c_selezione.setInsiemeReparti(this.insieme_r);
            this.reparto1 = (Reparto)this.insieme_r.vettoreReparti.elementAt(1);
            this.ccr_tm = new CCRigaTableModel2();
            this.causale_contabile = new CausaleContabile();
            this.causale_contabile.seleziona(this.reparto1.getId_cc());
            this.causale_contabile.seleziona_dettagli();
            this.jTextCausale.setText(this.causale_contabile.getCodice());
        }
        catch (Exception e) {
            this.insieme_r = new InsiemeReparti();
            this.insieme_r.vettoreReparti = new Vector();
            this.c_selezione = new ConfigurazioneCorrispettivo();
            this.c_selezione.setInsiemeReparti(this.insieme_r);
        }
        this.filtra_conti_incasso();
    }

    public void filtra_conti_incasso() {
        try {
            this.ccr_tm.setDataCCRiga(this.causale_contabile.getInsieme_righe().vettoreCCRighe);
            this.jTableContiIncasso.setModel(this.ccr_tm);
            this.c_selezione.setId_cc(this.reparto1.getId_cc());
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.filtra_conti_icasso() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void costruisci() {
        try {
            ConfigurazioneCorrispettivo cc = new ConfigurazioneCorrispettivo();
            cc.setId_cc(this.reparto1.getId_cc());
            cc.setInsiemeReparti(this.insieme_r);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.costruisci() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void elimina_reparto(int vector_element) {
        try {
            int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questo Reparto?");
            if (res == 0) {
                this.jTableReparti.setRowSelectionInterval(vector_element, vector_element);
                Reparto reparto_da_eliminare = new Reparto();
                reparto_da_eliminare = (Reparto)this.c_selezione.getInsiemeReparti().vettoreReparti.elementAt(vector_element);
                this.v_da_eliminare.add(reparto_da_eliminare);
                this.c_selezione.getInsiemeReparti().vettoreReparti.remove(vector_element);
                this.rrtm.setDataReparto(this.c_selezione.getInsiemeReparti().vettoreReparti);
                this.jTableReparti.setModel(this.rrtm);
                this.c_selezione.setV_da_eliminare(this.v_da_eliminare);
                this.formatta();
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.elimina_reparto() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private boolean check() {
        if (this.jTextCausale.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire una Causale Contabile valida");
            return false;
        }
        return true;
    }

    public void aiuto_riga(int row, int col) {
        try {
            JInternalFrame oggetto;
            if (col == 1 && !this.aiuto_riga_c) {
                oggetto = new MyConfiguraAliquotaIVA();
                ((MyConfiguraAliquotaIVA)oggetto).chiamante = this;
                this.getDesktopPane().add(oggetto);
                oggetto.setLocation(200, 100);
                oggetto.setVisible(true);
                oggetto.moveToFront();
                this.aiuto_riga_c = true;
            }
            if (col == 3 && !this.aiuto_riga_2) {
                oggetto = new MyConto5();
                ((MyConto5)oggetto).chiamante = this;
                this.getDesktopPane().add(oggetto);
                oggetto.setLocation(200, 100);
                oggetto.setVisible(true);
                oggetto.moveToFront();
                this.aiuto_riga_2 = true;
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.aiuto_riga() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void aiuto_righe(int row, int col) {
        try {
            if (col == 0 && !this.aiuto_riga_c) {
                this.setCursor(new Cursor(3));
                MyConto5 oggetto = new MyConto5();
                oggetto.chiamante = this;
                oggetto.row_chiamante = row;
                this.getDesktopPane().add(oggetto);
                oggetto.setLocation(200, 100);
                oggetto.setVisible(true);
                oggetto.moveToFront();
                this.setCursor(new Cursor(0));
                this.aiuto_riga_c = true;
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.aiuto_righe() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTableReparti = new JTable(this.rrtm);
        this.jPanel17 = new JPanel();
        this.jButtonAddReparto = new JButton();
        this.jPanel8 = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.jTableContiIncasso = new JTable();
        this.jPanel18 = new JPanel();
        this.jLabelCausale = new JLabel();
        this.jTextCausale = new JTextField();
        this.jLabelContiIncasso = new JLabel();
        this.jLabelReparti = new JLabel();
        this.jLabelDescrizioneCausale = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.jButtonModifica = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Contabilit\u00e0 \\ Configurazione Corrispettivi");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyConfigurazioneCorrispettivi.this.finestra_spostata(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyConfigurazioneCorrispettivi.this.finestra_ridimensionata(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Configurazione Corrispettivi");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setName("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 50, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel7.setName("jPanel7");
        this.jPanel7.setLayout(new BorderLayout());
        this.jScrollPane5.setName("jScrollPane5");
        this.jScrollPane5.setPreferredSize(new Dimension(450, 150));
        this.jTableReparti.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableReparti.setDragEnabled(true);
        this.jTableReparti.setName("jTableReparti");
        this.jTableReparti.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyConfigurazioneCorrispettivi.this.jTableRepartiFocusLost(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jTableReparti);
        this.jPanel7.add((Component)this.jScrollPane5, "Center");
        this.jPanel17.setName("jPanel17");
        this.jPanel17.setLayout(new BorderLayout());
        this.jButtonAddReparto.setText("+");
        this.jButtonAddReparto.setName("jButtonAddReparto");
        this.jButtonAddReparto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfigurazioneCorrispettivi.this.jButtonAddRepartoActionPerformed(evt);
            }
        });
        this.jPanel17.add((Component)this.jButtonAddReparto, "East");
        this.jPanel7.add((Component)this.jPanel17, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        this.jPanel1.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setName("jPanel8");
        this.jPanel8.setLayout(new BorderLayout());
        this.jScrollPane6.setName("jScrollPane6");
        this.jScrollPane6.setPreferredSize(new Dimension(450, 150));
        this.jTableContiIncasso.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableContiIncasso.setDragEnabled(true);
        this.jTableContiIncasso.setName("jTableContiIncasso");
        this.jTableContiIncasso.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyConfigurazioneCorrispettivi.this.jTableContiIncassoFocusLost(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.jTableContiIncasso);
        this.jPanel8.add((Component)this.jScrollPane6, "Center");
        this.jPanel18.setName("jPanel18");
        this.jPanel18.setLayout(new BorderLayout());
        this.jPanel8.add((Component)this.jPanel18, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        this.jPanel1.add((Component)this.jPanel8, gridBagConstraints);
        this.jLabelCausale.setText("Causale");
        this.jLabelCausale.setName("jLabelCausale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jLabelCausale, gridBagConstraints);
        this.jTextCausale.setToolTipText("Causale Contabile");
        this.jTextCausale.setMinimumSize(new Dimension(80, 27));
        this.jTextCausale.setName("jTextCausale");
        this.jTextCausale.setPreferredSize(new Dimension(80, 27));
        this.jTextCausale.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MyConfigurazioneCorrispettivi.this.jTextCausaleFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MyConfigurazioneCorrispettivi.this.jTextCausaleFocusLost(evt);
            }
        });
        this.jTextCausale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyConfigurazioneCorrispettivi.this.jTextCausaleKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel1.add((Component)this.jTextCausale, gridBagConstraints);
        this.jLabelContiIncasso.setText("Conti di incasso dalla Causale Contabile");
        this.jLabelContiIncasso.setName("jLabelContiIncasso");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.jPanel1.add((Component)this.jLabelContiIncasso, gridBagConstraints);
        this.jLabelReparti.setText("Reparti");
        this.jLabelReparti.setName("jLabelReparti");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jLabelReparti, gridBagConstraints);
        this.jLabelDescrizioneCausale.setName("jLabelDescrizioneCausale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel1.add((Component)this.jLabelDescrizioneCausale, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setName("jButtonModifica");
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfigurazioneCorrispettivi.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                this.c_selezione.inserisci(false);
                this.in_new = false;
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
            }
        } else if (this.check()) {
            this.costruisci();
            this.c_selezione.modifica(false);
            this.in_modifica = false;
            this.filtra();
            this.visualizzazione();
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
        }
    }

    private void jTableRepartiFocusLost(FocusEvent evt) {
    }

    private void jButtonAddRepartoActionPerformed(ActionEvent evt) {
        Reparto ro = new Reparto();
        ro.setCodice_conto("");
        ro.setCodice_aliquota("");
        ro.setDescrizione_conto("");
        ro.setDescrizione_conto("");
        this.c_selezione.getInsiemeReparti().vettoreReparti.add(ro);
        this.rrtm.setDataReparto(this.c_selezione.getInsiemeReparti().vettoreReparti);
        this.jTableReparti.setModel(this.rrtm);
    }

    private void jTableContiIncassoFocusLost(FocusEvent evt) {
    }

    private void jTextCausaleFocusGained(FocusEvent evt) {
    }

    private void jTextCausaleFocusLost(FocusEvent evt) {
        this.causale_contabile = new CausaleContabile();
        this.causale_contabile.seleziona(this.jTextCausale.getText());
        this.causale_contabile.seleziona_dettagli();
        this.jLabelDescrizioneCausale.setText(this.f.descrizione_CC(this.f.id_causale_contabile(this.jTextCausale.getText())));
        this.filtra_conti_incasso();
    }

    private void jTextCausaleKeyPressed(KeyEvent evt) {
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
    }

    private void finestra_spostata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextRigaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            MyConfigurazioneCorrispettivi.this.aiuto_righe(MyConfigurazioneCorrispettivi.this.jTableContiIncasso.getSelectedRow(), col);
            this.getCellEditorValue();
        }

        @Override
        public void azione_focus_lost(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            String[] b = null;
            double test = 0.0;
            try {
                test = Double.valueOf(this.tf.getText());
                System.out.println("questo \u00e8 il valore di test:__" + test + "__");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (col == 0 && test == 0.0) {
                b = MyConfigurazioneCorrispettivi.this.f.descrizione_conto_da_alias(this.tf.getText());
                System.out.println("Focus lost " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                MyTrace.log.info("FOCUS LOST:>   " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                MyConfigurazioneCorrispettivi.this.jTableContiIncasso.setValueAt(b[1], row, col);
                MyConfigurazioneCorrispettivi.this.jTableContiIncasso.setValueAt(b[0], row, col + 1);
            } else {
                String appoggio = this.tf.getText();
                try {
                    b[1] = MyConfigurazioneCorrispettivi.this.f.descrizione_conto(appoggio);
                    b[0] = this.tf.getText();
                    System.out.println("Focus lost " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                    MyTrace.log.info("FOCUS LOST:>   " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                    MyConfigurazioneCorrispettivi.this.jTableContiIncasso.setValueAt(b[1], row, col);
                    MyConfigurazioneCorrispettivi.this.jTableContiIncasso.setValueAt(b[0], row, col + 1);
                }
                catch (Exception e) {
                    MyConfigurazioneCorrispettivi.this.jTableContiIncasso.setValueAt(appoggio, row, col);
                }
            }
        }
    }

    class ButtonEditorEliminaCC
    extends DefaultCellEditor {
        private JButton button;
        private int row;

        ButtonEditorEliminaCC(JCheckBox checkBox) {
            super(checkBox);
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.setForeground(new Color(0, 0, 102));
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyConfigurazioneCorrispettivi.this.elimina_reparto(ButtonEditorEliminaCC.this.row);
                    ButtonEditorEliminaCC.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.button.setBackground(new Color(255, 255, 255));
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }
    }

    public class TextEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            this.getCellEditorValue();
            MyConfigurazioneCorrispettivi.this.aiuto_riga(row, col);
        }

        @Override
        public void azione_focus_lost(String col_row) {
            try {
                String[] a = col_row.split("_");
                int col = Integer.parseInt(a[0]);
                int row = Integer.parseInt(a[1]);
                Object b = null;
                if (col == 1) {
                    try {
                        double percentuale = MyConfigurazioneCorrispettivi.this.f.percentuale_aliquota_da_id(MyConfigurazioneCorrispettivi.this.f.id_aliquota_da_codice(this.tf.getText()));
                        MyConfigurazioneCorrispettivi.this.jTableReparti.setValueAt("" + percentuale, row, col + 1);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (col == 3) {
                    try {
                        String descrizione_conto = MyConfigurazioneCorrispettivi.this.f.descrizione_conto(this.tf.getText());
                        MyConfigurazioneCorrispettivi.this.jTableReparti.setValueAt("" + descrizione_conto, row, col + 1);
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception ex) {
                MyTrace.log.severe("ERRORE:  eccezione azione_focus_lost() ");
                ex.printStackTrace();
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
            }
            catch (Error err) {
                MyTrace.log.severe("ERRORE: azione_focus_lost() errore di avvio o di linkaggio");
                err.printStackTrace();
            }
        }
    }
}

