/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.corrispettivi.Corrispettivo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class CorrispettivoTableModel
extends AbstractTableModel {
    public Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    Vector nomi_colonne;
    String[] array_colonne;
    Vector colonne_reparti;
    Vector colonne_incassi;
    ArrayList<Money> vettore_reparti;
    ArrayList<Money> vettore_incassi;
    int max_reparti;
    int max_incassi;
    int max_totale;

    public CorrispettivoTableModel(int max_incassi, int max_reparti, int max_totale, Vector colonne_reparti, Vector colonne_incassi, Vector vettore_reparti, Vector vettore_incassi, String[] array_colonne) {
        this.cache = new Vector();
        this.array_colonne = array_colonne;
        this.colonne_reparti = colonne_reparti;
        this.colonne_incassi = colonne_incassi;
        this.max_incassi = max_incassi;
        this.max_reparti = max_reparti;
        this.max_totale = max_totale;
    }

    public CorrispettivoTableModel(int max_incassi, int max_reparti, int max_totale, Vector colonne_reparti, Vector colonne_incassi, ArrayList vettore_reparti, ArrayList vettore_incassi, String[] array_colonne) {
        this.cache = new Vector();
        this.vettore_reparti = vettore_reparti;
        this.vettore_incassi = vettore_incassi;
        this.array_colonne = array_colonne;
        this.colonne_reparti = colonne_reparti;
        this.colonne_incassi = colonne_incassi;
        this.max_incassi = max_incassi;
        this.max_reparti = max_reparti;
        this.max_totale = max_totale;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        retVal = this.array_colonne[i];
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return this.array_colonne.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            Corrispettivo p = new Corrispettivo();
            if (!this.cache.isEmpty()) {
                p = (Corrispettivo)this.cache.elementAt(row);
                return p.getColValue(col);
            }
            return "";
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su CorrispettivoTableModel.getValueAt ECCEZIONE:" + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return null;
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            Corrispettivo cc = (Corrispettivo)this.cache.elementAt(row);
            if (col == 0) {
                cc.setData_corrispettivo(value.toString());
            }
            if (col > 0 && col < this.max_reparti) {
                try {
                    cc.getIncasso_reparti().set(col - 1, new Money(value.toString()));
                }
                catch (Exception e) {
                    cc.getIncasso_reparti().set(col - 1, new Money(BigDecimal.ZERO));
                }
            }
            if (col >= this.max_reparti && col < this.max_incassi) {
                try {
                    cc.getDeposito_cassa().set(col - this.max_reparti, new Money(value.toString()));
                }
                catch (Exception e) {
                    cc.getDeposito_cassa().set(col - this.max_reparti, new Money(BigDecimal.ZERO));
                }
            }
            if (col == this.max_totale) {
                cc.setTotale_giorno(new Money(value.toString()));
            }
            this.fireTableRowsUpdated(row, row);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su CorrispettivoTableModel.setValueAt ECCEZIONE:" + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            return col != 0;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su CorrispettivoTableModel.isCellEditable ECCEZIONE:" + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public void setDataCorrispettivo(Vector vettorePNR) {
        try {
            this.cache = new Vector();
            for (Corrispettivo ro : vettorePNR) {
                this.cache.addElement(ro);
            }
            this.fireTableChanged(null);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su CorrispettivoTableModel.setDataCorrispettivo ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }
}

