/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.corrispettivi.ConfigurazioneCorrispettivo;
import java.math.BigDecimal;
import java.util.ArrayList;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;

public class Corrispettivo {
    String data_corrispettivo;
    ArrayList<Money> incasso_reparti;
    ArrayList<Money> deposito_cassa;
    ConfigurazioneCorrispettivo c;
    int dim_totale;
    int dim_reparti;
    int dim_cassa;
    Money totale_giorno = new Money(BigDecimal.ZERO);

    public Corrispettivo() {
    }

    public Corrispettivo(ConfigurazioneCorrispettivo c, int dim_totale, int dim_reparti, int dim_cassa) {
        this.c = c;
        this.dim_cassa = dim_cassa;
        this.dim_reparti = dim_reparti;
        this.dim_totale = dim_totale;
    }

    public String getData_corrispettivo() {
        return this.data_corrispettivo;
    }

    public void setData_corrispettivo(String data_corrispettivo) {
        this.data_corrispettivo = data_corrispettivo;
    }

    public ArrayList<Money> getDeposito_cassa() {
        return this.deposito_cassa;
    }

    public void setDeposito_cassa(ArrayList<Money> deposito_cassa) {
        this.deposito_cassa = deposito_cassa;
    }

    public ArrayList<Money> getIncasso_reparti() {
        return this.incasso_reparti;
    }

    public void setIncasso_reparti(ArrayList<Money> incasso_reparti) {
        this.incasso_reparti = incasso_reparti;
    }

    public Money getTotale_giorno() {
        return this.totale_giorno;
    }

    public void setTotale_giorno(Money totale_giorno) {
        this.totale_giorno = totale_giorno;
    }

    Object getColValue(int col) {
        try {
            String retVal = "";
            if (col == 0) {
                retVal = this.getData_corrispettivo();
            } else if (col == this.dim_totale - 1) {
                retVal = "" + this.getTotale_giorno();
            } else if (col > 0 && col < this.dim_reparti + 1) {
                try {
                    retVal = "" + this.getIncasso_reparti().get(col - 1);
                }
                catch (Exception e) {
                    retVal = "";
                }
            } else if (col > this.dim_reparti && col < this.dim_reparti + this.dim_cassa + 1) {
                try {
                    retVal = "" + this.getDeposito_cassa().get(col - this.dim_reparti - 1);
                }
                catch (Exception e) {
                    retVal = "";
                }
            }
            return retVal;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Corrispettivo.getColValue(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return null;
        }
    }

    Object getColValue_giorno(int col) {
        String retVal = "";
        if (col == 0) {
            retVal = this.getData_corrispettivo();
        }
        return retVal;
    }

    Object getColValue_reparti(int col) {
        String retVal = "";
        try {
            retVal = this.getIncasso_reparti().get(col).toString();
        }
        catch (Exception e) {
            retVal = "";
        }
        return retVal;
    }

    Object getColValue_deposito_in_cassa(int col) {
        try {
            String retVal = "";
            try {
                retVal = this.getDeposito_cassa().get(col).toString();
            }
            catch (Exception e) {
                retVal = "";
            }
            return retVal;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Corrispettivo.getColValue_deposito_in_cassa(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return null;
        }
    }

    Object getColValue_totale(int col) {
        String retVal = "";
        retVal = "" + this.getTotale_giorno();
        return retVal;
    }
}

