/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.causali_contabili.CausaleContabile;
import gestionale.causali_contabili.CausaleContabileRiga;
import gestionale.corrispettivi.InsiemeReparti;
import gestionale.corrispettivi.Reparto;
import gestionale.piano_dei_conti.Conto5;
import java.util.Iterator;
import java.util.Vector;
import utils.Funzioni;
import utils.MyTrace;

public class ConfigurazioneCorrispettivo {
    int id_cc;
    InsiemeReparti insiemeReparti;
    private Vector v_da_eliminare;

    public int getId_cc() {
        return this.id_cc;
    }

    public void setId_cc(int id_cc) {
        this.id_cc = id_cc;
    }

    public InsiemeReparti getInsiemeReparti() {
        return this.insiemeReparti;
    }

    public void setInsiemeReparti(InsiemeReparti insiemeReparti) {
        this.insiemeReparti = insiemeReparti;
    }

    public Vector getV_da_eliminare() {
        return this.v_da_eliminare;
    }

    public void setV_da_eliminare(Vector v_da_eliminare) {
        this.v_da_eliminare = v_da_eliminare;
    }

    public void inserisci(boolean da_fuori) {
        block9: {
            try {
                if (this.getInsiemeReparti() != null) {
                    try {
                        for (Reparto cc : this.getInsiemeReparti().vettoreReparti) {
                            cc.inserisci(true);
                        }
                    }
                    catch (Exception e) {
                        MyTrace.log.severe("Eccezione Inserimento Reparto su ConfigurazioneCorrispettivo.Inserisci()");
                        Funzioni.inviaBugPerEmail(e);
                        Funzioni.LogStackTrace(e);
                    }
                }
                if (this.getV_da_eliminare() == null) break block9;
                try {
                    for (Reparto cc : this.getV_da_eliminare()) {
                        cc.elimina();
                    }
                }
                catch (Exception e) {
                    MyTrace.log.severe("Non riuscita eliminazione Reparti da eliminare su ConfigurazioneCorrispettivo.Inserisci()");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            }
            catch (Exception e) {
                MyTrace.log.severe("ECCEZIONE su " + this.getClass().getCanonicalName() + ": " + e);
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        }
    }

    public void modifica(boolean da_fuori) {
        block10: {
            try {
                if (this.getInsiemeReparti() != null) {
                    try {
                        for (Reparto cc : this.getInsiemeReparti().vettoreReparti) {
                            if (cc.getIdreparto() == 0) {
                                cc.inserisci(false);
                                continue;
                            }
                            cc.modifica(false);
                        }
                    }
                    catch (Exception e) {
                        MyTrace.log.severe("Eccezione Inserimento Reparto su ConfigurazioneCorrispettivo.modifica()");
                        Funzioni.inviaBugPerEmail(e);
                        Funzioni.LogStackTrace(e);
                    }
                }
                if (this.getV_da_eliminare() == null) break block10;
                try {
                    for (Reparto cc : this.getV_da_eliminare()) {
                        cc.elimina();
                    }
                }
                catch (Exception e) {
                    MyTrace.log.severe("Non riuscita eliminazione Reparti da eliminare su ConfigurazioneCorrispettivo.modifica()");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            }
            catch (Exception e) {
                MyTrace.log.severe("ECCEZIONE su ConfigurazioneCorrispettivo.modifica(): " + e);
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        }
    }

    public Vector ottieni_colonne_tutte() {
        String codice_causale = "";
        MyTrace.log.info("Chiamato metodo ottieni_colonne_tutte()");
        Vector<String> vettore_colonne = new Vector<String>();
        String query = "SELECT * FROM conf_reparti WHERE abilita='1'  ";
        InsiemeReparti insieme_r = new InsiemeReparti();
        insieme_r.caricamento(query);
        Iterator I_reparti = insieme_r.vettoreReparti.iterator();
        vettore_colonne.add("Giorno");
        while (I_reparti.hasNext()) {
            Reparto r = (Reparto)I_reparti.next();
            vettore_colonne.add(r.getNome_reparto() + " \n" + r.getCodice_conto());
        }
        CausaleContabile causale = new CausaleContabile();
        causale.seleziona("corr");
        causale.seleziona_dettagli();
        for (CausaleContabileRiga r : causale.getInsieme_righe().vettoreCCRighe) {
            Conto5 c = new Conto5();
            c.seleziona(r.getId_conto());
            vettore_colonne.add(c.getAlias() + " \n" + c.getConto());
        }
        vettore_colonne.add("Totale Giorno");
        MyTrace.log.info("Fine metodo ottieni_colonne_tutte()");
        return vettore_colonne;
    }

    public int ottieni_dimensione_colonne() {
        MyTrace.log.info("Chiamato metodo ottieni_dimensioni_cassa()");
        return this.ottieni_dimensione_cassa() + this.ottieni_dimensione_reparti() + 2;
    }

    public Vector ottieni_colonne_reparti() {
        MyTrace.log.info("Chiamato metodo ottieni_colonne_reparti()");
        Vector<String> vettore_colonne = new Vector<String>();
        String query = "SELECT * FROM conf_reparti WHERE abilita='1'  ";
        InsiemeReparti insieme_r = new InsiemeReparti();
        insieme_r.caricamento(query);
        for (Reparto r : insieme_r.vettoreReparti) {
            vettore_colonne.add(r.getNome_reparto() + "-" + r.getCodice_conto());
        }
        MyTrace.log.info("Fine metodo ottieni_colonne_reparti()");
        return vettore_colonne;
    }

    public int ottieni_dimensione_reparti() {
        MyTrace.log.info("Chiamato metodo ottieni_dimensione_reparti()");
        Vector vettore_colonne = new Vector();
        String query = "SELECT * FROM conf_reparti WHERE abilita='1'  ";
        InsiemeReparti insieme_r = new InsiemeReparti();
        insieme_r.caricamento(query);
        Iterator I_reparti = insieme_r.vettoreReparti.iterator();
        int contatore = 0;
        while (I_reparti.hasNext()) {
            ++contatore;
            I_reparti.next();
        }
        MyTrace.log.info("Fine metodo ottieni_dimensione_reparti()");
        return contatore;
    }

    public Vector ottieni_colonne_cassa() {
        MyTrace.log.info("Chiamato metodo ottieni_colonne_cassa()");
        Vector<String> vettore_colonne = new Vector<String>();
        CausaleContabile causale = new CausaleContabile();
        causale.seleziona("corr");
        causale.seleziona_dettagli();
        for (CausaleContabileRiga r : causale.getInsieme_righe().vettoreCCRighe) {
            Conto5 c = new Conto5();
            c.seleziona(r.getId_conto());
            vettore_colonne.add(c.getAlias().replaceAll("  ", "") + "-" + c.getConto());
        }
        MyTrace.log.info("Fine metodo ottieni_colonne_cassa()");
        return vettore_colonne;
    }

    public int ottieni_dimensione_cassa() {
        MyTrace.log.info("Chiamato metodo ottieni_dimensione_cassa()");
        int contatore = 0;
        CausaleContabile causale = new CausaleContabile();
        causale.seleziona("corr");
        causale.seleziona_dettagli();
        Iterator i_conti_incasso = causale.getInsieme_righe().vettoreCCRighe.iterator();
        while (i_conti_incasso.hasNext()) {
            ++contatore;
            i_conti_incasso.next();
        }
        MyTrace.log.info("Fine metodo ottieni_dimensione_cassa()");
        return contatore;
    }
}

