/*
 * Decompiled with CFR 0.152.
 */
package gestionale.conti_correnti;

import anagrafiche.banche.IBAN;
import gestionale.conti_correnti.ContoCorrente;
import java.awt.Button;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;

public class RigheContiCorrentiTableModel
extends AbstractTableModel {
    public Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public RigheContiCorrentiTableModel() {
        this.cache = new Vector();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "IBAN";
                break;
            }
            case 1: {
                retVal = "ABI";
                break;
            }
            case 2: {
                retVal = "CAB";
                break;
            }
            case 3: {
                retVal = "Istituto";
                break;
            }
            case 4: {
                retVal = "Agenzia";
                break;
            }
            case 5: {
                retVal = "Note";
                break;
            }
            case 6: {
                retVal = "";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ContoCorrente p = new ContoCorrente();
        if (!this.cache.isEmpty()) {
            p = (ContoCorrente)this.cache.elementAt(row);
            return p.getColValueRiga(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ContoCorrente cc = new ContoCorrente();
        cc = (ContoCorrente)this.cache.elementAt(row);
        if (col == 0) {
            cc.setIban(value.toString());
        }
        if (col == 1) {
            cc.setAbi(value.toString());
        }
        if (col == 2) {
            cc.setCab(value.toString());
        }
        if (col == 3) {
            cc.setIstituto(value.toString());
        }
        if (col == 4) {
            cc.setAgenzia(value.toString());
        }
        if (col == 5) {
            cc.setNote(value.toString());
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return IBAN.class;
        }
        if (c == 6) {
            return Button.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setDataRiga(Vector vettorePNR) {
        this.cache = new Vector();
        for (ContoCorrente ro : vettorePNR) {
            this.cache.addElement(ro);
        }
        this.fireTableChanged(null);
    }
}

