/*
 * Decompiled with CFR 0.152.
 */
package gestionale.configurazioni;

import gestionale.Main;
import gestionale.MyDesktopWindow;
import gestionale.azienda.Azienda;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.ConfigurazioneIni;
import gestionale.configurazioni.Eccezioni;
import gestionale.iva.Aliquota;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JOptionPane;
import utils.Connessione;
import utils.Funzioni;
import utils.FunzioniDiritti;
import utils.GestioneLicenze;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;
import utils.Risorse;

public final class Configurazioni {
    public static final String revisioneSoftware = "$Rev: 1534 $";
    public static final String versioneSoftware = "1.3." + "$Rev: 1534 $".substring(6, "$Rev: 1534 $".length() - 2);
    public static ConfigurazioneFinestre conf_finestre;
    public static ConfigurazioneIni conf_ini;
    public Connessione connessione;
    public Connessione connessione_master;
    public static HashMap<String, String> hm;
    public static int righe_ricerca;
    public static int id_azienda;
    public static int inizio_stampe;
    public static Azienda azienda;
    public static String nome_azienda;
    public static String operatore;
    public static Eccezioni eccezione;
    private static boolean classe_istanziata;
    private static Configurazioni puntatore_istanza;
    public static String cartella_di_lavoro;
    public Main main = null;
    public static Aliquota aliquota_predefinita;
    public FunzioniDiritti fd;
    public static int numero_righe;
    public MyDesktopWindow desktopwindow;
    public static Calendar datascadenza;
    public static boolean modalit\u00e0ConsultazioneAttiva;
    String civetta_permessi;
    public static int size_diritti;
    public static String[] array_diritti;

    public Configurazioni() {
        try {
            MyTrace.log.config("RICHIESTA DI ISTANZIAZIONE DELLE CONFIGURAZIONI => CHIAMANTE: " + Configurazioni.getCaller());
            Thread.currentThread().setName("<<THREAD::MAIN>>");
            if (!classe_istanziata) {
                cartella_di_lavoro = System.getProperty("user.dir") + System.getProperty("file.separator");
                MyTrace.log.info("cartella_di_lavoro     = " + cartella_di_lavoro);
                Money.init(Currency.getInstance(Locale.ITALY), RoundingMode.HALF_UP);
                MyTrace.log.info("INIZIALIZZATO IL MONEY:      ITAY,HALF_UP");
                Quantita.init(2, RoundingMode.HALF_UP);
                MyTrace.log.info("INIZIALIZZATO IL QUANTITA':     2 decimali,HALF_UP");
                eccezione = new Eccezioni();
                new Risorse();
                conf_finestre = new ConfigurazioneFinestre();
                conf_ini = new ConfigurazioneIni();
                hm = ConfigurazioneIni.hm;
                righe_ricerca = ConfigurazioneIni.righe_ricerca;
                id_azienda = ConfigurazioneIni.id_azienda;
                inizio_stampe = ConfigurazioneIni.inizio_stampe;
                classe_istanziata = true;
                puntatore_istanza = this;
                MyTrace.log.info("CONFIGURAZIONI [ISTANZIATA]");
                this.preparaConnessioneDatabaseMaster();
                MyTrace.log.info("ISTANZIATO DB MASTER");
                this.connettiDatabaseMaster();
                MyTrace.log.info("DB MASTER [CONNESSO]****************************************************");
                modalit\u00e0ConsultazioneAttiva = new GestioneLicenze().verifica_validita_licenza(id_azienda);
                this.caricaDatabaseAziendaSelezionata();
                aliquota_predefinita = new Aliquota();
                String w = " where codice='" + ConfigurazioneIni.codice_aliquota_predefinito + "'";
                aliquota_predefinita.seleziona(w);
                MyTrace.log.info("PROFILO AZIENDA SELEZIONATA [CARICATO]");
            } else {
                MyTrace.log.severe("ERRORE DI PROGRAMMAZIONE (CLASSE Configurazioni istanziata pi\u00f9 volte)");
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE: NELLA CONFIGURAZIONE");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE:  NELLA CONFIGURAZIONE");
            err.printStackTrace();
        }
    }

    public static String getCaller() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        System.out.println(ste[2].getClassName() + ":" + ste[2].getMethodName());
        return "Classe chiamante = " + ste[2].getClassName() + "  Metodo Chiamante = " + ste[2].getMethodName();
    }

    private void preparaConnessioneDatabaseMaster() {
        if (classe_istanziata) {
            Connessione c;
            this.connessione_master = c = new Connessione(ConfigurazioneIni.hm.get("server"), ConfigurazioneIni.hm.get("dbName"), ConfigurazioneIni.hm.get("dbUser"), ConfigurazioneIni.hm.get("dbPass"), ConfigurazioneIni.hm.get("dbPorta"));
        } else {
            MyTrace.log.severe("ATTENZIONE uso anomalo della classe Configurazioni e metodo preparaConnessione() senza averla prima istanziato correttamente la classe Configurazioni");
        }
    }

    private void preparaConnessioneAziendaSelezionata() {
        if (classe_istanziata) {
            Connessione c;
            this.connessione = c = new Connessione(ConfigurazioneIni.hm.get("server"), azienda.getNomeDatabase(), ConfigurazioneIni.hm.get("dbUser"), ConfigurazioneIni.hm.get("dbPass"), ConfigurazioneIni.hm.get("dbPorta"));
        } else {
            MyTrace.log.severe("ATTENZIONE uso anomalo della classe Configurazioni e metodo preparaConnessione() senza averla prima istanziato correttamente la classe Configurazioni");
        }
    }

    public void connettiDatabaseMaster() {
        if (classe_istanziata) {
            if (this.connessione_master.connetti()) {
                MyTrace.log.info("Sono connesso al db MASTER      (TUTTO OK)");
            } else {
                MyTrace.log.severe("PROBLEMI DI CONNESSIONE AL DATABASE MASTER: predispongo l'uscita");
                JOptionPane.showMessageDialog(null, "CONNESSIONE con il SERVER del DATABASE \"" + Configurazioni.getIstanza().connessione_master.nomeUtente + "@" + Configurazioni.getIstanza().connessione_master.nomeDB + "@" + Configurazioni.getIstanza().connessione_master.server + "\" NON RIUSCITA!", "AVVISO DI SISTEMA", 2);
                this.main.uscita();
            }
        } else {
            MyTrace.log.severe("ATTENZIONE problemi al momento della connessione al DB Master");
        }
    }

    public void connettiDatabaseAzienda() {
        if (classe_istanziata) {
            if (Configurazioni.getIstanza().connessione.connetti()) {
                MyTrace.log.info("Sono connesso al db AZIENDA  [TUTTO OK]");
            } else {
                MyTrace.log.severe("PROBLEMI DI CONNESSIONE AL DATABASE AZIENDA: predispongo l'uscita");
                JOptionPane.showMessageDialog(null, "CONNESSIONE con il SERVER del DATABASE \"" + Configurazioni.getIstanza().connessione.nomeUtente + "@" + Configurazioni.getIstanza().connessione.nomeDB + "@" + Configurazioni.getIstanza().connessione.server + "\" NON RIUSCITA! " + "\n PROBABILE DATABASE NON CORRETTAMENTE CONFIGURATO   " + "\n CONTATTARE Kronos S.r.l. o il vostro rivenditore!   ", "AVVISO DI SISTEMA", 2);
                this.main.uscita();
            }
        } else {
            MyTrace.log.severe("ATTENZIONE problemi al momento della connessione al DB Master");
        }
    }

    public void caricaDatabaseAziendaSelezionata() {
        MyTrace.log.info("PREPARO L'AZIENDA");
        try {
            azienda = new Azienda();
            azienda.seleziona(id_azienda);
            nome_azienda = azienda.getRagione_sociale();
            if (this.connessione != null) {
                this.connessione.disconnetti();
                MyTrace.log.info("DISCONNESSO DATABASE " + this.connessione.nomeDB);
            } else {
                MyTrace.log.info("PRIMA ISTANZIAZIONE DATABASE AZIENDA = " + nome_azienda);
            }
            this.preparaConnessioneAziendaSelezionata();
            MyTrace.log.info("ISTANZIATO DB AZIENDA " + this.connessione.nomeDB);
            this.connettiDatabaseAzienda();
            MyTrace.log.info("DB AZIENDA CONNESSO AL DATABASE " + this.connessione.nomeDB);
            MyTrace.log.info("IMPOSTO IL SET di CARATTHERI DELLA CONNESSIONE");
            Configurazioni.getIstanza().connessione.eseguiAggiornamento("SET  NAMES 'utf8';SET  character_set_client     = 'latin1'; SET  character_set_connection = 'latin1'; SET  character_set_results    = 'utf8'; ");
            MyTrace.log.info("SET di CARATTERI DELLA CONNESSIONE IMPOSTATI a LATIN1");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE:  (NON CONNESSO AL DATABASE AZIENDA) configurazione o del config.ini o del database non corretta id=" + id_azienda);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE:  (NON CONNESSO AL DATABASE AZIENDA)  configurazione o del config.ini o del database non corretta id=" + id_azienda);
            err.printStackTrace();
        }
    }

    public void scriviConfigurazione() {
        conf_finestre.scriviConfigurazione();
        conf_ini.scriviConfigurazione();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.connessione.disconnetti();
            MyTrace.log.info("MyConfiguration: FINALIZZAZIONE PER USCITA (\u00e8 stata distrutta dal GC la classe Connessione!");
        }
        finally {
            super.finalize();
        }
    }

    public static Configurazioni getIstanza() {
        if (classe_istanziata) {
            return puntatore_istanza;
        }
        MyTrace.log.severe("ERRORE: Classe Configurazioni non ISTANZIATA!");
        return null;
    }

    static {
        classe_istanziata = false;
        datascadenza = Calendar.getInstance();
        modalit\u00e0ConsultazioneAttiva = false;
        size_diritti = 1;
        array_diritti = new String[]{"Configurazioni_Menu_Visualizza"};
    }
}

