/*
 * Decompiled with CFR 0.152.
 */
package gestionale.causali_contabili;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.iva.Aliquota;
import gestionale.piano_dei_conti.Conto5;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import utils.Funzioni;
import utils.MyTrace;

public class CausaleContabileIva {
    private int id;
    private int segno;
    private int id_cc;
    private int id_aliquota;
    private int id_conto;
    private Aliquota a;
    private Conto5 c;
    private Funzioni f = new Funzioni();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSegno() {
        return this.segno;
    }

    public void setSegno(int segno) {
        this.segno = segno;
    }

    public int getId_cc() {
        return this.id_cc;
    }

    public void setId_cc(int id_cc) {
        this.id_cc = id_cc;
    }

    public int getId_aliquota() {
        return this.id_aliquota;
    }

    public void setId_aliquota(int id_aliquota) {
        this.id_aliquota = id_aliquota;
        this.a = new Aliquota();
        if (id_aliquota != 0) {
            String w = "where idAliquota= " + id_aliquota + " ";
            this.a.seleziona(w);
        } else {
            this.a.setDescrizione("");
            this.a.setAliquota(0.0);
            this.a.setCodice("");
            this.a.setIndetraibilita(0.0);
        }
    }

    public Aliquota getA() {
        return this.a;
    }

    public int getId_conto() {
        return this.id_conto;
    }

    public void setId_conto(int id_conto) {
        this.id_conto = id_conto;
        this.c = new Conto5();
        if (id_conto != 0) {
            this.c.seleziona(id_conto);
        } else {
            this.c.setDescrizione("");
            this.c.setConto("");
        }
    }

    public Conto5 getC() {
        return this.c;
    }

    public void setC(Conto5 c) {
        this.c = c;
    }

    public boolean inserisci(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_ins = "INSERT INTO conf_cc_iva(id_aliquota,conto,segno,id_cc) VALUES ('" + this.getId_aliquota() + "', " + "'" + this.getC().getConto() + "','" + this.getSegno() + "','" + this.getId_cc() + "')";
        boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
        if (!r_start || !r_ins) {
            MyTrace.log.severe("Inserimento iva Causale Contabile non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM conf_cc_iva";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_cc_iva','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento  iva Causale Contabile non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento  iva Causale Contabile non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_mod = "UPDATE  conf_cc_iva  SET id_aliquota='" + this.getId_aliquota() + "'," + " conto='" + this.getC().getConto() + "', " + " segno='" + this.getSegno() + "'" + " WHERE idCCIva='" + this.getId() + "'";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_start || !r_mod) {
            MyTrace.log.severe("Modifica  iva Causale Contabile non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_cc_iva','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica  iva Causale Contabile non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica  iva Causale Contabile non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public void seleziona(int id) {
        String query_seleziona = "select * from conf_cc_iva where idCCIva='" + id + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                Conto5 c5 = new Conto5();
                c5.seleziona(res.getString("conto"));
                this.setC(c5);
                this.setId(res.getInt("id"));
                this.setId_cc(res.getInt("id_cc"));
                this.setId_aliquota(res.getInt("id_aliquota"));
                this.setSegno(res.getInt("segno"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona  iva Causale Contabile non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public boolean elimina() {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "delete from conf_cc_iva WHERE idCCIva='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina  iva Causale Contabile non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_cc_iva','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina  iva Causale Contabile non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        String q_commit = "COMMIT";
        boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
        if (r_commit) {
            return true;
        }
        MyTrace.log.severe("Elimina  iva Causale Contabile non riuscito per commit");
        Configurazioni.eccezione.gestisci("3.4", null);
        return false;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.a != null) {
                    retVal = this.a.getCodice();
                    break;
                }
                retVal = "";
                break;
            }
            case 1: {
                if (this.a != null) {
                    retVal = this.a.getDescrizione();
                    break;
                }
                retVal = "";
                break;
            }
            case 2: {
                if (this.c != null) {
                    retVal = this.c.getConto();
                    break;
                }
                retVal = "";
                break;
            }
            case 3: {
                if (this.c != null) {
                    retVal = this.c.getDescrizione();
                    break;
                }
                retVal = "";
                break;
            }
            case 4: {
                if (this.a != null) {
                    retVal = "" + Double.toString(this.a.getAliquota());
                    break;
                }
                retVal = "";
                break;
            }
            case 5: {
                if (this.a != null) {
                    retVal = "" + Double.toString(this.a.getIndetraibilita());
                    break;
                }
                retVal = "";
                break;
            }
            case 6: {
                retVal = this.f.string_segno(this.getSegno(), 0);
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

