/*
 * Decompiled with CFR 0.152.
 */
package gestionale.causali_contabili;

import gestionale.MyDesktopWindow;
import gestionale.causali_contabili.CausaleContabileIva;
import gestionale.causali_contabili.CausaleContabileRiga;
import gestionale.causali_contabili.InsiemeCCIva;
import gestionale.causali_contabili.InsiemeCCRighe;
import gestionale.causali_contabili.TipoModello;
import gestionale.configurazioni.Configurazioni;
import gestionale.iva.RegistriIVA;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Iterator;
import utils.Funzioni;
import utils.MyTrace;

public class CausaleContabile {
    private String codice = "";
    private String descrizione;
    private String riferimento;
    private String codice_conto_iva = "";
    private String tipo_causale;
    private int id;
    private int id_tipo_modello;
    private int id_registro_iva;
    private int editabile;
    private int id_conto_iva;
    private InsiemeCCIva insieme_iva;
    private InsiemeCCRighe insieme_righe;
    private RegistriIVA reg_iva;
    private Funzioni f = new Funzioni();
    private TipoModello tm = new TipoModello();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCodice() {
        return this.codice;
    }

    public void setCodice(String codice) {
        this.codice = codice;
    }

    public int getId_tipo_modello() {
        return this.id_tipo_modello;
    }

    public void setId_tipo_modello(int id_tipo_modello) {
        this.id_tipo_modello = id_tipo_modello;
    }

    public InsiemeCCIva getInsieme_iva() {
        return this.insieme_iva;
    }

    public void setInsieme_iva(InsiemeCCIva insieme_iva) {
        this.insieme_iva = insieme_iva;
    }

    public InsiemeCCRighe getInsieme_righe() {
        return this.insieme_righe;
    }

    public void setInsieme_righe(InsiemeCCRighe insieme_righe) {
        this.insieme_righe = insieme_righe;
    }

    public String getRiferimento() {
        return this.riferimento;
    }

    public void setRiferimento(String riferimento) {
        this.riferimento = riferimento;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public TipoModello getTm() {
        return this.tm;
    }

    public void setTm(TipoModello tm) {
        this.tm = tm;
    }

    public int getId_registro_iva() {
        return this.id_registro_iva;
    }

    public void setId_registro_iva(int id_registro_iva) {
        this.id_registro_iva = id_registro_iva;
    }

    public RegistriIVA getReg_iva() {
        return this.reg_iva;
    }

    public void setReg_iva(RegistriIVA reg_iva) {
        this.reg_iva = reg_iva;
    }

    public int getEditabile() {
        return this.editabile;
    }

    public void setEditabile(int editabile) {
        this.editabile = editabile;
    }

    public String getCodice_conto_iva() {
        return this.codice_conto_iva;
    }

    public void setCodice_conto_iva(String codice_conto_iva) {
        this.codice_conto_iva = codice_conto_iva;
    }

    public int getId_conto_iva() {
        return this.id_conto_iva;
    }

    public void setId_conto_iva(int id_conto_iva) {
        this.id_conto_iva = id_conto_iva;
    }

    public String getTipo_causale() {
        return this.tipo_causale;
    }

    public void setTipo_causale(String tipo_causale) {
        this.tipo_causale = tipo_causale;
    }

    public boolean inserisci(boolean da_fuori) {
        String q_trace;
        boolean r_trace;
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_ins = "INSERT INTO conf_causale_contabile(codice,descrizione,riferimento,id_modelli_cc,abilita,id_registro_iva,editabile,id_conto_iva) VALUES ('" + this.getCodice() + "','" + this.getDescrizione().replaceAll("'", "''") + "'," + "'" + this.getRiferimento() + "','" + this.getId_tipo_modello() + "','1'," + "" + this.f.zero_to_null(this.getId_registro_iva()) + ",1," + this.getId_conto_iva() + ")";
        boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
        if (!r_start || !r_ins) {
            MyTrace.log.severe("Inserimento conf_causale_contabile non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM conf_causale_contabile";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        if (this.getInsieme_iva() != null) {
            Iterator i = this.getInsieme_iva().vettoreCCIva.iterator();
            while (i.hasNext()) {
                CausaleContabileIva cc_i = new CausaleContabileIva();
                cc_i = (CausaleContabileIva)i.next();
                cc_i.setId_cc(this.getId());
                if (cc_i.getId_aliquota() == 0 && cc_i.getId_conto() == 0) continue;
                cc_i.inserisci(true);
            }
        }
        if (this.getInsieme_righe() != null) {
            Iterator ir = this.getInsieme_righe().vettoreCCRighe.iterator();
            while (ir.hasNext()) {
                CausaleContabileRiga cc_r = new CausaleContabileRiga();
                cc_r = (CausaleContabileRiga)ir.next();
                cc_r.setId_cc(this.getId());
                if (cc_r.getId_conto() == 0) continue;
                cc_r.inserisci(true);
            }
        }
        if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_causale_contabile','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')"))) {
            MyTrace.log.severe("Inserimento conf_causale_contabile non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento conf_causale_contabile non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_mod = "UPDATE conf_causale_contabile  SET codice='" + this.getCodice() + "'," + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "',  " + " riferimento='" + this.getRiferimento() + "', " + " id_modelli_cc='" + this.getId_tipo_modello() + "'," + " id_conto_iva='" + this.getId_conto_iva() + "'," + "id_registro_iva=" + this.f.zero_to_null(this.getId_registro_iva()) + "" + " WHERE idCausale_contabile='" + this.getId() + "'";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_start || !r_mod) {
            MyTrace.log.severe("Modifica causale_contabile non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        for (CausaleContabileIva s : this.getInsieme_iva().vettoreCCIva) {
            if (s.getId() == 0 && (s.getId_aliquota() != 0 || s.getId_conto() != 0)) {
                s.inserisci(true);
                continue;
            }
            if (s.getId_aliquota() != 0 || s.getId_conto() != 0) {
                s.modifica(true);
                continue;
            }
            s.elimina();
        }
        for (CausaleContabileRiga s : this.getInsieme_righe().vettoreCCRighe) {
            if (s.getId() == 0 && s.getId_conto() != 0) {
                s.inserisci(true);
                continue;
            }
            if (s.getId_conto() != 0) {
                s.modifica(true);
                continue;
            }
            s.elimina();
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_causali_contabili','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Causale Contabile non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica Causale Contabile non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public void seleziona(int id) {
        String query_seleziona = "select conf_causale_contabile.*,pc_conti_5.* from conf_causale_contabile LEFT JOIN pc_conti_5 ON conf_causale_contabile.id_conto_iva=pc_conti_5.idconto5  where idCausale_contabile='" + id + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setId(res.getInt("idCausale_contabile"));
                this.setCodice(res.getString("codice"));
                this.setDescrizione(res.getString("descrizione"));
                this.setRiferimento(res.getString("riferimento"));
                this.setId_tipo_modello(res.getInt("id_modelli_cc"));
                this.setId_registro_iva(res.getInt("id_registro_iva"));
                this.setEditabile(res.getInt("editabile"));
                this.setId_conto_iva(res.getInt("id_conto_iva"));
                this.setCodice_conto_iva(res.getString("cdconto"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Causale Contabile non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona(String codice) {
        String query_seleziona = "select conf_causale_contabile.*,pc_conti_5.* from conf_causale_contabile  LEFT JOIN pc_conti_5 ON conf_causale_contabile.id_conto_iva=pc_conti_5.idconto5  where codice='" + codice + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setId(res.getInt("idCausale_contabile"));
                this.setCodice(res.getString("codice"));
                this.setDescrizione(res.getString("descrizione"));
                this.setRiferimento(res.getString("riferimento"));
                this.setId_tipo_modello(res.getInt("id_modelli_cc"));
                this.setId_registro_iva(res.getInt("id_registro_iva"));
                this.setEditabile(res.getInt("editabile"));
                this.setId_conto_iva(res.getInt("id_conto_iva"));
                this.setCodice_conto_iva(res.getString("cdconto"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Causale Contabile non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_dettagli() {
        TipoModello tmlocal = new TipoModello();
        String w = " where conf_modello_causale_contabile.id=" + this.getId_tipo_modello() + "";
        tmlocal.seleziona(w);
        this.setTm(tmlocal);
        RegistriIVA ri = new RegistriIVA();
        ri.seleziona(this.getId_registro_iva());
        this.setReg_iva(ri);
        InsiemeCCIva i_iva = new InsiemeCCIva();
        i_iva.caricamento("SELECT * from conf_cc_iva WHERE id_cc='" + this.getId() + "'");
        this.setInsieme_iva(i_iva);
        InsiemeCCRighe i_r = new InsiemeCCRighe();
        i_r.caricamento("SELECT * FROM conf_cc_righe WHERE id_cc='" + this.getId() + "'");
        this.setInsieme_righe(i_r);
    }

    public boolean elimina(int id) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "UPDATE conf_causale_contabile SET abilita='0' WHERE idCausale_contabile='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina Causale Contabile non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_causale_contabile','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina Causale Contabile non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        String q_commit = "COMMIT";
        boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
        if (r_commit) {
            return true;
        }
        MyTrace.log.severe("Modifica Causale Contabile non riuscito per commit");
        Configurazioni.eccezione.gestisci("3.4", null);
        return false;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getCodice();
                break;
            }
            case 1: {
                retVal = "" + this.getDescrizione();
                break;
            }
            case 2: {
                retVal = "" + this.getTipo_causale();
                break;
            }
            case 3: {
                retVal = this.f.riferimento(this.getRiferimento());
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

