/*
 * Decompiled with CFR 0.152.
 */
package gestionale.backup;

import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import utils.File_getDimensione;
import utils.MySQLDump;
import utils.MyTrace;
import utils.ZipFile;

public class MyBackUpArchivi
extends JInternalFrame {
    String civetta_permessi;
    public static int size_diritti = 1;
    public static String[] array_diritti = new String[]{"Backup_Archivi_Visualizza"};
    private String nome_completo_file;
    private String cartella_di_backup;
    private JButton Pulsante_Backup;
    private JButton Pulsante_cambia_file;
    private JTextField file_per_backup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel label_esito;

    public MyBackUpArchivi() {
        this.initComponents();
        Date time = new Date();
        SimpleDateFormat formattazione = new SimpleDateFormat("yyyyMMddhhmmss_");
        String tempo_formattato = formattazione.format(time);
        this.cartella_di_backup = System.getProperty("user.dir") + System.getProperty("file.separator") + System.getProperty("file.separator");
        String nome_file = tempo_formattato + "database_" + Configurazioni.getIstanza().connessione.nomeDB;
        this.nome_completo_file = this.cartella_di_backup + nome_file + ".sql";
        this.file_per_backup.setText(this.nome_completo_file);
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(800, 380)));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.Pulsante_Backup = new JButton();
        this.label_esito = new JLabel();
        this.file_per_backup = new JTextField();
        this.Pulsante_cambia_file = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Esegue il Backup degli Archivi");
        this.setToolTipText("pigiare Salva per avviare il processo");
        this.setPreferredSize(new Dimension(626, 326));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyBackUpArchivi.this.finestra_spostata(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyBackUpArchivi.this.finestra_ridimensionata(evt);
            }
        });
        this.jLabel1.setFont(new Font("Verdana", 1, 12));
        this.jLabel1.setForeground(new Color(102, 0, 0));
        this.jLabel1.setText("Salvataggio Archivi");
        this.jLabel2.setFont(new Font("Verdana", 0, 11));
        this.jLabel2.setForeground(new Color(0, 0, 102));
        this.jLabel2.setText("<html>Cliccando sul pulsante \"Salva\" verr\u00e0 creato un file di backup degli archivi nel database.<br>L'ubicazione \u00e8 selezionabile a piacere.</html>");
        this.Pulsante_Backup.setFont(new Font("Verdana", 0, 11));
        this.Pulsante_Backup.setForeground(new Color(0, 0, 102));
        this.Pulsante_Backup.setText("Effettua il Backup");
        this.Pulsante_Backup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBackUpArchivi.this.Pulsante_BackupActionPerformed(evt);
            }
        });
        this.label_esito.setText("Esito:");
        this.file_per_backup.setText("jTextField1");
        this.Pulsante_cambia_file.setText("Cambia File");
        this.Pulsante_cambia_file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBackUpArchivi.this.Pulsante_cambia_fileActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(193, 193, 193).addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(125, 125, 125).addComponent(this.label_esito, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Pulsante_Backup)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, -1, -2).addGap(0, 61, Short.MAX_VALUE)).addComponent(this.file_per_backup))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.Pulsante_cambia_file, -2, 135, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2, -2, -1, -2).addGap(30, 30, 30).addComponent(this.file_per_backup, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.Pulsante_cambia_file).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 41, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.label_esito, -2, 25, -2).addGap(50, 50, 50)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.Pulsante_Backup).addGap(65, 65, 65)))));
        this.pack();
    }

    private void Pulsante_BackupActionPerformed(ActionEvent evt) {
        this.backup();
    }

    private void finestra_spostata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void Pulsante_cambia_fileActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(this.cartella_di_backup);
        fc.setApproveButtonText("Salva");
        File temp = new File(this.nome_completo_file);
        fc.setSelectedFile(temp);
        int returnVal = fc.showOpenDialog(this);
        File f = fc.getSelectedFile();
        MyTrace.log.info("FILE SCELTO =" + f.getAbsolutePath());
        this.nome_completo_file = f.getAbsolutePath();
        this.file_per_backup.setText(this.nome_completo_file);
    }

    private void backup() {
        MyTrace.log.info("BACKUP: START");
        MySQLDump mysqldump = new MySQLDump(Configurazioni.getIstanza().connessione);
        MyTrace.log.info("BACKUP: CREATA ISTANZA MYSQLDUMP");
        this.cancella_tabella_systrace(mysqldump);
        mysqldump.file_Open(this.nome_completo_file);
        mysqldump.Schema_dumpAll_CompletoConDati();
        mysqldump.file_Close();
        MyTrace.log.info("BACKUP: DUMP EFETTUATO");
        MyTrace.log.info("BACKUP: ORA COMPRIMO IL FILE DI DUMP");
        String nome_file_compresso = this.nome_completo_file + ".zip";
        ZipFile zf = new ZipFile(this.nome_completo_file, nome_file_compresso);
        MyTrace.log.info("BACKUP: FILE DI DUMP COMPRESSO");
        String dimensione_bck = new File_getDimensione(this.nome_completo_file).getDimensione();
        String dimensione_bck_zip = new File_getDimensione(nome_file_compresso).getDimensione();
        this.label_esito.setText("Esito: backup archivi effettuato: verificare sempre la coerenza! (file=" + dimensione_bck + "Mbyte, zip=" + dimensione_bck_zip + "Mbyte)");
        this.Pulsante_Backup.setEnabled(false);
        MyTrace.log.info("BACKUP: END");
    }

    private void cancella_tabella_systrace(MySQLDump istanza_mysqldump) {
        MyTrace.log.info("CANCELLO TABELLA 'sys_trace': START");
        istanza_mysqldump.truncate_table("sys_trace");
        MyTrace.log.info("CANCELLO TABELLA 'sys_trace': END");
    }
}

