/*
 * Decompiled with CFR 0.152.
 */
package gestionale.auth;

import gestionale.MyDesktopWindow;
import gestionale.auth.InsiemeOperatori;
import gestionale.auth.Operatore;
import gestionale.auth.OperatoriFixedModel;
import gestionale.auth.OperatoriTableModel;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import utils.Funzioni;
import utils.GenericTableRenderer;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.ToolTipHeader;

public class MyOperatori
extends JInternalFrame
implements ListSelectionListener {
    String civetta_permessi;
    public static int size_diritti = 2;
    public static String[] array_diritti = new String[]{"AUTH_Operatori_Visualizza", "AUTH_Operatori_Modifica"};
    JToolBar jToolBarMod;
    OperatoriTableModel otm;
    InsiemeOperatori insieme_o;
    JScrollPane scroll;
    JTable jTableOperatori;
    OperatoriFixedModel ofm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<OperatoriTableModel> sorter;
    RowFilter<OperatoriTableModel, Object> rf = null;
    ArrayList<RowFilter<OperatoriTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    Operatore o_selezione;
    Funzioni f = new Funzioni();
    long stato = 0L;
    float gamma = 0.0f;
    Timer show;
    Timer hide;
    private final int showMax = 600;
    private final int hideMax = 500;
    private final int showRate = 188;
    private final int hideRate = 188;
    JInternalFrame frame = this;
    private boolean visualizzata = false;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JComboBox jComboGruppi;
    private JLabel jLabelCognome;
    private JLabel jLabelGruppo;
    private JLabel jLabelNome;
    private JLabel jLabelPassword;
    private JLabel jLabelUsername;
    private JLabel jLabelVuota;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextCognome;
    private JTextField jTextNome;
    private JTextField jTextPassword;
    private JTextField jTextUsername;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyOperatori() {
        System.gc();
        if (!MyDesktopWindow.profilo.controllaPermesso("AUTH_Operatori_Visualizza")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.otm = new OperatoriTableModel();
        this.insieme_o = new InsiemeOperatori();
        this.jTableOperatori = new JTable(this.otm);
        this.jTableOperatori.setSelectionMode(0);
        this.sorter = new TableRowSorter<OperatoriTableModel>(this.otm);
        for (int i = 0; i < this.otm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.ofm = new OperatoriFixedModel();
        this.ofm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.ofm);
        this.fixedTable.setAutoResizeMode(4);
        this.initComponents();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(700, 500)));
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
    }

    @Override
    public void setVisible(boolean bol) {
        System.out.println("SetVisible=" + bol);
        this.show = new Timer(188, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Timer show event=" + MyOperatori.this.stato);
                if (MyOperatori.this.stato * 188L < 600L) {
                    ++MyOperatori.this.stato;
                    MyOperatori.this.gamma = (float)MyOperatori.this.stato * 188.0f / 600.0f;
                    MyOperatori.this.repaint();
                    System.out.println("StatoA=" + MyOperatori.this.stato + " G=" + MyOperatori.this.gamma);
                } else {
                    MyOperatori.this.show.stop();
                }
            }
        });
        this.hide = new Timer(188, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Timer hide event=" + MyOperatori.this.stato);
                if (MyOperatori.this.stato <= 1L) {
                    MyOperatori.this.dispose_ok();
                } else {
                    --MyOperatori.this.stato;
                    MyOperatori.this.gamma = (float)MyOperatori.this.stato * 188.0f / 500.0f;
                    MyOperatori.this.repaint();
                    System.out.println("StatoB=" + MyOperatori.this.stato + " G=" + MyOperatori.this.gamma);
                }
            }
        });
        if (bol) {
            System.out.println("TRUE");
            if (this.hide.isRunning()) {
                this.hide.stop();
            }
            if (!this.show.isRunning() && !this.visualizzata) {
                this.stato = 0L;
                this.visualizzata = true;
                this.show.start();
            }
            super.setVisible(bol);
        } else {
            System.out.println("FALSE");
            if (this.show.isRunning()) {
                this.show.stop();
            }
            if (!this.hide.isRunning() && this.visualizzata) {
                this.stato = 2L;
                this.visualizzata = false;
                this.hide.start();
            } else {
                super.setVisible(bol);
            }
        }
        System.out.println("FINE SetVisible=" + bol);
    }

    public void dispose_ok() {
        System.out.println("dispose_ok()");
        if (this.hide.isRunning()) {
            this.hide.stop();
        }
        super.dispose();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        this.gamma = (double)this.gamma > 0.9 ? 1.0f : this.gamma;
        g2.setComposite(AlphaComposite.getInstance(3, this.gamma));
        super.paint(g2);
        g2.dispose();
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("AUTH_Operatori_Modifica")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableOperatori){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableOperatori.setModel(this.otm);
        this.jTableOperatori.setAutoCreateRowSorter(true);
        this.jTableOperatori.setRowSorter(this.sorter);
        this.jTableOperatori.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        this.jTextNome.setEnabled(this.in_modifica);
        this.jTextCognome.setEnabled(this.in_modifica);
        this.jTextUsername.setEnabled(this.in_modifica);
        this.jTextPassword.setEnabled(this.in_modifica);
        this.jComboGruppi.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        ListSelectionModel listSelectionModel = this.jTableOperatori.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.jTableOperatori.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableOperatori.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumn = this.fixedTable.getColumnModel().getColumn(2);
        JComboBox comboBox = new JComboBox();
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] headerStr = new String[]{"Cognome", "Nome", "Gruppo"};
            String[] toolTipStr = new String[]{"Cognome", "Nome", "Gruppo"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableOperatori.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableOperatori.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query = "SELECT * FROM auth_operatori WHERE abilita='1' ORDER BY cognome ASC ";
        if (Configurazioni.righe_ricerca != 0) {
            query = query + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_o.caricamento(query);
        this.otm.setDataOperatori(this.insieme_o.vettoreOperatori);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_o.vettoreOperatori.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.o_selezione = new Operatore();
        this.o_selezione = (Operatore)this.insieme_o.vettoreOperatori.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextNome.setText(this.o_selezione.getNome());
        this.jTextCognome.setText(this.o_selezione.getCognome());
        this.jTextPassword.setText(this.o_selezione.getPassword());
        this.jTextUsername.setText(this.o_selezione.getPassword());
        this.jComboGruppi.setSelectedItem(this.f.nome_gruppo(this.o_selezione.getId_gruppo()));
    }

    private void costruisci() {
        this.o_selezione.setNome(this.jTextNome.getText());
        this.o_selezione.setCognome(this.jTextCognome.getText());
        this.o_selezione.setUsername(this.jTextUsername.getText());
        this.o_selezione.setPassword(this.jTextPassword.getText());
        this.o_selezione.setId_gruppo(this.f.id_gruppo(this.jComboGruppi.getSelectedItem().toString()));
    }

    private boolean check() {
        if (this.jTextNome.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il nome dell'operatore");
            return false;
        }
        if (this.jTextCognome.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il cognome dell'operatore");
            return false;
        }
        if (this.jTextUsername.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la username");
            return false;
        }
        if (this.jTextPassword.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire una password");
            return false;
        }
        if (this.jComboGruppi.getSelectedIndex() == 0) {
            JOptionPane.showMessageDialog(this, "Inserire il gruppo dell'operatore");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabelCognome = new JLabel();
        this.jTextCognome = new JTextField();
        this.jLabelNome = new JLabel();
        this.jTextNome = new JTextField();
        this.jLabelUsername = new JLabel();
        this.jTextUsername = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jTextPassword = new JTextField();
        this.jLabelGruppo = new JLabel();
        this.jComboGruppi = new JComboBox(this.f.crea_vettore_gruppi(1));
        this.jLabelVuota = new JLabel();
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Gestione Operatori \\ Operatori");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyOperatori.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyOperatori.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOperatori.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelCognome.setText("Cognome");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelCognome, gridBagConstraints);
        this.jTextCognome.setMinimumSize(new Dimension(200, 30));
        this.jTextCognome.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextCognome, gridBagConstraints);
        this.jLabelNome.setText("Nome");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelNome, gridBagConstraints);
        this.jTextNome.setMinimumSize(new Dimension(200, 30));
        this.jTextNome.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextNome, gridBagConstraints);
        this.jLabelUsername.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelUsername, gridBagConstraints);
        this.jTextUsername.setMinimumSize(new Dimension(200, 30));
        this.jTextUsername.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextUsername, gridBagConstraints);
        this.jLabelPassword.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelPassword, gridBagConstraints);
        this.jTextPassword.setMinimumSize(new Dimension(200, 30));
        this.jTextPassword.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextPassword, gridBagConstraints);
        this.jLabelGruppo.setText("Gruppo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelGruppo, gridBagConstraints);
        this.jComboGruppi.setMinimumSize(new Dimension(200, 30));
        this.jComboGruppi.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jComboGruppi, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel1, "Center");
        this.jPanel2.add((Component)this.jLabelVuota, "First");
        this.jPanelDettaglio.add((Component)this.jPanel2, "First");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                this.o_selezione.inserisci(false);
                this.in_new = false;
                this.in_modifica = false;
                this.filtra();
            }
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        } else {
            if (this.check()) {
                this.costruisci();
                this.o_selezione.modifica(false);
                this.in_modifica = false;
                this.filtra();
            }
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        this.in_modifica = false;
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableOperatori.getSelectionModel().clearSelection();
        this.o_selezione = new Operatore();
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(1);
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questo Gruppo?");
        if (res == 0) {
            this.o_selezione.elimina(res);
            this.in_modifica = false;
            this.filtra();
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.otm.getRowCount() != 0) {
            this.jTableOperatori.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableOperatori.getSelectedRow() > 0 && this.otm.getRowCount() != 0) {
            this.jTableOperatori.getSelectionModel().setSelectionInterval(this.jTableOperatori.getSelectedRow() - 1, this.jTableOperatori.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.otm.getRowCount() != 0) {
            this.jTableOperatori.getSelectionModel().setSelectionInterval(this.jTableOperatori.getSelectedRow() + 1, this.jTableOperatori.getSelectedRow() + 1);
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.otm.getRowCount() != 0) {
            this.jTableOperatori.getSelectionModel().setSelectionInterval(this.otm.getRowCount() - 1, this.otm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", ""};
            this.ofm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.ofm.deleteRow();
            this.ofm = new OperatoriFixedModel();
            this.fixedTable.setModel(this.ofm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", ""};
            this.ofm = new OperatoriFixedModel();
            this.fixedTable.setModel(this.ofm);
            this.ofm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.otm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void posizione_finestra(ComponentEvent evt) {
        System.out.println("component moved");
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        System.out.println("component resized");
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyOperatori().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableOperatori.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableOperatori.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.otm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<OperatoriTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyOperatori.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyOperatori.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyOperatori.this.rf = RowFilter.andFilter(MyOperatori.this.andFilters);
                MyOperatori.this.sorter.setRowFilter(MyOperatori.this.rf);
                MyOperatori.this.formatta();
            } else {
                String query = "SELECT * FROM auth_operatori WHERE abilita='1'";
                if (col == 0) {
                    query = query + " AND cognome LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    query = query + " AND nome LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND cognome LIKE '%" + this.tf.getText() + "%'";
                }
                query = query + " ORDER BY cognome ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyOperatori.this.insieme_o.caricamento(query);
                MyOperatori.this.otm.setDataOperatori(MyOperatori.this.insieme_o.vettoreOperatori);
                MyOperatori.this.formatta();
            }
        }
    }
}

