/*
 * Decompiled with CFR 0.152.
 */
package gestionale;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.ConfigurazioneIni;
import gestionale.configurazioni.Configurazioni;
import gestionale.login.MyLogin;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import utils.BannerAttesa;
import utils.Funzioni;
import utils.MyTrace;

public class Main {
    Configurazioni config;
    MyDesktopWindow mydesktopwindow;
    MyLogin login;

    public Main() {
        MyTrace.log.info("RICHIESTA ISTANZA CLASSE Main()");
        Thread.currentThread().setName("<<THREAD::MAIN:>>");
        try {
            MyTrace.log.info("CARICO LE CONFIGURAZIONI");
            System.out.println("CARICO LE CONFIGURAZIONI");
            this.config = new Configurazioni();
            System.out.println("CARICO CONFIGURAZIONI EFFETTUATO");
            MyTrace.log.info("CARICO CONFIGURAZIONI EFFETTUATO");
            MyTrace.log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info("OLIMPO versioneSoftware = " + Configurazioni.versioneSoftware);
            this.config.main = this;
            MyTrace.log.info("IMPOSTO Il LIVELLO DI TRACCIAMENTO");
            String livello = ConfigurazioneIni.hm.get("trace.level");
            MyTrace.setLivello_minimo_tracciato(livello);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione Main() errore di istanziazione della configurazione-connessione");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: Main() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
        try {
            MyTrace.log.info("AVVIO LA GRAFICA");
            this.config.desktopwindow = this.mydesktopwindow = new MyDesktopWindow(this);
            this.mydesktopwindow.main = this;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int h = screenSize.height - 30;
            this.mydesktopwindow.setSize(screenSize.width, h);
            this.mydesktopwindow.setLocation(0, 0);
            this.mydesktopwindow.setVisible(true);
            this.mydesktopwindow.setEnabled(false);
            this.mydesktopwindow.myDesktopPane.setDragMode(0);
            this.login = new MyLogin(this.mydesktopwindow);
            this.login.main = this;
            int wSize = 400;
            int hSize = 250;
            double hh = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            double ww = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            this.login.setSize(400, 250);
            this.login.setLocation((int)ww / 2 - wSize / 2, (int)hh / 2 - hSize / 2);
            this.login.setVisible(true);
            this.login.toFront();
            MyTrace.log.info("Main() AVVIO APPLICAZIONE AVVENUTO CORRETTAMENTE");
            MyTrace.log.info("CLASSE Main() ISTANZIATA ");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione Main() errore di istanziazione della GRAFICA");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: Main() errore di avvio o di linkaggio della GRAFICA");
            err.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Thread.currentThread().setName("<<THREAD::MAIN_STATIC:>>");
        new MyTrace();
        MyTrace.log.info("main START");
        DesertBlue tema = new DesertBlue();
        Plastic3DLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception ex) {
            MyTrace.log.severe("main() errore di configurazione del look and feel");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("main() errore di avvio o di linkaggio del LOOK and FEEL");
            err.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.mainOnEventDispatchThread();
            }
        });
        MyTrace.log.info("main END");
    }

    private static void mainOnEventDispatchThread() {
        MyTrace.log.info("ISTANZIO IL MAIN SUL THREAD DISPATCH DELLE CLASSI SWING");
        new Main();
    }

    public void uscita() {
        MyTrace.log.severe("MAIN --------------------- APPLICAZIONE IN CHIUSURA ------------------------------");
        try {
            this.login.logout();
            MyTrace.log.info("MAIN -logaout-ok-");
            if (Configurazioni.getIstanza().connessione != null) {
                Configurazioni.getIstanza().connessione.disconnetti();
            }
            MyTrace.log.info("MAIN -disconnessioneDB-ok-");
            Thread.sleep(500L);
            if (Configurazioni.getIstanza().connessione_master != null) {
                Configurazioni.getIstanza().connessione_master.disconnetti();
            }
            MyTrace.log.info("MAIN -disconnessioneDB-MASTER-ok-");
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            MyTrace.log.severe("ERRORE: Eccezione");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        MyTrace.log.info("MAIN BannerAttesa  attivazioni=" + BannerAttesa.attivazioni + "  disattivazioni=" + BannerAttesa.disattivazioni);
        MyTrace.log.severe("MAIN ----------------------- APPLICAZIONE TERMINATA ------------------------------");
        System.exit(0);
    }
}

