/*
 * Decompiled with CFR 0.152.
 */
package edilizia.commesse;

import controlling.regole.MyRegole;
import edilizia.commesse.EdilCommessa;
import edilizia.commesse.EdilCommesseFixedModel;
import edilizia.commesse.EdilCommesseTableModel;
import edilizia.commesse.InsiemeEdilCommesse;
import edilizia.commesse.MyStampaEdilCommesse;
import edilizia.gare.EdilCommesseGareRif;
import edilizia.gare.EdilCommesseRifTableModel;
import edilizia.gare.InsiemeEdilCommesseGareRif;
import edilizia.gare.MyGare;
import edilizia.rapportino.MyRapportino;
import gestionale.MyDesktopWindow;
import gestionale.commesse.Commessa;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import utils.ClientiFornitoriField;
import utils.DateField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TimeFormatter;

public final class MyEdilCommesse
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    EdilCommesseTableModel ctm;
    InsiemeEdilCommesse insieme_c;
    JScrollPane scroll;
    JTable jTableCommesse;
    EdilCommesseFixedModel cfm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<EdilCommesseTableModel> sorter;
    RowFilter<EdilCommesseTableModel, Object> rf = null;
    ArrayList<RowFilter<EdilCommesseTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    public EdilCommessa c_selezione;
    Funzioni f = new Funzioni();
    public JInternalFrame chiamante;
    public int row_chiamante;
    public boolean f_centri_r = false;
    public ClientiFornitoriField jTextCommittente;
    DateField data_apertura;
    FunzioniDate fda = new FunzioniDate();
    public EdilCommesseRifTableModel rctm;
    int riga_sel = 1000;
    public boolean f_c_open = false;
    private JButton JButtonEliminaRif;
    private JButton jButtonAddRif;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelCF;
    private JLabel jLabelCF1;
    private JLabel jLabelCF2;
    private JLabel jLabelDescCliente2;
    private JLabel jLabelDescCommittente;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JPanel jPanelPersonale;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane5;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    public JTable jTableRifCommesse;
    private JTextField jTexCIG;
    private JTextField jTexDescrizione_breve;
    private JTextField jTextAnno;
    private JTextField jTextCup;
    private JTextArea jTextDescrizione;
    private JTextArea jTextNote;
    private JTextField jTextNumeroCommessa;
    private JToolBar jToolBar1;
    private JToolBar jToolBar3;
    private JPanel p;

    public MyEdilCommesse() {
        if (!MyDesktopWindow.profilo.controllaPermesso("Commesse_Visualizza")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.ctm = new EdilCommesseTableModel();
        this.insieme_c = new InsiemeEdilCommesse();
        this.jTableCommesse = new JTable(this.ctm);
        this.jTableCommesse.setSelectionMode(0);
        for (int i = 0; i < this.ctm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.sorter = new TableRowSorter<EdilCommesseTableModel>(this.ctm);
        this.cfm = new EdilCommesseFixedModel();
        this.cfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.cfm);
        this.fixedTable.setAutoResizeMode(4);
        this.rctm = new EdilCommesseRifTableModel();
        this.addInternalFrameListener(this);
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.data_apertura = new DateFieldLocal(new TimeFormatter());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.data_apertura, gridBagConstraints);
        this.jTextCommittente = new ClientiFornitoriFieldLocal(this, "C");
        this.jTextCommittente.setPreferredSize(new Dimension(100, 27));
        this.jTextCommittente.tipo = "C";
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextCommittente, gridBagConstraints);
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableCommesse.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(660, 300)));
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("Commesse_Modifica")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableCommesse){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableCommesse.setModel(this.ctm);
        this.jTableCommesse.setAutoCreateRowSorter(true);
        this.jTableCommesse.setRowSorter(this.sorter);
        this.jTableCommesse.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        try {
            this.jTextCommittente.setEnabled(this.in_modifica);
            this.data_apertura.setEnabled(this.in_modifica);
            this.jTexDescrizione_breve.setEnabled(this.in_modifica);
            this.jTextNote.setEnabled(this.in_modifica);
            this.jTextDescrizione.setEnabled(this.in_modifica);
            this.jTexCIG.setEnabled(this.in_modifica);
            this.jTextCup.setEnabled(this.in_modifica);
            this.jTableRifCommesse.setEnabled(this.in_modifica);
            this.jButtonAddRif.setEnabled(this.in_modifica);
            this.JButtonEliminaRif.setEnabled(this.in_modifica);
            if (this.in_modifica) {
                this.getContentPane().remove(this.jToolBar1);
                this.getContentPane().add((Component)this.jToolBarMod, "North");
                this.jTabbedPane1.setEnabledAt(0, false);
            } else {
                this.getContentPane().remove(this.jToolBarMod);
                this.getContentPane().add((Component)this.jToolBar1, "North");
                this.jTabbedPane1.setEnabledAt(0, true);
            }
            this.getContentPane().validate();
            this.getContentPane().repaint();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyRegole.visualizzazione() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void formatta() {
        try {
            this.jTableCommesse.setDefaultRenderer(Object.class, new GenericTableRenderer());
            this.fixedTable.setRowHeight(30);
            this.fixedTable.setDefaultEditor(String.class, new TextEditor());
            this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            this.jTableCommesse.addMouseListener(this);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyRegole.formatta() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void filtra() {
        this.insieme_c = new InsiemeEdilCommesse();
        try {
            String w = " ";
            String order_by = " ORDER BY commesse.anno DESC, commesse.numero_commessa DESC ";
            if (Configurazioni.righe_ricerca != 0) {
                order_by = order_by + " LIMIT 0," + Configurazioni.righe_ricerca;
            }
            this.insieme_c.caricamento(w, order_by);
            this.ctm.setDataCommesse(this.insieme_c.vettoreCommesse);
            if (Configurazioni.righe_ricerca != 0 && this.insieme_c.vettoreCommesse.size() >= Configurazioni.righe_ricerca) {
                this.non_tutte_le_righe = true;
            }
            this.formatta();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCommesse.filtra() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void seleziona(int row) {
        try {
            this.c_selezione = new EdilCommessa();
            this.c_selezione = this.insieme_c.vettoreCommesse.get(row);
            this.c_selezione.seleziona_dettagli();
            this.riempi_campi();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyRegole.seleziona() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void riempi_campi() {
        try {
            this.jTextNumeroCommessa.setText("" + this.c_selezione.getCommessa_wrapper().getNumero());
            this.jTextAnno.setText("" + this.c_selezione.getCommessa_wrapper().getAnno());
            this.data_apertura.setText(this.c_selezione.getCommessa_wrapper().getData_apertura_it());
            this.jTexDescrizione_breve.setText(this.c_selezione.getCommessa_wrapper().getDescrizione_breve());
            this.jTextDescrizione.setText(this.c_selezione.getCommessa_wrapper().getDescrizione());
            this.jTextCommittente.setText(this.c_selezione.getCommessa_wrapper().getCodice_cliente());
            this.jLabelDescCommittente.setText(this.c_selezione.getCommessa_wrapper().getCommittente());
            this.jTexCIG.setText(this.c_selezione.getCodice_cig());
            this.jTextCup.setText(this.c_selezione.getCodice_cup());
            this.rctm = new EdilCommesseRifTableModel();
            this.rctm.setDataCommesse(this.c_selezione.getInsieme_rif().vettoreRif);
            this.jTableRifCommesse.setModel(this.rctm);
            this.formatta_dettagli();
            this.visualizzazione();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyRegole.riempi_campi() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void azzera() {
        try {
            this.jTextNumeroCommessa.setText("");
            this.jTextAnno.setText("");
            this.data_apertura.setText(this.fda.dataCorrenteIt());
            this.jTexDescrizione_breve.setText("");
            this.jTextDescrizione.setText("");
            this.jTextCommittente.setText("");
            this.jLabelDescCommittente.setText("** Non Definito **");
            this.jTexCIG.setText("");
            this.jTextCup.setText("");
            this.rctm = new EdilCommesseRifTableModel();
            this.jTableRifCommesse.setModel(this.rctm);
            this.visualizzazione();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyRegole.azzera() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void stop_edit() {
        if (this.jTableRifCommesse.getCellEditor() != null) {
            this.jTableRifCommesse.getCellEditor().stopCellEditing();
        }
    }

    public void formatta_dettagli() {
        this.jTableRifCommesse.setRowHeight(27);
        ListSelectionModel listSelectionModel3 = this.jTableRifCommesse.getSelectionModel();
        listSelectionModel3.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row;
                MyEdilCommesse.this.riga_sel = row = MyEdilCommesse.this.jTableRifCommesse.getSelectedRow();
            }
        });
    }

    private void costruisci() {
        if (this.c_selezione.getCommessa_wrapper() == null) {
            this.c_selezione.setCommessa_wrapper(new Commessa());
        }
        this.c_selezione.getCommessa_wrapper().setNumero(Integer.valueOf(this.jTextNumeroCommessa.getText()));
        this.c_selezione.getCommessa_wrapper().setData_apertura(this.fda.gira_data(this.data_apertura.getText()));
        this.c_selezione.getCommessa_wrapper().setAnno(Integer.valueOf(this.jTextAnno.getText()));
        this.c_selezione.getCommessa_wrapper().setDescrizione(this.jTextDescrizione.getText());
        this.c_selezione.getCommessa_wrapper().setDescrizione_breve(this.jTexDescrizione_breve.getText());
        this.c_selezione.getCommessa_wrapper().setNote(this.jTextNote.getText());
        this.c_selezione.getCommessa_wrapper().setId_anagrafica(this.f.id_anagrafica_da_codice(this.jTextCommittente.getText(), "C"));
        this.c_selezione.setCodice_cig(this.jTexCIG.getText());
        this.c_selezione.setCodice_cup(this.jTextCup.getText());
    }

    public void aggiornamento() {
        MyTrace.log.info("Aggiornamento() START ");
        if (this.data_apertura.getText().equals("") || this.data_apertura.getText().equals("  -  -    ")) {
            this.data_apertura.setText(this.fda.dataCorrenteIt());
        }
        String anno = this.fda.anno(this.fda.gira_data(this.data_apertura.getText()));
        int num = this.f.ultima_commessa(Integer.parseInt(anno)) + 1;
        MyTrace.log.info("DATI: registrazione  num_prot=" + num + "  anno_corrente=" + anno + "data_corrente=" + this.data_apertura.getText());
        if (!this.jTextAnno.getText().equals(anno)) {
            MyTrace.log.info("E'cambiato l'anno registrazione");
            boolean ok = true;
            if (this.jTextAnno.getText().equals("") || this.jTextNumeroCommessa.getText().equals("")) {
                MyTrace.log.info("Prima era nullo => posso settare il nuovo numero di registrazione");
                ok = true;
            } else {
                MyTrace.log.info("Controllo se era l'ultima registrazione per quell'anno");
                int ultima_registrazione_fatta = this.f.ultima_commessa(Integer.parseInt(this.jTextAnno.getText()));
                int num_old = Integer.parseInt(this.jTextNumeroCommessa.getText());
                MyTrace.log.info("ultima_registrazione_fatta_nell'anno=" + ultima_registrazione_fatta + "   numero di registrazione=" + this.jTextNumeroCommessa.getText());
                if (num_old >= ultima_registrazione_fatta) {
                    MyTrace.log.info("Era l'ultima registrazione per quell'anno  => posso settare il nuovo n um,ero di registrazione ");
                    ok = true;
                } else {
                    MyTrace.log.info("NON era l'ultima registrazione per quell'anno  => NON posso settare il nuovo n um,ero di registrazione ");
                    ok = false;
                }
            }
            if (ok) {
                this.jTextNumeroCommessa.setText("" + num);
                this.jTextAnno.setText(anno);
            }
        }
        MyTrace.log.info("Aggiornamento() END ");
    }

    private boolean check() {
        if (this.jTextNumeroCommessa.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "N COMMESSA NULLO!");
            return false;
        }
        if (this.jTextAnno.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "ANNO PROT NULLO!");
            return false;
        }
        if (this.jTexDescrizione_breve.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "descrizione breve NULLO!");
            return false;
        }
        if (this.jTextCommittente.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Cliente / Fornitore");
            return false;
        }
        if (this.data_apertura.isEnabled() && (this.data_apertura.getText().equals("00-00-0000") || this.data_apertura.getText().equals("  -  -    "))) {
            JOptionPane.showMessageDialog(this, "Inserire data ");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabelDescCliente2 = new JLabel();
        this.jTextNumeroCommessa = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextAnno = new JTextField();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextNote = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextDescrizione = new JTextArea();
        this.jLabelCF = new JLabel();
        this.jTexDescrizione_breve = new JTextField();
        this.jLabelCF2 = new JLabel();
        this.jTexCIG = new JTextField();
        this.jTextCup = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabelCF1 = new JLabel();
        this.jLabelDescCommittente = new JLabel();
        this.jPanelPersonale = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTableRifCommesse = new JTable(this.rctm);
        this.jToolBar3 = new JToolBar();
        this.jButtonAddRif = new JButton();
        this.JButtonEliminaRif = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Edilizia / Commesse");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyEdilCommesse.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyEdilCommesse.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setEnabled(false);
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setText("Data Apertura");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabelDescCliente2.setFont(new Font("Tahoma", 1, 11));
        this.jLabelDescCliente2.setText("Commessa n\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelDescCliente2, gridBagConstraints);
        this.jTextNumeroCommessa.setEditable(false);
        this.jTextNumeroCommessa.setEnabled(false);
        this.jTextNumeroCommessa.setMaximumSize(new Dimension(80, 30));
        this.jTextNumeroCommessa.setMinimumSize(new Dimension(60, 27));
        this.jTextNumeroCommessa.setPreferredSize(new Dimension(60, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextNumeroCommessa, gridBagConstraints);
        this.jLabel3.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextAnno.setEditable(false);
        this.jTextAnno.setEnabled(false);
        this.jTextAnno.setMaximumSize(new Dimension(80, 30));
        this.jTextAnno.setMinimumSize(new Dimension(60, 27));
        this.jTextAnno.setPreferredSize(new Dimension(60, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel3.add((Component)this.jTextAnno, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel3, "North");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jTextNote.setColumns(20);
        this.jTextNote.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextNote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabel4.setText("Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 7);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel1.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextDescrizione.setColumns(20);
        this.jTextDescrizione.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextDescrizione);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabelCF.setText("Descrizione Breve");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelCF, gridBagConstraints);
        this.jTexDescrizione_breve.setMinimumSize(new Dimension(200, 30));
        this.jTexDescrizione_breve.setPreferredSize(new Dimension(350, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel1.add((Component)this.jTexDescrizione_breve, gridBagConstraints);
        this.jLabelCF2.setText("Codice CIG");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelCF2, gridBagConstraints);
        this.jTexCIG.setMinimumSize(new Dimension(100, 270));
        this.jTexCIG.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel1.add((Component)this.jTexCIG, gridBagConstraints);
        this.jTextCup.setMinimumSize(new Dimension(100, 27));
        this.jTextCup.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextCup, gridBagConstraints);
        this.jLabel5.setText("Cup");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabelCF1.setText("Committente");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelCF1, gridBagConstraints);
        this.jLabelDescCommittente.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelDescCommittente, gridBagConstraints);
        this.jTabbedPane2.addTab("Generale", this.jPanel1);
        this.jPanelPersonale.setLayout(new BorderLayout());
        this.jTableRifCommesse.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane5.setViewportView(this.jTableRifCommesse);
        this.jPanelPersonale.add((Component)this.jScrollPane5, "Center");
        this.jToolBar3.setRollover(true);
        this.jButtonAddRif.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddRif.setText("Aggiungi Riga");
        this.jButtonAddRif.setFocusable(false);
        this.jButtonAddRif.setHorizontalAlignment(11);
        this.jButtonAddRif.setVerticalTextPosition(3);
        this.jButtonAddRif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.jButtonAddRifActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonAddRif);
        this.JButtonEliminaRif.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-remove.png")));
        this.JButtonEliminaRif.setText("Elimina riga Selezionata");
        this.JButtonEliminaRif.setFocusable(false);
        this.JButtonEliminaRif.setVerticalTextPosition(3);
        this.JButtonEliminaRif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyEdilCommesse.this.JButtonEliminaRifActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.JButtonEliminaRif);
        this.jPanelPersonale.add((Component)this.jToolBar3, "North");
        this.jTabbedPane2.addTab("Gare Collegate", this.jPanelPersonale);
        this.jPanelDettaglio.add((Component)this.jTabbedPane2, "Center");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.c_selezione.inserisci(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.c_selezione.modifica(true);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableCommesse.getSelectionModel().clearSelection();
        this.c_selezione = new EdilCommessa();
        this.azzera();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.ctm.getRowCount() != 0) {
            this.jTableCommesse.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableCommesse.getSelectedRow() > 0 && this.ctm.getRowCount() != 0) {
            this.jTableCommesse.getSelectionModel().setSelectionInterval(this.jTableCommesse.getSelectedRow() - 1, this.jTableCommesse.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.ctm.getRowCount() != 0) {
            this.jTableCommesse.getSelectionModel().setSelectionInterval(this.jTableCommesse.getSelectedRow() + 1, this.jTableCommesse.getSelectedRow() + 1);
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.ctm.getRowCount() != 0) {
            this.jTableCommesse.getSelectionModel().setSelectionInterval(this.ctm.getRowCount() - 1, this.ctm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", "", "", ""};
            this.cfm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.cfm.deleteRow();
            this.cfm = new EdilCommesseFixedModel();
            this.fixedTable.setModel(this.cfm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", "", "", ""};
            this.cfm = new EdilCommesseFixedModel();
            this.fixedTable.setModel(this.cfm);
            this.cfm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.ctm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        MyStampaEdilCommesse oggetto = new MyStampaEdilCommesse();
        this.getDesktopPane().add(oggetto);
        oggetto.setVisible(true);
        oggetto.moveToFront();
    }

    private void jButtonAddRifActionPerformed(ActionEvent evt) {
        this.stop_edit();
        if (this.c_selezione.getInsieme_rif() == null || this.c_selezione.getInsieme_rif().vettoreRif.isEmpty()) {
            this.c_selezione.setInsieme_rif(new InsiemeEdilCommesseGareRif());
        }
        if (!this.f_c_open) {
            MyGare oggetto = new MyGare();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_c_open = true;
        }
    }

    private void JButtonEliminaRifActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare la riga numero" + this.riga_sel + " selezionata?");
        if (res == 0) {
            EdilCommesseGareRif rif_sel = this.c_selezione.getInsieme_rif().vettoreRif.get(this.riga_sel);
            if (this.c_selezione.getInsieme_rif_da_el() == null) {
                this.c_selezione.setInsieme_rif_da_el(new InsiemeEdilCommesseGareRif());
            }
            this.c_selezione.getInsieme_rif_da_el().vettoreRif.add(rif_sel);
            this.c_selezione.getInsieme_rif().vettoreRif.remove(rif_sel);
            this.rctm.setDataCommesse(this.c_selezione.getInsieme_rif().vettoreRif);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyRegole().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableCommesse.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableCommesse.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.ctm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableCommesse.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.ctm.getRowCount() - 1 && modelRow >= 0) {
                EdilCommessa a = this.insieme_c.vettoreCommesse.get(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyRapportino.class && ((MyRapportino)this.chiamante).f_commesse_open) {
                        ((MyRapportino)this.chiamante).jTextCommessa.setText(a.getCommessa_wrapper().getNumero() + "/" + a.getCommessa_wrapper().getAnno());
                        ((MyRapportino)this.chiamante).jLabelDescrizioneCommessa.setText(a.getCommessa_wrapper().getDescrizione_breve());
                        ((MyRapportino)this.chiamante).f_commesse_open = false;
                    }
                    if (this.chiamante.getClass() == MyGare.class && ((MyGare)this.chiamante).f_c_open) {
                        ((MyGare)this.chiamante).jTextCommessa.setText(a.getCommessa_wrapper().getNumero() + "/" + a.getCommessa_wrapper().getAnno());
                        ((MyGare)this.chiamante).jLabelDescrizioneCommessa.setText(a.getCommessa_wrapper().getDescrizione_breve());
                        ((MyGare)this.chiamante).f_c_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyRapportino.class && ((MyRapportino)this.chiamante).f_commesse_open) {
                ((MyRapportino)this.chiamante).f_commesse_open = false;
            }
            if (this.chiamante.getClass() == MyGare.class && ((MyGare)this.chiamante).f_c_open) {
                ((MyGare)this.chiamante).f_c_open = false;
            }
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    class DateFieldLocal
    extends DateField {
        public DateFieldLocal(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
        }

        @Override
        public void focusLost(FocusEvent e) {
            MyEdilCommesse.this.aggiornamento();
        }
    }

    class ClientiFornitoriFieldLocal
    extends ClientiFornitoriField {
        public ClientiFornitoriFieldLocal(JInternalFrame frame, String t) {
            super(frame, t);
        }

        @Override
        public void focusLost(FocusEvent evt) {
            this.completaAutomaticamente();
            this.getAnagrafica().seleziona_dettagli();
            if (this.getAnagrafica().getIdanag() != 0) {
                if (MyEdilCommesse.this.c_selezione.getCommessa_wrapper() == null) {
                    MyEdilCommesse.this.c_selezione.setCommessa_wrapper(new Commessa());
                }
                MyEdilCommesse.this.c_selezione.getCommessa_wrapper().setId_anagrafica(this.getAnagrafica().getIdanag());
                MyEdilCommesse.this.jLabelDescCommittente.setText(this.getAnagrafica().getRagione_sociale());
            }
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<EdilCommesseTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            MyEdilCommesse.this.c_selezione = new EdilCommessa();
            if (!MyEdilCommesse.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyEdilCommesse.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyEdilCommesse.this.rf = RowFilter.andFilter(MyEdilCommesse.this.andFilters);
                MyEdilCommesse.this.sorter.setRowFilter(MyEdilCommesse.this.rf);
                MyEdilCommesse.this.formatta();
            } else {
                String query = " WHERE 1 ";
                if (col == 0) {
                    query = query + " AND descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                String order_by = " LIMIT 0," + Configurazioni.righe_ricerca;
                MyEdilCommesse.this.insieme_c.caricamento(query, order_by);
                MyEdilCommesse.this.ctm.setDataCommesse(MyEdilCommesse.this.insieme_c.vettoreCommesse);
                MyEdilCommesse.this.formatta();
            }
        }
    }
}

