/*
 * Decompiled with CFR 0.152.
 */
package controlling.regole;

import controlling.centri_di_responsabilita.CentroDiResponsabilita;
import controlling.centri_di_responsabilita.InsiemeCentriDiResponsabilita;
import controlling.regole_operative.InsiemeRegoleOperative;
import controlling.regole_operative.RegolaOperativa;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import utils.Funzioni;
import utils.MyTrace;

public class Regola {
    private String nome;
    private int id_regola;
    private int totale;
    private int km_percorsi_tot;
    private Funzioni f = new Funzioni();
    private InsiemeRegoleOperative insieme_ro;

    public String getNome() {
        return this.nome;
    }

    public void setNome(String descrizione_regola) {
        this.nome = descrizione_regola;
    }

    public int getId_regola() {
        return this.id_regola;
    }

    public void setId_regola(int id_regola) {
        this.id_regola = id_regola;
    }

    public int getTotale() {
        return this.totale;
    }

    public void setTotale(int totale) {
        this.totale = totale;
    }

    public int getKm_percorsi_tot() {
        return this.km_percorsi_tot;
    }

    public void setKm_percorsi_tot(int km_percorsi_tot) {
        this.km_percorsi_tot = km_percorsi_tot;
    }

    public InsiemeRegoleOperative getInsieme_ro() {
        return this.insieme_ro;
    }

    public void setInsieme_ro(InsiemeRegoleOperative insieme_ro) {
        this.insieme_ro = insieme_ro;
    }

    public boolean iinserisci(boolean da_solo) {
        try {
            String query_ins;
            boolean r_ins;
            if (da_solo) {
                String q_start = "START TRANSACTION;";
                boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
            }
            if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO ctrl_regole (nome,totale) VALUES ('" + this.getNome() + "','" + this.getTotale() + "')"))) {
                String q_commit = "ROLLBACK";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                MyTrace.log.severe("Inserimento Regola non riuscita");
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            String strSQL = "SELECT @@identity FROM ctrl_regole";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
            int id_inserito = 0;
            try {
                while (res.next()) {
                    id_inserito = res.getInt("@@identity");
                }
            }
            catch (Exception e) {
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                e.printStackTrace();
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            this.setId_regola(id_inserito);
            boolean resRO = true;
            if (this.getInsieme_ro() != null && !this.getInsieme_ro().vettoreRegoleOperative.isEmpty()) {
                for (RegolaOperativa ro : this.getInsieme_ro().vettoreRegoleOperative) {
                    ro.setId_regole(this.getId_regola());
                    resRO = ro.iinserisci(false);
                }
            }
            if (!resRO) {
                String q_commit = "ROLLBACK";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                MyTrace.log.severe("Inserimento  non riuscito per RegoleOperative");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','ctrl_regole','" + this.getId_regola() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                String q_commit = "ROLLBACK";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                MyTrace.log.severe("Inserimento  non riuscito per trace");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (da_solo) {
                String q_commit = "COMMIT";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                if (r_commit) {
                    return true;
                }
                MyTrace.log.severe("Inserimento Regola non riuscito per commit");
                Configurazioni.eccezione.gestisci("2.4", null);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Regola.inserisci() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean mmodifica(boolean da_solo) {
        try {
            String query_mod;
            boolean r_mod;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE ctrl_regole SET nome='" + this.getNome() + "', " + " totale='" + this.getTotale() + "' " + " WHERE idregole='" + this.getId_regola() + "'"))) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Modifica Regola non riuscita");
                Configurazioni.eccezione.gestisci("3.2", null);
                return false;
            }
            boolean resRO = true;
            if (this.getInsieme_ro() != null && !this.getInsieme_ro().vettoreRegoleOperative.isEmpty()) {
                for (RegolaOperativa ro : this.getInsieme_ro().vettoreRegoleOperative) {
                    ro.setId_regole(this.getId_regola());
                    if (ro.getIdregole_operative() == 0) {
                        resRO = ro.iinserisci(false);
                        continue;
                    }
                    resRO = ro.mmodifica(false);
                }
            }
            if (!resRO) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento  non riuscito per RegoleOperative");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','ctrl_regole','" + this.getId_regola() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Modifica Regola non riuscita per trace");
                Configurazioni.eccezione.gestisci("3.3", null);
                return false;
            }
            if (da_solo) {
                String q_commit = "COMMIT";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                if (r_commit) {
                    return true;
                }
                MyTrace.log.severe("Modifica Regola non riuscito per commit");
                Configurazioni.eccezione.gestisci("3.4", null);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Regola.modifica() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public void seleziona(String where) {
        try {
            String query_seleziona = "select * from ctrl_regole ";
            query_seleziona = query_seleziona + " " + where;
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
            try {
                ResultSetMetaData meta = res.getMetaData();
                while (res.next()) {
                    this.setId_regola(res.getInt("idregole"));
                    this.setNome(res.getString("nome"));
                    this.setTotale(res.getInt("totale"));
                }
            }
            catch (Exception e) {
                MyTrace.log.severe("Seleziona Regola non riuscito ");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                Configurazioni.eccezione.gestisci("4.1", null);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Regola.seleziona() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void seleziona_regola_0() {
        try {
            this.setId_regola(0);
            this.setNome("REGOLA ZERO");
            this.setInsieme_ro(new InsiemeRegoleOperative());
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Regola.seleziona_regola_0() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void seleziona_dettagli() {
        try {
            this.setInsieme_ro(new InsiemeRegoleOperative());
            if (this.getId_regola() != 0) {
                String where = " WHERE id_regole= " + this.getId_regola();
                this.getInsieme_ro().caricamento(where, "");
            } else {
                InsiemeCentriDiResponsabilita insieme_cdr = new InsiemeCentriDiResponsabilita();
                String where = " WHERE ctrl_centri_di_responsabilita.attivo=1 AND ctrl_centri_di_responsabilita.padre=0 ";
                insieme_cdr.caricamento(where, "");
                for (CentroDiResponsabilita cdr : insieme_cdr.vettoreCentriDiResponsabilita) {
                    RegolaOperativa ro = new RegolaOperativa();
                    ro.setId_regole(0);
                    ro.setId_centri_di_responsabilita(cdr.getIdcentri_di_responsabilita());
                    ro.setQuota(10);
                    this.setTotale(this.getTotale() + 10);
                    this.getInsieme_ro().vettoreRegoleOperative.add(ro);
                }
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Regola.seleziona_dettagli() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public boolean elimina(int id) {
        try {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
            String query_del = "UPDATE ctrl_regole SET abilita = 0 WHERE idregole='" + this.getId_regola() + "'";
            boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
            this.elimina_righe(false);
            if (!r_start || !r_del) {
                MyTrace.log.severe("Elimina Regola non riuscita");
                Configurazioni.eccezione.gestisci("3.5", null);
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','ctrl_regole','" + this.getId_regola() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Elimina Regola non riuscita per trace");
                Configurazioni.eccezione.gestisci("3.6", null);
                return false;
            }
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica Regola non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Regola.elimina() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean elimina_righe(boolean da_solo) {
        try {
            for (RegolaOperativa ro : this.getInsieme_ro().vettoreRegoleOperative) {
                ro.setId_regole(this.getId_regola());
                ro.elimina(da_solo);
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Regola.elimina_righe() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean costruisci_regola_diretta(int id_cdr, String nome_cdr) {
        this.setTotale(100);
        this.setNome(nome_cdr);
        this.setInsieme_ro(new InsiemeRegoleOperative());
        RegolaOperativa ro = new RegolaOperativa();
        ro.setCdr(nome_cdr);
        ro.setId_centri_di_responsabilita(id_cdr);
        ro.setQuota(100);
        this.getInsieme_ro().vettoreRegoleOperative.add(ro);
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getId_regola();
                break;
            }
            case 1: {
                retVal = "" + this.getNome();
                break;
            }
            case 2: {
                retVal = "" + this.getTotale();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

