/*
 * Decompiled with CFR 0.152.
 */
package controlling.esportazione;

import controlling.analitica.Analitica;
import controlling.analitica.InsiemeAnalitica;
import controlling.analitica.InsiemeVariabili;
import controlling.analitica.Variabile;
import controlling.analitica_operativa.AnaliticaOperativaVDA;
import controlling.centri_di_responsabilita.CentroDiResponsabilita;
import controlling.centri_di_responsabilita.InsiemeCentriDiResponsabilita;
import controlling.esportazione.MyEsportazione;
import controlling.regole.InsiemeRegole;
import controlling.regole.Regola;
import controlling.regole_operative.InsiemeRegoleOperative;
import controlling.regole_operative.RegolaOperativa;
import controlling.ribaltamento.RegolaRibaltamento;
import controlling.voci_di_analisi.InsiemeVociDiAnalisi;
import controlling.voci_di_analisi.VoceDiAnalisi;
import gestionale.configurazioni.Configurazioni;
import gestionale.documenti.Documento;
import gestionale.documenti.InsiemeDocumenti;
import gestionale.primanota.InsiemePNRiga;
import gestionale.primanota.PNRiga;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import trasporti.analitica.EsportatoreTrasporti;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.Task;

public class Esportatore {
    InsiemeVociDiAnalisi insieme_vda;
    InsiemeRegole insiemeRegole;
    InsiemeVariabili insieme_V;
    JInternalFrame chiamante;
    Regola r_0;
    VoceDiAnalisi vda_fatturato;
    long tempo_di_visualizzazione;
    EsportatoreTrasporti e_trasporti;
    FunzioniDate fda = new FunzioniDate();
    public Task fase_01_prepara_ambiente = new Task(){

        @Override
        public String doInBackground() {
            Esportatore.this.append("PRIMO PASSAGGIO DELL'ESPORTAZIONE>  prepara ambiente");
            this.setProgress(1);
            Esportatore.this.append("Carico le voci di analisi");
            Esportatore.this.insieme_vda = new InsiemeVociDiAnalisi();
            String w = " WHERE ctrl_voci_di_analisi.abilita=1 ";
            int res = Esportatore.this.insieme_vda.caricamento(w, "", true);
            if (res == 0) {
                Esportatore.this.append(" NON posso caricare le Voci d'analisi ");
                Esportatore.this.gestione_eccezione_in_task(this, "NON posso caricare le Voci d'analisi");
            }
            Esportatore.this.append("Caricate le Voci d'analisi");
            Esportatore.this.insiemeRegole = new InsiemeRegole();
            String where = " WHERE 1 ";
            Esportatore.this.insiemeRegole.caricamento(where, "");
            Esportatore.this.append("Caricate le Regole");
            Esportatore.this.r_0 = new Regola();
            w = " WHERE ctrl_regole.nome='REGOLA ZERO' ";
            Esportatore.this.r_0.seleziona(w);
            if (Esportatore.this.r_0.getId_regola() == 0) {
                Esportatore.this.append("Regola 0 non presente, la inserisco");
                Esportatore.this.r_0.setNome("REGOLA ZERO");
                Esportatore.this.r_0.setInsieme_ro(new InsiemeRegoleOperative());
                InsiemeCentriDiResponsabilita insieme_cdr_primo_livello = new InsiemeCentriDiResponsabilita();
                String w_cdr = " WHERE ctrl_centri_di_responsabilita.livello = 1 ";
                insieme_cdr_primo_livello.caricamento(w_cdr, "");
                int somma = 0;
                for (CentroDiResponsabilita cdr : insieme_cdr_primo_livello.vettoreCentriDiResponsabilita) {
                    RegolaOperativa ro = new RegolaOperativa();
                    ro.setId_centri_di_responsabilita(cdr.getIdcentri_di_responsabilita());
                    ro.setAttivo(1);
                    ro.setCdr(cdr.getCentro_di_responsabilita());
                    ro.setQuota(10);
                    Esportatore.this.r_0.getInsieme_ro().vettoreRegoleOperative.add(ro);
                    somma += 10;
                }
                Esportatore.this.r_0.setTotale(somma);
                Esportatore.this.r_0.iinserisci(false);
                Esportatore.this.append("REGOLA 0 INSERITA");
            } else {
                Esportatore.this.append("TROVATA REGOLA 0");
            }
            Esportatore.this.r_0.seleziona_dettagli();
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("voce_di_analisi_fatturato").equals("")) {
                Esportatore.this.append("Creare una voce di analisi per il fatturato: FATTURATO  Creare nel file di configurazioni la seguente riga:'voce_di_analisi_fatturato = FATTURATO'");
                Configurazioni.getIstanza().connessione.rollback();
                Esportatore.this.gestione_eccezione_in_task(this, "Creare una voce di analisi per il fatturato: FATTURATO  Creare nel file di configurazioni la seguente riga:'voce_di_analisi_fatturato = FATTURATO'");
            }
            VoceDiAnalisi voceDiAnalisi = Esportatore.this.vda_fatturato = new VoceDiAnalisi();
            StringBuilder stringBuilder = new StringBuilder().append(" WHERE descrizione_voce='");
            Configurazioni.getIstanza();
            voceDiAnalisi.seleziona(stringBuilder.append(Configurazioni.hm.get("voce_di_analisi_fatturato")).append("'").toString());
            this.setProgress(50);
            if (Esportatore.this.vda_fatturato.getIdvoci_di_analisi() == 0) {
                Esportatore.this.append(" vda_fatturato non presente, la inserisco");
                VoceDiAnalisi voceDiAnalisi2 = Esportatore.this.vda_fatturato = new VoceDiAnalisi();
                Configurazioni.getIstanza();
                voceDiAnalisi2.setDescrizione_voce(Configurazioni.hm.get("voce_di_analisi_fatturato"));
                Esportatore.this.vda_fatturato.setTipo("ricavo");
                Esportatore.this.vda_fatturato.setDiretto(1);
                Esportatore.this.vda_fatturato.setId_regola_predefinita(Esportatore.this.r_0.getId_regola());
                Esportatore.this.vda_fatturato.setNome_regola(Esportatore.this.r_0.getNome());
                Esportatore.this.vda_fatturato.setReg(Esportatore.this.r_0);
                Esportatore.this.vda_fatturato.inserisci(false);
                Esportatore.this.append(" vda_fatturato inserita");
            } else {
                Esportatore.this.append(" vda_fatturato TROVATA");
            }
            Esportatore.this.append(" istanzio l'esportatore per il modulo trasporti");
            Esportatore.this.e_trasporti = new EsportatoreTrasporti();
            Esportatore.this.e_trasporti.setChiamante(Esportatore.this.chiamante);
            Esportatore.this.e_trasporti.setInsiemeRegole(Esportatore.this.insiemeRegole);
            Esportatore.this.e_trasporti.setR_0(Esportatore.this.r_0);
            Esportatore.this.e_trasporti.setVda_fatturato(Esportatore.this.vda_fatturato);
            Esportatore.this.append(" COSTRUZIONE AMBIENTE TRASPORTI");
            boolean res2 = Esportatore.this.e_trasporti.trasporti_fase_01_costruisci_ambiente();
            if (!res2) {
                Esportatore.this.append(" COSTRUZIONE AMBIENTE NON COMPLETATA CORRETTAMENTE");
                Esportatore.this.gestione_eccezione_in_task(this, "COSTRUZIONE AMBIENTE NON COMPLETATA CORRETTAMENTE");
            }
            Esportatore.this.append("COSTRUZIONE AMBIENTE COMPLETATA CORRETTAMENTE");
            Esportatore.this.append("PRIMO PASSAGGIO DELL'ESPORTAZIONE>  TERMINATO CORRETTAMENTE");
            this.setProgress(100);
            return "OK";
        }
    };
    public Task fase_02_prepara_analitica_operativa = new Task(){

        @Override
        public String doInBackground() {
            this.setProgress(1);
            Esportatore.this.append("SECONDO PASSAGGIO DELL'ESPORTAZIONE>  prepara_analitica_operativa");
            Esportatore.this.append("svuota_tabella_analitica_operativa");
            boolean res1 = Esportatore.this.svuota_tabella_analitica_operativa();
            if (!res1) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: svuota_tabella_analitica_operativa");
                return "KO";
            }
            Esportatore.this.append("elimina_tabella_variabili");
            this.setProgress(33);
            boolean res2 = Esportatore.this.elimina_tabella_variabili();
            if (!res2) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: elimina_tabella_variabili");
                return "KO";
            }
            Esportatore.this.append("costruisci_tabella_variabili");
            this.setProgress(66);
            boolean res3 = Esportatore.this.costruisci_tabella_variabili();
            if (!res3) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: costruisci_tabella_variabili");
                return "KO";
            }
            this.setProgress(100);
            Esportatore.this.append("SECONDO PASSAGGIO DELL'ESPORTAZIONE>  TERMINATO CORRETTAMENTE");
            return "OK";
        }
    };
    public Task fase_03_esporta_passivo = new Task(){

        @Override
        public String doInBackground() {
            this.setProgress(1);
            Esportatore.this.append("Terzo PASSAGGIO DELL'ESPORTAZIONE>  prepara_analitica_operativa");
            Esportatore.this.append("esportazione_gestione");
            long tempo1 = System.currentTimeMillis();
            Configurazioni.getIstanza().connessione.start_transaction();
            boolean res = Esportatore.this.esportazione_gestione(this);
            if (!res) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: esportazione_gestione");
                return "KO";
            }
            this.setProgress(50);
            Esportatore.this.append("esporta_gasolio");
            boolean res2 = Esportatore.this.e_trasporti.trasporti_fase_03_esporta_gasolio();
            if (!res2) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: esporta_gasolio");
                return "KO";
            }
            this.setProgress(75);
            Esportatore.this.append("esporta_manutenzioni");
            boolean res3 = Esportatore.this.e_trasporti.trasporti_fase_03_esporta_manutenzioni();
            if (!res3) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: esporta_manutenzioni");
                return "KO";
            }
            this.setProgress(85);
            Esportatore.this.append("esporta_viaggi_terzi");
            boolean res4 = Esportatore.this.e_trasporti.trasporti_fase_03_esporta_viaggi_terzi();
            if (!res4) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: esporta_viaggi_terzi");
                return "KO";
            }
            Configurazioni.getIstanza().connessione.commit();
            long tempo2 = System.currentTimeMillis();
            long t = tempo2 - tempo1;
            Esportatore.this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE IN " + t + " millisecondi");
            this.setProgress(100);
            Esportatore.this.append("TERZO PASSAGGIO DELL'ESPORTAZIONE>  TERMINATO CORRETTAMENTE");
            return "OK";
        }
    };
    public Task fase_04_esportazione_fatture_attive = new Task(){

        @Override
        public String doInBackground() {
            this.setProgress(1);
            Esportatore.this.append("QUARTO PASSAGGIO DELL'ESPORTAZIONE>  esportazione_fatture_attive");
            long tempo1 = System.currentTimeMillis();
            boolean res_tot = false;
            Configurazioni.getIstanza().connessione.start_transaction();
            Esportatore.this.append("Carico Analitica");
            InsiemeAnalitica insieme_analitica = new InsiemeAnalitica();
            int size = insieme_analitica.caricamento(" WHERE tabella_origine='gestione' ", "");
            this.setProgress(5);
            InsiemeDocumenti insieme_fa = new InsiemeDocumenti();
            String where = " WHERE fatture_attive_tipi.idfatture_attive_tipi=1 ";
            insieme_fa.caricamento(where, "");
            Iterator<Documento> i_fa = insieme_fa.vettoreDOC.iterator();
            String w = "WHERE 1 ";
            if (!insieme_fa.vettoreDOC.isEmpty()) {
                w = w + " AND 1 ";
            }
            InsiemePNRiga insieme_gestione = new InsiemePNRiga();
            this.setProgress(10);
            while (i_fa.hasNext()) {
                Documento fa = i_fa.next();
                fa.seleziona_dettagli();
                if (fa.getR() == null) continue;
                for (PNRiga pnr : fa.getR().getInsieme_righe().vettoreRPN) {
                    insieme_gestione.vettoreRPN.add(pnr);
                }
            }
            this.setProgress(20);
            if (insieme_gestione.vettoreRPN.isEmpty()) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: NON SONO RIUSCITO A CARICARE I DATI DELLA TABELLA GESTIONE!!!!");
                return "KO";
            }
            Iterator i = insieme_gestione.vettoreRPN.iterator();
            long numero_righe = insieme_gestione.vettoreRPN.size();
            double passo = 30.0 / (double)numero_righe;
            Esportatore.this.append("righe di gestione totali=" + numero_righe);
            while (i.hasNext()) {
                this.setProgress((int)(50.0 - passo * (double)(--numero_righe)));
                PNRiga pnr = (PNRiga)i.next();
                MyTrace.log.info("RIGA DI GESTIONE CON ID=" + pnr.getId());
                if (pnr.getInizio_competenza() == null) {
                    pnr.setInizio_competenza("0000-00-00");
                }
                if (pnr.getFine_competenza() == null) {
                    pnr.setFine_competenza("0000-00-00");
                }
                InsiemeAnalitica insieme_record_trovati = insieme_analitica.cerca_record_analitica(pnr.getId(), "gestione");
                if (insieme_record_trovati.vettoreAnalitica.isEmpty()) {
                    MyTrace.log.info("RECORD NON PRESENTRE IN ANALITICA, LO INSERISCO");
                    res_tot = Esportatore.this.costruisci_e_inserisci_analitica(pnr);
                    if (res_tot) continue;
                    Configurazioni.getIstanza().connessione.rollback();
                    Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                    return "KO";
                }
                Analitica prima = (Analitica)insieme_record_trovati.vettoreAnalitica.elementAt(0);
                MyTrace.log.info("LA REGOLA MEMORIZZATA E'=" + prima.getId_regola());
                MyTrace.log.info("LA REGOLA ATTUALE'=" + pnr.getId_regola());
                if (prima.getId_regola() == pnr.getId_regola()) {
                    MyTrace.log.info("STESSA REGOLA, MODIFICO");
                    for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                        a.setData_dal(pnr.getInizio_competenza());
                        a.setData_al(pnr.getFine_competenza());
                        a.setImporto(pnr.getImporto().times(a.getRapporto()));
                        boolean res = a.modifica(false);
                        if (res) continue;
                        Configurazioni.getIstanza().connessione.rollback();
                        Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: NON POSSO MODIFICARE UN RECORD IN CTRL_ANALITICA!!!!");
                        return "KO";
                    }
                    continue;
                }
                MyTrace.log.info("LA REGOLA E' CAMBIATA");
                for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                    String where2;
                    boolean res = a.elimina(false, where2 = " WHERE idanalitica=" + a.getIdanalitica() + "");
                    if (res) continue;
                    Configurazioni.getIstanza().connessione.rollback();
                    Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: NON POSSO eliminare UN  RECORD IN CTRL_ANALITICA!!!!");
                    return "KO";
                }
                res_tot = Esportatore.this.costruisci_e_inserisci_analitica(pnr);
                if (res_tot) continue;
                Configurazioni.getIstanza().connessione.rollback();
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                return "KO";
            }
            this.setProgress(50);
            Esportatore.this.append("ESPORTAZIONE FATTURE GENERICHE CORRETTAMENTE ESEGUITA");
            boolean res = Esportatore.this.e_trasporti.trasporti_fase_04_esporta_fatturato_ordini(this);
            if (!res) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: NON RIESCO AD ESPORTARE FATTURATO ORDINI!!!");
                return "KO";
            }
            Configurazioni.getIstanza().connessione.commit();
            long tempo2 = System.currentTimeMillis();
            long t = tempo2 - tempo1;
            Esportatore.this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE IN " + t + " millisecondi");
            this.setProgress(100);
            Esportatore.this.append("QUARTO PASSAGGIO DELL'ESPORTAZIONE>  TERMINATO CORRETTAMENTE");
            return "OK";
        }
    };
    public Task fase_05_esportazione_produzione = new Task(){

        @Override
        public String doInBackground() {
            this.setProgress(1);
            Esportatore.this.append("QUINTO PASSAGGIO DELL'ESPORTAZIONE>  esportazione_produzione");
            long tempo1 = System.currentTimeMillis();
            boolean res_tot = false;
            Configurazioni.getIstanza().connessione.start_transaction();
            Esportatore.this.append("esporta_produzione");
            boolean res = Esportatore.this.e_trasporti.trasporti_fase_05_esporta_produzione(Esportatore.this.insieme_V);
            if (!res) {
                Esportatore.this.gestione_eccezione_in_task(this, "ERRORE IN: XXXX");
                return "KO";
            }
            this.setProgress(50);
            Configurazioni.getIstanza().connessione.commit();
            long tempo2 = System.currentTimeMillis();
            long t = tempo2 - tempo1;
            Esportatore.this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE IN " + t + " millisecondi");
            this.setProgress(100);
            Esportatore.this.append("QUINTO PASSAGGIO DELL'ESPORTAZIONE>  TERMINATO CORRETTAMENTE");
            return "OK";
        }
    };
    public Task fase_06_ribaltamento = new Task(){

        @Override
        public String doInBackground() {
            this.setProgress(1);
            Esportatore.this.append("QUINTO PASSAGGIO DELL'ESPORTAZIONE>  ribaltamento");
            long tempo1 = System.currentTimeMillis();
            Configurazioni.getIstanza().connessione.start_transaction();
            Esportatore.this.append("CARICO ANALITICA");
            InsiemeAnalitica insieme_analitica = new InsiemeAnalitica();
            String where = " WHERE 1 ";
            insieme_analitica.caricamento(where, "");
            InsiemeCentriDiResponsabilita insieme_centri = new InsiemeCentriDiResponsabilita();
            String w = " WHERE ctrl_centri_di_responsabilita.attivo=1";
            insieme_centri.caricamento(w, "");
            for (CentroDiResponsabilita c : insieme_centri.vettoreCentriDiResponsabilita) {
                c.seleziona_dettagli();
            }
            Esportatore.this.append("INIZIO ANALISI");
            this.setProgress(10);
            Iterator i = insieme_analitica.vettoreAnalitica.iterator();
            long lunghezza = insieme_analitica.vettoreAnalitica.size();
            double passo = 90.0 / (double)lunghezza;
            Esportatore.this.append("Numero record Analitica = " + lunghezza);
            while (i.hasNext()) {
                this.setProgress((int)(100.0 - passo * (double)(--lunghezza)));
                Analitica a = (Analitica)i.next();
                boolean res = true;
                if (a.getTipo_cdr().equals("operativo") && a.getCdrPadre() == 0) {
                    ArrayList<AnaliticaOperativaVDA> da_inserire = Esportatore.this.spezza_record(a.getData_dal(), a.getData_al(), a.getId_centro_di_responsabilita(), a.getTipo_vda(), a.getImporto().getDoubleValue());
                    for (AnaliticaOperativaVDA ao : da_inserire) {
                        ao.setId_vda(a.getId_vda());
                        res = ao.iinserisci(false);
                    }
                    if (res) continue;
                    Configurazioni.getIstanza().connessione.rollback();
                    Esportatore.this.gestione_eccezione_in_task(this, "NON POSSO inserire UN  RECORD IN CTRL_ANALITICA!!!!");
                    return "KO";
                }
                CentroDiResponsabilita cdr = new CentroDiResponsabilita();
                for (CentroDiResponsabilita cc : insieme_centri.vettoreCentriDiResponsabilita) {
                    if (cc.getIdcentri_di_responsabilita() != a.getId_centro_di_responsabilita()) continue;
                    cdr = cc;
                }
                if (cdr.getAttivo() == 1) {
                    if (cdr.getInsieme_regole_ribaltamento() != null && !cdr.getInsieme_regole_ribaltamento().vettoreRegole.isEmpty()) {
                        Iterator j = cdr.getInsieme_regole_ribaltamento().vettoreRegole.iterator();
                        double tot = 0.0;
                        boolean res_rr = true;
                        while (j.hasNext()) {
                            RegolaRibaltamento rr = (RegolaRibaltamento)j.next();
                            CentroDiResponsabilita c = new CentroDiResponsabilita();
                            for (CentroDiResponsabilita cc : insieme_centri.vettoreCentriDiResponsabilita) {
                                if (cc.getIdcentri_di_responsabilita() != rr.getId_cdr_operativo()) continue;
                                c = cc;
                            }
                            if (c.getPadre() == 1) {
                                double quantita_totale_c = a.getImporto().times(rr.getPercentuale() / 100.0).getDoubleValue();
                                if (c.getInsieme_regole_ribaltamento() != null && !c.getInsieme_regole_ribaltamento().vettoreRegole.isEmpty()) {
                                    for (RegolaRibaltamento rrr : c.getInsieme_regole_ribaltamento().vettoreRegole) {
                                        double value = quantita_totale_c * rrr.getPercentuale() / 100.0;
                                        ArrayList<AnaliticaOperativaVDA> da_inserire = Esportatore.this.spezza_record(a.getData_dal(), a.getData_al(), rrr.getId_cdr_operativo(), a.getTipo_vda(), value);
                                        for (AnaliticaOperativaVDA aoo : da_inserire) {
                                            double v = 0.0;
                                            v = aoo.getCosto() != 0.0 ? aoo.getCosto() : aoo.getRicavo();
                                            tot += v;
                                            aoo.setId_vda(a.getId_vda());
                                            res = aoo.iinserisci(false);
                                        }
                                    }
                                    continue;
                                }
                                Esportatore.this.gestione_eccezione_in_task(this, "PROBLEMA SUL RIBALTAMENTO: NEL CENTRO '" + c.getCentro_di_responsabilita() + "' che \u00e8 PADRE! non \u00e8 stata assegnata la regola di ribaltamento!!(obbligatoria)");
                                return "KO";
                            }
                            double value = a.getImporto().times(rr.getPercentuale() / 100.0).getDoubleValue();
                            ArrayList<AnaliticaOperativaVDA> da_inserire = Esportatore.this.spezza_record(a.getData_dal(), a.getData_al(), rr.getId_cdr_operativo(), a.getTipo_vda(), value);
                            for (AnaliticaOperativaVDA aoo : da_inserire) {
                                double v = 0.0;
                                v = aoo.getCosto() != 0.0 ? aoo.getCosto() : aoo.getRicavo();
                                tot += v;
                                aoo.setId_vda(a.getId_vda());
                                res = aoo.iinserisci(false);
                            }
                        }
                        double errore_max = 7.0 * a.getImporto().getDoubleValue() / 100.0;
                        double sup = a.getImporto().getDoubleValue() + errore_max;
                        double inf = a.getImporto().getDoubleValue() - errore_max;
                        if (!(a.getImporto().getDoubleValue() < 1.0)) {
                            if (a.getImporto().getDoubleValue() > 0.0) {
                                if (tot < 0.0) {
                                    tot = -tot;
                                }
                                if (sup < 0.0) {
                                    sup = -sup;
                                }
                                if (inf < 0.0) {
                                    inf = -inf;
                                }
                                MyTrace.log.severe("TOT=" + tot + " a.getImporto=" + a.getImporto() + " sup=" + sup + " inf=" + inf);
                                if (!(tot <= sup) || !(tot >= inf)) {
                                    Configurazioni.getIstanza().connessione.rollback();
                                    Esportatore.this.gestione_eccezione_in_task(this, "CENTRO FUNZIONALE O AUSILIARIO SENZA REGOLA DI RIBALTAMENTO TOT !=100!!!!");
                                    return "KO";
                                }
                            } else {
                                tot = -tot;
                                sup = -sup;
                                inf = -inf;
                                MyTrace.log.severe("TOT=" + tot + " a.getImporto=" + a.getImporto() + " sup=" + sup + " inf=" + inf);
                                if (!(tot <= sup) || !(tot >= inf)) {
                                    Configurazioni.getIstanza().connessione.rollback();
                                    Esportatore.this.gestione_eccezione_in_task(this, "CENTRO FUNZIONALE O AUSILIARIO SENZA REGOLA DI RIBALTAMENTO TOT !=100!!!!");
                                    return "KO";
                                }
                            }
                        }
                        if (res_rr) continue;
                        Configurazioni.getIstanza().connessione.rollback();
                        Esportatore.this.gestione_eccezione_in_task(this, "CENTRO FUNZIONALE O AUSILIARIO SENZA REGOLA DI RIBALTAMENTO non posso inserire ao!!!!");
                        return "KO";
                    }
                    Configurazioni.getIstanza().connessione.rollback();
                    Esportatore.this.gestione_eccezione_in_task(this, "CENTRO FUNZIONALE O AUSILIARIO PADRE SENZA REGOLA DI RIBALTAMENTO insieme vuoto!!!!");
                    return "KO";
                }
                Configurazioni.getIstanza().connessione.rollback();
                Esportatore.this.gestione_eccezione_in_task(this, "NON POSSO C'E una regola con cdr non attivo!!!!");
                return "KO";
            }
            Configurazioni.getIstanza().connessione.commit();
            long tempo2 = System.currentTimeMillis();
            long t = tempo2 - tempo1;
            Esportatore.this.append("RIBALTAMENTO ESEGUITO CORRETTAMENTE IN " + t + " millisecondi");
            this.setProgress(100);
            Esportatore.this.append("SESTO PASSAGGIO DELL'ESPORTAZIONE>  TERMINATO CORRETTAMENTE");
            return "OK";
        }
    };

    public InsiemeVociDiAnalisi getInsieme_vda() {
        return this.insieme_vda;
    }

    public void setInsieme_vda(InsiemeVociDiAnalisi insieme_vda) {
        this.insieme_vda = insieme_vda;
    }

    public JInternalFrame getChiamante() {
        return this.chiamante;
    }

    public void setChiamante(JInternalFrame chiamante) {
        this.chiamante = chiamante;
        if (this.e_trasporti != null) {
            this.e_trasporti.setChiamante(chiamante);
        }
    }

    public void gestione_eccezione_in_task(Task task, String descrizione) {
        this.append(descrizione);
        if (task.cancel(true)) {
            this.append("RICHIESTA INTERRUZIONE");
        }
    }

    public void append(String testo_da_inserire) {
        ((MyEsportazione)this.chiamante).jTextResult.append(testo_da_inserire + "\n");
        MyTrace.log.info("APPEND: " + testo_da_inserire);
    }

    private boolean elimina_tabella_variabili() {
        String query = "DROP TABLE IF EXISTS ctrl_analitica_operativa_variabili ";
        boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query);
        return r_ins;
    }

    private boolean costruisci_tabella_variabili() {
        Configurazioni.getIstanza().connessione.start_transaction();
        this.insieme_V = new InsiemeVariabili();
        this.insieme_V.caricamento("", "");
        String query = "CREATE  TABLE ctrl_analitica_operativa_variabili ( idAnalitica_variabili INT(11) NOT NULL AUTO_INCREMENT, dal DATE DEFAULT NULL, al DATE DEFAULT NULL, id_cdr int(11) NOT NULL ";
        for (Variabile v : this.insieme_V.vettoreV) {
            query = query + " ," + v.getDescrizione() + " DOUBLE(10,2) DEFAULT NULL  ";
        }
        boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query = query + " ,PRIMARY KEY (idAnalitica_variabili) )  ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
        if (r_ins) {
            Configurazioni.getIstanza().connessione.commit();
            return true;
        }
        Configurazioni.getIstanza().connessione.rollback();
        return false;
    }

    public boolean svuota_tabella_analitica_operativa() {
        long tempo1 = System.currentTimeMillis();
        String query_seleziona = "TRUNCATE TABLE ctrl_analitica_operativa_vda";
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("Svuota Tabella Analitica Operativa non riuscito ");
            this.append("Svuota Tabella Analitica Operativa non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
        long tempo2 = System.currentTimeMillis();
        long t = tempo2 - tempo1;
        this.append("TABELLA SVUOTATA CORRETTAMENTE IN " + t + " millisecondi");
        return true;
    }

    public boolean esportazione_gestione(Task task) {
        boolean res_tot = false;
        InsiemeAnalitica insieme_analitica = new InsiemeAnalitica();
        int size = insieme_analitica.caricamento(" WHERE tabella_origine='gestione' ", "");
        InsiemePNRiga insieme_gestione = new InsiemePNRiga();
        String w = " WHERE gestione.id_registro!=0  AND registro.id_causale_contabile!=0  AND conf_causale_contabile.editabile=1  AND conf_modello_causale_contabile.inserimento_analitica=1  ";
        insieme_gestione.ccaricamento(w, "");
        if (insieme_gestione.vettoreRPN.isEmpty()) {
            this.append("NON SONO RIUSCITO A CARICARE I DATI DELLA TABELLA GESTIONE!!!!");
            return false;
        }
        Iterator i = insieme_gestione.vettoreRPN.iterator();
        long numero_righe = insieme_gestione.vettoreRPN.size();
        double passo = 50.0 / (double)numero_righe;
        this.append("Numero righe gestione = " + numero_righe);
        while (i.hasNext()) {
            task.settaAvanzamento((int)(50.0 - passo * (double)(--numero_righe)));
            PNRiga pnr = (PNRiga)i.next();
            MyTrace.log.info("RIGA DI GESTIONE CON ID=" + pnr.getId());
            if (pnr.getId_registro() == 0 || pnr.getId_cc() == 0 || pnr.getCc_editabile() != 1 || pnr.getInserimento_analitica() != 1) continue;
            InsiemeAnalitica insieme_record_trovati = insieme_analitica.cerca_record_analitica(pnr.getId(), "gestione");
            if (insieme_record_trovati.vettoreAnalitica.isEmpty()) {
                MyTrace.log.info("RECORD NON PRESENTRE IN ANALITICA, LO INSERISCO");
                res_tot = this.costruisci_e_inserisci_analitica(pnr);
                if (res_tot) continue;
                Configurazioni.getIstanza().connessione.rollback();
                this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                return false;
            }
            Analitica prima = (Analitica)insieme_record_trovati.vettoreAnalitica.elementAt(0);
            MyTrace.log.info("LA REGOLA MEMORIZZATA E'=" + prima.getId_regola());
            MyTrace.log.info("LA REGOLA ATTUALE'=" + pnr.getId_regola());
            if (prima.getId_regola() == pnr.getId_regola()) {
                MyTrace.log.info("STESSA REGOLA, MODIFICO");
                for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                    a.setData_dal(pnr.getInizio_competenza());
                    a.setData_al(pnr.getFine_competenza());
                    a.setImporto(pnr.getImporto().times(a.getRapporto()));
                    boolean res = a.modifica(false);
                    if (res) continue;
                    Configurazioni.getIstanza().connessione.rollback();
                    this.append("NON POSSO MODIFICARE UN RECORD IN CTRL_ANALITICA!!!!");
                    return false;
                }
                continue;
            }
            MyTrace.log.info("LA REGOLA E' CAMBIATA");
            for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                String where;
                boolean res = a.elimina(false, where = " WHERE idanalitica=" + a.getIdanalitica() + "");
                if (res) continue;
                Configurazioni.getIstanza().connessione.rollback();
                this.append("NON POSSO eliminare UN  RECORD IN CTRL_ANALITICA!!!!");
                return false;
            }
            res_tot = this.costruisci_e_inserisci_analitica(pnr);
            if (res_tot) continue;
            Configurazioni.getIstanza().connessione.rollback();
            this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
            return false;
        }
        this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE DI fatture passive generiche ");
        return true;
    }

    private boolean costruisci_e_inserisci_analitica(PNRiga pnr) {
        boolean resTot = true;
        if (pnr.getId_vda() == 0 || pnr.getId_vda() == 1) {
            if (pnr.getC().getId_vda() != 0 && pnr.getC().getId_vda() != 1) {
                pnr.setId_vda(pnr.getC().getId_vda());
            } else {
                pnr.setId_vda(1);
            }
        }
        Iterator i_vda = this.insieme_vda.vettoreVociDiAnalisi.iterator();
        boolean trovato = false;
        while (i_vda.hasNext() && !trovato) {
            VoceDiAnalisi vda = (VoceDiAnalisi)i_vda.next();
            if (vda.getIdvoci_di_analisi() != pnr.getId_vda()) continue;
            pnr.setVda(vda);
            trovato = true;
        }
        if (pnr.getVda() == null) {
            pnr.setVda(new VoceDiAnalisi());
            String where = " WHERE idvoci_di_analisi=1";
            pnr.getVda().seleziona(where);
            pnr.getVda().seleziona_dettagli();
        }
        if (pnr.getId_regola() == 1 || pnr.getId_regola() == 0) {
            pnr.setId_regola(pnr.getVda().getReg().getId_regola());
            pnr.setRegola(pnr.getVda().getReg());
            pnr.modificaPNRiga(false);
        } else {
            pnr.setRegola(new Regola());
            String w = " where ctrl_regole.idregole=" + pnr.getId_regola() + "";
            pnr.getRegola().seleziona(w);
            pnr.getRegola().seleziona_dettagli();
        }
        for (RegolaOperativa ro : pnr.getRegola().getInsieme_ro().vettoreRegoleOperative) {
            Analitica a = new Analitica();
            a.setData_dal(pnr.getInizio_competenza());
            a.setData_al(pnr.getFine_competenza());
            a.setId_centro_di_responsabilita(ro.getId_centri_di_responsabilita());
            a.setImporto(pnr.getImporto().times(ro.getQuota()).div(pnr.getRegola().getTotale()));
            a.setId_vda(pnr.getId_vda());
            a.setRapporto((double)ro.getQuota() / (double)pnr.getRegola().getTotale());
            a.setTabella_origine("gestione");
            a.setId_tabella_origine(pnr.getId());
            a.setId_regola(pnr.getId_regola());
            resTot = a.inserisci(false);
        }
        return resTot;
    }

    public ArrayList<AnaliticaOperativaVDA> spezza_record(String data_dal, String data_al, int id_cdr, String tipo_vda, double importo) {
        ArrayList<AnaliticaOperativaVDA> da_inserire = new ArrayList<AnaliticaOperativaVDA>();
        String dal = data_dal;
        String anno_dal = this.fda.anno(dal);
        String mese_dal = this.fda.mese(dal);
        String giorno_dal = this.fda.giorno(dal);
        String al = data_al;
        String anno_al = this.fda.anno(al);
        String mese_al = this.fda.mese(al);
        String giorno_al = this.fda.giorno(al);
        boolean primo_mese = true;
        if (anno_dal.equals(anno_al) && mese_dal.equals(mese_al)) {
            AnaliticaOperativaVDA ao = new AnaliticaOperativaVDA();
            ao.setData_dal(data_dal);
            ao.setData_al(data_al);
            if (tipo_vda.equals("costo")) {
                ao.setCosto(importo);
                System.out.println("dddddddddd:" + ao.getCosto());
            } else {
                ao.setRicavo(importo);
                System.out.println("dddddddddd:" + ao.getRicavo());
            }
            ao.setId_centro_di_responsabilita(id_cdr);
            da_inserire.add(ao);
        } else {
            double value;
            double giorni_di_differenza_nel_mese_d;
            int giorni_di_differenza_nel_mese;
            AnaliticaOperativaVDA ao;
            int giorni_di_differenza = this.fda.giorniDifferenza(this.fda.string_to_date(dal), this.fda.string_to_date(al), null) + 1;
            double giorni_di_differenza_d = giorni_di_differenza;
            double quota = 1.0 / giorni_di_differenza_d;
            int anni_di_differenza = this.fda.AnniDifferenza(this.fda.string_to_date(dal), this.fda.string_to_date(al), null) + 1;
            for (int mesi_di_differenza = this.fda.MesiDifferenza(this.fda.string_to_date(dal), this.fda.string_to_date(al), null); mesi_di_differenza > 0; --mesi_di_differenza) {
                ao = new AnaliticaOperativaVDA();
                if (primo_mese) {
                    primo_mese = false;
                    giorni_di_differenza_nel_mese = this.fda.giorniDifferenza(this.fda.string_to_date(dal), this.fda.string_to_date(this.fda.ottieniUltimoGiornoDelMese(dal)), null) + 1;
                    giorni_di_differenza_nel_mese_d = giorni_di_differenza_nel_mese;
                    ao.setData_dal(data_dal);
                    ao.setData_al(this.fda.ottieniUltimoGiornoDelMese(dal));
                    value = importo * (quota * giorni_di_differenza_nel_mese_d);
                    if (tipo_vda.equals("costo")) {
                        ao.setCosto(value);
                    } else {
                        ao.setRicavo(value);
                    }
                } else {
                    String mese_successivo = this.fda.addMounth(dal, 1);
                    String mese_successivo_1 = anno_dal + "-" + this.fda.mese(mese_successivo) + "-01";
                    int giorni_di_differenza_nel_mese2 = this.fda.giorniDifferenza(this.fda.string_to_date(mese_successivo_1), this.fda.string_to_date(this.fda.ottieniUltimoGiornoDelMese(mese_successivo_1)), null) + 1;
                    double giorni_di_differenza_nel_mese_d2 = giorni_di_differenza_nel_mese2;
                    ao.setData_dal(mese_successivo_1);
                    ao.setData_al(this.fda.ottieniUltimoGiornoDelMese(mese_successivo_1));
                    double value2 = importo * (quota * giorni_di_differenza_nel_mese_d2);
                    if (tipo_vda.equals("costo")) {
                        ao.setCosto(value2);
                    } else {
                        ao.setRicavo(value2);
                    }
                }
                ao.setId_centro_di_responsabilita(id_cdr);
                da_inserire.add(ao);
            }
            ao = new AnaliticaOperativaVDA();
            ao.setData_dal(anno_al + "-" + mese_al + "-01");
            ao.setData_al(data_al);
            giorni_di_differenza_nel_mese = this.fda.giorniDifferenza(this.fda.string_to_date(anno_al + "-" + mese_al + "-01"), this.fda.string_to_date(data_al), null) + 1;
            giorni_di_differenza_nel_mese_d = giorni_di_differenza_nel_mese;
            value = importo * (quota * giorni_di_differenza_nel_mese_d);
            if (tipo_vda.equals("costo")) {
                ao.setCosto(value);
            } else {
                ao.setRicavo(value);
            }
            ao.setId_centro_di_responsabilita(id_cdr);
            da_inserire.add(ao);
        }
        return da_inserire;
    }
}

