/*
 * Decompiled with CFR 0.152.
 */
package cisterna.carico_gasolio;

import cisterna.carico_gasolio.CaricoGasolio;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Vector;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class InsiemeCaricoGasolio {
    public Vector vettoreGasolio;
    int colCount;
    public String[] headers;
    public Quantita giacenza = new Quantita(BigDecimal.ZERO);

    public InsiemeCaricoGasolio() {
        this.vettoreGasolio = new Vector();
        this.giacenza = new Quantita(BigDecimal.ZERO);
    }

    public int ccaricamento(String where, String order_by) {
        this.vettoreGasolio = new Vector();
        this.giacenza = new Quantita(BigDecimal.ZERO);
        String query = "SELECT mtra_gasolio.*, mtra_das.*, commesse.numero_commessa, commesse.anno as anno_commessa, commesse.descrizione_breve as db_commessa,  anag_anagrafica.*  FROM mtra_gasolio  LEFT JOIN mtra_das on mtra_gasolio.id_das=mtra_das.id  LEFT JOIN anag_anagrafica on mtra_das.id_anagrafica=anag_anagrafica.idanagrafica  LEFT JOIN commesse ON mtra_gasolio.id_commessa=commesse.idCommessa ";
        query = query + " " + where;
        query = query + " " + order_by;
        Money ultimo_costo_acquisto = new Money(BigDecimal.ZERO);
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                CaricoGasolio g = new CaricoGasolio();
                g.setId(res.getInt("id"));
                g.setTarga(res.getString("targa"));
                g.setCosto_al_litro(new Money(res.getDouble("costo_al_litro")));
                g.setData_movimento(res.getString("data_movimento"));
                g.setId_das(res.getInt("id_das"));
                g.setQuantita(new Quantita(res.getDouble("quantita")));
                g.setNum_doc(res.getString("numero_das"));
                g.setNumero_fattura(res.getString("numero_fattura"));
                g.setId_afornitore(res.getInt("id_anagrafica"));
                g.setStringa_fornitore(res.getString("codice") + "-" + res.getString("ragione_sociale"));
                g.setKm_percorsi(res.getInt("km_percorsi"));
                g.setId_commessa(res.getInt("id_commessa"));
                g.setString_numero_commessa(res.getInt("numero_commessa") + "/" + res.getInt("anno_commessa"));
                g.setDbCommessa(res.getString("db_commessa"));
                Money costo_al_litro = new Money(res.getDouble("costo_al_litro"));
                if (costo_al_litro.isZero()) {
                    g.setCosto_al_litro(new Money(ultimo_costo_acquisto));
                } else {
                    ultimo_costo_acquisto = costo_al_litro;
                }
                if (res.getDouble("costo_totale") != 0.0) {
                    g.setCosto_totale(new Money(res.getDouble("costo_totale")));
                } else {
                    Money costo_tot = ultimo_costo_acquisto.multiply(g.getQuantita().negate());
                    g.setCosto_totale(costo_tot);
                }
                this.giacenza.plusplus(g.getQuantita());
                this.vettoreGasolio.addElement(g);
                Collections.reverse(this.vettoreGasolio);
            }
        }
        catch (Exception e) {
            this.vettoreGasolio = new Vector();
            MyTrace.log.severe("Seleziona Gasolio non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreGasolio.size();
    }

    public int caricamento_analitica(String where, String order_by) {
        String query = "SELECT mtra_gasolio.*,  mtra_mezzi.id_macchina, mtra_mezzi.id_centro_di_responsabilita  FROM mtra_gasolio  LEFT JOIN mtra_mezzi on mtra_mezzi.targa=mtra_gasolio.targa ";
        query = query + " " + where;
        query = query + " " + order_by;
        this.vettoreGasolio = new Vector();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                CaricoGasolio g = new CaricoGasolio();
                g.setId(res.getInt("id"));
                g.setCosto_al_litro(new Money(res.getDouble("costo_al_litro")));
                g.setData_movimento(res.getString("data_movimento"));
                g.setQuantita(new Quantita(res.getDouble("quantita")));
                g.setId_centro_di_responsabilita(res.getInt("id_centro_di_responsabilita"));
                g.setTarga(res.getString("targa"));
                g.setKm_percorsi(res.getInt("km_percorsi"));
                this.vettoreGasolio.addElement(g);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreGasolio = new Vector();
            MyTrace.log.severe("Seleziona Gasolio non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreGasolio.size();
    }
}

