/*
 * Decompiled with CFR 0.152.
 */
package cisterna.carico_gasolio;

import cisterna.das.DAS;
import controlling.analitica_operativa.AnaliticaOperativaVDA;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class CaricoGasolio {
    public Quantita quantita = new Quantita(BigDecimal.ZERO);
    public int id_afornitore;
    public Money costo_al_litro = new Money(BigDecimal.ZERO);
    public Money costo_totale = new Money(BigDecimal.ZERO);
    public String data_movimento;
    public String stringa_fornitore;
    public String string_numero_commessa;
    public String dbCommessa;
    public int id_das;
    public int id_macchina;
    public int id_centro_di_responsabilita;
    public int km_percorsi;
    public int id_commessa;
    public String data_das;
    public String targa;
    public String num_doc;
    public String numero_fattura;
    public AnaliticaOperativaVDA analitica_gasolio;
    DAS das = new DAS();
    int id;
    FunzioniDate fda = new FunzioniDate();
    Funzioni f = new Funzioni();

    public String getData_movimento() {
        return this.data_movimento;
    }

    public void setData_movimento(String data_movimento) {
        this.data_movimento = data_movimento;
    }

    public Money getCosto_al_litro() {
        return this.costo_al_litro;
    }

    public void setCosto_al_litro(Money costo_al_litro) {
        this.costo_al_litro = costo_al_litro;
    }

    public Money getCosto_totale() {
        return this.costo_totale;
    }

    public void setCosto_totale(Money costo_totale) {
        this.costo_totale = costo_totale;
    }

    public int getId_das() {
        return this.id_das;
    }

    public void setId_das(int id_das) {
        this.id_das = id_das;
    }

    public int getKm_percorsi() {
        return this.km_percorsi;
    }

    public void setKm_percorsi(int km_percorsi) {
        this.km_percorsi = km_percorsi;
    }

    public Quantita getQuantita() {
        return this.quantita;
    }

    public void setQuantita(Quantita quantita) {
        this.quantita = quantita;
    }

    public int getId_centro_di_responsabilita() {
        return this.id_centro_di_responsabilita;
    }

    public void setId_centro_di_responsabilita(int id_centro_di_responsabilita) {
        this.id_centro_di_responsabilita = id_centro_di_responsabilita;
    }

    public int getId_macchina() {
        return this.id_macchina;
    }

    public void setId_macchina(int id_macchina) {
        this.id_macchina = id_macchina;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTarga() {
        return this.targa;
    }

    public void setTarga(String targa) {
        this.targa = targa;
    }

    public String getData_das() {
        return this.data_das;
    }

    public void setData_das(String data_das) {
        this.data_das = data_das;
    }

    public int getId_afornitore() {
        return this.id_afornitore;
    }

    public void setId_afornitore(int id_afornitore) {
        this.id_afornitore = id_afornitore;
    }

    public AnaliticaOperativaVDA getAnalitica_gasolio() {
        return this.analitica_gasolio;
    }

    public void setAnalitica_gasolio(AnaliticaOperativaVDA analitica_gasolio) {
        this.analitica_gasolio = analitica_gasolio;
    }

    public String getNum_doc() {
        return this.num_doc;
    }

    public void setNum_doc(String num_doc) {
        this.num_doc = num_doc;
    }

    public String getNumero_fattura() {
        return this.numero_fattura;
    }

    public void setNumero_fattura(String numero_fattura) {
        this.numero_fattura = numero_fattura;
    }

    public String getStringa_fornitore() {
        return this.stringa_fornitore;
    }

    public void setStringa_fornitore(String stringa_fornitore) {
        this.stringa_fornitore = stringa_fornitore;
    }

    public String getString_numero_commessa() {
        return this.string_numero_commessa;
    }

    public void setString_numero_commessa(String string_numero_commessa) {
        this.string_numero_commessa = string_numero_commessa;
    }

    public String getDbCommessa() {
        return this.dbCommessa;
    }

    public void setDbCommessa(String dbCommessa) {
        this.dbCommessa = dbCommessa;
    }

    public int getId_commessa() {
        return this.id_commessa;
    }

    public void setId_commessa(int id_commessa) {
        this.id_commessa = id_commessa;
    }

    public DAS getDas() {
        return this.das;
    }

    public void setDas(DAS das) {
        this.das = das;
    }

    public boolean inserisci_prelievo(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_gasolio( quantita,data_movimento,id_das,targa,costo_al_litro,costo_totale,id_mezzo,km_percorsi,id_commessa) VALUES (" + this.getQuantita() + "," + "'" + this.getData_movimento() + "'," + " " + this.f.zero_to_null(this.getId_das()) + "," + "'" + this.getTarga() + "'," + "" + this.getCosto_al_litro() + "," + "" + this.getCosto_totale() + "," + "" + this.getId_macchina() + "," + "" + this.getKm_percorsi() + "," + "" + this.f.zero_to_null(this.getId_commessa()) + ")"))) {
            MyTrace.log.severe("Inserimento Gasolio non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_gasolio";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_gasolio','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento Gasolio non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modifica_prelievo(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_gasolio  SET quantita=" + this.getQuantita() + "," + " data_movimento='" + this.getData_movimento() + "', " + " targa='" + this.getTarga() + "', " + " id_mezzo=" + this.getId_macchina() + ", " + " costo_totale=" + this.getCosto_totale() + ", " + " costo_al_litro=" + this.getCosto_al_litro() + ", " + " km_percorsi =" + this.getKm_percorsi() + ", " + " id_commessa =" + this.f.zero_to_null(this.getId_commessa()) + " " + " WHERE id=" + this.getId() + ""))) {
            MyTrace.log.severe("Modifica Gasolio non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_gasolio','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Gasolio non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona(String where) {
        String query_seleziona = "SELECT mtra_gasolio.*, commesse.numero_commessa, commesse.anno as anno_commessa, commesse.descrizione_breve as db_commessa  FROM mtra_gasolio LEFT JOIN commesse ON mtra_gasolio.id_commessa=commesse.idCommessa ";
        query_seleziona = query_seleziona + " " + where;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            while (res.next()) {
                this.setId(res.getInt("id"));
                this.setTarga(res.getString("targa"));
                this.setData_movimento(res.getString("data_movimento"));
                this.setId_das(res.getInt("id_das"));
                this.setQuantita(new Quantita(res.getDouble("quantita")));
                this.setId_commessa(res.getInt("id_commessa"));
                this.setString_numero_commessa(res.getInt("numero_commessa") + "/" + res.getInt("anno_commessa"));
                this.setDbCommessa(res.getString("db_commessa"));
                this.setCosto_al_litro(new Money(res.getDouble("costo_al_litro")));
                this.setCosto_totale(new Money(res.getDouble("costo_totale")));
                this.setKm_percorsi(res.getInt("km_percorsi"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Gasolio non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_dettagli() {
        this.setDas(new DAS());
        String w = " WHERE id=" + this.getId_das() + " ";
        this.getDas().selezionaDAS(w);
    }

    public boolean elimina(boolean da_solo) {
        String query_del;
        boolean r_del;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE FROM mtra_gasolio WHERE id=" + this.getId() + ""))) {
            MyTrace.log.severe("Elimina Gasolio non riuscita");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_gasolio','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina Gasolio non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public Money ultimo_costo_acquisto(String data) {
        String where = " WHERE costo_al_litro!=0  AND data_movimento<='" + data + "' " + " order by data_movimento desc limit 1";
        this.seleziona(where);
        Money ulltimo_costo_acquisto = this.getCosto_al_litro();
        return ulltimo_costo_acquisto;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getQuantita();
                break;
            }
            case 1: {
                retVal = "" + this.fda.gira_data(this.getData_movimento());
                break;
            }
            case 2: {
                if (this.getQuantita().isMinus()) {
                    retVal = "" + this.getTarga();
                    break;
                }
                retVal = "";
                break;
            }
            case 3: {
                if (this.getNum_doc() == null) {
                    retVal = "";
                    break;
                }
                retVal = "" + this.getNum_doc();
                break;
            }
            case 4: {
                if (this.getNumero_fattura() == null) {
                    retVal = "";
                    break;
                }
                retVal = "" + this.getNumero_fattura();
                break;
            }
            case 5: {
                if (this.getQuantita().isPlus()) {
                    retVal = "" + this.getStringa_fornitore();
                    break;
                }
                retVal = "";
                break;
            }
            case 6: {
                if (!this.getCosto_al_litro().isZero()) {
                    retVal = this.f.formattaNumero("" + this.getCosto_al_litro());
                    break;
                }
                retVal = "";
                break;
            }
            case 7: {
                if (!this.getCosto_totale().isZero()) {
                    retVal = this.f.formattaNumero("" + this.getCosto_totale());
                    break;
                }
                retVal = "";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

