/*
 * Decompiled with CFR 0.152.
 */
package anagrafiche.dipendenti;

import anagrafiche.dipendenti.AnagDipendenti;
import anagrafiche.dipendenti.AnagDipendentiFixedModel;
import anagrafiche.dipendenti.AnagDipendentiTableModel;
import anagrafiche.dipendenti.InsiemeAnagDipendenti;
import controlling.regole.MyRegole;
import edilizia.rapportino.MyRapportino;
import gestionale.MyDesktopWindow;
import gestionale.cap.CAP;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.ore_costo_personale.InsiemeOreCosto;
import gestionale.ore_costo_personale.OreCostiTableModel;
import gestionale.ore_costo_personale.OreCostoPersonale;
import gestionale.ore_impiego_personale.MyReportOrePersonale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import utils.FixedTable;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.GenericTableRenderer;
import utils.Money;
import utils.MyTrace;
import utils.PanelElenco;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;

public class MyAnagDipendenti
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    PanelElenco p_dipendenti;
    JTable jTableDipendenti;
    FixedTable fixedTable;
    AnagDipendentiTableModel dtm;
    AnagDipendentiFixedModel dfm;
    public InsiemeAnagDipendenti insieme_d;
    private TableRowSorter<AnagDipendentiTableModel> sorter;
    RowFilter<AnagDipendentiTableModel, Object> rf = null;
    ArrayList<RowFilter<AnagDipendentiTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    public AnagDipendenti d_selezione;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    public JInternalFrame chiamante;
    public int row_chiamante;
    public boolean f_centri_r = false;
    OreCostiTableModel octm;
    int riga_sel = 1000;
    private JButton jButtonAddOP;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JButton jButtonEliminaOP;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JComboBox jComboLoc;
    private JLabel jLabel1;
    private JLabel jLabelCF;
    private JLabel jLabelCF1;
    private JLabel jLabelCF2;
    private JLabel jLabelCodice;
    private JLabel jLabelCodiceBarreProdotto;
    private JLabel jLabelFax;
    private JLabel jLabelIndirizzo;
    private JLabel jLabelNote;
    private JLabel jLabelTel;
    private JLabel jLabelVia;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    public JTable jTableCostiPersonale;
    private JTextField jTextCF;
    private JTextField jTextCap;
    private JTextField jTextCognome;
    private JTextField jTextEmail;
    private JTextField jTextFax;
    private JTextField jTextIndirizzo;
    private JTextField jTextNome;
    private JTextArea jTextNote;
    private JTextField jTextProvincia;
    private JTextField jTextTel;
    private JToolBar jToolBar1;
    private JToolBar jToolBar3;

    public MyAnagDipendenti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("ANAG_Anagrafica_Visualizza")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.octm = new OreCostiTableModel();
        this.addInternalFrameListener(this);
        this.initComponents();
        this.dtm = new AnagDipendentiTableModel();
        this.insieme_d = new InsiemeAnagDipendenti();
        this.jTableDipendenti = new JTable(this.dtm);
        this.dfm = new AnagDipendentiFixedModel();
        this.dfm.setFIXED_NUM(0);
        this.fixedTable = new FixedTable(this.dfm);
        this.p_dipendenti = new PanelElenco(this.jTableDipendenti, this.fixedTable);
        this.sorter = new TableRowSorter<AnagDipendentiTableModel>(this.dtm);
        for (int i = 0; i < this.dtm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.jTableDipendenti.setRowSorter(this.sorter);
        ListSelectionModel listSelectionModel = this.jTableDipendenti.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.jTableDipendenti.addMouseListener(this);
        this.jPanelElenco.add((Component)this.p_dipendenti, "Center");
        this.crea_toolbar();
        this.filtra();
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(660, 300)));
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("ANAG_Anagrafica_Modifica")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    public void visualizzazione() {
        try {
            this.jTextNome.setEnabled(this.in_modifica);
            this.jTextCognome.setEnabled(this.in_modifica);
            this.jTextIndirizzo.setEnabled(this.in_modifica);
            this.jTextCap.setEnabled(this.in_modifica);
            this.jTextFax.setEnabled(this.in_modifica);
            this.jTextTel.setEnabled(this.in_modifica);
            this.jComboLoc.setEnabled(this.in_modifica);
            this.jTextEmail.setEnabled(this.in_modifica);
            this.jTextCF.setEnabled(this.in_modifica);
            this.jTextNote.setEnabled(this.in_modifica);
            this.jTableCostiPersonale.setEnabled(this.in_modifica);
            this.jButtonAddOP.setEnabled(this.in_modifica);
            this.jButtonEliminaOP.setEnabled(this.in_modifica);
            if (this.in_modifica) {
                this.getContentPane().remove(this.jToolBar1);
                this.getContentPane().add((Component)this.jToolBarMod, "North");
                this.jTabbedPane1.setEnabledAt(0, false);
            } else {
                this.getContentPane().remove(this.jToolBarMod);
                this.getContentPane().add((Component)this.jToolBar1, "North");
                this.jTabbedPane1.setEnabledAt(0, true);
            }
            this.getContentPane().validate();
            this.getContentPane().repaint();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyAnag.visualizzazione() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void formatta() {
        try {
            String[] toolTipStr = new String[]{"Nome e Cognome", "Codice Fiscale", "Telefono"};
            String[] withStr = new String[]{"300", "150", "*"};
            this.p_dipendenti.setTableHeader(toolTipStr, withStr);
            this.jTableDipendenti.setDefaultRenderer(Object.class, new GenericTableRenderer());
            this.fixedTable.setRowHeight(30);
            this.fixedTable.setDefaultEditor(String.class, new TextEditor());
            this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            this.jTableDipendenti.addMouseListener(this);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyAnagDipendenti.formatta() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void header_tebella() {
    }

    public void formatta_dettagli() {
        this.jTableCostiPersonale.setRowHeight(27);
        this.jTableCostiPersonale.setDefaultEditor(Object.class, new TextInsertEditor());
        this.jTableCostiPersonale.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        ListSelectionModel listSelectionModel3 = this.jTableCostiPersonale.getSelectionModel();
        listSelectionModel3.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row;
                MyAnagDipendenti.this.riga_sel = row = MyAnagDipendenti.this.jTableCostiPersonale.getSelectedRow();
            }
        });
    }

    public void filtra() {
        try {
            String w = " WHERE 1";
            String o = " ORDER BY anag_dipendenti.cognome asc ";
            if (Configurazioni.righe_ricerca != 0) {
                o = o + " LIMIT 0," + Configurazioni.righe_ricerca;
            }
            this.insieme_d.caricamento(w, o);
            this.dtm.setDataDipendenti(this.insieme_d.vettoreI);
            if (Configurazioni.righe_ricerca != 0 && this.insieme_d.vettoreI.size() >= Configurazioni.righe_ricerca) {
                this.non_tutte_le_righe = true;
            }
            this.formatta();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyAnagDipendenti.filtra() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void seleziona(int row) {
        try {
            this.d_selezione = new AnagDipendenti();
            this.d_selezione = (AnagDipendenti)this.insieme_d.vettoreI.elementAt(row);
            this.d_selezione.seleziona_dettagli();
            this.riempi_campi();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyAnagDipendenti.seleziona() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void riempi_campi() {
        try {
            this.jTextNome.setText(this.d_selezione.getNome());
            this.jTextCognome.setText(this.d_selezione.getCognome());
            this.jTextIndirizzo.setText(this.d_selezione.getIndirizzo());
            this.jTextFax.setText(this.d_selezione.getFax());
            this.jTextTel.setText(this.d_selezione.getTelefono());
            if (this.d_selezione.getCap() != null) {
                this.jTextCap.setText(this.d_selezione.getCap().getCap());
                this.d_selezione.getCap().seleziona_tutti(this.d_selezione.getCap().getCap());
                Iterator i = this.d_selezione.getCap().getArray_descrizione().iterator();
                while (i.hasNext()) {
                    this.jComboLoc.addItem((String)i.next());
                }
                this.jComboLoc.setSelectedItem(this.d_selezione.getLocalita());
                this.jTextProvincia.setText(this.d_selezione.getCap().getCd_provincia());
            }
            this.jTextEmail.setText(this.d_selezione.getEmail());
            this.jTextCF.setText(this.d_selezione.getCf());
            this.jTextNote.setText(this.d_selezione.getNote());
            this.octm = new OreCostiTableModel();
            this.octm.setDataOP(this.d_selezione.getInsieme_costi().vettoreOreCosto);
            this.jTableCostiPersonale.setModel(this.octm);
            this.formatta_dettagli();
            this.visualizzazione();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyRegole.riempi_campi() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void azzera() {
        try {
            this.jTextNome.setText("");
            this.jTextCognome.setText("");
            this.jTextIndirizzo.setText("");
            this.jTextCap.setText("");
            this.jComboLoc.removeAllItems();
            this.jTextProvincia.setText("");
            this.jTextFax.setText("");
            this.jTextTel.setText("");
            this.jTextEmail.setText("");
            this.jTextCF.setText("");
            this.jTextNote.setText("");
            this.octm = new OreCostiTableModel();
            this.jTableCostiPersonale.setModel(this.octm);
            this.formatta_dettagli();
            this.visualizzazione();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyAnagDipendenti.azzera() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void costruisci() {
        try {
            this.d_selezione.setNome(this.jTextNome.getText());
            this.d_selezione.setCognome(this.jTextCognome.getText());
            this.d_selezione.setIndirizzo(this.jTextIndirizzo.getText());
            this.d_selezione.setId_cap(this.f.id_cap(this.jTextCap.getText(), this.jComboLoc.getSelectedItem().toString()));
            this.d_selezione.setLocalita(this.jComboLoc.getSelectedItem().toString());
            this.d_selezione.setTelefono(this.jTextTel.getText());
            this.d_selezione.setFax(this.jTextFax.getText());
            this.d_selezione.setEmail(this.jTextEmail.getText());
            this.d_selezione.setCf(this.jTextCF.getText());
            this.d_selezione.setNote(this.jTextNote.getText());
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyAnagDipendenti.costruisci() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private boolean check() {
        if (this.jTextNome.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Nome della AnagDipendenti");
            return false;
        }
        if (this.jTextCognome.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Cognome della AnagDipendenti");
            return false;
        }
        return true;
    }

    private void stop_edit() {
        if (this.jTableCostiPersonale.getCellEditor() != null) {
            this.jTableCostiPersonale.getCellEditor().stopCellEditing();
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTextCognome = new JTextField();
        this.jLabelCodice = new JLabel();
        this.jLabelCF = new JLabel();
        this.jTextNome = new JTextField();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jTextCF = new JTextField();
        this.jLabelCF1 = new JLabel();
        this.jLabelIndirizzo = new JLabel();
        this.jTextIndirizzo = new JTextField();
        this.jLabelVia = new JLabel();
        this.jTextCap = new JTextField();
        this.jLabelCodiceBarreProdotto = new JLabel();
        this.jComboLoc = new JComboBox();
        this.jLabelNote = new JLabel();
        this.jTextProvincia = new JTextField();
        this.jLabelTel = new JLabel();
        this.jTextTel = new JTextField();
        this.jLabelFax = new JLabel();
        this.jTextFax = new JTextField();
        this.jLabelCF2 = new JLabel();
        this.jTextEmail = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextNote = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTableCostiPersonale = new JTable(this.octm);
        this.jToolBar3 = new JToolBar();
        this.jButtonAddOP = new JButton();
        this.jButtonEliminaOP = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Anagrafica \\ Dipendenti");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyAnagDipendenti.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyAnagDipendenti.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jTextCognome.setMinimumSize(new Dimension(150, 30));
        this.jTextCognome.setPreferredSize(new Dimension(200, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel2.add((Component)this.jTextCognome, gridBagConstraints);
        this.jLabelCodice.setText("Cognome");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabelCodice, gridBagConstraints);
        this.jLabelCF.setText("Nome");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabelCF, gridBagConstraints);
        this.jTextNome.setMinimumSize(new Dimension(150, 30));
        this.jTextNome.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel2.add((Component)this.jTextNome, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jTextCF.setMinimumSize(new Dimension(200, 30));
        this.jTextCF.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCF, gridBagConstraints);
        this.jLabelCF1.setText("Codice Fiscale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF1, gridBagConstraints);
        this.jLabelIndirizzo.setText("Indirizzo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelIndirizzo, gridBagConstraints);
        this.jTextIndirizzo.setMinimumSize(new Dimension(200, 30));
        this.jTextIndirizzo.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextIndirizzo, gridBagConstraints);
        this.jLabelVia.setText("CAP");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelVia, gridBagConstraints);
        this.jTextCap.setMinimumSize(new Dimension(200, 30));
        this.jTextCap.setPreferredSize(new Dimension(80, 30));
        this.jTextCap.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyAnagDipendenti.this.jTextCapFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCap, gridBagConstraints);
        this.jLabelCodiceBarreProdotto.setText("Localit\u00e0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodiceBarreProdotto, gridBagConstraints);
        this.jComboLoc.setMinimumSize(new Dimension(71, 27));
        this.jComboLoc.setPreferredSize(new Dimension(170, 27));
        this.jComboLoc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MyAnagDipendenti.this.jComboLocItemStateChanged(evt);
            }
        });
        this.jComboLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jComboLocActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jComboLoc, gridBagConstraints);
        this.jLabelNote.setText("Provincia");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelNote, gridBagConstraints);
        this.jTextProvincia.setEditable(false);
        this.jTextProvincia.setEnabled(false);
        this.jTextProvincia.setMinimumSize(new Dimension(50, 27));
        this.jTextProvincia.setPreferredSize(new Dimension(50, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextProvincia, gridBagConstraints);
        this.jLabelTel.setText("Telefono");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelTel, gridBagConstraints);
        this.jTextTel.setMinimumSize(new Dimension(200, 30));
        this.jTextTel.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextTel, gridBagConstraints);
        this.jLabelFax.setText("Fax");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelFax, gridBagConstraints);
        this.jTextFax.setMinimumSize(new Dimension(200, 30));
        this.jTextFax.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextFax, gridBagConstraints);
        this.jLabelCF2.setText("Email");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF2, gridBagConstraints);
        this.jTextEmail.setMinimumSize(new Dimension(200, 30));
        this.jTextEmail.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextEmail, gridBagConstraints);
        this.jLabel1.setText("Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextNote.setColumns(20);
        this.jTextNote.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextNote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTabbedPane2.addTab("Anagrafica", this.jPanel3);
        this.jPanel1.setLayout(new BorderLayout());
        this.jTableCostiPersonale.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane4.setViewportView(this.jTableCostiPersonale);
        this.jPanel1.add((Component)this.jScrollPane4, "Center");
        this.jToolBar3.setRollover(true);
        this.jButtonAddOP.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddOP.setText("Aggiungi Riga");
        this.jButtonAddOP.setFocusable(false);
        this.jButtonAddOP.setHorizontalAlignment(11);
        this.jButtonAddOP.setVerticalTextPosition(3);
        this.jButtonAddOP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonAddOPActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonAddOP);
        this.jButtonEliminaOP.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-remove.png")));
        this.jButtonEliminaOP.setText("Elimina riga Selezionata");
        this.jButtonEliminaOP.setFocusable(false);
        this.jButtonEliminaOP.setVerticalTextPosition(3);
        this.jButtonEliminaOP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAnagDipendenti.this.jButtonEliminaOPActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonEliminaOP);
        this.jPanel1.add((Component)this.jToolBar3, "North");
        this.jTabbedPane2.addTab("Costo Orario", this.jPanel1);
        this.jPanelDettaglio.add((Component)this.jTabbedPane2, "Center");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        this.stop_edit();
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.d_selezione.inserisci(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.d_selezione.modifica(true);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableDipendenti.getSelectionModel().clearSelection();
        this.d_selezione = new AnagDipendenti();
        this.azzera();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questa AnagDipendenti?");
        if (res == 0) {
            this.d_selezione.elimina(true);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.dtm.getRowCount() != 0) {
            this.jTableDipendenti.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableDipendenti.getSelectedRow() > 0 && this.dtm.getRowCount() != 0) {
            this.jTableDipendenti.getSelectionModel().setSelectionInterval(this.jTableDipendenti.getSelectedRow() - 1, this.jTableDipendenti.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.dtm.getRowCount() != 0) {
            this.jTableDipendenti.getSelectionModel().setSelectionInterval(this.jTableDipendenti.getSelectedRow() + 1, this.jTableDipendenti.getSelectedRow() + 1);
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.dtm.getRowCount() != 0) {
            this.jTableDipendenti.getSelectionModel().setSelectionInterval(this.dtm.getRowCount() - 1, this.dtm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", ""};
            this.dfm.addRow(a_ric);
            this.p_dipendenti.addFilterTable();
            this.repaint();
        } else {
            this.in_filter = false;
            this.dfm.deleteRow();
            this.dfm = new AnagDipendentiFixedModel();
            this.fixedTable.setModel(this.dfm);
            this.sorter.setRowFilter(null);
            this.p_dipendenti.delFilterTable();
            this.repaint();
            this.formatta();
        }
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", ""};
            this.dfm = new AnagDipendentiFixedModel();
            this.fixedTable.setModel(this.dfm);
            this.dfm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.dtm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.repaint();
        }
        this.formatta();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jTextCapFocusLost(FocusEvent evt) {
        CAP c = new CAP();
        c.seleziona_tutti(this.jTextCap.getText());
        this.d_selezione.setCap(c);
        this.jComboLoc.removeAllItems();
        Iterator i = this.d_selezione.getCap().getArray_descrizione().iterator();
        while (i.hasNext()) {
            this.jComboLoc.addItem((String)i.next());
        }
        this.jTextProvincia.setText(this.d_selezione.getCap().getCd_provincia());
    }

    private void jComboLocItemStateChanged(ItemEvent evt) {
    }

    private void jComboLocActionPerformed(ActionEvent evt) {
    }

    private void jButtonAddOPActionPerformed(ActionEvent evt) {
        this.stop_edit();
        OreCostoPersonale temp = new OreCostoPersonale();
        temp.setId_anag_dipendenti(this.d_selezione.getIdAnag_dipendenti());
        temp.setData_da(this.fda.dataCorrente());
        temp.setData_a(this.fda.dataCorrente());
        temp.setC_orario(new Money(BigDecimal.ZERO));
        temp.setC_ore_extra(new Money(BigDecimal.ZERO));
        temp.setC_ci(new Money(BigDecimal.ZERO));
        temp.setC_trasferta(new Money(BigDecimal.ZERO));
        temp.setC_trasferta_extra(new Money(BigDecimal.ZERO));
        if (this.d_selezione.getInsieme_costi() == null || this.d_selezione.getInsieme_costi().vettoreOreCosto.isEmpty()) {
            this.d_selezione.setInsieme_costi(new InsiemeOreCosto());
        }
        this.d_selezione.getInsieme_costi().vettoreOreCosto.add(temp);
        this.octm.setDataOP(this.d_selezione.getInsieme_costi().vettoreOreCosto);
    }

    private void jButtonEliminaOPActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare la riga numero" + this.riga_sel + " selezionata?");
        if (res == 0) {
            OreCostoPersonale op_sel = this.d_selezione.getInsieme_costi().vettoreOreCosto.get(this.riga_sel);
            if (this.d_selezione.getInsieme_costi() == null) {
                this.d_selezione.setInsieme_costi(new InsiemeOreCosto());
            }
            this.d_selezione.getInsieme_costi_da_el().vettoreOreCosto.add(op_sel);
            this.d_selezione.getInsieme_costi().vettoreOreCosto.remove(op_sel);
            this.octm.setDataOP(this.d_selezione.getInsieme_costi().vettoreOreCosto);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyRegole().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableDipendenti.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableDipendenti.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.dtm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableDipendenti.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.dtm.getRowCount() - 1 && modelRow >= 0) {
                AnagDipendenti a = new AnagDipendenti();
                a = (AnagDipendenti)this.insieme_d.vettoreI.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyRapportino.class && ((MyRapportino)this.chiamante).f_personale_open) {
                        ((MyRapportino)this.chiamante).jTableOrePersonale.getCellEditor().getTableCellEditorComponent(((MyRapportino)this.chiamante).jTableOrePersonale, a.getCognome() + "_" + a.getNome(), false, this.row_chiamante, 0);
                        ((MyRapportino)this.chiamante).jTableOrePersonale.getCellEditor().stopCellEditing();
                        ((MyRapportino)this.chiamante).f_personale_open = false;
                    }
                    if (this.chiamante.getClass() == MyReportOrePersonale.class && ((MyReportOrePersonale)this.chiamante).f_dip_open) {
                        ((MyReportOrePersonale)this.chiamante).jTextDipendente.setText(a.getCognome());
                        ((MyReportOrePersonale)this.chiamante).f_dip_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyRapportino.class && ((MyRapportino)this.chiamante).f_personale_open) {
                ((MyRapportino)this.chiamante).f_materiale_open = false;
            }
            if (this.chiamante.getClass() == MyReportOrePersonale.class && ((MyReportOrePersonale)this.chiamante).f_dip_open) {
                ((MyReportOrePersonale)this.chiamante).f_dip_open = false;
            }
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<AnagDipendentiTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            MyAnagDipendenti.this.d_selezione = new AnagDipendenti();
            if (!MyAnagDipendenti.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyAnagDipendenti.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyAnagDipendenti.this.rf = RowFilter.andFilter(MyAnagDipendenti.this.andFilters);
                MyAnagDipendenti.this.sorter.setRowFilter(MyAnagDipendenti.this.rf);
                MyAnagDipendenti.this.formatta();
            } else {
                String query = " WHERE 1 ";
                if (col == 0) {
                    query = query + " AND (cognome LIKE '%" + this.tf.getText() + "%' OR nome LIKE '%" + this.tf.getText() + "%') ";
                }
                if (col == 1) {
                    query = query + " AND cf LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND telefono LIKE '%" + this.tf.getText() + "%'";
                }
                String order_by = " ORDER BY anag_dipendenti.cognome ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyAnagDipendenti.this.insieme_d.caricamento(query, order_by);
                MyAnagDipendenti.this.dtm.setDataDipendenti(MyAnagDipendenti.this.insieme_d.vettoreI);
                MyAnagDipendenti.this.formatta();
            }
        }
    }
}

