/*
 * Decompiled with CFR 0.152.
 */
package utils.stampe;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import utils.stampe.OggettoToPrint;
import utils.stampe.Page;
import utils.stampe.Segnalibro;
import utils.stampe.Stringa;

public class Testo
extends OggettoToPrint {
    Graphics graphics;
    public String text;
    public Font font;
    FontMetrics fm;
    PageFormat pf;
    Color colore = Color.BLACK;
    int x = 0;
    int y = 0;

    public Testo(String text, Font font) {
        this.text = text;
        this.font = font;
    }

    public Testo(String text, Font font, Color colore) {
        this.text = text;
        this.font = font;
        this.colore = colore;
    }

    @Override
    int print(Segnalibro contesto) {
        contesto.graphics.setFont(this.font);
        this.fm = contesto.graphics.getFontMetrics();
        int rowHeight = this.fm.getHeight();
        if (contesto.currY == 0) {
            contesto.currY = rowHeight;
        }
        StringTokenizer st = new StringTokenizer(this.text, "\n", true);
        boolean emptyRow = true;
        while (st.hasMoreTokens()) {
            String currentRow = st.nextToken();
            if (currentRow.equals("\n")) {
                if (emptyRow) {
                    contesto.currY += rowHeight;
                    if (contesto.currY < 780) continue;
                    contesto.getMy_pj_corrente().getDummyBook().append(new Page((Vector)contesto.currentPage.clone(), contesto.gestore), contesto.pf);
                    contesto.currentPage.removeAllElements();
                    contesto.currY = rowHeight;
                    continue;
                }
                emptyRow = true;
                continue;
            }
            emptyRow = false;
            Enumeration rows = this.splitString(currentRow, contesto.xLimit).elements();
            while (rows.hasMoreElements()) {
                if (this.colore.equals(Color.BLACK)) {
                    contesto.currentPage.add(new Stringa((String)rows.nextElement(), this.font, (int)contesto.pf.getImageableX(), (int)contesto.pf.getImageableY() + contesto.currY));
                } else {
                    contesto.currentPage.add(new Stringa((String)rows.nextElement(), this.font, (int)contesto.pf.getImageableX(), (int)contesto.pf.getImageableY() + contesto.currY, this.colore));
                }
                contesto.currY += rowHeight;
                if (contesto.currY < 780) continue;
                contesto.getMy_pj_corrente().getDummyBook().append(new Page((Vector)contesto.currentPage.clone(), contesto.gestore), contesto.pf);
                contesto.currentPage.removeAllElements();
                contesto.currY = rowHeight;
            }
        }
        return contesto.currY;
    }

    private Vector splitString(String stringToSplit, int maxWidth) {
        Vector<String> result = new Vector<String>();
        if (maxWidth >= this.fm.stringWidth(stringToSplit)) {
            result.add(stringToSplit);
            return result;
        }
        StringTokenizer st = new StringTokenizer(stringToSplit, " ");
        String row = " ";
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (maxWidth > this.fm.stringWidth(row + word)) {
                row = row + word + " ";
            } else if (!row.equals("")) {
                result.add(row);
                row = word + " ";
            }
            if (maxWidth >= this.fm.stringWidth(word)) continue;
            char[] chars = word.toCharArray();
            row = "";
            for (int i = 0; i < chars.length; ++i) {
                if (maxWidth > this.fm.stringWidth(row + chars[i])) {
                    row = row + chars[i] + " ";
                    continue;
                }
                result.add(row);
                row = "" + chars[i] + " ";
            }
        }
        if (!row.equals("")) {
            result.add(row);
        }
        return result;
    }
}

