/*
 * Decompiled with CFR 0.152.
 */
package utils.stampe;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import utils.Funzioni;
import utils.MyTrace;
import utils.stampe.OggettoToPrint;
import utils.stampe.Segnalibro;

class GraficoOvunque
extends OggettoToPrint {
    int x;
    int y;
    int width;
    int height;
    int dimensione_ascissa;
    String titolo;
    String intestazioneX;
    String intestazioneY;
    JFreeChart chart;
    Rectangle2D rectangle2d_dimensione;
    Font Font_Calibri_18_B = new Font("Calibri", 1, 18);

    public GraficoOvunque(DefaultCategoryDataset dataset, int dimensione_ascissa, int x, int y, int width, int height, String titolo, String intestazioneX, String intestazioneY) {
        MyTrace.log.info("Costruttore Grafico Ovunque  " + this.toString() + " >>>> chiamato da:" + Funzioni.getCaller());
        try {
            this.height = height;
            this.width = width;
            this.x = x;
            this.y = y;
            this.intestazioneX = intestazioneX;
            this.intestazioneY = intestazioneY;
            this.titolo = titolo;
            this.dimensione_ascissa = dimensione_ascissa;
            this.rectangle2d_dimensione = new Rectangle2D.Double(this.x, this.y, this.width, this.height);
            MyTrace.log.info("Costruisco il grafico");
            this.chart = ChartFactory.createBarChart3D((String)("" + this.titolo), (String)("" + this.intestazioneX), (String)("" + this.intestazioneY), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            TextTitle texttitle = new TextTitle(this.titolo);
            texttitle.setFont(this.Font_Calibri_18_B);
            this.chart.setTitle(texttitle);
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE:  eccezione NELLA STAMPA  GRAFICO OVUNQUE");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
    }

    @Override
    int print(Segnalibro contesto) {
        contesto.currentPage.add(this);
        return contesto.currY;
    }

    @Override
    public void print(Graphics g, PageFormat pf, int pageIndex) {
        MyTrace.log.info("PRINT GRAFICO OVUNQUE  " + this.toString() + " >>>> chiamato da:" + Funzioni.getCaller());
        Graphics2D g2 = (Graphics2D)g;
        MyTrace.log.info("1) g2.getTrasform()  =" + g2.getTransform().toString());
        MyTrace.log.info("2) g2.getClipBounds()=" + g2.getClipBounds().toString());
        AffineTransform atprecedente = g2.getTransform();
        AffineTransform at = new AffineTransform(0.5, 0.0, 0.0, 0.5, 0.0, 0.0);
        g2.transform(at);
        MyTrace.log.info("2) g2.getTrasform()=" + g2.getTransform().toString());
        this.rectangle2d_dimensione = new Rectangle2D.Double(this.x * 2, this.y * 2, this.width * 2, this.height * 2);
        this.chart.draw(g2, this.rectangle2d_dimensione);
        g2.setTransform(atprecedente);
        MyTrace.log.info("PRINT  FINE");
    }
}

