/*
 * Decompiled with CFR 0.152.
 */
package utils.stampe;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import javax.swing.JEditorPane;
import javax.swing.text.View;
import utils.Funzioni;
import utils.MyTrace;
import utils.stampe.OggettoToPrint;

public class EditorPane
extends OggettoToPrint {
    public JEditorPane jeditorPane;
    protected double pageEndY = 0.0;
    private double scala;
    private final Rectangle parte_del_pane_da_stampare;
    private final Rectangle rettangolo_della_pagina_entro_cui_stampare;

    EditorPane(JEditorPane jeditorPane, double scala, Rectangle parte_del_pane_da_stampare, Rectangle rettangolo_della_pagina_entro_cui_stampare) {
        this.jeditorPane = jeditorPane;
        this.scala = scala;
        this.parte_del_pane_da_stampare = parte_del_pane_da_stampare;
        this.rettangolo_della_pagina_entro_cui_stampare = rettangolo_della_pagina_entro_cui_stampare;
        System.out.println("XXXXXXXXXXXXXXXXXX:  ISTANZIATO  EditorPaneViaggio  :XXXXXXXXXXXXXXXX");
    }

    @Override
    public void print(Graphics graphics, PageFormat pf, int pageIndex) {
        MyTrace.log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO  print(Graphics graphics, PageFormat pf, int pageIndex)   della classe EditorPaneViaggio XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        MyTrace.log.info("EDTPANEV:                                                 pageIndex = " + pageIndex);
        MyTrace.log.info("EDTPANEV:               dimensioni della parte_del_pane_da_stampare = " + this.parte_del_pane_da_stampare.toString());
        MyTrace.log.info("EDTPANEV: dimensioni del rettangolo_della_pagina_entro_cui_stampare = " + this.rettangolo_della_pagina_entro_cui_stampare.toString());
        MyTrace.log.info("EDTPANEV:   jeditorPane.getMinimumSize() = " + this.jeditorPane.getMinimumSize().toString());
        MyTrace.log.info("EDTPANEV:          jeditorPane.getSize() = " + this.jeditorPane.getSize().toString());
        MyTrace.log.info("EDTPANEV: jeditorPane.getPreferredSize() = " + this.jeditorPane.getPreferredSize().toString());
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform atprecedente = graphics2D.getTransform();
        Shape clipprecedente = graphics2D.getClip();
        this.jeditorPane.validate();
        View rootView = this.jeditorPane.getUI().getRootView(this.jeditorPane);
        MyTrace.log.info("EDTPANEV:  SCALA = " + this.scala);
        graphics2D.scale(this.scala, this.scala);
        double moltiplicatore_scala = 1.0;
        if (this.scala != 0.0) {
            moltiplicatore_scala = 1.0 / this.scala;
        }
        graphics2D.setClip(this.rettangolo_della_pagina_entro_cui_stampare);
        graphics2D.setColor(Color.RED);
        graphics2D.setColor(Color.BLACK);
        try {
            rootView.paint(graphics2D, this.parte_del_pane_da_stampare);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione print() errore presumibilmente in rootView.paint per rendering anomalo!!");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        graphics2D.setColor(Color.GREEN);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setTransform(atprecedente);
        graphics2D.setClip(clipprecedente);
        MyTrace.log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  FINE  print(Graphics graphics, PageFormat pf, int pageIndex)   della classe EditorPaneViaggio XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    }

    protected boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0 && !view.getElement().getName().equalsIgnoreCase("td")) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null || !this.printView(graphics2D, childAllocation, childView = view.getView(i))) continue;
                pageExists = true;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY()) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    view.paint(graphics2D, allocation);
                } else if (allocation.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }
}

