/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import utils.Funzioni;
import utils.MyTrace;
import utils.Performance;

public class ZipFile {
    String file_in = "";
    String file_out = "";
    static final int BUFFER = 2048;

    public ZipFile(String nome_file_da_comprimere_completo_di_path) {
        this.file_in = nome_file_da_comprimere_completo_di_path;
        this.file_out = nome_file_da_comprimere_completo_di_path + ".zip";
        this.doCompressFile();
    }

    public ZipFile(String nome_file_da_comprimere_completo_di_path, String nome_file_compresso_completo_di_path) {
        this.file_in = nome_file_da_comprimere_completo_di_path;
        this.file_out = nome_file_compresso_completo_di_path;
        this.doCompressFile();
    }

    private void doCompressFile() {
        MyTrace.log.info("Compressione START");
        try {
            int byte_letti;
            File file = new File(this.file_in);
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fin);
            MyTrace.log.info("Aperto e  Preparato il file da comprimere: " + file);
            FileOutputStream fos = new FileOutputStream(this.file_out);
            BufferedOutputStream out = new BufferedOutputStream(fos);
            ZipOutputStream zout = new ZipOutputStream(out);
            zout.putNextEntry(new ZipEntry(file.getName()));
            MyTrace.log.info("Aperto e preparato il file compresso su cui scrivere : " + this.file_out);
            Performance p = new Performance("Compressione  di " + this.file_in + " in " + this.file_out);
            byte[] buffer = new byte[2048];
            while ((byte_letti = in.read(buffer)) >= 0) {
                zout.write(buffer, 0, byte_letti);
            }
            p.fine();
            in.close();
            zout.flush();
            zout.close();
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione doCompressFile() errore di istanziazione della configurazione ");
            ex.printStackTrace();
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: InviaEmail() doCompressFile di avvio o di linkaggio  ");
            err.printStackTrace();
        }
        MyTrace.log.info("Compressione END");
    }
}

