/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.logging.Level;
import utils.Funzioni;
import utils.MyTrace;

public final class Quantita
implements Comparable<Quantita>,
Serializable {
    private final MathContext APPROSSIMAZIONE_MASSIMA_PER_DIVISIONI = MathContext.DECIMAL32;
    private BigDecimal fAmount = BigDecimal.ZERO;
    private final RoundingMode fRounding;
    private static RoundingMode DEFAULT_ROUNDING;
    private final int fDecimali_nel_toSting;
    private static int DEFAULT_DECIMALI_TOSTRING;
    private int fHashCode;
    private static final int HASH_SEED = 23;
    private static final int HASH_FACTOR = 37;
    private static final long serialVersionUID = 7526471155622776147L;

    public static void init(int numero_decimali_default_per_toString, RoundingMode aDefaultRounding) {
        DEFAULT_ROUNDING = aDefaultRounding;
        DEFAULT_DECIMALI_TOSTRING = numero_decimali_default_per_toString;
    }

    public Quantita(BigDecimal aAmount, RoundingMode aRoundingStyle, int aDecimali_nel_toSting) {
        this.fAmount = aAmount;
        this.fRounding = aRoundingStyle;
        this.fDecimali_nel_toSting = aDecimali_nel_toSting;
        this.validateState();
    }

    public Quantita(String aAmount_in_Stringa, RoundingMode aRoundingStyle, int aDecimali_nel_toSting) {
        if (aAmount_in_Stringa == null) {
            MyTrace.log.severe("ERRORE:: VALORE Quantit\u00e0 NULLO!! controllare : " + aAmount_in_Stringa);
        } else if (aAmount_in_Stringa.isEmpty()) {
            MyTrace.log.severe("ERRORE:: VALORE Quantit\u00e0 VUOTO!! controllare" + aAmount_in_Stringa);
        }
        BigDecimal aAmount = this.Stringa_to_BigDecimal(aAmount_in_Stringa);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Quantit\u00e0 NULLO!! controllare : " + aAmount_in_Stringa);
        }
        this.fAmount = aAmount;
        this.fRounding = aRoundingStyle;
        this.fDecimali_nel_toSting = aDecimali_nel_toSting;
        this.validateState();
    }

    public Quantita(BigDecimal aAmount) {
        this(aAmount, DEFAULT_ROUNDING, DEFAULT_DECIMALI_TOSTRING);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Money NULLO!! controllare");
        }
    }

    public Quantita(BigDecimal aAmount, int aDecimali_nel_toSting) {
        this(aAmount, DEFAULT_ROUNDING, aDecimali_nel_toSting);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Money NULLO!! controllare");
        }
    }

    public Quantita(double aAmount) {
        this(new BigDecimal(Double.toString(aAmount)), DEFAULT_ROUNDING, DEFAULT_DECIMALI_TOSTRING);
    }

    public Quantita(double aAmount, int aDecimali_nel_toSting) {
        this(new BigDecimal(Double.toString(aAmount)), DEFAULT_ROUNDING, aDecimali_nel_toSting);
    }

    public Quantita(String aAmount_in_Stringa) {
        this(aAmount_in_Stringa, DEFAULT_ROUNDING, DEFAULT_DECIMALI_TOSTRING);
    }

    public Quantita(String aAmount_in_Stringa, int aDecimali_nel_toSting) {
        this(aAmount_in_Stringa, DEFAULT_ROUNDING, aDecimali_nel_toSting);
    }

    private BigDecimal Stringa_to_BigDecimal(String valore_in_stringa) {
        BigDecimal valore = null;
        try {
            valore = new BigDecimal(valore_in_stringa);
        }
        catch (Exception e) {
            MyTrace.log.log(Level.SEVERE, "ECCEZIONE: Costruttore Quantit\u00e0 con valore stringa anomalo ={0}", valore_in_stringa);
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            valore = new BigDecimal(BigInteger.ZERO);
        }
        return valore;
    }

    public Quantita(Quantita valore_da_copiare) {
        this(new BigDecimal(valore_da_copiare.getDoubleValue()), valore_da_copiare.getRoundingStyle(), valore_da_copiare.getNumRealDecimals());
    }

    public BigDecimal getAmount() {
        return this.fAmount;
    }

    public RoundingMode getRoundingStyle() {
        return this.fRounding;
    }

    public boolean isPlus() {
        return this.fAmount.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isMinus() {
        return this.fAmount.compareTo(BigDecimal.ZERO) < 0;
    }

    public boolean isZero() {
        return this.fAmount.compareTo(BigDecimal.ZERO) == 0;
    }

    public Quantita plus(Quantita aThat) {
        return new Quantita(this.fAmount.add(aThat.fAmount), this.fRounding, this.fDecimali_nel_toSting);
    }

    public void plusplus(Quantita aThat) {
        this.fAmount = this.fAmount.add(aThat.fAmount);
    }

    public Quantita minus(Quantita aThat) {
        return new Quantita(this.fAmount.subtract(aThat.fAmount), this.fRounding, this.fDecimali_nel_toSting);
    }

    public static Quantita sum(Collection<Quantita> aMoneys) {
        Quantita sum = new Quantita(BigDecimal.ZERO);
        for (Quantita money : aMoneys) {
            sum = sum.plus(money);
        }
        return sum;
    }

    public boolean eq(Quantita aThat) {
        return this.compareAmount(aThat) == 0;
    }

    public boolean gt(Quantita aThat) {
        return this.compareAmount(aThat) > 0;
    }

    public boolean gteq(Quantita aThat) {
        return this.compareAmount(aThat) >= 0;
    }

    public boolean lt(Quantita aThat) {
        return this.compareAmount(aThat) < 0;
    }

    public boolean lteq(Quantita aThat) {
        return this.compareAmount(aThat) <= 0;
    }

    public Quantita times(int aFactor) {
        BigDecimal factor = new BigDecimal(aFactor);
        BigDecimal newAmount = this.fAmount.multiply(factor);
        return new Quantita(newAmount, this.fRounding, this.fDecimali_nel_toSting);
    }

    public Quantita times(double aFactor) {
        BigDecimal newAmount = this.fAmount.multiply(this.asBigDecimal(aFactor));
        return new Quantita(newAmount, this.fRounding, this.fDecimali_nel_toSting);
    }

    public Quantita div(int aDivisor) {
        try {
            BigDecimal divisor = new BigDecimal(aDivisor);
            BigDecimal newAmount = this.fAmount.divide(divisor, this.APPROSSIMAZIONE_MASSIMA_PER_DIVISIONI);
            return new Quantita(newAmount, this.fRounding, this.fDecimali_nel_toSting);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE:A:  DIVISIONE PER ZERO");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return new Quantita(new BigDecimal(Long.MAX_VALUE), this.fRounding, this.fDecimali_nel_toSting);
        }
    }

    public Quantita div(double aDivisor) {
        try {
            BigDecimal newAmount = this.fAmount.divide(this.asBigDecimal(aDivisor), this.APPROSSIMAZIONE_MASSIMA_PER_DIVISIONI);
            return new Quantita(newAmount, this.fRounding, this.fDecimali_nel_toSting);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE:B:  DIVISIONE PER ZERO");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return new Quantita(new BigDecimal(Long.MAX_VALUE), this.fRounding, this.fDecimali_nel_toSting);
        }
    }

    public Quantita abs() {
        return this.isPlus() ? this : this.times(-1);
    }

    public Quantita negate() {
        return this.times(-1);
    }

    public String toString() {
        return this.fAmount.setScale(this.fDecimali_nel_toSting, RoundingMode.HALF_UP).toPlainString();
    }

    public String toString(int numero_massimo_di_decimali_voluto) {
        return this.fAmount.setScale(numero_massimo_di_decimali_voluto, RoundingMode.HALF_UP).toPlainString();
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Quantita)) {
            return false;
        }
        Quantita that = (Quantita)aThat;
        boolean result = this.fAmount.equals(that.fAmount);
        result = result && this.fRounding == that.fRounding;
        return result;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = 23;
            this.fHashCode = 37 * this.fHashCode + this.fAmount.hashCode();
            this.fHashCode = 37 * this.fHashCode + this.fRounding.hashCode();
        }
        return this.fHashCode;
    }

    @Override
    public int compareTo(Quantita aThat) {
        boolean EQUAL = false;
        if (this == aThat) {
            return 0;
        }
        int comparison = this.fAmount.compareTo(aThat.fAmount);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.fRounding.compareTo(aThat.fRounding);
        if (comparison != 0) {
            return comparison;
        }
        return 0;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.fAmount = new BigDecimal(this.fAmount.toPlainString());
        if (this.validateState() != 0) {
            MyTrace.log.severe("ANOMALIA: nella lettura di un Money dallo streaming con funzione readObject()");
        }
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    public int validateState() {
        if (this.fAmount == null) {
            MyTrace.log.severe("ERRORE: Il valore di Quantita non pu\u00f2 essere nullo");
            return 1;
        }
        return 0;
    }

    private int getNumRealDecimals() {
        return this.fAmount.scale();
    }

    private int compareAmount(Quantita aThat) {
        return this.fAmount.compareTo(aThat.fAmount);
    }

    private BigDecimal asBigDecimal(double aDouble) {
        String asString = Double.toString(aDouble);
        return new BigDecimal(asString);
    }

    public double getDoubleValue() {
        return this.fAmount.doubleValue();
    }

    public void arrotonda(int decimaliVoluti) {
        BigDecimal valore;
        this.fAmount = valore = this.fAmount.setScale(decimaliVoluti, RoundingMode.HALF_UP);
    }

    public BigDecimal getValueArrotondato(int decimaliVoluti) {
        return this.fAmount.setScale(decimaliVoluti, RoundingMode.HALF_UP);
    }

    public static final class MismatchedCurrencyException
    extends RuntimeException {
        MismatchedCurrencyException(String aMessage) {
            super(aMessage);
        }
    }
}

