/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import utils.BoldAction;
import utils.FontAndSizeAction;
import utils.ForegroundAction;
import utils.ItalicAction;
import utils.UnderlineAction;

public class PanelTesto
extends JPanel {
    public JScrollPane scrollPane;
    public JToolBar jToolBar2;
    public Action boldAction;
    public Action underlineAction;
    public Action italicAction;
    public Action foregroundAction;
    public Action formatTextAction;
    public Action[] actions;
    public Action pasteAction;
    public Action leftAction;
    public Action rightAction;
    public Action centerAction;
    public Action elencoPAction;
    JEditorPane jTextModello;

    public PanelTesto() {
        this.setLayout(new BorderLayout());
        this.jTextModello = new JEditorPane();
        this.jTextModello.setContentType("text/html");
        this.jTextModello.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        ((HTMLDocument)this.jTextModello.getDocument()).setPreservesUnknownTags(false);
        this.scrollPane = new JScrollPane(this.jTextModello);
        this.scrollPane.setMinimumSize(new Dimension(300, 200));
        this.jToolBar2 = new JToolBar();
        this.boldAction = new BoldAction();
        this.boldAction.putValue("Name", "Bold");
        JButton b_bold = this.jToolBar2.add(this.boldAction);
        b_bold.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/format-text-bold.png")));
        this.underlineAction = new UnderlineAction();
        this.underlineAction.putValue("Name", "Underline");
        JButton b_underline = this.jToolBar2.add(this.underlineAction);
        b_underline.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/format-text-underline.png")));
        this.italicAction = new ItalicAction();
        this.italicAction.putValue("Name", "Italic");
        JButton b_italic = this.jToolBar2.add(this.italicAction);
        b_italic.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/format-text-italic.png")));
        this.foregroundAction = new ForegroundAction();
        this.foregroundAction.putValue("Name", "Color");
        JButton b_color = this.jToolBar2.add(this.foregroundAction);
        b_color.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/applications-graphics.png")));
        this.formatTextAction = new FontAndSizeAction();
        this.formatTextAction.putValue("Name", "Font and Size");
        JButton b_font = this.jToolBar2.add(this.formatTextAction);
        b_font.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-desktop-font.png")));
        Hashtable<Object, Action> commands = new Hashtable<Object, Action>();
        this.actions = this.jTextModello.getActions();
        for (int i = 0; i < this.actions.length; ++i) {
            Action a = this.actions[i];
            commands.put(a.getValue("Name"), a);
        }
        this.pasteAction = (AbstractAction)commands.get("paste-from-clipboard");
        JButton button = this.jToolBar2.add(this.pasteAction);
        button.setText("Paste");
        button.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-paste.png")));
        this.leftAction = (AbstractAction)commands.get("left-justify");
        JButton buttonLeft = this.jToolBar2.add(this.leftAction);
        buttonLeft.setText("Left");
        buttonLeft.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/format-justify-left.png")));
        this.rightAction = (AbstractAction)commands.get("right-justify");
        JButton buttonRight = this.jToolBar2.add(this.rightAction);
        buttonRight.setText("Right");
        buttonRight.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/format-justify-right.png")));
        this.centerAction = (AbstractAction)commands.get("center-justify");
        JButton buttonCenter = this.jToolBar2.add(this.centerAction);
        buttonCenter.setText("Center");
        buttonCenter.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/format-justify-center.png")));
        this.elencoPAction = (AbstractAction)commands.get("InsertUnorderedList");
        JButton buttonList = this.jToolBar2.add(this.elencoPAction);
        buttonList.setText("Elenco Puntato");
        buttonList.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/Preferences16.gif")));
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.jToolBar2, "North");
        this.jTextModello.setSelectionStart(0);
    }

    public void setText(String testo) {
        try {
            this.jTextModello.setText(testo);
            this.jTextModello.setSelectionStart(testo.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getText() {
        return this.jTextModello.getText().replaceAll("'", "''").replaceAll("\n", "<br/>");
    }

    public void setEditable(boolean value) {
        this.jTextModello.setEditable(value);
    }

    public void abilita_disabilita_pulsanti(boolean value) {
        this.boldAction.setEnabled(value);
        this.centerAction.setEnabled(value);
        this.elencoPAction.setEnabled(value);
        this.foregroundAction.setEnabled(value);
        this.formatTextAction.setEnabled(value);
        this.italicAction.setEnabled(value);
        this.leftAction.setEnabled(value);
        this.pasteAction.setEnabled(value);
        this.rightAction.setEnabled(value);
        this.underlineAction.setEnabled(value);
        this.underlineAction.setEnabled(value);
    }

    public JEditorPane getjTextModello() {
        return this.jTextModello;
    }

    public void addText(String text) {
        HTMLDocument doc = (HTMLDocument)this.getjTextModello().getDocument();
        int pos = this.jTextModello.getCaretPosition();
        Element e = doc.getParagraphElement(pos);
        try {
            doc.insertBeforeEnd(e, text);
        }
        catch (Throwable bl) {
            // empty catch block
        }
        this.jTextModello.setDocument(doc);
    }
}

