/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import utils.Funzioni;
import utils.MyTrace;
import utils.MyTraceFormatter;

public class MyTrace_buffered
extends Thread {
    public static Logger log = Logger.getLogger("global");
    private StreamHandler sh;
    private BufferedOutputStream bufout;
    private PrintStream out;

    public MyTrace_buffered() {
        log = Logger.getLogger("global");
        Level livello_trace = Level.FINER;
        log.setLevel(Level.FINEST);
        String Sistema = "";
        String log_file = "";
        try {
            String user_home = System.getProperty("user.home") + System.getProperty("file.separator") + "Desktop";
            log_file = System.getProperty("java.logger.logDir", user_home) + System.getProperty("file.separator") + this.getClass().getName() + ".wri";
            this.bufout = new BufferedOutputStream(new FileOutputStream(log_file));
            this.out = new PrintStream(this.bufout);
            this.sh = new StreamHandler(this.out, new MyTraceFormatter());
            Handler[] handlers = log.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                log.removeHandler(handlers[i]);
            }
            log.addHandler(this.sh);
            Sistema = "Sistema " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        }
        catch (IOException ioe) {
            Funzioni.LogStackTrace(ioe);
            System.out.println(ioe.toString());
        }
        log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX START XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        log.info(Sistema);
        log.info("Aperto il file di log: " + log_file);
        log.setLevel(livello_trace);
        log.info("LIVELLO DI TRACCIAMENTO=" + livello_trace.toString());
        this.start();
    }

    public void flush() {
        try {
            this.out.flush();
            this.bufout.flush();
        }
        catch (IOException ex) {
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }

    @Override
    public void run() {
        log.info("START THREAD per Flush del LOGGER ");
        boolean in_esecuzione = true;
        while (in_esecuzione) {
            try {
                this.flush();
                log.info("Flush del LOGGER");
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                MyTrace.log.severe("ERRORE Eccezione su di un trhead del MyTrace");
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        }
    }
}

