/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import utils.Funzioni;
import utils.MyTrace;

public class MyTraceFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        String stringaformattata = "";
        try {
            Date time = new Date(record.getMillis());
            SimpleDateFormat formattazione = new SimpleDateFormat("yyyy:MM:dd-hh:mm:ss");
            String time_formattato = formattazione.format(time);
            stringaformattata = "[" + time_formattato + "] ";
            stringaformattata = stringaformattata + "|" + String.format("%1$-7s", record.getLevel().toString()) + "| ";
            stringaformattata = stringaformattata + "{" + String.format("%1$-25s", record.getSourceClassName()) + "} ";
            stringaformattata = stringaformattata + "(" + String.format("%1$-20s", record.getSourceMethodName()) + ") ";
            stringaformattata = stringaformattata + "<" + String.format("%1$-40s", record.getMessage()) + "> ";
            stringaformattata = stringaformattata + ":" + record.getThreadID() + ": ";
            stringaformattata = stringaformattata + "\r\n";
        }
        catch (Exception err) {
            MyTrace.log.severe("MyTraceFormatter format() ECCEZIONE");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        return stringaformattata;
    }

    @Override
    public String formatMessage(LogRecord record) {
        return "XXXX";
    }
}

