/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.configurazioni.Configurazioni;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import utils.Funzioni;
import utils.MyTraceFormatter;

public class MyTrace
extends Thread {
    static String log_file = "";
    public static Logger log = Logger.getLogger("global");
    private static Level livello_minimo_tracciato;
    private static FileHandler fh;

    public MyTrace() {
        livello_minimo_tracciato = Level.FINER;
        String Sistema = "";
        try {
            log_file = Funzioni.CartellaPerTrace() + System.getProperty("file.separator") + this.getClass().getName();
            fh = new FileHandler(log_file + ".%g.trace", 10000000, 5, true);
            Handler[] handlers = log.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                log.removeHandler(handlers[i]);
            }
            Sistema = "Sistema " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        }
        catch (IOException e) {
            System.out.println(e.toString());
            log.severe("ERRORE: Eccezione");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        log.addHandler(fh);
        fh.setFormatter(new MyTraceFormatter());
        String Original_Encoding = fh.getEncoding();
        try {
            fh.setEncoding("latin1");
        }
        catch (Exception ex) {
            log.severe("ECCEZIONE:  (errato charset nel trace (contattare Kronos S.r.l.)");
        }
        log.setLevel(livello_minimo_tracciato);
        log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX START  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX OLIMPO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX START  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        log.config("Aperto il file di log: " + log_file + ".0.trace");
        log.config("Encoding Originario = " + Original_Encoding + " sostituito con  latin1");
        log.config("LIVELLO DI TRACCIAMENTO=" + livello_minimo_tracciato.toString());
        log.config(Sistema);
        log.config("OLIMPO versioneSoftware = " + Configurazioni.versioneSoftware);
        log.config("Java    = " + System.getProperty("java.version") + " " + System.getProperty("java.vendor"));
        log.config("Java VM = " + System.getProperty("java.vm.specification.name") + " " + System.getProperty("java.vm.specification.version"));
        log.config("Java VM = " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        log.config("Utente  = " + System.getProperty("user.name") + " home=" + System.getProperty("user.home") + " curr_dir=" + System.getProperty("user.dir"));
        log.finest("java CP = " + System.getProperty("java.class.path") + " library_path=" + System.getProperty("java.library.path") + " java_home=" + System.getProperty("java.home"));
        log.info("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    }

    public static void setLivello_minimo_tracciato(Level livello_minimo_tracciato) {
        MyTrace.livello_minimo_tracciato = livello_minimo_tracciato;
        log.setLevel(livello_minimo_tracciato);
        log.info("LIVELLO DI TRACCIAMENTO = " + livello_minimo_tracciato.toString());
    }

    public static void setLivello_minimo_tracciato(String livello_minimo_tracciato_string) {
        log.info("LIVELLO DI TRACCIAMENTO RICHIESTO = " + livello_minimo_tracciato_string);
        livello_minimo_tracciato = Level.parse(livello_minimo_tracciato_string);
        log.setLevel(livello_minimo_tracciato);
        log.info("LIVELLO DI TRACCIAMENTO IMPOSTATO = " + livello_minimo_tracciato.toString());
    }
}

