/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.MyDesktopWindow;
import gestionale.MyMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.Risorse;

public class MyStatusBar
extends JPanel {
    public JLabel label;
    public JLabel utente;
    JButton button_finestre;
    Vector finestre;
    private JPopupMenu popup;
    JDesktopPane desktop;
    JInternalFrame[] array_di_finestre;
    MyDesktopWindow dw;
    int height = 0;
    boolean menu_aperto = false;
    private Timer timeout = null;
    private JLabel immagine_working;

    public MyStatusBar(int w, MyDesktopWindow dw) {
        this.dw = dw;
        this.label = new JLabel();
        this.label.setForeground(new Color(0, 0, 0));
        this.label.setBackground(new Color(217, 217, 217));
        this.label.setFont(new Font("Tahoma", 0, 9));
        this.label.setBorder(BorderFactory.createEtchedBorder(0));
        this.label.setVisible(true);
        this.label.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/internet-group-chat.png")));
        this.label.setHorizontalAlignment(2);
        this.setMessage("Ready");
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.add((Component)this.label, new AbsoluteConstraints(230, 0, -1, -1));
        this.button_finestre = new JButton();
        this.button_finestre.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/win.jpg")));
        this.button_finestre.setText("");
        this.button_finestre.setSize(new Dimension(30, 20));
        this.button_finestre.setToolTipText("Finestre aperte");
        this.button_finestre.setBorder(BorderFactory.createBevelBorder(0, null, new Color(0, 0, 102), null, null));
        this.button_finestre.setFocusable(false);
        this.button_finestre.setHorizontalTextPosition(0);
        this.button_finestre.setVerticalTextPosition(3);
        this.button_finestre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrace.log.info("Evento >" + evt.toString());
                MyStatusBar.this.jButtonFinestreActionPerformed(evt);
            }
        });
        this.add((Component)this.button_finestre, new AbsoluteConstraints(0, 0, -1, -1));
        this.utente = new JLabel();
        this.utente.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/system-users.png")));
        this.add((Component)this.utente, new AbsoluteConstraints(30, 0, -1, -1));
        FunzioniDate fda = new FunzioniDate();
        JLabel data = new JLabel(fda.gira_data(fda.dataCorrente()));
        data.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/office-calendar.png")));
        this.add((Component)data, new AbsoluteConstraints(800, 0, -1, -1));
        this.finestre = new Vector();
        this.popup = new JPopupMenu();
        this.desktop = dw.myDesktopPane;
        this.immagine_working = new JLabel("STATUS IDLE");
        Risorse risorse = Risorse.puntatore;
        this.immagine_working.setIcon(risorse.icona_elabora);
        this.add((Component)this.immagine_working, new AbsoluteConstraints(1000, 0, -1, -1));
        this.immagine_working.setDisabledIcon(risorse.icona_fulmine);
        this.immagine_working.setEnabled(false);
    }

    public void riempi_campi() {
        this.utente.setText(MyDesktopWindow.profilo.cognome + " " + MyDesktopWindow.profilo.nome);
    }

    private void jButtonFinestreActionPerformed(ActionEvent evt) {
        if (!this.menu_aperto) {
            this.array_di_finestre = null;
            this.popup.removeAll();
            this.array_di_finestre = this.desktop.getAllFrames();
            int size = this.array_di_finestre.length;
            if (size != 0) {
                for (int i = 0; i < size; ++i) {
                    JMenuItem popupItem = new JMenuItem(this.array_di_finestre[i].getTitle());
                    popupItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            String title = ((JMenuItem)evt.getSource()).getText();
                            MyTrace.log.info("Porto avanti la finestra >" + title);
                            MyStatusBar.this.porta_avanti(title);
                            MyStatusBar.this.popup.setVisible(false);
                            MyStatusBar.this.menu_aperto = false;
                        }
                    });
                    this.popup.add(popupItem);
                }
                int h = this.array_di_finestre.length * 25;
                this.desktop.add(this.popup);
                this.popup.setLocation(5, this.desktop.getHeight() + 60 - h);
                this.popup.setVisible(true);
                this.menu_aperto = true;
            }
        } else {
            this.popup.setVisible(false);
            this.menu_aperto = false;
        }
    }

    public void setMessage(String message) {
        this.label.setText("");
        this.label.setText(message);
    }

    public void SetWorking(boolean sta_lavorando) {
        if (sta_lavorando) {
            MyTrace.log.info("STATUS WORKING");
            this.immagine_working.setEnabled(true);
            this.immagine_working.setName("L'applicazione sta elaborando una richiesta che richiede tempo e per questo potrebbe rispondere lentamente ad ulteriori richieste.");
            this.immagine_working.setText("STATUS WORKING");
            this.timeout = new Timer(30000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyStatusBar.this.immagine_working.setEnabled(false);
                    MyStatusBar.this.immagine_working.setName("L'applicazione \u00e8 libero e risponde velocemente alle richieste utente");
                    MyStatusBar.this.immagine_working.setText("STATUS TIMEOUT");
                }
            });
            this.timeout.setRepeats(false);
            this.timeout.start();
        } else {
            MyTrace.log.info("STATUS IDLE");
            if (this.timeout != null) {
                this.timeout.stop();
                this.timeout = null;
            }
            this.immagine_working.setEnabled(false);
            this.immagine_working.setName("L'applicazione \u00e8 libero e risponde velocemente alle richieste utente");
            this.immagine_working.setText("STATUS IDLE");
            this.immagine_working.invalidate();
        }
    }

    private void porta_avanti(String titolo) {
        int size = this.array_di_finestre.length;
        for (int i = 0; i < size; ++i) {
            String local = this.array_di_finestre[i].getTitle();
            if (!titolo.equals(local)) continue;
            try {
                this.array_di_finestre[i].setIcon(false);
            }
            catch (PropertyVetoException ex) {
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
                Logger.getLogger(MyStatusBar.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.array_di_finestre[i].moveToFront();
        }
    }

    public void chiudiTutteLeFinestre() {
        JInternalFrame[] frame = this.desktop.getAllFrames();
        if (frame.length != 0) {
            for (int i = 0; i < frame.length; ++i) {
                if (!(frame[i] instanceof JInternalFrame) || frame[i] instanceof MyMenu) continue;
                frame[i].dispose();
            }
        }
    }
}

