/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.configurazioni.ConfigurazioneIni;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.ProfiloUtente;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import utils.Connessione;
import utils.Funzioni;
import utils.FunzioniDiritti;
import utils.MyTrace;
import utils.SysSessioneUtente;
import utils.ZipFile;

public class MySQLDump {
    private String hostname;
    private static String MySQLDump_Version = "1.0";
    private String schema = null;
    private String utente_connesso = null;
    private Connection conn = null;
    private int databaseProductMajorVersion = 0;
    private int databaseProductMinorVersion = 0;
    private Connessione connessione = null;
    private BufferedWriter outStream;
    protected static final byte[] Hexhars = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public MySQLDump() {
        System.out.println("CHIAMATA ERRATA");
    }

    public MySQLDump(Connessione connessione) {
        try {
            this.connessione = connessione;
            this.schema = this.connessione.nomeDB;
            this.databaseProductMajorVersion = this.connessione.getDatabaseMetaData().getDatabaseMajorVersion();
            this.databaseProductMinorVersion = this.connessione.getDatabaseMetaData().getDatabaseMinorVersion();
            this.utente_connesso = this.connessione.nomeUtente;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE: all'istanziazione di MuSQLDump Kronos");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }

    public void Schema_dumpAll_CompletoConDati() {
        try {
            MyTrace.log.info("START DUMP COMPLETO CON DATI");
            this.outStream.write(this.intestazioni_Versioni_e_Parametri());
            this.outStream.write(this.Schema_dumpCreate());
            this.outStream.write(this.intestazioni_Separatore());
            this.outStream.write(this.intestazioni_START_dump());
            this.outStream.write(this.intestazioni_Separatore());
            this.Tables_dumpAll(this.outStream);
            this.outStream.write(this.intestazioni_Separatore());
            this.Views_dumpAll(this.outStream);
            this.outStream.write(this.intestazioni_Separatore());
            this.Routine_dumpAll(this.outStream);
            this.outStream.write(this.intestazioni_Separatore());
            this.outStream.write(this.intestazioni_END_dump());
            this.outStream.write(this.intestazioni_Separatore());
            this.outStream.write("\n-- fine backup archivio --");
            MyTrace.log.info("END DUMP COMPLETO CON DATI");
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpAll_SchemaCompletoConDati!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public String Schema_dumpCreate() {
        String createDatabase = "\n\n--\n-- create struttura per il  database = `" + this.connessione.nomeDB + "`\n--\n\n";
        ResultSet res = null;
        try {
            String query = "SHOW CREATE   DATABASE   IF NOT EXISTS " + this.connessione.nomeDB;
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                createDatabase = createDatabase + res.getString("Create Database") + ";\n";
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpCreateDatabase!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            createDatabase = "";
        }
        this.connessione.ChiudiResultSet(res);
        createDatabase = createDatabase + "\nUSE  `" + this.connessione.nomeDB + "`;\n";
        return createDatabase;
    }

    public void Tables_dumpAll(BufferedWriter out) {
        ResultSet res = null;
        MyTrace.log.info("MySQLDump: Eseguo dumpAllTables");
        try {
            String query = "show full tables where Table_Type = 'BASE TABLE'";
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                String tableName = res.getString(1);
                out.write(this.Table_dumpCreate(tableName));
                this.Table_dumpDati(out, tableName);
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpAllTables!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        this.connessione.ChiudiResultSet(res);
    }

    public String dumpCreateEvent(String schema, String event) {
        ResultSet res = null;
        String createEvent = "--\n-- Event structure for event `" + event + "`\n--\n\n";
        try {
            String query = "SHOW CREATE EVENT " + this.connessione.nomeDB + "." + event;
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                createEvent = createEvent + res.getString("Create Event") + ";";
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpCreateEvent!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            createEvent = "";
        }
        this.connessione.ChiudiResultSet(res);
        return createEvent;
    }

    public String Table_dumpCreate(String nome_tabella) {
        ResultSet res = null;
        MyTrace.log.info("MySQLDump: Eseguo dumpCreateTable=" + nome_tabella);
        String createTable = "\n\n--\n-- Table:  struttura di creazione per la tabella `" + nome_tabella + "`\n--\n\n";
        createTable = createTable + "DROP TABLE IF EXISTS `" + nome_tabella + "`;\n";
        createTable = createTable + "/*!40101 SET @saved_cs_client     = @@character_set_client */;\n";
        createTable = createTable + "/*!40101 SET character_set_client = utf8 */;\n";
        try {
            String query = "SHOW CREATE TABLE " + this.connessione.nomeDB + "." + nome_tabella;
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                String test = res.getString("Create Table");
                createTable = createTable + test + ";";
                if (!nome_tabella.contains("ctrl_variab")) continue;
                MyTrace.log.info("MYSQLDUMP==" + test);
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpCreateTable!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            createTable = createTable + "";
        }
        this.connessione.ChiudiResultSet(res);
        createTable = createTable + "\n/*!40101 SET character_set_client = @saved_cs_client */;\n";
        return createTable;
    }

    public String Routine_dumpCreate(String nome_routine) {
        MyTrace.log.info("MySQLDump: Eseguo Routine_dumpCreate su :" + nome_routine);
        ResultSet res = null;
        String createRoutine = "\n\n\n--\n-- Routine: struttura per la routine =`" + nome_routine + "`\n--\n\n";
        createRoutine = createRoutine + "/*!50003 DROP PROCEDURE IF EXISTS `" + nome_routine + "` */;\n";
        createRoutine = createRoutine + this.intestazioni_START_routine();
        createRoutine = createRoutine + "DELIMITER ;;\n";
        createRoutine = createRoutine + "/*!50003 CREATE*/ /*!50020 DEFINER=`" + this.utente_connesso + "`@`%`*/ /*!50003 PROCEDURE `" + nome_routine + "`()\n";
        try {
            String query = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME='" + nome_routine + "' and ROUTINE_SCHEMA='" + this.connessione.nomeDB + "'";
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                createRoutine = createRoutine + res.getString("ROUTINE_DEFINITION");
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpCreateRoutine!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            createRoutine = createRoutine + "";
        }
        this.connessione.ChiudiResultSet(res);
        createRoutine = createRoutine + "*/;; \nDELIMITER ;\n";
        createRoutine = createRoutine + this.intestazioni_END_routine();
        return createRoutine;
    }

    public String dumpCreateTrigger(String trigger) {
        ResultSet res = null;
        String createTrigger = "--\n-- Trigger structure for trigger `" + trigger + "`\n--\n\n";
        try {
            String query = "SHOW CREATE TRIGGER " + this.connessione.nomeDB + "." + trigger;
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                createTrigger = createTrigger + res.getString("SQL Original Statement") + ";";
            }
        }
        catch (SQLException e) {
            MyTrace.log.severe("DB: ERRORE dumpCreateTrigger!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            createTrigger = createTrigger + "";
        }
        this.connessione.ChiudiResultSet(res);
        return createTrigger;
    }

    public void Table_dumpDati(BufferedWriter out, String nome_tabella) {
        MyTrace.log.info("MySQLDump: Eseguo dumpTable=" + nome_tabella);
        StringBuilder buffer_di_scrittura = new StringBuilder();
        long dimensione_in_byte = 0L;
        try {
            String query = "SELECT /*!40001 SQL_NO_CACHE */ * FROM " + nome_tabella;
            ResultSet res = this.connessione.eseguiQuery(query);
            ResultSetMetaData rsMetaData = res.getMetaData();
            if (!res.last()) {
                String intestazioni = "\n\n--\n-- Dumping data for table `" + nome_tabella + "`\n--\n";
                intestazioni = intestazioni + "\n--   NON ci sono dati nella tabella  `" + nome_tabella + "` \n\n";
                out.write(intestazioni);
                return;
            }
            String intestazioni = "\n\n--\n-- Dumping data for table `" + nome_tabella + "`\n--\n";
            intestazioni = intestazioni + "\nLOCK TABLES `" + nome_tabella + "` WRITE;\n";
            intestazioni = intestazioni + "/*!40000 ALTER TABLE `" + nome_tabella + "` DISABLE KEYS */;\n";
            out.write(intestazioni);
            res.beforeFirst();
            int columnCount = rsMetaData.getColumnCount();
            String inizio_riga = new String("INSERT INTO `" + nome_tabella + "` VALUES(");
            out.write(inizio_riga);
            int numero_record_corrente = 0;
            while (res.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String valore = null;
                    try {
                        valore = this.normalizzaStringa(res.getString(i));
                    }
                    catch (Exception e) {
                        valore = "NULL";
                    }
                    if (i == columnCount) {
                        if (res.isLast()) {
                            buffer_di_scrittura.append("'").append(valore).append("');\n");
                            out.write(buffer_di_scrittura.toString());
                            dimensione_in_byte += (long)(buffer_di_scrittura.length() * 2);
                            buffer_di_scrittura = new StringBuilder();
                            continue;
                        }
                        if (2 * buffer_di_scrittura.length() >= 1000000) {
                            MyTrace.log.info("Dimensione riga = " + 2 * buffer_di_scrittura.length() + " bytes con record = " + numero_record_corrente);
                            buffer_di_scrittura.append("'").append(valore).append("');\n");
                            out.write(buffer_di_scrittura.toString());
                            dimensione_in_byte += (long)(buffer_di_scrittura.length() * 2);
                            buffer_di_scrittura = new StringBuilder().append(inizio_riga);
                            continue;
                        }
                        buffer_di_scrittura.append("'").append(valore).append("'),(");
                        continue;
                    }
                    buffer_di_scrittura.append("'").append(valore).append("',");
                }
                ++numero_record_corrente;
            }
            this.connessione.ChiudiResultSet(res);
            String piede = "/*!40000 ALTER TABLE `" + nome_tabella + "` ENABLE KEYS */;\n";
            piede = piede + "UNLOCK TABLES;\n";
            piede = piede + "-- dimensione dati tabella = " + dimensione_in_byte + " byte";
            out.write(piede);
        }
        catch (IOException e) {
            MyTrace.log.severe("DB: ERRORE IO dumpTable!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpTable!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        MyTrace.log.info("Dimensione dati nella tabella " + nome_tabella + " = " + dimensione_in_byte);
    }

    public void Table_dumpDati_old_lenta(BufferedWriter out, String nome_tabella) {
        MyTrace.log.info("MySQLDump: Eseguo dumpTable=" + nome_tabella);
        try {
            String query = "SELECT /*!40001 SQL_NO_CACHE */ * FROM " + nome_tabella;
            ResultSet res = this.connessione.eseguiQuery(query);
            ResultSetMetaData rsMetaData = res.getMetaData();
            if (res.last()) {
                String intestazioni = "\n\n--\n-- Dumping data for table `" + nome_tabella + "`\n--\n";
                intestazioni = intestazioni + "\nLOCK TABLES `" + nome_tabella + "` WRITE;\n";
                intestazioni = intestazioni + "/*!40000 ALTER TABLE `abi_cab` DISABLE KEYS */;\n";
                out.write(intestazioni);
                res.beforeFirst();
            }
            int columnCount = rsMetaData.getColumnCount();
            String prefix = new String("INSERT INTO " + nome_tabella + " (");
            for (int i = 1; i <= columnCount; ++i) {
                prefix = i == columnCount ? prefix + rsMetaData.getColumnName(i) + ") VALUES(" : prefix + rsMetaData.getColumnName(i) + ",";
            }
            String postfix = new String();
            int numero_riga_corrente = 0;
            while (res.next()) {
                postfix = "";
                for (int i = 1; i <= columnCount; ++i) {
                    if (i == columnCount) {
                        postfix = postfix + "'" + this.normalizzaStringa(res.getString(i)) + "');\n";
                        continue;
                    }
                    try {
                        postfix = postfix + "'" + this.normalizzaStringa(res.getString(i)) + "',";
                        continue;
                    }
                    catch (Exception e) {
                        postfix = postfix + "NULL,";
                    }
                }
                out.write(prefix + postfix);
                ++numero_riga_corrente;
            }
            this.connessione.ChiudiResultSet(res);
            String piede = "\n/*!40000 ALTER TABLE `abi_cab` ENABLE KEYS */;\n";
            piede = piede + "UNLOCK TABLES;\n";
            out.write(piede);
        }
        catch (IOException e) {
            MyTrace.log.severe("DB: ERRORE IO dumpTable!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpTable!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private String normalizzaStringa(String valore) {
        String normalizzata = "";
        normalizzata = normalizzata + valore.replaceAll("'", "''").trim();
        return normalizzata;
    }

    public Map<String, String> dumpGlobalVariables() {
        TreeMap<String, String> variables = new TreeMap<String, String>();
        try {
            Statement s = this.conn.createStatement(1005, 1007);
            s.executeQuery("SHOW GLOBAL VARIABLES");
            ResultSet rs = s.getResultSet();
            while (rs.next()) {
                variables.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        return variables;
    }

    public void Views_dumpAll(BufferedWriter out) {
        ResultSet res = null;
        MyTrace.log.info("MySQLDump: Eseguo dumpAllViews");
        try {
            String query = "show full tables where Table_Type = 'VIEW'";
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                String tableName = res.getString(1);
                out.write(this.View_dumpCreate(tableName));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpAllViews!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        this.connessione.ChiudiResultSet(res);
    }

    public void Routine_dumpAll(BufferedWriter out) {
        ResultSet res = null;
        MyTrace.log.info("MySQLDump: Eseguo dumpAllRoutine");
        try {
            String query = "SELECT ROUTINE_NAME FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA='" + this.connessione.nomeDB + "'";
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                String routine = res.getString(1);
                out.write(this.Routine_dumpCreate(routine));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpAllRoutine!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        this.connessione.ChiudiResultSet(res);
    }

    public String View_dumpCreate(String nome_vista) {
        MyTrace.log.info("MySQLDump: Eseguo View_dumpCreate su :" + nome_vista);
        ResultSet res = null;
        String createView = "\n\n--\n-- Table:struttura di creazione per la vista `" + nome_vista + "`\n--\n\n";
        createView = createView + "/*!50001 DROP TABLE IF EXISTS `" + nome_vista + "`*/;\n";
        createView = createView + "/*!50001 DROP VIEW IF EXISTS `" + nome_vista + "`*/;\n";
        createView = createView + "/*!50001 SET @saved_cs_client          = @@character_set_client */;\n";
        createView = createView + "/*!50001 SET @saved_cs_results         = @@character_set_results */;\n";
        createView = createView + "/*!50001 SET @saved_col_connection     = @@collation_connection */;\n";
        createView = createView + "/*!50001 SET character_set_client      = utf8 */;\n";
        createView = createView + "/*!50001 SET character_set_results     = utf8 */;\n";
        createView = createView + "/*!50001 SET collation_connection      = utf8_general_ci */;\n";
        try {
            String query = "SHOW CREATE VIEW " + this.connessione.nomeDB + "." + nome_vista;
            res = this.connessione.eseguiQuery(query);
            while (res.next()) {
                createView = createView + res.getString("Create View") + ";";
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE dumpCreateView!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            createView = createView + "";
        }
        this.connessione.ChiudiResultSet(res);
        createView = createView + "/*!50001 SET character_set_client      = @saved_cs_client */;\n";
        createView = createView + "/*!50001 SET character_set_results     = @saved_cs_results */;\n";
        createView = createView + "/*!50001 SET collation_connection      = @saved_col_connection */;\n";
        return createView.replace("CREATE", "CREATE OR REPLACE");
    }

    public ArrayList<String> listRoutines(String schema) {
        ArrayList<String> routines = new ArrayList<String>();
        if (this.databaseProductMajorVersion < 5) {
            return routines;
        }
        try {
            Statement s = this.conn.createStatement(1005, 1007);
            s.executeQuery("SELECT ROUTINE_NAME FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA='" + schema + "'");
            ResultSet rs = s.getResultSet();
            while (rs.next()) {
                routines.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        return routines;
    }

    public ArrayList<String> listTriggers(String schema) {
        ArrayList<String> triggers = new ArrayList<String>();
        if (this.databaseProductMajorVersion < 5) {
            return triggers;
        }
        try {
            Statement s = this.conn.createStatement(1005, 1007);
            s.executeQuery("SELECT TRIGGER_NAME FROM INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_SCHEMA='" + schema + "'");
            ResultSet rs = s.getResultSet();
            while (rs.next()) {
                triggers.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        return triggers;
    }

    public ArrayList<String> listGrantTables() {
        ArrayList<String> grantTables = new ArrayList<String>();
        grantTables.add("user");
        grantTables.add("db");
        grantTables.add("tables_priv");
        grantTables.add("columns_priv");
        if (this.databaseProductMajorVersion > 4) {
            grantTables.add("procs_priv");
        }
        return grantTables;
    }

    public ArrayList<String> listTables(String schema) {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            Statement s = this.conn.createStatement(1005, 1007);
            if (this.databaseProductMajorVersion < 5) {
                s.executeQuery("SHOW TABLES FROM " + this.schema);
            } else {
                s.executeQuery("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + schema + "'");
            }
            ResultSet rs = s.getResultSet();
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        return tables;
    }

    public ArrayList<String> listEvents(String schema) {
        ArrayList<String> events = new ArrayList<String>();
        try {
            if (this.databaseProductMajorVersion == 5 && this.databaseProductMinorVersion == 1) {
                Statement s = this.conn.createStatement(1005, 1007);
                s.executeQuery("SELECT EVENT_NAME FROM INFORMATION_SCHEMA.EVENTS WHERE EVENT_SCHEMA='" + schema + "'");
                ResultSet rs = s.getResultSet();
                while (rs.next()) {
                    events.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        return events;
    }

    private ByteArrayOutputStream escapeString(byte[] bIn) {
        int numBytes = bIn.length;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(numBytes + 2);
        for (int i = 0; i < numBytes; ++i) {
            byte b = bIn[i];
            try {
                bOut.write(Hexhars[b >> 4 & 0xF]);
                bOut.write(Hexhars[b & 0xF]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bOut;
    }

    public boolean truncate_table(String nome_tabella_da_svuotare) {
        boolean q_res = false;
        MyTrace.log.info("TRUNCATE TABELLA ='" + nome_tabella_da_svuotare + "'");
        try {
            String query = "TRUNCATE TABLE `" + nome_tabella_da_svuotare + "`;";
            q_res = this.connessione.eseguiAggiornamento(query);
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ECCEZIONE truncate_table!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        MyTrace.log.info("TRUNCATE SUCCESS ='" + q_res + "'");
        return q_res;
    }

    public void file_Open(String nome_file) {
        try {
            File temp = new File(nome_file);
            MyTrace.log.info("file_Open  nome_file)" + temp.getCanonicalPath());
            MyTrace.log.info("file_Open  nome_file)" + temp.getAbsolutePath());
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(temp), Charset.forName("UTF-8"));
            this.outStream = new BufferedWriter(osw);
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE file_Open!");
            MyTrace.log.severe("DB: EXQ=" + e.toString());
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void file_Close() {
        try {
            this.outStream.flush();
            this.outStream.close();
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: ERRORE file_Close! forse il file era gi\u00e0 chiuso");
        }
    }

    private String intestazioni_Versioni_e_Parametri() {
        String version = "--\n-- Backup database `" + this.connessione.nomeDB + "`\n--\n\n";
        version = version + "-- Eseguito il " + new Date().toString() + "--";
        version = version + "\n-- " + this.connessione.databaseProductVersion;
        version = version + "\n-- Server=" + this.connessione.server;
        version = version + "\n-- nomeDB=" + this.connessione.nomeDB;
        version = version + "\n-- test charset encoding = a\u00e0e\u00e8i\u00eco\u00f2u\u00f9";
        return version + "\n";
    }

    private String intestazioni_START_dump() {
        String start = "/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;\n" + "/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;\n" + "/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;\n" + "/*!40101 SET NAMES utf8 */;\n" + "/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;\n" + "/*!40103 SET TIME_ZONE='+00:00' */;\n" + "/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;\n" + "/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;\n" + "/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;\n" + "/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;\n";
        return start;
    }

    private String intestazioni_END_dump() {
        String end = "/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;\n" + "/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;\n" + "/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;\n" + "/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;\n" + "/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;\n" + "/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;\n" + "/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;\n";
        return end;
    }

    private String intestazioni_START_routine() {
        String start = "/*!50003 SET @saved_cs_client      = @@character_set_client */ ;\n" + "/*!50003 SET @saved_cs_results     = @@character_set_results */ ;\n" + "/*!50003 SET @saved_col_connection = @@collation_connection */ ;\n" + "/*!50003 SET character_set_client  = utf8 */ ;\n" + "/*!50003 SET character_set_results = utf8 */ ;\n" + "/*!50003 SET collation_connection  = utf8_general_ci */ ;\n" + "/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;\n" + "/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;\n";
        return start;
    }

    private String intestazioni_END_routine() {
        String end = "/*!50003 SET sql_mode              = @saved_sql_mode */ ;\n" + "/*!50003 SET character_set_client  = @saved_cs_client */ ;\n" + "/*!50003 SET character_set_results = @saved_cs_results */ ;\n" + "/*!50003 SET collation_connection  = @saved_col_connection */ ;\n";
        return end;
    }

    private String intestazioni_Separatore() {
        String separatore = "\n\n\n\n-- ############################################################################\n";
        return separatore;
    }

    public static void main(String[] args) throws IOException {
        new MySQLDump().main_eseguiTest(args);
    }

    private void main_eseguiTest(String[] args) throws IOException {
        Configurazioni config = new Configurazioni();
        MyTrace.log.info("OLIMPO TEST versioneSoftware = " + Configurazioni.versioneSoftware);
        String livello = ConfigurazioneIni.hm.get("trace.level");
        config.fd = new FunzioniDiritti();
        ProfiloUtente profilo = new ProfiloUtente("sandro", "sandro");
        profilo.controllaCredenzialiSeOK();
        boolean result = profilo.carica_diritti_del_gruppo_utente_dal_database();
        SysSessioneUtente HB = new SysSessioneUtente();
        config.fd.CopiaPermessiDalDatabase(profilo);
        this.connessione = config.connessione;
        System.out.println("CONFIGURAZIONE DI TEST ESEGUITA");
        System.out.println("INIZIO TEST");
        System.out.println("PROVO ORA LA CREAZIONE DEl FILE");
        try {
            String cartella_di_backup = System.getProperty("user.dir") + System.getProperty("file.separator") + System.getProperty("file.separator");
            Date time = new Date();
            SimpleDateFormat formattazione = new SimpleDateFormat("yyyyMMddhhmmss_");
            String tempo_formattato = formattazione.format(time);
            String nome_file = cartella_di_backup + tempo_formattato + "database" + ".sql";
            this.file_Open(nome_file);
            this.Schema_dumpAll_CompletoConDati();
            this.file_Close();
            System.out.println("ORA COMPRIMO IL FILE DI DUMP");
            String nome_file_compresso = nome_file + ".zip";
            ZipFile zf = new ZipFile(nome_file, nome_file_compresso);
        }
        catch (Exception se) {
            System.out.println("ECCEZIONE");
            System.out.println(se.getMessage());
        }
        System.out.println("FINE TEST");
        System.exit(0);
    }
}

