/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Currency;
import java.util.logging.Level;
import utils.Funzioni;
import utils.MyTrace;
import utils.Quantita;

public final class Money
implements Comparable<Money>,
Serializable {
    private BigDecimal fAmount = BigDecimal.ZERO;
    private final Currency fCurrency;
    private final RoundingMode fRounding;
    private final int fNumeroDecimali;
    private static Currency DEFAULT_CURRENCY;
    private static RoundingMode DEFAULT_ROUNDING;
    private static int DEFAULT_SCALE;
    private int fHashCode;
    private static final int HASH_SEED = 23;
    private static final int HASH_FACTOR = 37;
    private static final long serialVersionUID = 7526471155622776147L;

    public static void init(Currency aDefaultCurrency, RoundingMode aDefaultRounding) {
        DEFAULT_CURRENCY = aDefaultCurrency;
        DEFAULT_ROUNDING = aDefaultRounding;
        DEFAULT_SCALE = aDefaultCurrency.getDefaultFractionDigits();
    }

    public Money(BigDecimal aAmount, Currency aCurrency, RoundingMode aRoundingStyle, int aNumeroDecimali) {
        this.fAmount = aAmount.setScale(aNumeroDecimali, aRoundingStyle);
        this.fCurrency = aCurrency;
        this.fRounding = aRoundingStyle;
        this.fNumeroDecimali = aNumeroDecimali;
    }

    public Money(String aAmount_in_Stringa, Currency aCurrency, RoundingMode aRoundingStyle, int aNumeroDecimali) {
        if (aAmount_in_Stringa == null) {
            MyTrace.log.severe("ERRORE:: VALORE Money NULLO!! controllare : " + aAmount_in_Stringa);
        } else if (aAmount_in_Stringa.isEmpty()) {
            MyTrace.log.severe("ERRORE:: VALORE Money VUOTO!! controllare" + aAmount_in_Stringa);
        }
        BigDecimal aAmount = this.Stringa_to_BigDecimal(aAmount_in_Stringa);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Money NULLO!! controllare : " + aAmount_in_Stringa);
        }
        this.fAmount = aAmount.setScale(aNumeroDecimali, aRoundingStyle);
        this.fCurrency = aCurrency;
        this.fRounding = aRoundingStyle;
        this.fNumeroDecimali = aNumeroDecimali;
    }

    public Money(BigDecimal aAmount) {
        this(aAmount, DEFAULT_CURRENCY, DEFAULT_ROUNDING, DEFAULT_SCALE);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Money NULLO!! controllare");
        }
    }

    public Money(BigDecimal aAmount, int aNumeroDecimali) {
        this(aAmount, DEFAULT_CURRENCY, DEFAULT_ROUNDING, aNumeroDecimali);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Money NULLO!! controllare");
        }
    }

    public Money(BigDecimal aAmount, Currency aCurrency) {
        this(aAmount, aCurrency, DEFAULT_ROUNDING, DEFAULT_SCALE);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Money NULLO!! controllare");
        }
    }

    public Money(BigDecimal aAmount, Currency aCurrency, int aNumeroDecimali) {
        this(aAmount, aCurrency, DEFAULT_ROUNDING, aNumeroDecimali);
        if (aAmount == null) {
            MyTrace.log.severe("ERRORE: VALORE Money NULLO!! controllare");
        }
    }

    public Money(double aAmount) {
        this(new BigDecimal(Double.toString(aAmount)), DEFAULT_CURRENCY, DEFAULT_ROUNDING, DEFAULT_SCALE);
    }

    public Money(double aAmount, int aNumeroDecimali) {
        this(new BigDecimal(Double.toString(aAmount)), DEFAULT_CURRENCY, DEFAULT_ROUNDING, aNumeroDecimali);
    }

    public Money(String aAmount_in_Stringa) {
        this(aAmount_in_Stringa, DEFAULT_CURRENCY, DEFAULT_ROUNDING, DEFAULT_SCALE);
    }

    public Money(String aAmount_in_Stringa, int aNumeroDecimali) {
        this(aAmount_in_Stringa, DEFAULT_CURRENCY, DEFAULT_ROUNDING, aNumeroDecimali);
    }

    private BigDecimal Stringa_to_BigDecimal(String valore_in_stringa) {
        BigDecimal valore = null;
        try {
            valore = new BigDecimal(valore_in_stringa);
        }
        catch (Exception e) {
            MyTrace.log.log(Level.SEVERE, "ECCEZIONE: Costruttore Money con valore stringa anomalo ={0}", valore_in_stringa);
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            valore = new BigDecimal(BigInteger.ZERO);
        }
        return valore;
    }

    public Money(Money valore_da_copiare) {
        this(new BigDecimal(valore_da_copiare.getDoubleValue()), valore_da_copiare.getCurrency(), valore_da_copiare.getRoundingStyle(), valore_da_copiare.getNumDecimalsForThisMoney());
    }

    public Money(Money valore_da_copiare, int aNumeroDecimali) {
        this(new BigDecimal(valore_da_copiare.getDoubleValue()), valore_da_copiare.getCurrency(), valore_da_copiare.getRoundingStyle(), aNumeroDecimali);
    }

    public BigDecimal getAmount() {
        return this.fAmount;
    }

    public Currency getCurrency() {
        return this.fCurrency;
    }

    public RoundingMode getRoundingStyle() {
        return this.fRounding;
    }

    private int getNumDecimalsForCurrency() {
        return this.fCurrency.getDefaultFractionDigits();
    }

    private int getNumDecimalsForThisMoney() {
        return DEFAULT_SCALE;
    }

    public double getDoubleValue() {
        return this.fAmount.doubleValue();
    }

    public Money abs() {
        return this.isPlus() ? this : this.times(-1);
    }

    public Money negate() {
        return this.times(-1);
    }

    public Money plus(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        return new Money(this.fAmount.add(aThat.fAmount), this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public void plusplus(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        this.fAmount = this.fAmount.add(aThat.fAmount);
    }

    public Money minus(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        return new Money(this.fAmount.subtract(aThat.fAmount), this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public static Money sum(Collection<Money> aMoneys, Currency aCurrencyIfEmpty) {
        Money sum = new Money(BigDecimal.ZERO, aCurrencyIfEmpty, DEFAULT_SCALE);
        for (Money money : aMoneys) {
            sum = sum.plus(money);
        }
        return sum;
    }

    public boolean eq(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        return this.compareAmount(aThat) == 0;
    }

    public boolean gt(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        return this.compareAmount(aThat) > 0;
    }

    public boolean gteq(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        return this.compareAmount(aThat) >= 0;
    }

    public boolean lt(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        return this.compareAmount(aThat) < 0;
    }

    public boolean lteq(Money aThat) {
        this.checkCurrenciesMatch(aThat);
        return this.compareAmount(aThat) <= 0;
    }

    public boolean isSameCurrencyAs(Money aThat) {
        boolean result = false;
        if (aThat != null) {
            result = this.fCurrency.equals(aThat.fCurrency);
        }
        return result;
    }

    public boolean isPlus() {
        return this.fAmount.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isMinus() {
        return this.fAmount.compareTo(BigDecimal.ZERO) < 0;
    }

    public boolean isZero() {
        return this.fAmount.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Money)) {
            return false;
        }
        Money that = (Money)aThat;
        boolean result = this.fAmount.equals(that.fAmount);
        result = result && this.fCurrency.equals(that.fCurrency);
        result = result && this.fRounding == that.fRounding;
        result = result && this.fNumeroDecimali == that.fNumeroDecimali;
        return result;
    }

    @Override
    public int compareTo(Money aThat) {
        boolean EQUAL = false;
        if (this == aThat) {
            return 0;
        }
        int comparison = this.fAmount.compareTo(aThat.fAmount);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.fCurrency.getCurrencyCode().compareTo(aThat.fCurrency.getCurrencyCode());
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.fRounding.compareTo(aThat.fRounding);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.fNumeroDecimali - aThat.fNumeroDecimali;
        if (comparison != 0) {
            return comparison;
        }
        return 0;
    }

    public Money times(int aFactor) {
        BigDecimal factor = new BigDecimal(aFactor);
        BigDecimal newAmount = this.fAmount.multiply(factor);
        newAmount = newAmount.setScale(this.fNumeroDecimali, this.fRounding);
        return new Money(newAmount, this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public Money times(double aFactor) {
        BigDecimal newAmount = this.fAmount.multiply(this.asBigDecimal(aFactor));
        newAmount = newAmount.setScale(this.fNumeroDecimali, this.fRounding);
        return new Money(newAmount, this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public Money multiply(BigDecimal aFactor) {
        BigDecimal newAmount = this.fAmount.multiply(aFactor);
        newAmount = newAmount.setScale(this.fNumeroDecimali, this.fRounding);
        return new Money(newAmount, this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public Money multiply(Quantita aFactor) {
        BigDecimal newAmount = this.fAmount.multiply(aFactor.getAmount());
        newAmount = newAmount.setScale(this.fNumeroDecimali, this.fRounding);
        return new Money(newAmount, this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public Money div(int aDivisor) {
        BigDecimal divisor = new BigDecimal(aDivisor);
        BigDecimal newAmount = this.fAmount.divide(divisor, this.fRounding);
        return new Money(newAmount, this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public Money div(double aDivisor) {
        BigDecimal newAmount = this.fAmount.divide(this.asBigDecimal(aDivisor), this.fRounding);
        return new Money(newAmount, this.fCurrency, this.fRounding, this.fNumeroDecimali);
    }

    public String toString() {
        return this.fAmount.setScale(this.fNumeroDecimali, RoundingMode.HALF_UP).toPlainString();
    }

    public String toStringValuta() {
        return this.fAmount.setScale(this.fNumeroDecimali, RoundingMode.HALF_UP).toPlainString() + " " + this.fCurrency.getSymbol();
    }

    public String toStringFormato() {
        String impostazioni = "value       =" + this.fAmount.toPlainString() + "\n";
        impostazioni = impostazioni + "Scale       =" + this.fAmount.scale() + "\n";
        impostazioni = impostazioni + "precision   =" + this.fAmount.precision() + "\n";
        impostazioni = impostazioni + "Currency    =" + this.fCurrency.toString() + "\n";
        impostazioni = impostazioni + "Round       =" + this.fRounding.toString() + "\n";
        impostazioni = impostazioni + "hash code   =" + this.fHashCode + "\n";
        impostazioni = impostazioni + "decimali    =" + this.fCurrency.getDefaultFractionDigits() + "\n";
        return impostazioni;
    }

    public int validateState() {
        if (this.fAmount == null) {
            MyTrace.log.severe("ERRORE: Il valore di Money non pu\u00f2 essere nullo");
            this.fAmount = BigDecimal.ZERO.setScale(this.getNumDecimalsForCurrency(), RoundingMode.HALF_UP);
            return 1;
        }
        if (this.fCurrency == null) {
            MyTrace.log.severe("ERRORE: Il valore di Currency (valuta) non pu\u00f2 essere nullo");
            return 2;
        }
        if (this.fAmount.scale() > this.fNumeroDecimali) {
            MyTrace.log.fine(new String("ANOMALIA:1: nei decimali di Money " + this.fAmount.floatValue() + ":" + this.fAmount.toPlainString() + "che ne ha ") + this.fAmount.scale() + " ma questo money ne ha impostati " + this.fNumeroDecimali + " decimali");
            this.fAmount = this.fAmount.setScale(this.fNumeroDecimali, this.fRounding);
            return 3;
        }
        if (this.fAmount.scale() < this.fNumeroDecimali) {
            MyTrace.log.fine(new String("ANOMALIA:2: nei decimali di Money " + this.fAmount.floatValue() + ":" + this.fAmount.toPlainString() + " che ne ha ") + this.fAmount.scale() + " ma questo money ne ha impostati " + this.fNumeroDecimali + " decimali");
            this.fAmount = this.fAmount.setScale(this.fNumeroDecimali, this.fRounding);
            return 3;
        }
        return 0;
    }

    private void checkCurrenciesMatch(Money aThat) {
        if (!this.fCurrency.equals(aThat.getCurrency())) {
            throw new MismatchedCurrencyException("ATTENZIONE: " + aThat.getCurrency() + " non corrisponde alla stessa valuta : " + this.fCurrency);
        }
    }

    private int compareAmount(Money aThat) {
        return this.fAmount.compareTo(aThat.fAmount);
    }

    private BigDecimal asBigDecimal(double aDouble) {
        String asString = Double.toString(aDouble);
        return new BigDecimal(asString);
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = 23;
            this.fHashCode = 37 * this.fHashCode + this.fAmount.hashCode();
            this.fHashCode = 37 * this.fHashCode + this.fCurrency.hashCode();
            this.fHashCode = 37 * this.fHashCode + this.fRounding.hashCode();
        }
        return this.fHashCode;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.fAmount = new BigDecimal(this.fAmount.toPlainString());
        if (this.validateState() != 0) {
            MyTrace.log.severe("ANOMALIA: nella lettura di un Money dallo streaming con funzione readObject()");
        }
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    public void ___arrotondaAlCurrency() {
        BigDecimal valore;
        this.fAmount = valore = this.fAmount.setScale(this.getNumDecimalsForCurrency(), this.fRounding);
    }

    public BigDecimal ___getValueArrotondato() {
        return this.fAmount.setScale(this.fNumeroDecimali, this.fRounding);
    }

    public static final class MismatchedCurrencyException
    extends RuntimeException {
        MismatchedCurrencyException(String aMessage) {
            super(aMessage);
        }
    }
}

