/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.text.ParseException;
import javax.swing.text.MaskFormatter;
import utils.Funzioni;

public class IBANFormatter
extends MaskFormatter {
    public String nazione = "";
    public String codice_iban = "";
    String mask_it = "";
    String mask_de = "";
    public String azzera_maschera_iban = "azzera_maschera_iban";

    public IBANFormatter() {
        try {
            this.setMask("UU##-U###-####-###A-A###-####-###");
            this.setAllowsInvalid(false);
            this.setOverwriteMode(true);
        }
        catch (ParseException e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
    }

    public IBANFormatter(String nazione) {
        try {
            this.nazione = nazione;
            if (nazione.equals("IT")) {
                this.setMask("##-U-#####-#####-############");
                this.mask_it = "##-#-#####-#####-############";
            }
            if (nazione.equals("DE")) {
                this.setMask("##-########-##########");
                this.mask_de = "##-########-##########";
            }
            this.setAllowsInvalid(false);
            this.setOverwriteMode(true);
        }
        catch (ParseException e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        String cod_iban;
        if (value == null || value.equals("")) {
            return "XX00-X000-0000-0000-0000-0000-000";
        }
        String uscita = value.toString().replaceAll("-", "");
        if (this.nazione.equals("IT")) {
            String cod_iban2;
            this.codice_iban = cod_iban2 = uscita.substring(0, 2) + "-" + uscita.substring(2, 3) + "-" + uscita.substring(3, 8) + "-" + uscita.substring(8, 13) + "-" + uscita.substring(13, 25);
            return cod_iban2;
        }
        if (this.nazione.equals("DE")) {
            String cod_iban3;
            this.codice_iban = cod_iban3 = uscita.substring(0, 2) + "-" + uscita.substring(2, 10) + "-" + uscita.substring(10, 20);
            return cod_iban3;
        }
        if (this.nazione.equals(this.azzera_maschera_iban)) {
            return "";
        }
        this.codice_iban = cod_iban = uscita.substring(0, 4) + "-" + uscita.substring(4, 8) + "-" + uscita.substring(8, 12) + "-" + uscita.substring(12, 16) + "-" + uscita.substring(16, 20) + "-" + uscita.substring(20, 24) + "-" + uscita.substring(24, 27);
        return cod_iban;
    }

    public void setText(Object value) {
        try {
            this.valueToString(value);
        }
        catch (ParseException ex) {
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }

    public String getMask_it() {
        return this.mask_it;
    }

    public void setMask_it(String mask_it) {
        this.mask_it = mask_it;
    }

    public String getMask_de() {
        return this.mask_de;
    }

    public void setMask_de(String mask_de) {
        this.mask_de = mask_de;
    }

    public String getTesto() {
        return this.nazione;
    }

    public void setTesto(String Testo2) {
        this.nazione = Testo2;
    }
}

