/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import utils.ColumnGroup;
import utils.GroupableTableHeaderUI;

public class GroupableTableHeader
extends JTableHeader {
    private static final String uiClassID = "GroupableTableHeaderUI";
    protected Vector columnGroups = null;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    @Override
    public void updateUI() {
        this.setUI(new GroupableTableHeaderUI());
    }

    @Override
    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public Enumeration getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration e = this.columnGroups.elements();
        while (e.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)e.nextElement();
            Vector v_ret = cGroup.getColumnGroups(col, new Vector());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration e = this.columnGroups.elements();
        while (e.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)e.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }
}

