/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.cap.CAP;
import gestionale.cap.InsiemeCAP;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import trasporti.listini.Prezzo;
import trasporti.prese_consegne.PresaConsegna;
import trasporti.tratte.InsiemeTratte;
import trasporti.tratte.Tratta;
import utils.Funzioni;
import utils.MyTrace;

public class FunzioniTrasporti {
    public Vector crea_vettore_tipologie(int star) {
        String query = "SELECT nome_tipologia FROM mtra_tipologie_merce";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> nomi_tipologie = new Vector<String>();
        if (star == 1) {
            nomi_tipologie.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_tipologie.add(res.getString("nome_tipologia"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nomi_tipologie;
    }

    public Vector crea_vettore_tipologia_merce() {
        String query = "SELECT * FROM mtra_tipologie_merce";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> tipo_causale = new Vector<String>();
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                tipo_causale.add(res.getString("nome_tipologia"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return tipo_causale;
    }

    public int id_tipologia_merce(String nome_t) {
        int id = 0;
        String query = "SELECT idmtra_tipologie_merce as id FROM mtra_tipologie_merce WHERE nome_tipologia='" + nome_t + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String nome_tipologia_merce(int id) {
        String nome = "";
        String query = "SELECT nome_tipologia FROM mtra_tipologie_merce WHERE idmtra_tipologie_merce='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("nome_tipologia");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int id_tratta_da_codice(String codice) {
        int id = 0;
        String query = "SELECT idTratta FROM mtra_tratte WHERE cod_tratta='" + codice.replaceAll("'", "''") + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idTratta");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_opzione_da_codice(String codice) {
        int id = 0;
        String query = "SELECT idOpzione FROM mtra_opzioni WHERE cod_opzione='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idOpzione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public Vector crea_vettore_opzioni(int star) {
        String query_listini_riferimento = "SELECT cod_opzione from mtra_opzioni";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_listini_riferimento);
        Vector<String> nomi_gruppi = new Vector<String>();
        if (star == 1) {
            nomi_gruppi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_gruppi.add(res.getString("cod_opzione"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nomi_gruppi;
    }

    public Vector crea_array_opzioni(int star, String aggiunta) {
        String query = "SELECT cod_opzione FROM mtra_opzioni ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> nomi_gruppi = new Vector<String>();
        if (star == 1) {
            nomi_gruppi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_gruppi.add(res.getString("cod_opzione"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        nomi_gruppi.add(aggiunta);
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nomi_gruppi;
    }

    public String ordine_sistemato(boolean val) {
        if (val) {
            return "ORDINE ASSEGNATO";
        }
        return "ORDINE DA ASSEGNARE";
    }

    public String nome_tipologia_listini(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Tonnellata";
                break;
            }
            case 1: {
                retVal = "Forfait";
                break;
            }
            case 2: {
                retVal = "Colli";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public String nome_listini_da_id_listino_riferimento(int id) {
        String nome = "";
        String query = "SELECT nome FROM mmag_listini WHERE id= " + id;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("nome");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return nome;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int ultimo_viaggio(int anno) {
        int id = 0;
        String query = "SELECT MAX(numero_viaggio) as ultimo FROM mtra_viaggi WHERE anno='" + anno + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("ultimo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int ultimo_ordine(int anno) {
        int id = 0;
        String query = "SELECT MAX(numero_ordine) as ultimo FROM mtra_ordini WHERE anno='" + anno + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("ultimo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_cliente_da_presa(int id_presa) {
        int id = 0;
        String query = "SELECT mtra_prese_consegne.*,mtra_ordini.* FROM mtra_prese_consegne  LEFT JOIN mtra_ordini on mtra_prese_consegne.id_ordine=mtra_ordini.id_ordine  WHERE idmtra_prese_consegne=" + id_presa + " ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                id = res.getInt("id_cliente");
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_ordine_da_presa(int id_presa) {
        int id = 0;
        String query = "SELECT * FROM mtra_prese_consegne WHERE idmtra_prese_consegne=" + id_presa + " ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                id = res.getInt("id_ordine");
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_ordine_da_numero(String num, String anno) {
        int id = 0;
        String query = "SELECT id_ordine FROM mtra_ordini WHERE numero_ordine=" + num + " AND anno=" + anno;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                id = res.getInt("id_ordine");
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public Vector crea_vettore_gruppi_articoli_manutenzione(int star) {
        String query = "SELECT nome FROM mtra_man_gruppi ORDER BY nome ASC ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> nomi_gruppi = new Vector<String>();
        if (star == 1) {
            nomi_gruppi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_gruppi.add(res.getString("nome"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nomi_gruppi;
    }

    public int id_mezzo(String targa) {
        int id = 0;
        String query = "SELECT id_macchina as id FROM mtra_mezzi WHERE targa='" + targa + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_articolo_manutenzione_da_codice(String codice) {
        int id = 0;
        String query = "SELECT id FROM mtra_man_articoli WHERE codice_articolo='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_gruppo_di_articoli_manutenzione(String nome_gruppo) {
        int id = 0;
        String query = "SELECT id FROM mtra_man_gruppi WHERE nome='" + nome_gruppo + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public Tratta cerca_tratta_generica(PresaConsegna presa, PresaConsegna consegna) {
        MyTrace.log.info("INIZIO CERCO TRATTA GENERICA");
        int id_cap_presa = presa.getLuogo().getCap().getId();
        int id_cap_consegna = consegna.getLuogo().getCap().getId();
        InsiemeTratte insieme_t1 = new InsiemeTratte();
        String w = " where cap.id_cap=" + presa.getLuogo().getCap().getId() + " AND mtra_tratte.generica=1";
        int numero = insieme_t1.caricamentoRic(w, "");
        MyTrace.log.info("ho trovato " + numero + " tratte generiche CHE CONTENGONO IL CAP DELLA PRESA");
        Iterator i = insieme_t1.vettoreT.iterator();
        boolean trovato = false;
        Tratta t_giusta = new Tratta();
        while (i.hasNext() && !trovato) {
            Tratta t1 = (Tratta)i.next();
            MyTrace.log.info("CERCO SE " + t1.getCod_tratta() + " HA ANCHE L'ALTRO CAP");
            if (t1.getId_cap_a() != 0) {
                t1.seleziona_cap_p(id_cap_consegna);
                for (CAP cc : t1.getInsieme_cap_p().vettoreC) {
                    if (cc.getId() != id_cap_consegna) continue;
                    MyTrace.log.info("HO TROVATO ANCHE IL CAP DELLA consegna");
                    t_giusta = t1;
                    t_giusta.setDa_rigirare(true);
                    trovato = true;
                }
            }
            if (t1.getId_cap_p() == 0) continue;
            t1.seleziona_cap_a(id_cap_consegna);
            for (CAP cc : t1.getInsieme_cap_a().vettoreC) {
                if (cc.getId() != id_cap_consegna) continue;
                MyTrace.log.info("HO TROVATO ANCHE IL CAP DELLA consegna");
                t_giusta = t1;
                trovato = true;
            }
        }
        if (trovato) {
            MyTrace.log.info("HO TROVATO LA TRATTA GENERICA NEL DATABASE DELLE TRATTE");
            return t_giusta;
        }
        MyTrace.log.info("NON HO TROVATO LA TRATTA GENERICA NEL DATABASE DELLE TRATTE");
        return null;
    }

    public Tratta cerca_tratta_giusta(PresaConsegna presa, PresaConsegna consegna, JInternalFrame chiamante, double km_tratta_generica) {
        String km;
        MyTrace.log.info("INIZIO CERCO TRATTA GIUSTA");
        InsiemeTratte insieme_t1 = new InsiemeTratte();
        String where = " where cap.id_cap=" + presa.getLuogo().getCap().getId() + " " + " AND mtra_tratte.generica=0 ";
        int numero = insieme_t1.caricamentoRic(where, "");
        MyTrace.log.info("ho trovato " + numero + " tratte CHE CONTENGONO IL CAP DELLA PRESA");
        Iterator i = insieme_t1.vettoreT.iterator();
        boolean trovato = false;
        Tratta t_giusta = new Tratta();
        while (i.hasNext() && !trovato) {
            Tratta t1 = (Tratta)i.next();
            MyTrace.log.info("CERCO SE " + t1.getCod_tratta() + " HA ANCHE L'ALTRO CAP");
            if (t1.getId_cap_a() != 0) {
                t1.seleziona_cap_p(consegna.getLuogo().getCap().getId());
                Iterator i2 = t1.getInsieme_cap_p().vettoreC.iterator();
                while (i2.hasNext() && !trovato) {
                    CAP cc = (CAP)i2.next();
                    if (!cc.getCap().equals(consegna.getLuogo().getCap().getCap())) continue;
                    MyTrace.log.info("HO TROVATO ANCHE IL CAP DELLA consegna");
                    t_giusta = t1;
                    t_giusta.setDa_rigirare(true);
                    trovato = true;
                }
            }
            if (t1.getId_cap_p() == 0) continue;
            t1.seleziona_cap_a(consegna.getLuogo().getCap().getId());
            for (CAP cc : t1.getInsieme_cap_a().vettoreC) {
                if (!cc.getCap().equals(consegna.getLuogo().getCap().getCap())) continue;
                MyTrace.log.info("HO TROVATO ANCHE IL CAP DELLA consegna");
                t_giusta = t1;
                trovato = true;
            }
        }
        if (trovato) {
            MyTrace.log.info("HO TROVATO LA TRATTA NEL DATABASE DELLE TRATTE");
            return t_giusta;
        }
        MyTrace.log.info("non HO TROVATO LA TRATTA NEL DATABASE DELLE TRATTE");
        Tratta t_nuova = new Tratta();
        t_nuova.setDescrizione(presa.getLuogo().getCodice_pt() + " - " + consegna.getLuogo().getCodice_pt());
        t_nuova.setCod_tratta(presa.getLuogo().getCodice_pt() + " - " + consegna.getLuogo().getCodice_pt());
        t_nuova.setKm(0.0);
        t_nuova.setCp(presa.getLuogo().getCap());
        t_nuova.getCp().setDescrizione_sel(presa.getLuogo().getLocalita_selezionata());
        t_nuova.setCa(consegna.getLuogo().getCap());
        t_nuova.getCa().setDescrizione_sel(consegna.getLuogo().getLocalita_selezionata());
        t_nuova.setInsieme_cap_p(new InsiemeCAP());
        t_nuova.setInsieme_cap_a(new InsiemeCAP());
        t_nuova.getInsieme_cap_p().vettoreC.add(presa.getLuogo().getCap());
        t_nuova.getInsieme_cap_a().vettoreC.add(consegna.getLuogo().getCap());
        t_nuova.setPrezzo(new Prezzo());
        String testo = "La tratta " + t_nuova.getDescrizione() + " non \u00e8 presente nel database. Inserisci i Km...";
        if (km_tratta_generica != 0.0) {
            testo = testo + "\n [Suggerimento:i Km da provincia a provincia sono  " + km_tratta_generica;
        }
        if ((km = JOptionPane.showInputDialog(chiamante, (Object)testo)) != null) {
            t_nuova.setKm(Double.parseDouble(km));
            return t_nuova;
        }
        return null;
    }
}

