/*
 * Decompiled with CFR 0.152.
 */
package utils;

import anagrafiche.banche.IBAN;
import gestionale.DA_CANCELLARE_fatturazione.DA_CANCELLARE_FatturaAttiva;
import gestionale.configurazioni.Configurazioni;
import gestionale.scadenziario.Scadenza;
import gestionale.trattamento_economico.ConfRata;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import magazzino.DA_CANCELLARE_ddu.DA_CANCELLARE_DDU;
import magazzino.DA_CANCELLARE_ddu.DA_CANCELLARE_InsiemeDDU;
import utils.InviaEmail;
import utils.MyTrace;

public class Funzioni {
    public String[] array_iban(String appoggio) {
        String iban = appoggio.replaceAll("-", "");
        String[] array = new String[6];
        try {
            array[0] = iban;
            array[1] = iban.substring(5, 10);
            array[2] = iban.substring(10, 15);
            IBAN iban2 = new IBAN();
            iban2.seleziona(array[1], array[2]);
            array[3] = iban2.getDescrizione();
            array[4] = iban2.getFiliale();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Compare?");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return null;
        }
        return array;
    }

    public int check_abi_cab(String abi_cab) {
        int id = 0;
        String query = "SELECT id FROM abi_cab WHERE cd_abicab='" + abi_cab + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int check_cap(String cap) {
        int id = 0;
        String query = "SELECT id_cap FROM cap WHERE cap='" + cap + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id_cap");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_gruppo_di_articoli(String nome_gruppo) {
        int id = 0;
        String query = "SELECT id FROM mmag_gruppi WHERE nome='" + nome_gruppo.replaceAll("'", "''") + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_um(String nome_um) {
        int id = 0;
        String query = "SELECT id FROM conf_unita_di_misura WHERE codice='" + nome_um + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String nome_um(int id_um) {
        String nome = "";
        String query = "SELECT codice FROM conf_unita_di_misura WHERE id='" + id_um + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("codice");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public boolean controlla_aliquota(String codice_aliquota) {
        String query = "SELECT * FROM conf_aliquote_iva WHERE codice='" + codice_aliquota + "'";
        boolean trovato = false;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                String codice2 = res.getString("codice");
                if (!codice_aliquota.equals(codice2)) continue;
                trovato = true;
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return trovato;
    }

    public boolean controlla_data(String data) {
        String query = "SELECT registro.data_reg FROM registro  LEFT JOIN conf_causale_contabile ON registro.id_causale_contabile=conf_causale_contabile.idcausale_contabile  WHERE conf_causale_contabile.codice='CORR' and registro.data_doc='" + data + "'";
        boolean trovato = false;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                String codice2 = res.getString("data_reg");
                if (!data.equals(codice2)) continue;
                trovato = true;
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return trovato;
    }

    public boolean ccontrolla_cliente_fornitore(String codice_cf) {
        String query = "SELECT * FROM anag_anagrafica WHERE codice='" + codice_cf.replaceAll(codice_cf.substring(0, 1), "") + "' " + " AND tipo_anag='" + codice_cf.substring(0, 1) + "' ";
        boolean trovato = false;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                String codice2 = res.getString("codice");
                if (!codice_cf.equals(codice_cf.substring(0, 1) + codice2)) continue;
                trovato = true;
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return trovato;
    }

    public boolean controlla_FA_se_riepilogativa(DA_CANCELLARE_FatturaAttiva fa_scelta) {
        try {
            String query = "SELECT count(id)as n from mmag_ddu where numero_fattura=" + fa_scelta.getNumero() + " AND codifica_fattura= '" + fa_scelta.getCodifica() + "' AND anno_fattura=" + fa_scelta.getAnno() + " ";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            int quante_ddu = 0;
            try {
                while (res.next()) {
                    quante_ddu = res.getInt("n");
                }
            }
            catch (SQLException e) {
                MyTrace.log.severe("Seleziona Fatture Attive non riuscito");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                Configurazioni.eccezione.gestisci("4.2", null);
            }
            return fa_scelta.getId_tipo_modello() != 3 && quante_ddu <= 1;
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return true;
        }
    }

    public boolean controlla_FA_se_riepilogativa(String numero, String codifica, int anno, int tipo_modello) {
        try {
            String query = "SELECT count(id)as n from mmag_ddu where numero_fattura=" + numero + " AND codifica_fattura= '" + codifica + "' AND anno_fattura=" + anno + " ";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            int quante_ddu = 0;
            try {
                while (res.next()) {
                    quante_ddu = res.getInt("n");
                }
            }
            catch (SQLException e) {
                MyTrace.log.severe("Seleziona Fatture Attive non riuscito");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                Configurazioni.eccezione.gestisci("4.2", null);
            }
            return tipo_modello != 3 && quante_ddu <= 1;
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return true;
        }
    }

    public boolean controlla_DDU_se_riepilogativa(DA_CANCELLARE_DDU ddu) {
        try {
            ddu.seleziona_dettagli();
            DA_CANCELLARE_FatturaAttiva fa_scelta = ddu.getFa();
            String query = "SELECT count(id)as n from mmag_ddu where numero_fattura=" + fa_scelta.getNumero() + " AND codifica_fattura= '" + fa_scelta.getCodifica() + "' AND anno_fattura=" + fa_scelta.getAnno() + " ";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            int quante_ddu = 0;
            try {
                while (res.next()) {
                    quante_ddu = res.getInt("n");
                }
            }
            catch (SQLException e) {
                MyTrace.log.severe("Seleziona Fatture Attive non riuscito");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                Configurazioni.eccezione.gestisci("4.2", null);
            }
            return fa_scelta.getId_tipo_modello() != 3 && quante_ddu <= 1;
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return true;
        }
    }

    public String nome_permesso(int id_permesso) {
        String nome = "";
        String query = "SELECT nome_permesso FROM auth_permessi WHERE id='" + id_permesso + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("nome_permesso");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String nome_gruppo_dadb(int id_gruppo) {
        String nome = "";
        String query = "SELECT nome_gruppo FROM auth_gruppi WHERE id='" + id_gruppo + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione_master.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("nome_gruppo");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return "";
        }
        Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
        return nome;
    }

    public String nome_gruppo(int id_gruppo) {
        String nome = "";
        nome = Configurazioni.getIstanza().fd.gruppi_operatore.get(id_gruppo);
        if (nome == null) {
            ResultSet res;
            try {
                String query = "SELECT nome_gruppo FROM auth_gruppi WHERE id='" + id_gruppo + "' ";
                res = Configurazioni.getIstanza().connessione_master.eseguiQuery(query);
                ResultSetMetaData meta = res.getMetaData();
                while (res.next()) {
                    nome = res.getString("nome_gruppo");
                    Configurazioni.getIstanza().fd.gruppi_operatore.put(id_gruppo, nome);
                }
            }
            catch (Exception e) {
                MyTrace.log.severe("ERRORE: ECCEZIONE non sono riuscito a determinare il GRUPPO avente ID" + id_gruppo);
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                e.printStackTrace();
                return "";
            }
            Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
        }
        return nome;
    }

    public void ordina_array(String[] a) {
        int MAX = a.length;
        for (int k = MAX - 1; k >= 1; --k) {
            for (int j = 0; j <= k - 1; ++j) {
                try {
                    if (a[j].compareTo(a[k]) <= 0) continue;
                    String temp = a[k];
                    a[k] = a[j];
                    a[j] = temp;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void ordina_vettore_scadenze(Vector v) {
        int MAX = v.size();
        for (int k = MAX - 1; k >= 1; --k) {
            for (int j = 0; j <= k - 1; ++j) {
                try {
                    Scadenza sj = (Scadenza)v.elementAt(j);
                    Scadenza sk = (Scadenza)v.elementAt(j + 1);
                    if (sj.getA_codice_cf().compareTo(sk.getA_codice_cf()) <= 0) continue;
                    Scadenza temp = sk;
                    sk = sj;
                    v.setElementAt(sj, j + 1);
                    sj = temp;
                    v.setElementAt(temp, j);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void ordina_vettore_rate(Vector v) {
        int MAX = v.size();
        for (int k = MAX - 1; k >= 1; --k) {
            for (int j = 0; j <= k - 1; ++j) {
                try {
                    ConfRata sj = (ConfRata)v.elementAt(j);
                    ConfRata sk = (ConfRata)v.elementAt(k);
                    if (sj.getGiorni() <= sk.getGiorni()) continue;
                    ConfRata temp = sk;
                    sk = sj;
                    v.setElementAt(sj, k);
                    sj = temp;
                    v.setElementAt(temp, j);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public String gira_stringa_data(String a) {
        String temp;
        String uscita = "";
        String[] x = a.split("-");
        if (x.length == 2) {
            temp = x[1];
            x[1] = x[0];
            x[0] = temp;
            uscita = x[0] + "-" + x[1];
        }
        if (x.length == 3) {
            temp = x[2];
            x[2] = x[0];
            x[0] = temp;
            uscita = x[0] + "-" + x[1] + "-" + x[2];
        }
        if (x.length == 1) {
            uscita = a;
        }
        return uscita;
    }

    public int id_gruppo(String nome_gruppo) {
        int id = 0;
        String query = "SELECT id FROM auth_gruppi WHERE nome_gruppo='" + nome_gruppo + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione_master.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
        return id;
    }

    public Vector crea_vettore_gruppi(int star) {
        String query = "SELECT nome_gruppo FROM auth_gruppi WHERE auth_gruppi.abilita=1 ";
        ResultSet res = Configurazioni.getIstanza().connessione_master.eseguiQuery(query);
        Vector<String> nomi_gruppi = new Vector<String>();
        if (star == 1) {
            nomi_gruppi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_gruppi.add(res.getString("nome_gruppo"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
        return nomi_gruppi;
    }

    public Vector crea_vettore_gruppi_articoli(int star) {
        String query = "SELECT nome FROM mmag_gruppi ORDER BY nome ASC ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> nomi_gruppi = new Vector<String>();
        if (star == 1) {
            nomi_gruppi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_gruppi.add(res.getString("nome"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nomi_gruppi;
    }

    public Vector crea_vettore_um(int star) {
        String query = "SELECT codice FROM conf_unita_di_misura WHERE abilita=1";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> nomi_gruppi = new Vector<String>();
        if (star == 1) {
            nomi_gruppi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_gruppi.add(res.getString("codice"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nomi_gruppi;
    }

    public Vector crea_vettore_modello(int star) {
        String query = "SELECT tipo FROM fatture_attive_tipi ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> tipi = new Vector<String>();
        if (star == 1) {
            tipi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                tipi.add(res.getString("tipo"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return tipi;
    }

    public boolean partita_iva(String piva) {
        MyTrace.log.info("PIVA:" + piva + " " + piva.length());
        if (piva.length() == 11) {
            try {
                for (int i = 0; i < piva.length(); ++i) {
                    Integer.valueOf(piva.substring(i, i + 1));
                }
                return true;
            }
            catch (NumberFormatException nfe) {
                Funzioni.LogStackTrace(nfe);
                return false;
            }
        }
        return false;
    }

    public String creacodice(int numero) {
        String retval;
        String stringa = "" + numero;
        int lunghezza = stringa.length();
        switch (lunghezza) {
            case 0: {
                retval = "000000";
                break;
            }
            case 1: {
                retval = "00000" + stringa;
                break;
            }
            case 2: {
                retval = "0000" + stringa;
                break;
            }
            case 3: {
                retval = "000" + stringa;
                break;
            }
            case 4: {
                retval = "00" + stringa;
                break;
            }
            case 5: {
                retval = "0" + stringa;
                break;
            }
            case 6: {
                retval = "" + stringa;
                break;
            }
            default: {
                retval = "";
            }
        }
        return retval;
    }

    public String[] dividi_stringa(String stringona, int dimensione) {
        System.out.println(stringona);
        String s_trattini = "";
        for (int dsa = 0; dsa <= stringona.length(); dsa += dimensione) {
            s_trattini = stringona.length() > dsa + dimensione ? s_trattini + stringona.substring(dsa, dsa + dimensione) + "-" : s_trattini + stringona.substring(dsa, stringona.length());
        }
        System.out.println(s_trattini);
        String[] stringhette = s_trattini.split("-");
        return stringhette;
    }

    public int id_anag_da_piva(String p_iva, String tipo_anag) {
        int id = 0;
        String query = " SELECT idanagrafica FROM anag_anagrafica  WHERE p_iva='" + p_iva + "' and abilita=1 AND tipo_anag='" + tipo_anag + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idanagrafica");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_anagrafica_da_ragione_sociale(String codice, String tipo_anag) {
        int id = 0;
        String query = "SELECT idanagrafica FROM anag_anagrafica WHERE ragione_sociale='" + codice + "' AND tipo_anag='" + tipo_anag + "' AND abilita=1 ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idanagrafica");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_anagrafica_da_codice(String codice, String tipo_anag) {
        int id = 0;
        if (codice.startsWith("C") || codice.startsWith("F")) {
            codice = codice.substring(1, codice.length());
        }
        String query = "SELECT idanagrafica FROM anag_anagrafica WHERE codice='" + codice + "' AND tipo_anag='" + tipo_anag + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idanagrafica");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_trattamento_economico(String codice) {
        int id = 0;
        String query = "SELECT idTrattamento_economico FROM conf_trattamento_economico WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idTrattamento_economico");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_cagoria_protocollo(String codice) {
        int id = 0;
        String query = "SELECT idProtCategorie FROM protocollo_categorie WHERE descrizione='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idProtCategorie");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_commessa(String codice) {
        int id = 0;
        String query = "SELECT idCommessa FROM commesse WHERE descrizione='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idCommessa");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_cagoria_gara(String codice) {
        int id = 0;
        String query = "SELECT id FROM edil_categorie_gare WHERE nome_categoria='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String zero_to_null(int id) {
        if (id == 0) {
            return null;
        }
        return Integer.valueOf(id).toString();
    }

    public int id_registro_iva(String codice) {
        int id = 0;
        String query = "SELECT idConf_registri_iva FROM conf_registri_iva WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idConf_registri_iva");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String codice_conto(int id_conto) {
        String nome = "";
        String query = "SELECT cdconto FROM pc_conti_5 WHERE idconto5='" + id_conto + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("cdconto");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int id_articolo_da_codice(String codice) {
        int id = 0;
        String query = "SELECT id FROM mmag_articoli WHERE codice_articolo='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String descrizione_conto(int id_conto) {
        String nome = "";
        String query = "SELECT descrizione FROM pc_conti_5 WHERE idconto5='" + id_conto + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String codice_te(int id_te) {
        String nome = "";
        String query = "SELECT codice FROM conf_trattamento_economico WHERE idTrattamento_economico='" + id_te + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("codice");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String descrizione_te(int id_te) {
        String nome = "";
        String query = "SELECT descrizione FROM conf_trattamento_economico WHERE idTrattamento_economico='" + id_te + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String codice_articolo(int id) {
        String nome = "";
        String query = "SELECT codice_articolo FROM mmag_articoli WHERE id='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("codice_articolo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String codice_CC(int id_CC) {
        String nome = "";
        String query = "SELECT codice FROM conf_causale_contabile WHERE idcausale_contabile='" + id_CC + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("codice");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String descrizione_CC(int id_CC) {
        String nome = "";
        String query = "SELECT descrizione FROM conf_causale_contabile WHERE idcausale_contabile='" + id_CC + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String codice_anagrafica(int id_anagrafica) {
        String codice = "";
        String tipo_anag = "";
        String query = "SELECT codice,tipo_anag FROM anag_anagrafica WHERE idanagrafica='" + id_anagrafica + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                codice = res.getString("codice");
                tipo_anag = res.getString("tipo_anag");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        if (codice.equals("")) {
            return "";
        }
        return tipo_anag + codice;
    }

    public String ragione_sociale_anagrafica(int id_anagrafica) {
        String codice = "";
        String query = "SELECT ragione_sociale FROM anag_anagrafica WHERE idanagrafica='" + id_anagrafica + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                codice = res.getString("ragione_sociale");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        if (codice.equals("")) {
            return "";
        }
        return "" + codice;
    }

    public String codice_banca(int id_banca) {
        String codice = "";
        String query = "SELECT codice FROM anag_banche WHERE idAnag_banche='" + id_banca + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                codice = res.getString("codice");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        if (codice.equals("")) {
            return "";
        }
        return codice;
    }

    public String descrizione_conto(String codice) {
        String descrizione = "";
        String query = "SELECT descrizione FROM pc_conti_5 WHERE cdconto='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                descrizione = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return descrizione;
    }

    public String descrizione_mastro_1(String codice) {
        String descrizione = "";
        String query = "SELECT descrizione FROM pc_mastro_1 WHERE cdmastro1='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                descrizione = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return descrizione;
    }

    public String descrizione_mastro_2(String codice) {
        String descrizione = "";
        String query = "SELECT descrizione FROM pc_mastro_2 WHERE cdmastro2='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                descrizione = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return descrizione;
    }

    public String descrizione_mastro_3(String codice) {
        String descrizione = "";
        String query = "SELECT descrizione FROM pc_mastro_3 WHERE cdmastro3='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                descrizione = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return descrizione;
    }

    public String descrizione_mastro_4(String codice) {
        String descrizione = "";
        String query = "SELECT descrizione FROM pc_mastro_4 WHERE cdmastro4='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                descrizione = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return descrizione;
    }

    public String[] descrizione_conto_da_alias(String alias) {
        try {
            String[] descrizione = new String[2];
            String query = "SELECT descrizione,cdconto FROM pc_conti_5 WHERE alias='" + alias + "' and abilita=1";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            try {
                ResultSetMetaData meta = res.getMetaData();
                while (res.next()) {
                    descrizione[0] = res.getString("descrizione");
                    descrizione[1] = res.getString("cdconto");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
                return descrizione;
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return descrizione;
        }
        catch (Exception x) {
            return null;
        }
    }

    public String nome_regola_da_id(int id) {
        String query = "SELECT nome FROM ctrl_regole WHERE idregole='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        String nome = "";
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("nome");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return nome;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int id_regola_da_nome(String nome) {
        String query = "SELECT idregole FROM ctrl_regole WHERE nome='" + nome + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        int id = 0;
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idregole");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return id;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String centro_responsabilita_da_id(int id) {
        String query = "SELECT centro_di_responsabilita FROM ctrl_centri_di_responsabilita WHERE idcentri_di_responsabilita='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        String nome = "";
        try {
            while (res.next()) {
                nome = res.getString("centro_di_responsabilita");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return nome;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int id_centro_responsabilita_da_nome(String nome) {
        String query = "SELECT idcentri_di_responsabilita FROM ctrl_centri_di_responsabilita WHERE centro_di_responsabilita='" + nome + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        int id = 0;
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idcentri_di_responsabilita");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return id;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String descrizione_centro_responsabilita_da_id(int id) {
        String centro = "";
        String query = "SELECT centro_di_responsabilita FROM ctrl_centri_di_responsabilita WHERE idcentri_di_responsabilita='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                centro = res.getString("centro_di_responsabilita");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return centro;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return centro;
    }

    public String descrizione_vda_da_id(int id) {
        String query = "SELECT descrizione_voce FROM ctrl_voci_di_analisi WHERE idvoci_di_analisi='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        String nome = "";
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("descrizione_voce");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return nome;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int id_vda_da_descrizione(String nome) {
        String query = "SELECT idvoci_di_analisi FROM ctrl_voci_di_analisi WHERE descrizione_voce='" + nome + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        int id = 0;
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idvoci_di_analisi");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            return id;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String string_segno(int segno, int star) {
        if (segno == 1) {
            if (star == 0) {
                return "Dare";
            }
            if (star == 1) {
                return "Attivo";
            }
            if (star != 2) return "Errore";
            return "Costo";
        }
        if (segno != 2) return "Errore";
        if (star == 0) {
            return "Avere";
        }
        if (star == 1) {
            return "Passivo";
        }
        if (star != 2) return "Errore";
        return "Ricavo";
    }

    public int int_segno(String segno) {
        System.out.println(segno);
        if (segno.equals("Attivo") || segno.equals("Dare") || segno.equals("Costi")) {
            return 1;
        }
        if (segno.equals("Passivo") || segno.equals("Avere") || segno.equals("Ricavi")) {
            return 2;
        }
        return 0;
    }

    public Vector crea_vettore_tipi_modello(int star) {
        String query = "SELECT tipo_causale FROM conf_modello_causale_contabile  ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        Vector<String> tipo_causale = new Vector<String>();
        if (star == 1) {
            tipo_causale.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                tipo_causale.add(res.getString("tipo_causale"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return tipo_causale;
    }

    public int prossimo_id(String nome_tabella, String nome_id) {
        int id = 0;
        String query = "SELECT max(" + nome_id + ") FROM " + nome_tabella;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = 1 + res.getInt("max(" + nome_id + ")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public DA_CANCELLARE_InsiemeDDU ottieni_insiemeDDU_fattura(DA_CANCELLARE_FatturaAttiva fa) {
        try {
            DA_CANCELLARE_InsiemeDDU i_ddu_temp = new DA_CANCELLARE_InsiemeDDU();
            String where = " where mmag_ddu.numero_fattura=" + fa.getNumero() + " AND mmag_ddu.anno_fattura=" + fa.getAnno() + " AND mmag_ddu.codifica_fattura='" + fa.getCodifica() + "'";
            int q2 = i_ddu_temp.caricamento(where, "");
            return i_ddu_temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return null;
        }
    }

    public String nome_tipo_modello(int id) {
        String nome = "";
        String query = "SELECT tipo_causale FROM conf_modello_causale_contabile WHERE id='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("tipo_causale");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String nome_modello_fattura(int id) {
        String nome = "";
        String query = "SELECT tipo FROM fatture_attive_tipi WHERE idfatture_attive_tipi='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("tipo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int id_tipo_modello(String tipo_modello) {
        int id = 0;
        String query = "SELECT id FROM conf_modello_causale_contabile WHERE tipo_causale='" + tipo_modello + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_tipo_modello_fa(String tipo_modello) {
        int id = 0;
        String query = "SELECT idfatture_attive_tipi as id FROM fatture_attive_tipi WHERE tipo='" + tipo_modello + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_aliquota_iva(String codice) {
        int id = 0;
        String query = "SELECT idAliquota FROM conf_aliquote_iva WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idAliquota");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_aliquota_da_percentuale(Double perc) {
        int id = 0;
        String query = "SELECT idAliquota FROM conf_aliquote_iva WHERE aliquota=" + perc + " ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                id = res.getInt("idAliquota");
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_aliquota_da_codice(String codice) {
        int id = 0;
        String query = "SELECT idAliquota FROM conf_aliquote_iva WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                id = res.getInt("idAliquota");
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String codice_aliquota_da_id(int id) {
        String codice = "";
        String query = "SELECT codice FROM conf_aliquote_iva WHERE idAliquota='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                codice = res.getString("codice");
                return codice;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return codice;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return codice;
    }

    public double percentuale_aliquota_da_id(int id) {
        double aliquota = 0.0;
        String query = "SELECT aliquota FROM conf_aliquote_iva WHERE idAliquota='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                aliquota = res.getDouble("aliquota");
                return aliquota;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return aliquota;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return aliquota;
    }

    public int id_causale_contabile(String codice) {
        int id = 0;
        String query = "SELECT idcausale_contabile FROM conf_causale_contabile WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idcausale_contabile");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String riferimento(String lettera) {
        if (lettera != null) {
            if (lettera.equals("F")) {
                return "Fornitore";
            }
            if (lettera.equals("C")) {
                return "Cliente";
            }
            if (lettera.equals("N")) {
                return "Nessuno";
            }
        }
        return "Fornitore";
    }

    public String lettera_riferimento(String riferimento) {
        if (riferimento.equals("Fornitore")) {
            return "F";
        }
        if (riferimento.equals("Cliente")) {
            return "C";
        }
        if (riferimento.equals("Nessuno")) {
            return "N";
        }
        return "";
    }

    public String si_no(int i) {
        if (i == 1) {
            return "Si";
        }
        return "No";
    }

    public String crea(int i) {
        if (i == 1) {
            return "Crea";
        }
        return "Non Creare";
    }

    public int int_crea(String crea) {
        if (crea.equals("Crea")) {
            return 1;
        }
        return 0;
    }

    public int id_conto5(String codice) {
        int id = 0;
        String query = "SELECT idconto5 FROM pc_conti_5 WHERE cdconto='" + codice + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idconto5");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_mastro4(String codice) {
        int id = 0;
        String query = "SELECT idmastro4 FROM pc_mastro_4 WHERE cdmastro4='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idmastro4");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_banca(String codice) {
        int id = 0;
        String query = "SELECT idAnag_banche as id FROM anag_banche WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_banca_da_descrizione(String codice) {
        int id = 0;
        String query = "SELECT idAnag_banche as id FROM anag_banche WHERE descrizione='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_banca_da_descrizione_FPA(String codice, String iban) {
        int id = 0;
        String query = "SELECT idAnag_banche as id FROM anag_banche WHERE descrizione='" + codice + "' AND IBAN='" + iban + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String descrizione_banca(int id) {
        String nome = "";
        String query = "SELECT descrizione as des FROM anag_banche WHERE idAnag_banche='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("des");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public String descrizione_banca_FPA(int id) {
        String nome = "";
        String IBAN2 = "";
        String query = "SELECT descrizione as des, IBAN FROM anag_banche WHERE idAnag_banche='" + id + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("des");
                IBAN2 = res.getString("IBAN");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome + " " + IBAN2;
    }

    public String sezione_bilancio(String lettera) {
        if (lettera.equals("P")) {
            return "Patrimoniale";
        }
        if (lettera.equals("E")) {
            return "Economico";
        }
        if (lettera.equals("O")) {
            return "Ordine";
        }
        return "Errore";
    }

    public String normalizza_abi_cab(String abi_cab) {
        if (abi_cab.length() == 0) {
            abi_cab = "00000" + abi_cab;
        }
        if (abi_cab.length() == 1) {
            abi_cab = "0000" + abi_cab;
        }
        if (abi_cab.length() == 2) {
            abi_cab = "000" + abi_cab;
        }
        if (abi_cab.length() == 3) {
            abi_cab = "00" + abi_cab;
        }
        if (abi_cab.length() == 4) {
            abi_cab = "0" + abi_cab;
        }
        return abi_cab;
    }

    public String sezione_bilancio_lettera(String stringa) {
        if (stringa.equals("Patrimoniale")) {
            return "P";
        }
        if (stringa.equals("Economico")) {
            return "E";
        }
        if (stringa.equals("Ordine")) {
            return "O";
        }
        return "Errore";
    }

    public String ricava_mastro3(String code4) {
        String nome = "";
        String query = "SELECT Cd_CGMastro3 FROM pc_mastro_3 WHERE id_CGMa='" + code4 + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("descrizione");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public int check_id_codice_aliquota(String codice) {
        int id = 0;
        String query = "SELECT idAliquota FROM conf_aliquote_iva WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idAliquota");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int ultima_registrazione(int anno) {
        int id = 0;
        String query = "SELECT MAX(num_reg) as ultimo FROM registro WHERE anno_reg='" + anno + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("ultimo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int ultimo_protocollo(int anno) {
        int id = 0;
        String query = "SELECT MAX(num_prot) as ultimo FROM protocollo_registro WHERE anno='" + anno + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("ultimo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int ultimo_ddt(int anno) {
        int id = 0;
        String query = "SELECT MAX(numero_ddt) as ultimo FROM mmag_ddu WHERE anno_ddt='" + anno + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("ultimo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int ultima_commessa(int anno) {
        int id = 0;
        String query = "SELECT MAX(numero_commessa) as ultimo FROM commesse WHERE anno='" + anno + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("ultimo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String formattaNumero(String numberToFormat) {
        try {
            numberToFormat = numberToFormat.replace(',', '.');
            DecimalFormat formatter = new DecimalFormat("#0.00");
            ((NumberFormat)formatter).setRoundingMode(RoundingMode.HALF_UP);
            Double d = Double.parseDouble(numberToFormat);
            return this.virgolaToPunto(formatter.format(d));
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE:  eccezione su formattaNumero() probabiel che la stringa conteneva parti non numeriche");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
    }

    public String formattaNumero(String numberToFormat, String formattazione) {
        try {
            numberToFormat = numberToFormat.replace(',', '.');
            DecimalFormat formatter = new DecimalFormat(formattazione);
            ((NumberFormat)formatter).setRoundingMode(RoundingMode.HALF_UP);
            Double d = Double.parseDouble(numberToFormat);
            return this.virgolaToPunto(formatter.format(d));
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE:  eccezione su formattaNumero( a,b) probabiel che la stringa conteneva parti non numeriche");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
    }

    public String formattaNumero_2(double numero) {
        String stringa = "" + numero + "000";
        System.out.println("Stringa " + stringa);
        int indice = stringa.indexOf(".");
        String parte1 = stringa.substring(0, indice);
        String parte2 = stringa.substring(indice, indice + 3);
        String uscita = parte1 + parte2;
        return uscita;
    }

    public String virgolaToPunto(String numero) {
        return numero.replaceAll(",", ".");
    }

    public double double_due_cifre(double ingresso) {
        double uscita = 0.0;
        System.out.println("questo \u00e8 il numero che gli passo:_" + ingresso + "_");
        DecimalFormat df = new DecimalFormat("%#.##");
        df.format(ingresso);
        System.out.println("questo \u00e8 il numero che mi restituisce:_" + ingresso + "_");
        return ingresso;
    }

    public int check_id_codice_banca(String codice) {
        int id = 0;
        String query = "SELECT idAnag_banche FROM anag_banche WHERE codice='" + codice + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("idAliquota");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_cap(String codice, String loc) {
        int id = 0;
        String query = "SELECT id_cap FROM cap where cap='" + codice + "' AND descrizione='" + loc.replaceAll("'", "''") + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id_cap");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public static String getCaller() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        System.out.println(ste[2].getClassName() + ":" + ste[2].getMethodName());
        return "Classe chiamante = " + ste[2].getClassName() + "  Metodo Chiamante = " + ste[2].getMethodName();
    }

    public static String StackTraceToString(Exception e) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(b);
        e.printStackTrace(p);
        p.flush();
        return b.toString();
    }

    public static void LogStackTraceError(Error e) {
        MyTrace.log.severe("Errore: " + e.toString());
        StackTraceElement[] elements = e.getStackTrace();
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            MyTrace.log.severe("file_name=" + elements[i].getFileName() + "  linea=" + elements[i].getLineNumber() + "  medoto=" + elements[i].getMethodName() + "()");
        }
    }

    public static void LogStackTrace(Exception eccezione) {
        MyTrace.log.severe("ECCEZIONE: " + eccezione.toString());
        StackTraceElement[] elements = eccezione.getStackTrace();
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            MyTrace.log.severe("file_name=" + elements[i].getFileName() + "  linea=" + elements[i].getLineNumber() + "  medoto=" + elements[i].getMethodName() + "()");
        }
    }

    public static void inviaBugPerEmail(Exception eccezione) {
        String invio_per_email_abilitato = Configurazioni.hm.get("debug.invia_email");
        MyTrace.log.severe("inviaBugPerEmail:" + invio_per_email_abilitato + ":" + eccezione.toString());
        if (invio_per_email_abilitato.matches("true")) {
            String messaggio = "ECCEZIONE: " + eccezione.toString() + "\n";
            messaggio = messaggio + "  CLIENTE: " + Configurazioni.nome_azienda + "\n";
            messaggio = messaggio + "   UTENTE: " + Configurazioni.operatore + "\n\n";
            messaggio = messaggio + "___________________________________________________\n";
            messaggio = messaggio + "DI SEGUITO lo STACK delle chiamate\n";
            StackTraceElement[] elements = eccezione.getStackTrace();
            int n = elements.length;
            for (int i = 0; i < n; ++i) {
                messaggio = messaggio + "file_name=" + elements[i].getFileName() + "  linea=" + elements[i].getLineNumber() + "  medoto=" + elements[i].getMethodName() + "()\n";
            }
            InviaEmail email = new InviaEmail();
            email.nuovaEmailDebugconTraceAllegato(messaggio);
            email.send();
        } else {
            MyTrace.log.config("inviaBugPerEmail: NON ABILITATO su config.ini");
        }
    }

    public Vector crea_vettore_colori() {
        Vector<Color> colori = new Vector<Color>();
        colori.add(Color.BLUE);
        colori.add(Color.MAGENTA);
        colori.add(Color.GREEN);
        colori.add(Color.YELLOW);
        colori.add(Color.PINK);
        colori.add(Color.GRAY);
        colori.add(Color.ORANGE);
        colori.add(Color.RED);
        colori.add(Color.LIGHT_GRAY);
        return colori;
    }

    public boolean esiste_provincia(String provincia) {
        String q = "SELECT id_cap from cap where cd_provincia='" + provincia + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
        int count = 0;
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return count != 0;
    }

    public static String CartellaPerTrace() {
        String log_directory = "./";
        String user_home = System.getProperty("user.home");
        String cartella_tracciato = user_home + System.getProperty("file.separator") + "TRACCIATO_KRONOS";
        boolean success = false;
        try {
            if (new File(cartella_tracciato).isDirectory()) {
                MyTrace.log.info("Directory: " + cartella_tracciato + "  esistente");
                success = true;
            } else {
                success = new File(cartella_tracciato).mkdir();
                if (success) {
                    MyTrace.log.info("Directory: " + cartella_tracciato + "  creata");
                }
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Errore nella creazione della cartella tracciato: " + e.getMessage());
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        log_directory = success ? System.getProperty("java.logger.logDir", cartella_tracciato) : System.getProperty("java.logger.logDir", user_home + System.getProperty("file.separator") + "Desktop");
        MyTrace.log.info("Directory per tracciamento: " + log_directory);
        return log_directory;
    }

    public static String CartellaPerStampe() {
        String cartella_per_stampe = "./";
        String user_home = System.getProperty("user.home");
        String cartella_temp = user_home + System.getProperty("file.separator") + "STAMPE";
        boolean success = false;
        try {
            if (new File(cartella_temp).isDirectory()) {
                MyTrace.log.info("Directory: " + cartella_temp + "  esistente");
                success = true;
            } else {
                success = new File(cartella_temp).mkdir();
                if (success) {
                    MyTrace.log.info("Directory: " + cartella_temp + "  creata");
                }
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Errore nella creazione della cartella per stampe: " + e.getMessage());
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        cartella_per_stampe = success ? cartella_temp : user_home + System.getProperty("file.separator") + "Desktop";
        MyTrace.log.info("Directory per stampe: " + cartella_per_stampe);
        return cartella_per_stampe;
    }

    public static boolean FileExist(String path) {
        try {
            File f = new File(path);
            if (f.isFile()) {
                return true;
            }
            MyTrace.log.severe("ERRORE: " + path + "  non esistente o non trovato");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int ottieni_n_doc_corrispettivo(int anno) {
        try {
            int n_doc = 0;
            String query = "SELECT (COALESCE(MAX(num_reg),0))+1 as n_doc FROM (SELECT * FROM registro WHERE anno_reg=" + anno + ")as tab_temporanea";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                n_doc = res.getInt("n_doc");
            }
            return n_doc;
        }
        catch (SQLException ex) {
            return 0;
        }
    }

    public String pulisci_nome_file(String stringa_da_ripulire) {
        String nome_file = stringa_da_ripulire.replaceAll("[^a-z^A-Z^0-9^_]+", "");
        return nome_file;
    }

    public String pulisci_da_accenti(String nome) {
        String nome1 = nome.replaceAll("\u00f2", "o").replaceAll("\u00e0", "a").replaceAll("\u00e8", "e").replaceAll("\u00e9", "e").replaceAll("\u00ec", "i").replaceAll("\u00f9", "u");
        return nome1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int id_azienda_da_ragione_sociale(String ragione_sociale) {
        int id_azienda = 0;
        String query = "SELECT anag_azienda.idAnag_azienda FROM anag_azienda WHERE ragione_sociale='" + ragione_sociale + "'";
        ResultSet res = null;
        try {
            res = Configurazioni.getIstanza().connessione_master.eseguiQuery(query);
            while (res.next()) {
                id_azienda = res.getInt("idAnag_azienda");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Funzioni.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
        }
        MyTrace.log.info("ID_AZIENDA NUOVA (SCELTA) = " + id_azienda);
        return id_azienda;
    }

    public int id_listini_riferimento_da_nome_listino(String nome) {
        int id = 1;
        String query = "SELECT id FROM mmag_listini WHERE nome= '" + nome + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return id;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public Vector crea_vettore_listini(int star) {
        String query_listini_riferimento = "SELECT nome from mmag_listini ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_listini_riferimento);
        Vector<String> nomi_gruppi = new Vector<String>();
        if (star == 1) {
            nomi_gruppi.add("");
        }
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nomi_gruppi.add(res.getString("nome"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return new Vector();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nomi_gruppi;
    }

    public int crea_id_listini(String nome) {
        int id = 0;
        String query_listini_riferimento = "SELECT * from mmag_listini where nome= '" + nome + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_listini_riferimento);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                id = res.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public String crea_nome_listini(int id) {
        String nome = "";
        String query_listini_riferimento = "SELECT nome from mmag_listini where id=" + id;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_listini_riferimento);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                nome = res.getString("nome");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return nome;
    }

    public Vector aggiungi_se_non_presente(Vector v, String a) {
        Iterator i = v.iterator();
        boolean trovato = false;
        while (i.hasNext() && !trovato) {
            if (!i.next().toString().equals(a)) continue;
            trovato = true;
        }
        if (!trovato) {
            v.add(a);
        }
        return v;
    }

    public String cli_for(String sigla) {
        if (sigla.equals("C")) {
            return "Cliente";
        }
        if (sigla.equals("F")) {
            return "Fornitore";
        }
        return "##Errore##";
    }

    public int id_cdr_da_nome(String nome) {
        int id = 0;
        String query = "SELECT idcentri_di_responsabilita FROM ctrl_centri_di_responsabilita WHERE centro_di_responsabilita='" + nome + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = res.getMetaData();
            if (res.next()) {
                id = res.getInt("idcentri_di_responsabilita");
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int id_dipendente_da_nome(String cognome, String nome) {
        int id = 0;
        String query = "SELECT idanag_dipendenti FROM anag_dipendenti WHERE nome='" + nome + "' AND cognome='" + cognome + "' ";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            if (res.next()) {
                id = res.getInt("idanag_dipendenti");
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return 0;
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return id;
    }

    public int[] converti_string_csv_to_arrayint(String csv) {
        try {
            String[] array_stringhe;
            if (csv != null) {
                array_stringhe = csv.contains(",") ? csv.split(",") : new String[]{csv};
            } else {
                return null;
            }
            int[] array_interi = new int[array_stringhe.length];
            for (int i = 0; i < array_stringhe.length; ++i) {
                array_interi[i] = Integer.valueOf(array_stringhe[i]);
            }
            return array_interi;
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return null;
        }
    }

    public String[] converti_string_csv_to_arrayString(String csv) {
        try {
            String[] array_stringhe;
            if (csv != null) {
                array_stringhe = csv.contains(",") ? csv.split(",") : new String[]{csv};
            } else {
                return null;
            }
            return array_stringhe;
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return null;
        }
    }

    public boolean isNumber(String value) {
        try {
            double theWeight = Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String formatta_Calendar_in_data_SQL(Calendar nuova_scadenza) {
        String data_sql = "";
        data_sql = data_sql + nuova_scadenza.get(1) + "-";
        data_sql = data_sql + (1 + nuova_scadenza.get(2)) + "-";
        data_sql = data_sql + nuova_scadenza.get(5);
        return data_sql;
    }

    public long giorniTraDueDateCalendar(Calendar data, Calendar data_da_stottrarre) {
        long giorni = (data.getTime().getTime() - data_da_stottrarre.getTime().getTime()) / 86400000L;
        return giorni;
    }

    public static long giorniTraDueDateCalendar2(Calendar startDate, Calendar endDate) {
        double MSECOND_IN_SECOND = 1000.0;
        double SECOND_IN_MINUTE = 60.0;
        double MINUTE_IN_HOUR = 60.0;
        double HOURS_IN_DAY = 24.0;
        long startTime = startDate.getTimeInMillis();
        long endTime = endDate.getTimeInMillis();
        double msecDiff = endTime - startTime;
        long daysDiff = Math.round(msecDiff / 1000.0 / 60.0 / 60.0 / 24.0);
        daysDiff = Math.abs(daysDiff);
        return daysDiff;
    }
}

